/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.ec4j.core.ResourceProperties;
import org.ec4j.core.model.Property;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigUsagesCollector;
import org.editorconfig.configmanagement.extended.EditorConfigCodeStyleSettingsModifier;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.editorconfig.plugincomponents.EditorConfigPropertiesService;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a>\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002\u001a<\u0010\u0017\u001a\u00020\u00122\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002\u001a(\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\"2\u0006\u0010\t\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0002\u001a\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\"2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010)\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0002\u001a*\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u00140-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020+H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "ourEnabledInTestOnly", "", "processOptions", "properties", "Lorg/ec4j/core/ResourceProperties;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "mapper", "Lcom/intellij/application/options/codeStyle/properties/AbstractCodeStylePropertyMapper;", "languageSpecific", "processed", "", "", "getDependentProperties", "", "property", "langPrefix", "preprocessValue", "accessor", "Lcom/intellij/application/options/codeStyle/properties/CodeStylePropertyAccessor;", "optionKey", "rawValue", "findAccessor", "propertyName", "getExplicitTabSize", "getDefaultTabSize", "isTabIndent", "getMappers", "", "Lcom/intellij/psi/codeStyle/modifier/TransientCodeStyleSettings;", "fileBaseLanguage", "Lcom/intellij/lang/Language;", "getLanguageCodeStyleProviders", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "getLanguageIds", "applyCodeStyleSettings", "file", "Lcom/intellij/psi/PsiFile;", "processEditorConfig", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigCodeStyleSettingsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigCodeStyleSettingsModifier.kt\norg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifierKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,363:1\n15#2:364\n62#2,5:368\n1628#3,3:365\n*S KotlinDebug\n*F\n+ 1 EditorConfigCodeStyleSettingsModifier.kt\norg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifierKt\n*L\n50#1:364\n360#1:368,5\n284#1:365,3\n*E\n"})
public final class EditorConfigCodeStyleSettingsModifierKt {
    private static boolean ourEnabledInTestOnly;

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConfigCodeStyleSettingsModifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final boolean processOptions(ResourceProperties properties, CodeStyleSettings settings, FileType fileType, AbstractCodeStylePropertyMapper mapper, boolean languageSpecific, Set<String> processed) {
        String langPrefix = languageSpecific ? mapper.getLanguageDomainId() + "_" : null;
        boolean isModified = false;
        for (Property prop : properties.getProperties().values()) {
            String intellijName;
            String optionKey = prop.getName();
            Intrinsics.checkNotNullExpressionValue((Object)EditorConfigIntellijNameUtil.toIntellijName(optionKey), (String)"toIntellijName(...)");
            CodeStylePropertyAccessor<?> accessor = EditorConfigCodeStyleSettingsModifierKt.findAccessor(mapper, intellijName, langPrefix);
            if (accessor == null) continue;
            Intrinsics.checkNotNull((Object)optionKey);
            String string = prop.getSourceValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSourceValue(...)");
            String val = EditorConfigCodeStyleSettingsModifierKt.preprocessValue(accessor, properties, settings, fileType, optionKey, string);
            for (String dependency : EditorConfigCodeStyleSettingsModifierKt.getDependentProperties(optionKey, langPrefix)) {
                CodeStylePropertyAccessor<?> dependencyAccessor;
                if (processed.contains(dependency) || (dependencyAccessor = EditorConfigCodeStyleSettingsModifierKt.findAccessor(mapper, dependency, null)) == null) continue;
                isModified |= dependencyAccessor.setFromString(val);
            }
            isModified |= accessor.setFromString(val);
            processed.add(intellijName);
        }
        return isModified;
    }

    private static final List<String> getDependentProperties(String property, String langPrefix) {
        List list;
        String stripped = StringsKt.removePrefix((String)property, (CharSequence)"ij_");
        if (langPrefix != null) {
            stripped = StringsKt.removePrefix((String)stripped, (CharSequence)langPrefix);
        }
        if (Intrinsics.areEqual((Object)stripped, (Object)"indent_size")) {
            Object[] objectArray = new String[]{"continuation_indent_size", "OverrideLanguageOptions"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final String preprocessValue(CodeStylePropertyAccessor<?> accessor, ResourceProperties properties, CodeStyleSettings settings, FileType fileType, String optionKey, String rawValue) {
        String optionValue = ((Object)StringsKt.trim((CharSequence)rawValue)).toString();
        if (Intrinsics.areEqual((Object)"indent_size", (Object)optionKey)) {
            String explicitTabSize = EditorConfigCodeStyleSettingsModifierKt.getExplicitTabSize(properties);
            if (Intrinsics.areEqual((Object)"tab", (Object)optionValue)) {
                String string = explicitTabSize;
                if (string == null) {
                    string = EditorConfigCodeStyleSettingsModifierKt.getDefaultTabSize(settings, fileType);
                }
                return string;
            }
            if (EditorConfigCodeStyleSettingsModifierKt.isTabIndent(properties) && explicitTabSize != null) {
                return explicitTabSize;
            }
        } else if (Intrinsics.areEqual((Object)"max_line_length", (Object)optionKey)) {
            if (Intrinsics.areEqual((Object)optionValue, (Object)"off")) {
                return "1000";
            }
        } else if (Intrinsics.areEqual((Object)"none", (Object)optionValue) && CodeStylePropertiesUtil.isAccessorAllowingEmptyList(accessor)) {
            return "";
        }
        return optionValue;
    }

    private static final CodeStylePropertyAccessor<?> findAccessor(AbstractCodeStylePropertyMapper mapper, String propertyName, String langPrefix) {
        if (langPrefix != null) {
            if (StringsKt.startsWith$default((String)propertyName, (String)langPrefix, (boolean)false, (int)2, null)) {
                String string = Strings.trimStart((String)propertyName, (String)langPrefix);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimStart(...)");
                String prefixlessName = string;
                EditorConfigPropertyKind editorConfigPropertyKind = IntellijPropertyKindMap.getPropertyKind(prefixlessName);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)editorConfigPropertyKind), (String)"getPropertyKind(...)");
                EditorConfigPropertyKind propertyKind = editorConfigPropertyKind;
                if (propertyKind == EditorConfigPropertyKind.LANGUAGE || propertyKind == EditorConfigPropertyKind.COMMON || EditorConfigIntellijNameUtil.isIndentProperty(prefixlessName)) {
                    return mapper.getAccessor(prefixlessName);
                }
            }
        } else {
            return mapper.getAccessor(propertyName);
        }
        return null;
    }

    private static final String getExplicitTabSize(ResourceProperties properties) {
        Property property = properties.getProperties().get("tab_width");
        return property != null ? property.getSourceValue() : null;
    }

    private static final String getDefaultTabSize(CodeStyleSettings settings, FileType fileType) {
        return String.valueOf(settings.getIndentOptions((FileType)fileType).TAB_SIZE);
    }

    private static final boolean isTabIndent(ResourceProperties properties) {
        Property prop = properties.getProperties().get("indent_style");
        boolean bl = false;
        return prop != null && Intrinsics.areEqual((Object)prop.getSourceValue(), (Object)"tab");
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<AbstractCodeStylePropertyMapper> getMappers(TransientCodeStyleSettings settings, ResourceProperties properties, Language fileBaseLanguage) {
        Set set;
        Set $this$getMappers_u24lambda_u242 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$mapTo$iv = EditorConfigCodeStyleSettingsModifierKt.getLanguageCodeStyleProviders(properties, fileBaseLanguage);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            LanguageCodeStyleSettingsProvider languageCodeStyleSettingsProvider = (LanguageCodeStyleSettingsProvider)item$iv;
            Collection collection = $this$getMappers_u24lambda_u242;
            boolean bl2 = false;
            collection.add(it.getPropertyMapper((CodeStyleSettings)settings));
        }
        $this$getMappers_u24lambda_u242.add(new GeneralCodeStylePropertyMapper((CodeStyleSettings)settings));
        return SetsKt.build((Set)set);
    }

    private static final Collection<LanguageCodeStyleSettingsProvider> getLanguageCodeStyleProviders(ResourceProperties properties, Language fileBaseLanguage) {
        LinkedHashSet<LanguageCodeStyleSettingsProvider> providers = new LinkedHashSet<LanguageCodeStyleSettingsProvider>();
        LanguageCodeStyleSettingsProvider languageCodeStyleSettingsProvider = LanguageCodeStyleSettingsProvider.findUsingBaseLanguage((Language)fileBaseLanguage);
        if (languageCodeStyleSettingsProvider != null) {
            LanguageCodeStyleSettingsProvider it = languageCodeStyleSettingsProvider;
            boolean bl = false;
            providers.add(it);
        }
        for (String langId : EditorConfigCodeStyleSettingsModifierKt.getLanguageIds(properties)) {
            LanguageCodeStyleSettingsProvider it;
            if (Intrinsics.areEqual((Object)langId, (Object)"any")) {
                providers.clear();
                providers.addAll(LanguageCodeStyleSettingsProvider.getAllProviders());
                break;
            }
            if (LanguageCodeStyleSettingsProvider.findByExternalLanguageId((String)langId) == null) continue;
            boolean bl = false;
            providers.add(it);
        }
        return providers;
    }

    private static final Collection<String> getLanguageIds(ResourceProperties properties) {
        LinkedHashSet<String> langIds = new LinkedHashSet<String>();
        for (String key : properties.getProperties().keySet()) {
            String langId;
            if (EditorConfigIntellijNameUtil.isIndentProperty(key)) {
                langIds.add("any");
            }
            if ((langId = EditorConfigIntellijNameUtil.extractLanguageDomainId(key)) == null) continue;
            langIds.add(langId);
        }
        return langIds;
    }

    private static final boolean applyCodeStyleSettings(TransientCodeStyleSettings settings, ResourceProperties properties, PsiFile file) {
        HashSet processed = new HashSet();
        boolean isModified = false;
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        for (AbstractCodeStylePropertyMapper mapper : EditorConfigCodeStyleSettingsModifierKt.getMappers(settings, properties, language)) {
            processed.clear();
            CodeStyleSettings codeStyleSettings = (CodeStyleSettings)settings;
            FileType fileType = file.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
            isModified |= EditorConfigCodeStyleSettingsModifierKt.processOptions(properties, codeStyleSettings, fileType, mapper, false, processed);
            CodeStyleSettings codeStyleSettings2 = (CodeStyleSettings)settings;
            FileType fileType2 = file.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
            isModified |= EditorConfigCodeStyleSettingsModifierKt.processOptions(properties, codeStyleSettings2, fileType2, mapper, true, processed);
        }
        if (isModified) {
            EditorConfigUsagesCollector.INSTANCE.logEditorConfigUsed(file, properties);
        }
        return isModified;
    }

    private static final Pair<ResourceProperties, List<VirtualFile>> processEditorConfig(Project project, PsiFile psiFile) {
        VirtualFile file = psiFile.getVirtualFile();
        Intrinsics.checkNotNull((Object)file);
        String filePath = Utils.INSTANCE.getFilePath(project, file);
        if (filePath != null) {
            return EditorConfigPropertiesService.Companion.getInstance(project).getPropertiesAndEditorConfigs(file);
        }
        if (VfsUtilCore.isBrokenLink((VirtualFile)file)) {
            EditorConfigCodeStyleSettingsModifierKt.getLOG().warn(file.getPresentableUrl() + " is a broken link");
        }
        Logger $this$debug_u24default$iv = EditorConfigCodeStyleSettingsModifierKt.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("null filepath for " + psiFile.getName(), e$iv);
        }
        return new Pair((Object)new ResourceProperties.Builder().build(), (Object)CollectionsKt.emptyList());
    }

    public static final /* synthetic */ Pair access$processEditorConfig(Project project, PsiFile psiFile) {
        return EditorConfigCodeStyleSettingsModifierKt.processEditorConfig(project, psiFile);
    }

    public static final /* synthetic */ boolean access$applyCodeStyleSettings(TransientCodeStyleSettings settings, ResourceProperties properties, PsiFile file) {
        return EditorConfigCodeStyleSettingsModifierKt.applyCodeStyleSettings(settings, properties, file);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return EditorConfigCodeStyleSettingsModifierKt.getLOG();
    }

    public static final /* synthetic */ boolean access$getOurEnabledInTestOnly$p() {
        return ourEnabledInTestOnly;
    }

    public static final /* synthetic */ void access$setOurEnabledInTestOnly$p(boolean bl) {
        ourEnabledInTestOnly = bl;
    }
}

