/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.LineTerminators;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\b\u0016\u0018\u0000 \u0017*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003\u0015\u0016\u0017B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0004J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0004R\u0012\u0010\u0004\u001a\u00028\u00008\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/javascript/parsing/JavaScriptParserBase;", "T", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "", "parser", "<init>", "(Lcom/intellij/lang/javascript/parsing/JavaScriptParser;)V", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "builder", "Lcom/intellij/lang/PsiBuilder;", "isECMAL4", "", "()Z", "isECMA6", "isJavaScript", "isJSorTS", "isIdentifierToken", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "getTokenCharSequence", "", "ForceContext", "JSDocBinder", "Companion", "intellij.javascript.parser"})
public class JavaScriptParserBase<T extends JavaScriptParser> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final T parser;
    @JvmField
    @NotNull
    protected final PsiBuilder builder;
    @JvmField
    @NotNull
    public static final Key<ForceContext> FORCE_CONTEXT_KEY;
    @JvmField
    public static int MAX_TREE_DEPTH;
    @JvmField
    @NotNull
    public static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT;
    @JvmField
    @NotNull
    public static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT_NO_EXTRA_LINEBREAK;

    protected JavaScriptParserBase(@NotNull T parser) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        this.parser = parser;
        this.builder = ((JavaScriptParser)this.parser).builder;
    }

    protected final boolean isECMAL4() {
        return ((JavaScriptParser)this.parser).getDialect().isECMA4;
    }

    protected final boolean isECMA6() {
        return ((JavaScriptParser)this.parser).getDialect().isECMA6;
    }

    protected final boolean isJavaScript() {
        return ((JavaScriptParser)this.parser).getDialect().isJavaScript();
    }

    protected final boolean isJSorTS() {
        DialectOptionHolder dialect = ((JavaScriptParser)this.parser).getDialect();
        return dialect.isJavaScript() || dialect.isTypeScript;
    }

    protected final boolean isIdentifierToken(@Nullable IElementType tokenType) {
        if (tokenType == JSTokenTypes.IDENTIFIER || tokenType == JSTokenTypes.PRIVATE_IDENTIFIER) {
            return true;
        }
        return ((JavaScriptParser)this.parser).isIdentifierToken(tokenType);
    }

    @Nullable
    protected final CharSequence getTokenCharSequence() {
        return this.builder.eof() ? null : PsiBuilderUtil.rawTokenText((PsiBuilder)this.builder, (int)0);
    }

    @JvmStatic
    public static final boolean hasLineTerminatorBefore(@NotNull PsiBuilder builder) {
        return Companion.hasLineTerminatorBefore(builder);
    }

    @JvmStatic
    public static final boolean hasLineTerminatorAfter(@NotNull PsiBuilder builder) {
        return Companion.hasLineTerminatorAfter(builder);
    }

    @JvmStatic
    public static final boolean hasLineTerminator(@NotNull PsiBuilder builder, int at) {
        return Companion.hasLineTerminator(builder, at);
    }

    @JvmStatic
    public static final boolean checkMatches(@NotNull PsiBuilder builder, @NotNull IElementType token, @PropertyKey(resourceBundle="messages.JavaScriptParserBundle") @NotNull String errorMessageKey) {
        return Companion.checkMatches(builder, token, errorMessageKey);
    }

    static {
        Key key = Key.create((String)"FORCE_CONTEXT");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FORCE_CONTEXT_KEY = key;
        MAX_TREE_DEPTH = 100;
        INCLUDE_DOC_COMMENT_AT_LEFT = new JSDocBinder(true);
        INCLUDE_DOC_COMMENT_AT_LEFT_NO_EXTRA_LINEBREAK = new JSDocBinder(false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bH\u0007J\"\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/javascript/parsing/JavaScriptParserBase$Companion;", "", "<init>", "()V", "FORCE_CONTEXT_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/javascript/parsing/JavaScriptParserBase$ForceContext;", "MAX_TREE_DEPTH", "", "INCLUDE_DOC_COMMENT_AT_LEFT", "Lcom/intellij/lang/WhitespacesAndCommentsBinder;", "INCLUDE_DOC_COMMENT_AT_LEFT_NO_EXTRA_LINEBREAK", "hasLineTerminatorBefore", "", "builder", "Lcom/intellij/lang/PsiBuilder;", "hasLineTerminatorAfter", "hasLineTerminator", "at", "checkMatches", "token", "Lcom/intellij/psi/tree/IElementType;", "errorMessageKey", "", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean hasLineTerminatorBefore(@NotNull PsiBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return LineTerminators.INSTANCE.hasLineTerminatorBefore(builder);
        }

        @JvmStatic
        public final boolean hasLineTerminatorAfter(@NotNull PsiBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return LineTerminators.INSTANCE.hasLineTerminatorAfter(builder);
        }

        @JvmStatic
        public final boolean hasLineTerminator(@NotNull PsiBuilder builder, int at) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return LineTerminators.INSTANCE.hasLineTerminator(builder, at);
        }

        @JvmStatic
        public final boolean checkMatches(@NotNull PsiBuilder builder, @NotNull IElementType token, @PropertyKey(resourceBundle="messages.JavaScriptParserBundle") @NotNull String errorMessageKey) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)errorMessageKey, (String)"errorMessageKey");
            if (builder.getTokenType() == token) {
                builder.advanceLexer();
                return true;
            }
            builder.error(JavaScriptParserBundle.message(errorMessageKey, new Object[0]));
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/parsing/JavaScriptParserBase$ForceContext;", "", "<init>", "(Ljava/lang/String;I)V", "Type", "TypeAllowEmpty", "Parameter", "intellij.javascript.parser"})
    public static final class ForceContext
    extends Enum<ForceContext> {
        public static final /* enum */ ForceContext Type = new ForceContext();
        public static final /* enum */ ForceContext TypeAllowEmpty = new ForceContext();
        public static final /* enum */ ForceContext Parameter = new ForceContext();
        private static final /* synthetic */ ForceContext[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ForceContext[] values() {
            return (ForceContext[])$VALUES.clone();
        }

        public static ForceContext valueOf(String value) {
            return Enum.valueOf(ForceContext.class, value);
        }

        @NotNull
        public static EnumEntries<ForceContext> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = forceContextArray = new ForceContext[]{ForceContext.Type, ForceContext.TypeAllowEmpty, ForceContext.Parameter};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/javascript/parsing/JavaScriptParserBase$JSDocBinder;", "Lcom/intellij/lang/WhitespacesAndCommentsBinder;", "allowExtraLineBreak", "", "<init>", "(Z)V", "getEdgePosition", "", "tokens", "", "Lcom/intellij/psi/tree/IElementType;", "atStreamEdge", "getter", "Lcom/intellij/lang/WhitespacesAndCommentsBinder$TokenTextGetter;", "intellij.javascript.parser"})
    @SourceDebugExtension(value={"SMAP\nJavaScriptParserBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptParserBase.kt\ncom/intellij/lang/javascript/parsing/JavaScriptParserBase$JSDocBinder\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,151:1\n1104#2,3:152\n*S KotlinDebug\n*F\n+ 1 JavaScriptParserBase.kt\ncom/intellij/lang/javascript/parsing/JavaScriptParserBase$JSDocBinder\n*L\n82#1:152,3\n*E\n"})
    private static final class JSDocBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean allowExtraLineBreak;

        public JSDocBinder(boolean allowExtraLineBreak) {
            this.allowExtraLineBreak = allowExtraLineBreak;
        }

        public int getEdgePosition(@NotNull List<? extends IElementType> tokens, boolean atStreamEdge, @NotNull WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            IElementType type;
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
            int i = tokens.size() - 1;
            IElementType iElementType = type = i >= 0 ? tokens.get(i) : null;
            while (type == JSTokenTypes.WHITE_SPACE || type == JSTokenTypes.END_OF_LINE_COMMENT) {
                if (!this.allowExtraLineBreak && type == JSTokenTypes.WHITE_SPACE) {
                    CharSequence tokenText;
                    Intrinsics.checkNotNullExpressionValue((Object)getter.get(i), (String)"get(...)");
                    CharSequence $this$count$iv = tokenText;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    for (int j = 0; j < $this$count$iv.length(); ++j) {
                        char element$iv;
                        char it = element$iv = $this$count$iv.charAt(j);
                        boolean bl = false;
                        if (!(it == '\n')) continue;
                        ++count$iv;
                    }
                    if (count$iv > 1) break;
                }
                type = --i >= 0 ? tokens.get(i) : null;
            }
            if (type == JSTokenTypes.DOC_COMMENT) {
                return i;
            }
            return tokens.size();
        }
    }
}

