/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSEvaluableElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.recordImpl.FunctionSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.qml.psi.impl.QmlElementDeclarationImpl;
import com.intellij.lang.qml.psi.impl.QmlImportAliasExpressionImpl;
import com.intellij.lang.qml.psi.impl.QmlImportDeclarationImpl;
import com.intellij.lang.qml.psi.impl.QmlLocalImplicitElementImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QmlElementReferenceExpressionImpl
extends JSReferenceExpressionImpl
implements JSEvaluableElement,
PsiNamedElement {
    public QmlElementReferenceExpressionImpl(IElementType elementType) {
        super(elementType);
    }

    @Nullable
    public PsiFile getContainingFile() {
        return SharedImplUtil.getContainingFile((ASTNode)this);
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSTokenTypes.IDENTIFIER);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            QmlElementReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        if ((nameNode = this.findNameIdentifier()) == null || name.equals(nameNode.getText())) {
            return this;
        }
        ASTNode nameElement = JSChangeUtil.createPropertyNameWithContext((String)name, (ASTNode)nameNode);
        nameNode.getTreeParent().replaceChild(nameNode, nameElement);
        return this;
    }

    public String getName() {
        ASTNode identifierNode = this.getNode().findChildByType(JSTokenTypes.IDENTIFIER);
        return identifierNode != null ? identifierNode.getText() : null;
    }

    @Nullable
    public static PsiFile readJSFile(@Nullable VirtualFile jsFile, @NotNull Project project) {
        if (project == null) {
            QmlElementReferenceExpressionImpl.$$$reportNull$$$0(1);
        }
        if (jsFile == null) {
            return null;
        }
        @Nullable Document document = FileDocumentManager.getInstance().getDocument(jsFile);
        if (document == null) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
    }

    @Nullable
    private static JSType findInAliases(QmlImportDeclarationImpl imp, @NotNull PsiElement elem) {
        QmlImportAliasExpressionImpl alias;
        if (elem == null) {
            QmlElementReferenceExpressionImpl.$$$reportNull$$$0(2);
        }
        if ((alias = imp.getAlias()) == null) {
            return null;
        }
        if (alias.getText().equals(elem.getText())) {
            final ArrayList<PropertySignatureImpl> curTypeMembers = new ArrayList<PropertySignatureImpl>();
            if (imp.isJSImport()) {
                JSFile jsFile;
                FileASTNode block;
                if (imp.getContainingFile() == null) {
                    return null;
                }
                VirtualFile virtualFile = imp.getContainingFile().getVirtualFile();
                @Nullable String jsPath = imp.getStringInQuotes();
                if (virtualFile == null || jsPath == null) {
                    return null;
                }
                @Nullable VirtualFile importedFile = virtualFile.getParent().findFileByRelativePath(jsPath);
                @Nullable PsiFile psiFile = QmlElementReferenceExpressionImpl.readJSFile(importedFile, imp.getProject());
                if (psiFile instanceof JSFile && (block = (jsFile = (JSFile)psiFile).getNode()) != null && block.getFirstChildNode() != null) {
                    PsiElement variable = block.getFirstChildNode().getPsi();
                    jsFile.processDeclarations(new PsiScopeProcessor(){

                        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (state == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (element instanceof JSFunctionImpl) {
                                JSFunctionImpl funcImpl = (JSFunctionImpl)element;
                                if (funcImpl.getName() == null) {
                                    return true;
                                }
                                @NotNull JSTypeSource typeSrc = JSTypeSourceFactory.createTypeSource((PsiElement)funcImpl, (boolean)true);
                                ArrayList<JSParameterTypeDecoratorImpl> parameters = new ArrayList<JSParameterTypeDecoratorImpl>();
                                for (JSParameterListElement param : funcImpl.getParameters()) {
                                    parameters.add(new JSParameterTypeDecoratorImpl(param.getName(), param.getJSType(), param.isOptional(), param.isRest(), true));
                                }
                                JSFunctionTypeImpl funcType = new JSFunctionTypeImpl(typeSrc, parameters, funcImpl.getReturnType());
                                curTypeMembers.add(new FunctionSignatureImpl(funcImpl.getName(), (JSType)funcType, false, false));
                            } else if (element instanceof JSVariable) {
                                JSVariable jsVar = (JSVariable)element;
                                if (jsVar.getName() == null) {
                                    return true;
                                }
                                curTypeMembers.add(new PropertySignatureImpl(jsVar.getName(), jsVar.getJSType(), false, false));
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "element";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "state";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/lang/qml/psi/impl/QmlElementReferenceExpressionImpl$1";
                            objectArray[2] = "execute";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, ResolveState.initial(), (PsiElement)jsFile, variable);
                    @NotNull JSTypeSource typeSrc = JSTypeSourceFactory.createTypeSource((PsiElement)alias, (boolean)true);
                    return new QmlImportDeclarationImpl.QmlRecordType(typeSrc, curTypeMembers, elem.getText());
                }
                return null;
            }
            @NotNull JSTypeSource typeSrc = JSTypeSourceFactory.createTypeSource((PsiElement)alias, (boolean)true);
            List<QmlImportDeclarationImpl.QmlComponentTemplate> components = imp.getAllComponents();
            for (QmlImportDeclarationImpl.QmlComponentTemplate component : components) {
                curTypeMembers.add(new PropertySignatureImpl(component.getRelatedElement().getName(), component.getRelatedElement().getJSType(), false, false));
            }
            return new QmlImportDeclarationImpl.QmlRecordType(typeSrc, curTypeMembers, elem.getText());
        }
        return null;
    }

    private static JSType findInImportedComponents(@NotNull PsiElement elem, Ref<Boolean> isComponent) {
        if (elem == null) {
            QmlElementReferenceExpressionImpl.$$$reportNull$$$0(3);
        }
        if (elem.getContainingFile() == null) {
            return null;
        }
        List imports = ContainerUtil.filter((Object[])elem.getContainingFile().getChildren(), element -> element instanceof QmlImportDeclarationImpl);
        for (PsiElement imp : imports) {
            @Nullable JSType aliasType = QmlElementReferenceExpressionImpl.findInAliases((QmlImportDeclarationImpl)imp, elem);
            if (aliasType != null) {
                return aliasType;
            }
            QmlImportDeclarationImpl.QmlComponentTemplate elementTemplate = ((QmlImportDeclarationImpl)imp).getComponent(elem.getText());
            if (elementTemplate != null) {
                isComponent.set((Object)true);
                return elementTemplate.getJSType();
            }
            JSType type = ((QmlImportDeclarationImpl)imp).getType(elem.getText());
            if (type == null) continue;
            isComponent.set((Object)false);
            return type;
        }
        return null;
    }

    private static JSType getTypeFromSameDirQmls(@NotNull PsiElement elem) {
        if (elem == null) {
            QmlElementReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        if (elem.getContainingFile() == null || elem.getContainingFile().getVirtualFile() == null) {
            return null;
        }
        VirtualFile parentFolder = elem.getContainingFile().getVirtualFile().getParent();
        if (parentFolder == null) {
            return null;
        }
        for (VirtualFile child : parentFolder.getChildren()) {
            PsiFile file;
            int foundId;
            Document document;
            if (!child.getName().endsWith(".qml") || (document = FileDocumentManager.getInstance().getDocument(child)) == null || (foundId = document.getText().indexOf("id: " + elem.getText())) < 0 || (file = elem.getManager().findFile(child)) == null) continue;
            return QmlElementReferenceExpressionImpl.getTypeFromIds(elem.getText(), (PsiElement)file);
        }
        return null;
    }

    public static JSType getTypeFromParent(@NotNull PsiElement elem, Ref<Boolean> isComponent) {
        if (elem == null) {
            QmlElementReferenceExpressionImpl.$$$reportNull$$$0(5);
        }
        String elemName = elem.getText();
        PsiElement child = elem.getFirstChild();
        if (child instanceof QmlElementReferenceExpressionImpl) {
            JSType parentType = QmlElementReferenceExpressionImpl.getTypeFromParent(child, isComponent);
            if (parentType == null) {
                parentType = QmlElementReferenceExpressionImpl.getTypeFromSameDirQmls(child);
            }
            if (parentType instanceof JSRecordType) {
                JSRecordType parentRecord = (JSRecordType)parentType;
                return QmlElementDeclarationImpl.getChildType(parentRecord, elemName);
            }
            return null;
        }
        JSType curType = QmlElementReferenceExpressionImpl.findInImportedComponents(elem, isComponent);
        if (curType != null) {
            QmlImportDeclarationImpl.QmlRecordType record;
            if (curType instanceof QmlImportDeclarationImpl.QmlRecordType && (record = (QmlImportDeclarationImpl.QmlRecordType)curType).getSourceElement() instanceof QmlImportAliasExpressionImpl) {
                isComponent.set((Object)false);
            }
            return curType;
        }
        return QmlElementDeclarationImpl.getChildTypeFromParentElemDecl(elem, elemName);
    }

    private static JSType getTypeFromIds(@NotNull String elementName, @Nullable PsiElement parent) {
        if (elementName == null) {
            QmlElementReferenceExpressionImpl.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            return null;
        }
        List elemDecls = ContainerUtil.filter((Object[])parent.getChildren(), elem -> elem instanceof QmlElementDeclarationImpl);
        List assignments = ContainerUtil.filter((Object[])parent.getChildren(), elem -> elem instanceof JSAssignmentExpression);
        for (PsiElement assignment : assignments) {
            List declInAssignment = ContainerUtil.filter((Object[])assignment.getChildren(), elem -> elem instanceof QmlElementDeclarationImpl);
            if (declInAssignment.isEmpty()) continue;
            elemDecls = ContainerUtil.concat((List)elemDecls, (List)declInAssignment);
        }
        for (PsiElement curElemDecl : elemDecls) {
            PsiElement scope;
            List idElem;
            List<PsiElement> blockElem = Arrays.stream(curElemDecl.getChildren()).filter(elem -> elem instanceof JSBlockStatement).toList();
            if (blockElem.isEmpty() || (idElem = ContainerUtil.filter((Object[])(scope = blockElem.get(0)).getChildren(), elem -> elem instanceof JSAssignmentExpression && elem.getChildren().length > 1 && elem.getChildren()[0].getText().equals("id"))).isEmpty() || ((PsiElement)idElem.get(0)).getChildren().length < 2) continue;
            @NlsSafe String idName = ((PsiElement)idElem.get(0)).getChildren()[1].getFirstChild().getText();
            if (idName.equals(elementName)) {
                @NotNull JSTypeSource typeSrc = JSTypeSourceFactory.createTypeSource((PsiElement)curElemDecl, (boolean)true);
                ArrayList<PropertySignatureImpl> curTypeMembers = new ArrayList<PropertySignatureImpl>();
                @Nullable List<SmartPsiElementPointer<PsiElement>> properties = ((QmlElementDeclarationImpl)curElemDecl).getProperties();
                if (properties != null) {
                    for (SmartPsiElementPointer<PsiElement> property : properties) {
                        PsiElement psiElement;
                        if (property == null || !((psiElement = property.getElement()) instanceof QmlLocalImplicitElementImpl)) continue;
                        QmlLocalImplicitElementImpl localElem = (QmlLocalImplicitElementImpl)psiElement;
                        curTypeMembers.add(new PropertySignatureImpl(localElem.getName(), localElem.getJSType(), false, false));
                    }
                }
                return new QmlImportDeclarationImpl.QmlRecordType(typeSrc, curTypeMembers, elementName);
            }
            JSType typeFromChild = QmlElementReferenceExpressionImpl.getTypeFromIds(elementName, scope);
            if (typeFromChild == null) continue;
            return typeFromChild;
        }
        return null;
    }

    @Nullable
    private JSType getJSType(Ref<Boolean> isComponent) {
        JSType jsType = QmlElementReferenceExpressionImpl.getTypeFromParent((PsiElement)this, isComponent);
        if (jsType != null) {
            return jsType;
        }
        return QmlElementReferenceExpressionImpl.getTypeFromIds(this.getText(), (PsiElement)this.getContainingFile());
    }

    @Nullable
    public JSType getJSType() {
        Ref isComponent = new Ref((Object)false);
        return this.getJSType((Ref<Boolean>)isComponent);
    }

    public boolean evaluate(@NotNull JSEvaluateContext evaluateContext, @NotNull JSTypeProcessor typeProcessor) {
        Ref isComponent;
        Object jsType;
        if (evaluateContext == null) {
            QmlElementReferenceExpressionImpl.$$$reportNull$$$0(7);
        }
        if (typeProcessor == null) {
            QmlElementReferenceExpressionImpl.$$$reportNull$$$0(8);
        }
        if ((jsType = this.getJSType((Ref<Boolean>)(isComponent = new Ref((Object)false)))) != null) {
            if (((Boolean)isComponent.get()).booleanValue() || jsType.getSourceElement() == null) {
                @NotNull JSTypeSource typeSrc = JSTypeSourceFactory.createTypeSource((PsiElement)this, (boolean)true);
                ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
                for (JSRecordType.TypeMember member : jsType.asRecordType().getTypeMembers()) {
                    if (!((Boolean)isComponent.get()).booleanValue()) {
                        typeMembers.add(member);
                        continue;
                    }
                    if (!(member instanceof QmlImportDeclarationImpl.QmlPropertySignatureImpl) || ((QmlImportDeclarationImpl.QmlPropertySignatureImpl)member).getKind() != QmlImportDeclarationImpl.QmlMember.Kind.EnumValue) continue;
                    typeMembers.add(member);
                }
                jsType = new QmlImportDeclarationImpl.QmlRecordType(typeSrc, typeMembers, "onlyEnums" + jsType.getTypeText());
            }
            typeProcessor.process(jsType, evaluateContext);
            return true;
        }
        return false;
    }

    public boolean allowRecordingAsNeighborElement() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/qml/psi/impl/QmlElementReferenceExpressionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readJSFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findInAliases";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findInImportedComponents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromSameDirQmls";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromParent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromIds";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

