/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.view.DefaultBackgroundRendererImpl;
import com.intellij.openapi.graph.threading.GraphThreadingType;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphBuilderFactoryImpl
extends GraphBuilderFactory {
    @NotNull
    private final Project myProject;

    public GraphBuilderFactoryImpl(@NotNull Project project) {
        if (project == null) {
            GraphBuilderFactoryImpl.L(0);
        }
        this.myProject = project;
    }

    @NotNull
    public <N, E> GraphBuilder<N, E> createGraphBuilder(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull GraphDataModel<N, E> dataModel, @NotNull GraphPresentationModel<N, E> presentationModel, @Nullable EditMode editMode) {
        if (graph == null) {
            GraphBuilderFactoryImpl.L(1);
        }
        if (view == null) {
            GraphBuilderFactoryImpl.L(2);
        }
        if (dataModel == null) {
            GraphBuilderFactoryImpl.L(3);
        }
        if (presentationModel == null) {
            GraphBuilderFactoryImpl.L(4);
        }
        GraphBuilder graphBuilder = (GraphBuilder)WriteAction.computeAndWait(() -> {
            final GraphBuilderImpl graphBuilderImpl = new GraphBuilderImpl(this.myProject, graph, view, dataModel, presentationModel, GraphThreadingType.OLD_EDT_BASED, editMode);
            if (presentationModel instanceof BasicGraphPresentationModel) {
                ((BasicGraphPresentationModel)presentationModel).setGraphBuilder(graphBuilderImpl);
                graph.addGraph2DSelectionListener(new Graph2DSelectionListener(){

                    public void onGraph2DSelectionEvent(Graph2DSelectionEvent e2) {
                        if (e2.isNodeSelection()) {
                            graphBuilderImpl.getGraphPresentationModel().onSelectionChanged(e2);
                        }
                    }
                });
            }
            ((DefaultBackgroundRendererImpl)view.getBackgroundRenderer()).setColor(JBColor.background());
            return graphBuilderImpl;
        });
        if (graphBuilder == null) {
            GraphBuilderFactoryImpl.L(5);
        }
        return graphBuilder;
    }

    @NotNull
    public <N, E> GraphBuilder<N, E> createGraphBuilder(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull GraphDataModel<N, E> dataModel, @NotNull GraphPresentationModel<N, E> presentationModel) {
        if (graph == null) {
            GraphBuilderFactoryImpl.L(6);
        }
        if (view == null) {
            GraphBuilderFactoryImpl.L(7);
        }
        if (dataModel == null) {
            GraphBuilderFactoryImpl.L(8);
        }
        if (presentationModel == null) {
            GraphBuilderFactoryImpl.L(9);
        }
        GraphBuilder<N, E> graphBuilder = this.createGraphBuilder(graph, view, dataModel, presentationModel, null);
        if (graphBuilder == null) {
            GraphBuilderFactoryImpl.L(10);
        }
        return graphBuilder;
    }

    @NotNull
    public <N, E> GraphBuilder<N, E> createGraphBuilder(@NotNull GraphDataModel<N, E> dataModel, @NotNull GraphPresentationModel<N, E> presentationModel) {
        if (dataModel == null) {
            GraphBuilderFactoryImpl.L(11);
        }
        if (presentationModel == null) {
            GraphBuilderFactoryImpl.L(12);
        }
        GraphBuilder<N, E> graphBuilder = this.createGraphBuilder(GraphManager.getGraphManager().createGraph2D(), GraphManager.getGraphManager().createGraph2DView(), dataModel, presentationModel);
        if (graphBuilder == null) {
            GraphBuilderFactoryImpl.L(13);
        }
        return graphBuilder;
    }

    @NotNull
    public <N, E> GraphBuilder<N, E> createGraphBuilder(@NotNull GraphDataModel<N, E> dataModel) {
        if (dataModel == null) {
            GraphBuilderFactoryImpl.L(14);
        }
        Graph2D graph2D = GraphManager.getGraphManager().createGraph2D();
        GraphBuilder<N, E> graphBuilder = this.createGraphBuilder(graph2D, GraphManager.getGraphManager().createGraph2DView(), dataModel, (GraphPresentationModel<N, E>)new BasicGraphPresentationModel((Graph)graph2D));
        if (graphBuilder == null) {
            GraphBuilderFactoryImpl.L(15);
        }
        return graphBuilder;
    }

    @NotNull
    public <N, E> EventDispatcher<GraphBuilderListener> getGraphBuilderDispatcher(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            GraphBuilderFactoryImpl.L(16);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = ((GraphBuilderImpl)builder).getGraphBuilderDispatcher();
        if (eventDispatcher == null) {
            GraphBuilderFactoryImpl.L(17);
        }
        return eventDispatcher;
    }

    private static /* synthetic */ void L(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 5, 10, 13, 15, 17 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 4: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createGraphBuilder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilderDispatcher";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createGraphBuilder";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGraphBuilderDispatcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 5, 10, 13, 15, 17 -> new IllegalStateException(string);
        };
    }
}

