/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui.download;

import com.intellij.openapi.project.Project;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrlImpl;
import com.intellij.webcore.libraries.ui.download.DownloadableWebLibrariesSource;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DefaultDownloadableWebLibrariesSource
extends DownloadableWebLibrariesSource {
    private final LangScriptingContextProvider myProvider;
    private final Project myProject;

    DefaultDownloadableWebLibrariesSource(Project project, LangScriptingContextProvider provider) {
        super(WebCoreBundle.message((String)"library.download.official_libraries_source.name", (Object[])new Object[0]), true);
        this.myProvider = provider;
        this.myProject = project;
    }

    @Override
    public void prepareTableModel(final DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl> callback) {
        DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescription> fileSetVersionsCallback = new DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescription>(){

            public void onSuccess(@NotNull List<? extends DownloadableFileSetDescription> versions) {
                if (versions == null) {
                    1.L(0);
                }
                ArrayList arrayList = new ArrayList();
                for (DownloadableFileSetDescription downloadableFileSetDescription : versions) {
                    arrayList.add(1.L(downloadableFileSetDescription, downloadableFileSetDescription.getFiles()));
                }
                callback.onSuccess(arrayList);
            }

            private static <T extends DownloadableFileDescription> DownloadableFileSetDescriptionWithUrlImpl<T> L(DownloadableFileSetDescription downloadableFileSetDescription, List<T> list) {
                return new DownloadableFileSetDescriptionWithUrlImpl<T>(downloadableFileSetDescription.getName(), downloadableFileSetDescription.getVersionString(), ((DownloadableFileDescription)downloadableFileSetDescription.getFiles().get(0)).getDownloadUrl(), list);
            }

            private static /* synthetic */ void L(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/intellij/webcore/libraries/ui/download/DefaultDownloadableWebLibrariesSource$1", "onSuccess"));
            }
        };
        this.myProvider.getDownloadableLibraryDescriptors(this.myProject).fetchVersions((DownloadableFileSetVersions.FileSetVersionsCallback)fileSetVersionsCallback);
    }
}

