/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.converters.curl.CurlClientGeneratorKt;
import com.intellij.httpClient.converters.curl.CurlRequestBuilder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.microservices.client.generator.ClientExample;
import com.intellij.microservices.client.generator.ClientGenerator;
import com.intellij.microservices.oas.OasComponents;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasParameterIn;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/converters/curl/CurlClientGenerator;", "Lcom/intellij/microservices/client/generator/ClientGenerator;", "<init>", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "generate", "Lcom/intellij/microservices/client/generator/ClientExample;", "project", "Lcom/intellij/openapi/project/Project;", "openApiSpecification", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "generateCurlCommandForOperation", "path", "Lcom/intellij/microservices/oas/OasEndpointPath;", "operation", "Lcom/intellij/microservices/oas/OasOperation;", "components", "Lcom/intellij/microservices/oas/OasComponents;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nCurlClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurlClientGenerator.kt\ncom/intellij/httpClient/converters/curl/CurlClientGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1368#2:116\n1454#2,2:117\n1557#2:119\n1628#2,3:120\n1456#2,3:123\n1863#2,2:126\n1#3:128\n*S KotlinDebug\n*F\n+ 1 CurlClientGenerator.kt\ncom/intellij/httpClient/converters/curl/CurlClientGenerator\n*L\n17#1:116\n17#1:117,2\n18#1:119\n18#1:120,3\n17#1:123,3\n47#1:126,2\n*E\n"})
public final class CurlClientGenerator
implements ClientGenerator {
    @NotNull
    public String getTitle() {
        String string = RestClientBundle.message("curl.client.generator.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ClientExample generate(@NotNull Project project, @NotNull OpenApiSpecification openApiSpecification) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)openApiSpecification, (String)"openApiSpecification");
        Iterable $this$flatMap$iv = openApiSpecification.getPaths();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            OasEndpointPath path = (OasEndpointPath)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = path.getOperations();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void operation;
                OasOperation oasOperation = (OasOperation)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(this.generateCurlCommandForOperation(path, (OasOperation)operation, openApiSpecification.getComponents()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List curlCommands = (List)destination$iv$iv;
        StringBuilder $this$generate_u24lambda_u242 = new StringBuilder();
        boolean bl = false;
        Iterator iterator = ((Iterable)curlCommands).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String command = (String)iterator.next();
            if (i > 0) {
                $this$generate_u24lambda_u242.append('\n');
                $this$generate_u24lambda_u242.append("###").append('\n');
            }
            $this$generate_u24lambda_u242.append(command);
        }
        String string = $this$generate_u24lambda_u242.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"run(...)");
        String text2 = string;
        return ClientExample.Companion.fromFileExtension(text2, "sh");
    }

    private final String generateCurlCommandForOperation(OasEndpointPath path, OasOperation operation, OasComponents components) {
        CurlRequestBuilder curlRequestBuilder;
        CurlRequestBuilder $this$generateCurlCommandForOperation_u24lambda_u248 = curlRequestBuilder = new CurlRequestBuilder(false, 1, null);
        boolean bl = false;
        String p = StringsKt.removePrefix((String)path.getPath(), (CharSequence)"/");
        Object url = null;
        url = "http://localhost/" + p;
        String string = operation.getMethod().getMethodName().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        $this$generateCurlCommandForOperation_u24lambda_u248.withMethod(string);
        Iterable $this$forEach$iv = operation.getParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OasParameter param = (OasParameter)element$iv;
            boolean bl2 = false;
            OasSchema oasSchema = param.getSchema();
            OasSchema realSchema = oasSchema != null ? CurlClientGeneratorKt.access$getRealSchema(oasSchema, components) : null;
            switch (WhenMappings.$EnumSwitchMapping$0[param.getInPlace().ordinal()]) {
                case 1: {
                    url = StringsKt.replace$default((String)url, (String)("{" + param.getName() + "}"), (String)CurlClientGeneratorKt.access$getValue(realSchema), (boolean)false, (int)4, null);
                    break;
                }
                case 2: {
                    $this$generateCurlCommandForOperation_u24lambda_u248.withQueryParameters(arg_0 -> CurlClientGenerator.generateCurlCommandForOperation$lambda$8$lambda$5$lambda$3(param, realSchema, arg_0));
                    break;
                }
                case 3: {
                    $this$generateCurlCommandForOperation_u24lambda_u248.withHeader(param.getName(), param.getInPlace().getPlaceName(), CurlClientGenerator::generateCurlCommandForOperation$lambda$8$lambda$5$lambda$4);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Object object = operation.getRequestBody();
        if (object != null && (object = object.getContent()) != null && (object = object.entrySet()) != null && (object = (Map.Entry)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) != null) {
            Object object2 = object;
            boolean bl3 = false;
            String contentType = (String)object2.getKey();
            OasSchema body2 = (OasSchema)object2.getValue();
            $this$generateCurlCommandForOperation_u24lambda_u248.withHeader("Content-Type", contentType, CurlClientGenerator::generateCurlCommandForOperation$lambda$8$lambda$7$lambda$6);
            OasSchema realBody = CurlClientGeneratorKt.access$getRealSchema(body2, components);
            String data = Intrinsics.areEqual((Object)contentType, (Object)"application/json") ? CurlClientGeneratorKt.access$generateJsonBodyForObject(realBody) : null;
            String string2 = data;
            if (string2 == null) {
                string2 = CurlClientGeneratorKt.access$getValue(realBody);
            }
            $this$generateCurlCommandForOperation_u24lambda_u248.withTextToSend(string2);
        }
        $this$generateCurlCommandForOperation_u24lambda_u248.withUrl((String)url);
        CurlRequestBuilder curlRequestBuilder2 = curlRequestBuilder;
        return curlRequestBuilder2.build();
    }

    private static final void generateCurlCommandForOperation$lambda$8$lambda$5$lambda$3(OasParameter $param, OasSchema $realSchema, RequestBuilder.QueryBuilder it) {
        it.addQueryParameter($param.getName(), CurlClientGeneratorKt.access$getValue($realSchema));
    }

    private static final String generateCurlCommandForOperation$lambda$8$lambda$5$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return null;
    }

    private static final String generateCurlCommandForOperation$lambda$8$lambda$7$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OasParameterIn.values().length];
            try {
                nArray[OasParameterIn.PATH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasParameterIn.QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasParameterIn.HEADER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasParameterIn.COOKIE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

