/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.google.common.net.InternetDomainName;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.impl.engineV2.UrlComparisonResult;
import com.intellij.httpClient.execution.impl.engineV2.UrlUtilsKt;
import java.net.URL;
import java.time.Instant;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\u0003\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"isExpired", "", "Lcom/intellij/httpClient/execution/RestClientRequest$Biscuit;", "pathMatches", "url", "Ljava/net/URL;", "localDomains", "", "", "hostMatches", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpClientCookieJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientCookieJar.kt\ncom/intellij/httpClient/execution/impl/engineV2/HttpClientCookieJarKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class HttpClientCookieJarKt {
    @NotNull
    private static final Set<String> localDomains;

    private static final boolean isExpired(RestClientRequest.Biscuit $this$isExpired) {
        if ($this$isExpired.getDate() == -1L) {
            return false;
        }
        return Instant.ofEpochMilli($this$isExpired.getDate()).compareTo(Instant.now()) < 0;
    }

    private static final boolean pathMatches(RestClientRequest.Biscuit $this$pathMatches, URL url) {
        String string;
        String urlPath;
        block8: {
            block7: {
                urlPath = url.getPath();
                string = $this$pathMatches.getPath();
                if (string == null) break block7;
                String it = string;
                boolean bl = false;
                String string2 = it.length() > 1 ? StringsKt.removeSuffix((String)it, (CharSequence)"/") : it;
                string = string2;
                if (string2 != null) break block8;
            }
            string = "/";
        }
        String cookiePath = string;
        Intrinsics.checkNotNull((Object)urlPath);
        if (StringsKt.startsWith$default((String)urlPath, (String)cookiePath, (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)cookiePath, (Object)"/")) {
                return true;
            }
            if (urlPath.length() == cookiePath.length()) {
                return true;
            }
            if (urlPath.charAt(cookiePath.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hostMatches(RestClientRequest.Biscuit $this$hostMatches, URL url) {
        String urlHost = url.getHost();
        String string = $this$hostMatches.getDomain();
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)".")) == null) return false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        string = string2;
        if (string2 == null) {
            return false;
        }
        String cookieDomain = string;
        Intrinsics.checkNotNull((Object)urlHost);
        switch (WhenMappings.$EnumSwitchMapping$0[UrlUtilsKt.compareWithSubdomain(cookieDomain, urlHost).ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                int dotIndex = StringsKt.indexOf$default((CharSequence)cookieDomain, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dotIndex != -1) {
                    String string3 = cookieDomain.substring(dotIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    if (localDomains.contains(string3)) return true;
                }
                if (!InternetDomainName.from((String)cookieDomain).isPublicSuffix()) return true;
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final /* synthetic */ boolean access$hostMatches(RestClientRequest.Biscuit $receiver, URL url) {
        return HttpClientCookieJarKt.hostMatches($receiver, url);
    }

    public static final /* synthetic */ boolean access$pathMatches(RestClientRequest.Biscuit $receiver, URL url) {
        return HttpClientCookieJarKt.pathMatches($receiver, url);
    }

    public static final /* synthetic */ boolean access$isExpired(RestClientRequest.Biscuit $receiver) {
        return HttpClientCookieJarKt.isExpired($receiver);
    }

    static {
        Object[] objectArray = new String[]{".localhost.", ".localhost", ".test.", ".local.", ".local", ".localdomain"};
        localDomains = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UrlComparisonResult.values().length];
            try {
                nArray[UrlComparisonResult.EQUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UrlComparisonResult.NOT_EQUAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UrlComparisonResult.SUBDOMAIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

