/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.dns.AbstractDnsOptPseudoRrRecord;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.handler.codec.dns.TcpDnsQueryEncoder;
import io.netty.handler.codec.dns.TcpDnsResponseDecoder;
import io.netty.resolver.dns.DnsNameResolverException;
import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.netty.resolver.dns.DnsQueryContextManager;
import io.netty.resolver.dns.TcpDnsQueryContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;

abstract class DnsQueryContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsQueryContext.class);
    private static final long ID_REUSE_ON_TIMEOUT_DELAY_MILLIS = SystemPropertyUtil.getLong((String)"io.netty.resolver.dns.idReuseOnTimeoutDelayMillis", (long)10000L);
    private static final TcpDnsQueryEncoder TCP_ENCODER;
    private final Future<? extends Channel> channelReadyFuture;
    private final Channel channel;
    private final InetSocketAddress nameServerAddr;
    private final DnsQueryContextManager queryContextManager;
    private final Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
    private final DnsQuestion question;
    private final DnsRecord[] additionals;
    private final DnsRecord optResource;
    private final boolean recursionDesired;
    private final Bootstrap socketBootstrap;
    private final boolean retryWithTcpOnTimeout;
    private final long queryTimeoutMillis;
    private volatile Future<?> timeoutFuture;
    private int id = Integer.MIN_VALUE;

    DnsQueryContext(Channel channel, Future<? extends Channel> channelReadyFuture, InetSocketAddress nameServerAddr, DnsQueryContextManager queryContextManager, int maxPayLoadSize, boolean recursionDesired, long queryTimeoutMillis, DnsQuestion question, DnsRecord[] additionals, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise, Bootstrap socketBootstrap, boolean retryWithTcpOnTimeout) {
        this.channel = (Channel)ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        this.queryContextManager = (DnsQueryContextManager)ObjectUtil.checkNotNull((Object)queryContextManager, (String)"queryContextManager");
        this.channelReadyFuture = (Future)ObjectUtil.checkNotNull(channelReadyFuture, (String)"channelReadyFuture");
        this.nameServerAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)nameServerAddr, (String)"nameServerAddr");
        this.question = (DnsQuestion)ObjectUtil.checkNotNull((Object)question, (String)"question");
        this.additionals = (DnsRecord[])ObjectUtil.checkNotNull((Object)additionals, (String)"additionals");
        this.promise = (Promise)ObjectUtil.checkNotNull(promise, (String)"promise");
        this.recursionDesired = recursionDesired;
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.socketBootstrap = socketBootstrap;
        this.retryWithTcpOnTimeout = retryWithTcpOnTimeout;
        this.optResource = maxPayLoadSize > 0 && !DnsQueryContext.hasOptRecord(additionals) ? new AbstractDnsOptPseudoRrRecord(maxPayLoadSize, 0, 0){} : null;
    }

    private static boolean hasOptRecord(DnsRecord[] additionals) {
        if (additionals != null && additionals.length > 0) {
            for (DnsRecord additional : additionals) {
                if (additional.type() != DnsRecordType.OPT) continue;
                return true;
            }
        }
        return false;
    }

    final boolean isDone() {
        return this.promise.isDone();
    }

    final DnsQuestion question() {
        return this.question;
    }

    protected abstract DnsQuery newQuery(int var1, InetSocketAddress var2);

    protected abstract String protocol();

    final ChannelFuture writeQuery(boolean flush) {
        assert (this.id == Integer.MIN_VALUE) : this.getClass().getSimpleName() + ".writeQuery(...) can only be executed once.";
        this.id = this.queryContextManager.add(this.nameServerAddr, this);
        if (this.id == -1) {
            IllegalStateException e = new IllegalStateException("query ID space exhausted: " + this.question());
            this.finishFailure("failed to send a query via " + this.protocol(), e, false);
            return this.channel.newFailedFuture((Throwable)e);
        }
        this.promise.addListener((GenericFutureListener)new FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>>(){

            public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
                Throwable cause;
                Future timeoutFuture = DnsQueryContext.this.timeoutFuture;
                if (timeoutFuture != null) {
                    DnsQueryContext.this.timeoutFuture = null;
                    timeoutFuture.cancel(false);
                }
                if ((cause = future.cause()) instanceof DnsNameResolverTimeoutException || cause instanceof CancellationException) {
                    DnsQueryContext.this.channel.eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            DnsQueryContext.this.removeFromContextManager(DnsQueryContext.this.nameServerAddr);
                        }
                    }, ID_REUSE_ON_TIMEOUT_DELAY_MILLIS, TimeUnit.MILLISECONDS);
                } else {
                    DnsQueryContext.this.removeFromContextManager(DnsQueryContext.this.nameServerAddr);
                }
            }
        });
        DnsQuestion question = this.question();
        DnsQuery query = this.newQuery(this.id, this.nameServerAddr);
        query.setRecursionDesired(this.recursionDesired);
        query.addRecord(DnsSection.QUESTION, question);
        for (DnsRecord record : this.additionals) {
            query.addRecord(DnsSection.ADDITIONAL, record);
        }
        if (this.optResource != null) {
            query.addRecord(DnsSection.ADDITIONAL, this.optResource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WRITE: {}, [{}: {}], {}", new Object[]{this.channel, this.protocol(), this.id, this.nameServerAddr, question});
        }
        return this.sendQuery(query, flush);
    }

    private void removeFromContextManager(InetSocketAddress nameServerAddr) {
        DnsQueryContext self = this.queryContextManager.remove(nameServerAddr, this.id);
        assert (self == this) : "Removed DnsQueryContext is not the correct instance";
    }

    private ChannelFuture sendQuery(final DnsQuery query, boolean flush) {
        final ChannelPromise writePromise = this.channel.newPromise();
        if (this.channelReadyFuture.isSuccess()) {
            this.writeQuery(query, flush, writePromise);
        } else {
            Throwable cause = this.channelReadyFuture.cause();
            if (cause != null) {
                this.failQuery(query, cause, writePromise);
            } else {
                this.channelReadyFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

                    public void operationComplete(Future<? super Channel> future) {
                        if (future.isSuccess()) {
                            DnsQueryContext.this.writeQuery(query, true, writePromise);
                        } else {
                            Throwable cause = future.cause();
                            DnsQueryContext.this.failQuery(query, cause, writePromise);
                        }
                    }
                });
            }
        }
        return writePromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failQuery(DnsQuery query, Throwable cause, ChannelPromise writePromise) {
        try {
            this.promise.tryFailure(cause);
            writePromise.tryFailure(cause);
        }
        finally {
            ReferenceCountUtil.release((Object)query);
        }
    }

    private void writeQuery(DnsQuery query, boolean flush, ChannelPromise promise) {
        ChannelFuture writeFuture;
        ChannelFuture channelFuture = writeFuture = flush ? this.channel.writeAndFlush((Object)query, promise) : this.channel.write((Object)query, promise);
        if (writeFuture.isDone()) {
            this.onQueryWriteCompletion(this.queryTimeoutMillis, writeFuture);
        } else {
            writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    DnsQueryContext.this.onQueryWriteCompletion(DnsQueryContext.this.queryTimeoutMillis, writeFuture);
                }
            });
        }
    }

    private void onQueryWriteCompletion(final long queryTimeoutMillis, ChannelFuture writeFuture) {
        if (!writeFuture.isSuccess()) {
            this.finishFailure("failed to send a query '" + this.id + "' via " + this.protocol(), writeFuture.cause(), false);
            return;
        }
        if (queryTimeoutMillis > 0L) {
            this.timeoutFuture = this.channel.eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    if (DnsQueryContext.this.promise.isDone()) {
                        return;
                    }
                    DnsQueryContext.this.finishFailure("query '" + DnsQueryContext.this.id + "' via " + DnsQueryContext.this.protocol() + " timed out after " + queryTimeoutMillis + " milliseconds", null, true);
                }
            }, queryTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    void finishSuccess(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope, boolean truncated) {
        if (!truncated || !this.retryWithTcp(envelope)) {
            DnsResponse res = (DnsResponse)envelope.content();
            if (res.count(DnsSection.QUESTION) != 1) {
                logger.warn("{} Received a DNS response with invalid number of questions. Expected: 1, found: {}", (Object)this.channel, envelope);
            } else if (!this.question().equals(res.recordAt(DnsSection.QUESTION))) {
                logger.warn("{} Received a mismatching DNS response. Expected: [{}], found: {}", new Object[]{this.channel, this.question(), envelope});
            } else if (this.trySuccess(envelope)) {
                return;
            }
            envelope.release();
        }
    }

    private boolean trySuccess(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope) {
        return this.promise.trySuccess(envelope);
    }

    final boolean finishFailure(String message, Throwable cause, boolean timeout) {
        DnsNameResolverException e;
        if (this.promise.isDone()) {
            return false;
        }
        DnsQuestion question = this.question();
        StringBuilder buf = new StringBuilder(message.length() + 128);
        buf.append('[').append(this.id).append(": ").append(this.nameServerAddr).append("] ").append(question).append(' ').append(message).append(" (no stack trace available)");
        if (timeout) {
            e = new DnsNameResolverTimeoutException(this.nameServerAddr, question, buf.toString());
            if (this.retryWithTcpOnTimeout && this.retryWithTcp(e)) {
                return false;
            }
        } else {
            e = new DnsNameResolverException(this.nameServerAddr, question, buf.toString(), cause);
        }
        return this.promise.tryFailure((Throwable)e);
    }

    private boolean retryWithTcp(final Object originalResult) {
        if (this.socketBootstrap == null) {
            return false;
        }
        this.socketBootstrap.connect((SocketAddress)this.nameServerAddr).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    logger.debug("{} Unable to fallback to TCP [{}: {}]", new Object[]{future.channel(), DnsQueryContext.this.id, DnsQueryContext.this.nameServerAddr, future.cause()});
                    DnsQueryContext.this.finishOriginal(originalResult, (Future)future);
                    return;
                }
                final Channel tcpCh = future.channel();
                Promise promise = tcpCh.eventLoop().newPromise();
                final TcpDnsQueryContext tcpCtx = new TcpDnsQueryContext(tcpCh, (Future<? extends Channel>)DnsQueryContext.this.channelReadyFuture, (InetSocketAddress)tcpCh.remoteAddress(), DnsQueryContext.this.queryContextManager, 0, DnsQueryContext.this.recursionDesired, DnsQueryContext.this.queryTimeoutMillis, DnsQueryContext.this.question(), DnsQueryContext.this.additionals, (Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>>)promise);
                tcpCh.pipeline().addLast(new ChannelHandler[]{TCP_ENCODER});
                tcpCh.pipeline().addLast(new ChannelHandler[]{new TcpDnsResponseDecoder()});
                tcpCh.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        DnsQueryContext foundCtx;
                        Channel tcpCh = ctx.channel();
                        DnsResponse response2 = (DnsResponse)msg;
                        int queryId = response2.id();
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} RECEIVED: TCP [{}: {}], {}", new Object[]{tcpCh, queryId, tcpCh.remoteAddress(), response2});
                        }
                        if ((foundCtx = DnsQueryContext.this.queryContextManager.get(DnsQueryContext.this.nameServerAddr, queryId)) != null && foundCtx.isDone()) {
                            logger.debug("{} Received a DNS response for a query that was timed out or cancelled : TCP [{}: {}]", new Object[]{tcpCh, queryId, DnsQueryContext.this.nameServerAddr});
                            response2.release();
                        } else if (foundCtx == tcpCtx) {
                            tcpCtx.finishSuccess(new AddressedEnvelopeAdapter((InetSocketAddress)ctx.channel().remoteAddress(), (InetSocketAddress)ctx.channel().localAddress(), response2), false);
                        } else {
                            response2.release();
                            tcpCtx.finishFailure("Received TCP DNS response with unexpected ID", null, false);
                            if (logger.isDebugEnabled()) {
                                logger.debug("{} Received a DNS response with an unexpected ID: TCP [{}: {}]", new Object[]{tcpCh, queryId, tcpCh.remoteAddress()});
                            }
                        }
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        if (tcpCtx.finishFailure("TCP fallback error", cause, false) && logger.isDebugEnabled()) {
                            logger.debug("{} Error during processing response: TCP [{}: {}]", new Object[]{ctx.channel(), DnsQueryContext.this.id, ctx.channel().remoteAddress(), cause});
                        }
                    }
                }});
                promise.addListener((GenericFutureListener)new FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>>(){

                    public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
                        if (future.isSuccess()) {
                            DnsQueryContext.this.finishSuccess((AddressedEnvelope<? extends DnsResponse, InetSocketAddress>)((AddressedEnvelope)future.getNow()), false);
                            ReferenceCountUtil.release((Object)originalResult);
                        } else {
                            DnsQueryContext.this.finishOriginal(originalResult, future);
                        }
                        tcpCh.close();
                    }
                });
                tcpCtx.writeQuery(true);
            }
        });
        return true;
    }

    private void finishOriginal(Object originalResult, Future<?> future) {
        if (originalResult instanceof Throwable) {
            Throwable error = (Throwable)originalResult;
            ThrowableUtil.addSuppressed((Throwable)error, (Throwable)future.cause());
            this.promise.tryFailure(error);
        } else {
            this.finishSuccess((AddressedEnvelope<? extends DnsResponse, InetSocketAddress>)((AddressedEnvelope)originalResult), false);
        }
    }

    static {
        logger.debug("-Dio.netty.resolver.dns.idReuseOnTimeoutDelayMillis: {}", (Object)ID_REUSE_ON_TIMEOUT_DELAY_MILLIS);
        TCP_ENCODER = new TcpDnsQueryEncoder();
    }

    private static final class AddressedEnvelopeAdapter
    implements AddressedEnvelope<DnsResponse, InetSocketAddress> {
        private final InetSocketAddress sender;
        private final InetSocketAddress recipient;
        private final DnsResponse response;

        AddressedEnvelopeAdapter(InetSocketAddress sender, InetSocketAddress recipient, DnsResponse response2) {
            this.sender = sender;
            this.recipient = recipient;
            this.response = response2;
        }

        public DnsResponse content() {
            return this.response;
        }

        public InetSocketAddress sender() {
            return this.sender;
        }

        public InetSocketAddress recipient() {
            return this.recipient;
        }

        public AddressedEnvelope<DnsResponse, InetSocketAddress> retain() {
            this.response.retain();
            return this;
        }

        public AddressedEnvelope<DnsResponse, InetSocketAddress> retain(int increment) {
            this.response.retain(increment);
            return this;
        }

        public AddressedEnvelope<DnsResponse, InetSocketAddress> touch() {
            this.response.touch();
            return this;
        }

        public AddressedEnvelope<DnsResponse, InetSocketAddress> touch(Object hint) {
            this.response.touch(hint);
            return this;
        }

        public int refCnt() {
            return this.response.refCnt();
        }

        public boolean release() {
            return this.response.release();
        }

        public boolean release(int decrement) {
            return this.response.release(decrement);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AddressedEnvelope)) {
                return false;
            }
            AddressedEnvelope that = (AddressedEnvelope)obj;
            if (this.sender() == null ? that.sender() != null : !this.sender().equals(that.sender())) {
                return false;
            }
            if (this.recipient() == null ? that.recipient() != null : !this.recipient().equals(that.recipient())) {
                return false;
            }
            return this.response.equals(obj);
        }

        public int hashCode() {
            int hashCode = this.response.hashCode();
            if (this.sender() != null) {
                hashCode = hashCode * 31 + this.sender().hashCode();
            }
            if (this.recipient() != null) {
                hashCode = hashCode * 31 + this.recipient().hashCode();
            }
            return hashCode;
        }
    }
}

