/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.compose;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.cli.DockerComposeCli;
import com.intellij.docker.remote.compose.DockerComposeCacheValue;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/remote/compose/DockerComposeVersionProvider;", "", "<init>", "()V", "getDockerComposeVersion", "", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "runtime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "Companion", "intellij.clouds.docker.remoteRun"})
public final class DockerComposeVersionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<DockerComposeCacheValue> DOCKER_COMPOSE_VERSION_CACHE_KEY;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_DOCKER_COMPOSE_VERSION = "1.11.2";

    private DockerComposeVersionProvider() {
    }

    @NotNull
    public final String getDockerComposeVersion(@NotNull DockerCloudConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        try {
            DockerComposeCacheValue cachedValue = (DockerComposeCacheValue)config2.getCache().getUserData(DOCKER_COMPOSE_VERSION_CACHE_KEY);
            if (cachedValue != null && System.currentTimeMillis() <= cachedValue.getRecordTime() + (long)30000) {
                return cachedValue.getVersion();
            }
            String newValue2 = (String)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(config2, null){
                int label;
                final /* synthetic */ DockerCloudConfiguration $config;
                {
                    this.$config = $config;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return DockerComposeCli.Companion.getVersion(this.$config, ProgressManager.getInstance().getProgressIndicator());
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            config2.getCache().putUserData(DOCKER_COMPOSE_VERSION_CACHE_KEY, (Object)new DockerComposeCacheValue(newValue2, System.currentTimeMillis()));
            return newValue2;
        }
        catch (Exception e) {
            LOG.info("Unable to get Docker Compose version using. path: " + config2.getDockerComposeExePath() + ", autodetect: " + config2.getAutoDetectExePaths(), (Throwable)e);
            return DEFAULT_DOCKER_COMPOSE_VERSION;
        }
    }

    @NotNull
    public final String getDockerComposeVersion(@NotNull RemoteDockerRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        return this.getDockerComposeVersion(runtime.getAccount());
    }

    @JvmStatic
    @NotNull
    public static final DockerComposeVersionProvider getInstance() {
        return Companion.getInstance();
    }

    static {
        Key key = Key.create((String)"docker.compose.version");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DOCKER_COMPOSE_VERSION_CACHE_KEY = key;
        Logger logger = Logger.getInstance(DockerComposeVersionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0007R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/remote/compose/DockerComposeVersionProvider$Companion;", "", "<init>", "()V", "DOCKER_COMPOSE_VERSION_CACHE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/docker/remote/compose/DockerComposeCacheValue;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DEFAULT_DOCKER_COMPOSE_VERSION", "", "getInstance", "Lcom/intellij/docker/remote/compose/DockerComposeVersionProvider;", "intellij.clouds.docker.remoteRun"})
    @SourceDebugExtension(value={"SMAP\nDockerComposeVersionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeVersionProvider.kt\ncom/intellij/docker/remote/compose/DockerComposeVersionProvider$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,59:1\n40#2,3:60\n*S KotlinDebug\n*F\n+ 1 DockerComposeVersionProvider.kt\ncom/intellij/docker/remote/compose/DockerComposeVersionProvider$Companion\n*L\n55#1:60,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DockerComposeVersionProvider getInstance() {
            boolean $i$f$service = false;
            Class<DockerComposeVersionProvider> serviceClass$iv = DockerComposeVersionProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DockerComposeVersionProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

