/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.support;

import java.util.Iterator;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.util.Args;

public class ClassicResponseBuilder {
    private int status;
    private ProtocolVersion version;
    private HeaderGroup headerGroup;
    private HttpEntity entity;

    ClassicResponseBuilder() {
    }

    ClassicResponseBuilder(int status2) {
        this.status = status2;
    }

    public static ClassicResponseBuilder create(int status2) {
        Args.checkRange(status2, 100, 599, "HTTP status code");
        return new ClassicResponseBuilder(status2);
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public ClassicResponseBuilder setVersion(ProtocolVersion version2) {
        this.version = version2;
        return this;
    }

    public Header[] getHeaders(String name2) {
        return this.headerGroup != null ? this.headerGroup.getHeaders(name2) : null;
    }

    public ClassicResponseBuilder setHeaders(Header ... headers) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeaders(headers);
        return this;
    }

    public Header getFirstHeader(String name2) {
        return this.headerGroup != null ? this.headerGroup.getFirstHeader(name2) : null;
    }

    public Header getLastHeader(String name2) {
        return this.headerGroup != null ? this.headerGroup.getLastHeader(name2) : null;
    }

    public ClassicResponseBuilder addHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader(header);
        return this;
    }

    public ClassicResponseBuilder addHeader(String name2, String value) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader(new BasicHeader(name2, value));
        return this;
    }

    public ClassicResponseBuilder removeHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.removeHeader(header);
        return this;
    }

    public ClassicResponseBuilder removeHeaders(String name2) {
        if (name2 == null || this.headerGroup == null) {
            return this;
        }
        Iterator<Header> i = this.headerGroup.headerIterator();
        while (i.hasNext()) {
            Header header = i.next();
            if (!name2.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
        return this;
    }

    public ClassicResponseBuilder setHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeader(header);
        return this;
    }

    public ClassicResponseBuilder setHeader(String name2, String value) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeader(new BasicHeader(name2, value));
        return this;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public ClassicResponseBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public ClassicResponseBuilder setEntity(String content2, ContentType contentType) {
        this.entity = new StringEntity(content2, contentType);
        return this;
    }

    public ClassicResponseBuilder setEntity(String content2) {
        this.entity = new StringEntity(content2);
        return this;
    }

    public ClassicResponseBuilder setEntity(byte[] content2, ContentType contentType) {
        this.entity = new ByteArrayEntity(content2, contentType);
        return this;
    }

    public ClassicHttpResponse build() {
        BasicClassicHttpResponse result2 = new BasicClassicHttpResponse(this.status);
        result2.setVersion(this.version != null ? this.version : HttpVersion.HTTP_1_1);
        if (this.headerGroup != null) {
            result2.setHeaders(this.headerGroup.getHeaders());
        }
        result2.setEntity(this.entity);
        return result2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClassicResponseBuilder [method=");
        builder.append(this.status);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", version=");
        builder.append(this.version);
        builder.append(", headerGroup=");
        builder.append(this.headerGroup);
        builder.append(", entity=");
        builder.append(this.entity != null ? this.entity.getClass() : null);
        builder.append("]");
        return builder.toString();
    }
}

