/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.core.CoreBundle;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.inspections.requirement.RunningPackagingTasksListener;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.ui.PyUiUtil;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBP\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0015\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/inspections/quickfix/PyInstallRequirementsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "quickFixName", "", "Lorg/jetbrains/annotations/Nls;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "unsatisfied", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "installOptions", "listener", "Lcom/jetbrains/python/inspections/requirement/RunningPackagingTasksListener;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/util/List;Ljava/util/List;Lcom/jetbrains/python/inspections/requirement/RunningPackagingTasksListener;)V", "getFamilyName", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "installRequirements", "requirements", "hasAdminPermissionsAndConfigureInterpreter", "askToConfigureInterpreter", "", "Companion", "intellij.python.community.impl"})
public final class PyInstallRequirementsFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String quickFixName;
    @NotNull
    private final Module module;
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final List<PyRequirement> unsatisfied;
    @NotNull
    private final List<String> installOptions;
    @Nullable
    private final RunningPackagingTasksListener listener;
    private static final int DEFAULT_OPTION_INDEX = 0;
    private static final int SDK_NAME_MAX_LENGTH = 25;

    public PyInstallRequirementsFix(@Nullable String quickFixName, @NotNull Module module, @NotNull Sdk sdk2, @NotNull List<? extends PyRequirement> unsatisfied, @NotNull List<String> installOptions, @Nullable RunningPackagingTasksListener listener2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(unsatisfied, (String)"unsatisfied");
        Intrinsics.checkNotNullParameter(installOptions, (String)"installOptions");
        this.quickFixName = quickFixName;
        this.module = module;
        this.sdk = sdk2;
        this.unsatisfied = unsatisfied;
        this.installOptions = installOptions;
        this.listener = listener2;
    }

    public /* synthetic */ PyInstallRequirementsFix(String string, Module module, Sdk sdk2, List list, List list2, RunningPackagingTasksListener runningPackagingTasksListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            runningPackagingTasksListener = null;
        }
        this(string, module, sdk2, list, list2, runningPackagingTasksListener);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.quickFixName;
        if (string == null) {
            Object[] objectArray = new Object[]{this.unsatisfied.size()};
            String string2 = PyPsiBundle.message("QFIX.NAME.install.requirements", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.hasAdminPermissionsAndConfigureInterpreter(project, descriptor2, this.sdk)) {
            return;
        }
        SideEffectGuard.Companion.checkSideEffectAllowed(SideEffectGuard.EffectType.PROJECT_MODEL);
        PyUiUtil.clearFileLevelInspectionResults(descriptor2.getPsiElement().getContainingFile());
        this.installRequirements(project, this.unsatisfied, descriptor2);
    }

    private final void installRequirements(Project project, List<? extends PyRequirement> requirements, ProblemDescriptor descriptor2) {
        PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        RunningPackagingTasksListener runningPackagingTasksListener = this.listener;
        if (runningPackagingTasksListener == null) {
            runningPackagingTasksListener = new RunningPackagingTasksListener(this.module);
        }
        RunningPackagingTasksListener listener2 = runningPackagingTasksListener;
        PyPackageManagerUI ui = new PyPackageManagerUI(project, this.sdk, listener2);
        ui.install(requirements, this.installOptions);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
    }

    private final boolean hasAdminPermissionsAndConfigureInterpreter(Project project, ProblemDescriptor descriptor2, Sdk sdk2) {
        if (PythonSdkUtil.isRemote(sdk2) || !PySdkExtKt.adminPermissionsNeeded(sdk2)) {
            return false;
        }
        int answer = this.askToConfigureInterpreter(project, sdk2);
        if (answer == 0) {
            new PyInterpreterInspection.ConfigureInterpreterFix().applyFix(project, descriptor2);
        }
        return answer == 0 || answer == 2 || answer == -1;
    }

    private final int askToConfigureInterpreter(Project project, Sdk sdk2) {
        String string = StringUtil.shortenTextWithEllipsis((String)sdk2.getName(), (int)25, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        String sdkName2 = string;
        Object[] objectArray = new Object[]{sdkName2};
        String string2 = PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String text = string2;
        objectArray = new String[]{PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required.button.configure", new Object[0]), PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required.button.install.anyway", new Object[0]), CoreBundle.message((String)"button.cancel", (Object[])new Object[0])};
        Object[] options = objectArray;
        return Messages.showIdeaMessageDialog((Project)project, (String)text, (String)PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required", new Object[0]), (String[])options, (int)0, (Icon)Messages.getWarningIcon(), null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/inspections/quickfix/PyInstallRequirementsFix$Companion;", "", "<init>", "()V", "DEFAULT_OPTION_INDEX", "", "SDK_NAME_MAX_LENGTH", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

