/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.toolwindow.modules;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.packaging.toolwindow.PyPackagingToolWindowService;
import com.jetbrains.python.packaging.toolwindow.modules.PyPackagesModuleController;
import com.jetbrains.python.packaging.utils.PyPackageCoroutine;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0012\u001b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000eH\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001eH\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010\u000e2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\b\u0010)\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/jetbrains/python/packaging/toolwindow/modules/PyPackagesModuleController;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "packagingScope", "Lkotlinx/coroutines/CoroutineScope;", "toolWindowService", "Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowService;", "getToolWindowService", "()Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowService;", "allModules", "", "Lcom/intellij/openapi/module/Module;", "getAllModules", "()Ljava/util/List;", "moduleListRenderer", "com/jetbrains/python/packaging/toolwindow/modules/PyPackagesModuleController$moduleListRenderer$1", "Lcom/jetbrains/python/packaging/toolwindow/modules/PyPackagesModuleController$moduleListRenderer$1;", "moduleList", "Lcom/intellij/ui/components/JBList;", "mainScrollPane", "Ljavax/swing/JScrollPane;", "getMainScrollPane", "()Ljavax/swing/JScrollPane;", "fileEditorListener", "com/jetbrains/python/packaging/toolwindow/modules/PyPackagesModuleController$fileEditorListener$1", "Lcom/jetbrains/python/packaging/toolwindow/modules/PyPackagesModuleController$fileEditorListener$1;", "refreshModuleListAndSelection", "", "refreshModuleList", "restorePreviousSelection", "updateSelectedModuleIndex", "module", "createSelectionListener", "Ljavax/swing/event/ListSelectionListener;", "subscribeToFileEditorEvents", "getModuleForVirtualFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyPackagesModuleController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPackagesModuleController.kt\ncom/jetbrains/python/packaging/toolwindow/modules/PyPackagesModuleController\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n31#2,2:113\n1053#3:115\n360#3,7:116\n1#4:123\n*S KotlinDebug\n*F\n+ 1 PyPackagesModuleController.kt\ncom/jetbrains/python/packaging/toolwindow/modules/PyPackagesModuleController\n*L\n35#1:113,2\n38#1:115\n82#1:116,7\n*E\n"})
public final class PyPackagesModuleController
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope packagingScope;
    @NotNull
    private final moduleListRenderer.1 moduleListRenderer;
    @NotNull
    private final JBList<Module> moduleList;
    @NotNull
    private final JScrollPane mainScrollPane;
    @NotNull
    private final fileEditorListener.1 fileEditorListener;

    /*
     * WARNING - void declaration
     */
    public PyPackagesModuleController(@NotNull Project project) {
        void $this$moduleList_u24lambda_u241;
        JBList jBList;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.packagingScope = PyPackageCoroutine.Companion.getIoScope(this.project);
        this.moduleListRenderer = new SimpleListCellRenderer<Module>(){

            public void customize(JList<? extends Module> list, Module value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Object object = value;
                if (object == null || (object = object.getName()) == null) {
                    object = "";
                }
                this.setText((String)object);
                this.setIcon(PythonIcons.Python.PythonClosed);
            }
        };
        JBList jBList2 = jBList = new JBList((Collection)this.getAllModules());
        PyPackagesModuleController pyPackagesModuleController = this;
        boolean bl = false;
        $this$moduleList_u24lambda_u241.setSelectionMode(0);
        $this$moduleList_u24lambda_u241.setCellRenderer((ListCellRenderer)((Object)this.moduleListRenderer));
        $this$moduleList_u24lambda_u241.addListSelectionListener(this.createSelectionListener());
        pyPackagesModuleController.moduleList = jBList;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.moduleList), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        this.mainScrollPane = jScrollPane;
        this.fileEditorListener = new FileEditorManagerListener(this){
            final /* synthetic */ PyPackagesModuleController this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (PyPackagesModuleController.access$getAllModules(this.this$0).size() > 1) {
                    Module module = PyPackagesModuleController.access$getModuleForVirtualFile(this.this$0, event.getNewFile());
                    if (module == null) {
                        return;
                    }
                    Module module2 = module;
                    PyPackagesModuleController.access$updateSelectedModuleIndex(this.this$0, module2);
                }
            }
        };
        this.subscribeToFileEditorEvents();
    }

    private final PyPackagingToolWindowService getToolWindowService() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<PyPackagingToolWindowService> serviceClass$iv = PyPackagingToolWindowService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (PyPackagingToolWindowService)object;
    }

    private final List<Module> getAllModules() {
        Iterable $this$sortedBy$iv = ArraysKt.toList((Object[])ModuleManager.Companion.getInstance(this.project).getModules());
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Module it = (Module)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Module)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @NotNull
    public final JScrollPane getMainScrollPane() {
        return this.mainScrollPane;
    }

    public final void refreshModuleListAndSelection() {
        this.refreshModuleList();
        this.restorePreviousSelection();
    }

    private final void refreshModuleList() {
        DefaultListModel defaultListModel;
        ListModel listModel = this.moduleList.getModel();
        Intrinsics.checkNotNull((Object)listModel, (String)"null cannot be cast to non-null type javax.swing.DefaultListModel<com.intellij.openapi.module.Module>");
        DefaultListModel $this$refreshModuleList_u24lambda_u242 = defaultListModel = (DefaultListModel)listModel;
        boolean bl = false;
        $this$refreshModuleList_u24lambda_u242.removeAllElements();
        $this$refreshModuleList_u24lambda_u242.addAll((Collection)this.getAllModules());
    }

    /*
     * WARNING - void declaration
     */
    private final void restorePreviousSelection() {
        int n;
        JBList<Module> jBList;
        block2: {
            void $this$indexOfFirst$iv;
            Module module = (Module)this.moduleList.getSelectedValue();
            String selectedModuleName = module != null ? module.getName() : null;
            List<Module> list = this.getAllModules();
            jBList = this.moduleList;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                Module it = (Module)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)selectedModuleName)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n2 = n;
        jBList.setSelectedIndex(n2);
    }

    private final void updateSelectedModuleIndex(Module module) {
        BuildersKt.launch$default((CoroutineScope)this.packagingScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, module, null){
            int label;
            final /* synthetic */ PyPackagesModuleController this$0;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ListModel listModel = PyPackagesModuleController.access$getModuleList$p(this.this$0).getModel();
                        Intrinsics.checkNotNull((Object)listModel, (String)"null cannot be cast to non-null type javax.swing.DefaultListModel<com.intellij.openapi.module.Module>");
                        int index = ((DefaultListModel)listModel).indexOf(this.$module);
                        PyPackagesModuleController.access$getModuleList$p(this.this$0).getSelectionModel().setSelectionInterval(index, index);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final ListSelectionListener createSelectionListener() {
        return arg_0 -> PyPackagesModuleController.createSelectionListener$lambda$4(this, arg_0);
    }

    private final void subscribeToFileEditorEvents() {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)this.fileEditorListener);
    }

    private final Module getModuleForVirtualFile(VirtualFile file) {
        Module module;
        VirtualFile virtualFile = file;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            module = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)this.project);
        } else {
            module = null;
        }
        return module;
    }

    public void dispose() {
    }

    private static final void createSelectionListener$lambda$4(PyPackagesModuleController this$0, ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            Module module = (Module)this$0.moduleList.getSelectedValue();
            if (module == null || (module = PySdkExtKt.getPythonSdk(module)) == null) {
                return;
            }
            Module selectedSdk = module;
            BuildersKt.launch$default((CoroutineScope)this$0.packagingScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, (Sdk)selectedSdk, null){
                int label;
                final /* synthetic */ PyPackagesModuleController this$0;
                final /* synthetic */ Sdk $selectedSdk;
                {
                    this.this$0 = $receiver;
                    this.$selectedSdk = $selectedSdk;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = PyPackagesModuleController.access$getToolWindowService(this.this$0).initForSdk$intellij_python_community_impl(this.$selectedSdk, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public static final /* synthetic */ JBList access$getModuleList$p(PyPackagesModuleController $this) {
        return $this.moduleList;
    }

    public static final /* synthetic */ PyPackagingToolWindowService access$getToolWindowService(PyPackagesModuleController $this) {
        return $this.getToolWindowService();
    }

    public static final /* synthetic */ List access$getAllModules(PyPackagesModuleController $this) {
        return $this.getAllModules();
    }

    public static final /* synthetic */ Module access$getModuleForVirtualFile(PyPackagesModuleController $this, VirtualFile file) {
        return $this.getModuleForVirtualFile(file);
    }

    public static final /* synthetic */ void access$updateSelectedModuleIndex(PyPackagesModuleController $this, Module module) {
        $this.updateSelectedModuleIndex(module);
    }
}

