/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBEmptyBorder;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBooleanRendererFactory
implements GridCellRendererFactory {
    private final DataGrid myGrid;
    private TextBooleanRenderer myTextRenderer;
    private CheckboxBooleanRenderer myCheckboxRenderer;

    public DefaultBooleanRendererFactory(@NotNull DataGrid grid) {
        if (grid == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    @Override
    public boolean supports(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(2);
        }
        return DefaultBooleanRendererFactory.isBooleanCell(this.myGrid, row, column);
    }

    private static boolean isBooleanCell(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(3);
        }
        if (row == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(4);
        }
        if (column == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(5);
        }
        if (column.asInteger() == -1) {
            return false;
        }
        int type = GridCellEditorHelper.get((CoreGrid)grid).guessJdbcTypeForEditing((CoreGrid)grid, row, column);
        GridModel model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        GridColumn c = Objects.requireNonNull((GridColumn)model2.getColumn(column));
        return ObjectFormatterUtil.isBooleanColumn((GridColumn)c, (int)type);
    }

    @Override
    @NotNull
    public GridCellRenderer getOrCreateRenderer(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(6);
        }
        if (column == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(7);
        }
        if (this.myGrid.getAppearance().getBooleanMode() == DataGridAppearanceSettings.BooleanMode.TEXT) {
            if (this.myTextRenderer == null) {
                this.myTextRenderer = new TextBooleanRenderer(this.myGrid);
                Disposer.register((Disposable)this.myGrid, (Disposable)this.myTextRenderer);
            }
            TextBooleanRenderer textBooleanRenderer = this.myTextRenderer;
            if (textBooleanRenderer == null) {
                DefaultBooleanRendererFactory.$$$reportNull$$$0(8);
            }
            return textBooleanRenderer;
        }
        if (this.myCheckboxRenderer == null) {
            this.myCheckboxRenderer = new CheckboxBooleanRenderer(this.myGrid);
            Disposer.register((Disposable)this.myGrid, (Disposable)this.myCheckboxRenderer);
        }
        CheckboxBooleanRenderer checkboxBooleanRenderer = this.myCheckboxRenderer;
        if (checkboxBooleanRenderer == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(9);
        }
        return checkboxBooleanRenderer;
    }

    @Override
    public void reinitSettings() {
        if (this.myTextRenderer != null) {
            this.myTextRenderer.reinitSettings();
        }
        if (this.myCheckboxRenderer != null) {
            this.myCheckboxRenderer.reinitSettings();
        }
    }

    private static boolean isBoolean(@Nullable Object value) {
        return value instanceof Boolean || value instanceof String && (StringUtil.equalsIgnoreCase((CharSequence)((String)value), (CharSequence)"true") || StringUtil.equalsIgnoreCase((CharSequence)((String)value), (CharSequence)"false"));
    }

    private static boolean isTrue(@Nullable Object value) {
        return Boolean.TRUE.equals(value) || value instanceof String && StringUtil.equalsIgnoreCase((CharSequence)((String)value), (CharSequence)"true");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanCell";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRenderer";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }

    public static class TextBooleanRenderer
    extends DefaultTextRendererFactory.TextRenderer {
        private static final char BULLET = '\u2022';

        public TextBooleanRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                TextBooleanRenderer.$$$reportNull$$$0(0);
            }
            super(grid, (Border)new JBEmptyBorder(0, 1, 0, 3));
        }

        @Override
        @NotNull
        protected String getValueText(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull Object value) {
            if (columnIdx == null) {
                TextBooleanRenderer.$$$reportNull$$$0(1);
            }
            if (value == null) {
                TextBooleanRenderer.$$$reportNull$$$0(2);
            }
            String text = super.getValueText(columnIdx, value);
            Object object = DefaultBooleanRendererFactory.isTrue(value) ? (this.myGrid.getResultView().isTransposed() ? text + " \u2022" : " \u2022 " + text) : (this.myGrid.getResultView().isTransposed() ? text : "   " + text);
            if (object == null) {
                TextBooleanRenderer.$$$reportNull$$$0(3);
            }
            return object;
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
            if (row == null) {
                TextBooleanRenderer.$$$reportNull$$$0(4);
            }
            if (column == null) {
                TextBooleanRenderer.$$$reportNull$$$0(5);
            }
            return DefaultBooleanRendererFactory.isBooleanCell(this.myGrid, row, column) ? 1 : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$TextBooleanRenderer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$TextBooleanRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueText";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class CheckboxBooleanRenderer
    extends GridCellRenderer {
        final DefaultTextRendererFactory.TextRenderer reservedCellValuesRenderer;
        final JBCheckBox myComponent;

        public CheckboxBooleanRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(0);
            }
            super(grid);
            this.reservedCellValuesRenderer = new DefaultTextRendererFactory.TextRenderer(grid);
            Disposer.register((Disposable)this, (Disposable)this.reservedCellValuesRenderer);
            this.myComponent = new JBCheckBox();
            this.myComponent.setHorizontalAlignment(0);
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
            if (row == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(1);
            }
            if (column == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(2);
            }
            return DefaultBooleanRendererFactory.isBooleanCell(this.myGrid, row, column) ? 1 : 0;
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<GridRow> row, @NotNull ViewIndex<GridColumn> column, @Nullable Object value) {
            if (row == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(3);
            }
            if (column == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(4);
            }
            if (DefaultBooleanRendererFactory.isBoolean(value)) {
                this.myComponent.setSelected(DefaultBooleanRendererFactory.isTrue(value));
                JBCheckBox jBCheckBox = this.myComponent;
                if (jBCheckBox == null) {
                    CheckboxBooleanRenderer.$$$reportNull$$$0(5);
                }
                return jBCheckBox;
            }
            JComponent jComponent = this.reservedCellValuesRenderer.getComponent(row, column, value);
            if (jComponent == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(6);
            }
            return jComponent;
        }

        @Override
        public void reinitSettings() {
            this.reservedCellValuesRenderer.reinitSettings();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$CheckboxBooleanRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$CheckboxBooleanRenderer";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

