/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 50052851871537L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(697030260 - (char)-22999, -697030260 - -29635, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(697030260 - (char)-22998, 697030260 - 31528, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 79053122918498L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.L();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 != 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(45088080 + (char)-13878, -45088080 + -((char)-6091), (int)l2) + string + WindowsNamedPipeAgentIpc.b(45088080 + (char)-13877, -45088080 + -((char)-12421), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(45088080 + (char)-13876, -45088080 + -((char)-12409), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 57295579853862L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    n2 = SshAgentIpcService.P();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-716166480 - -((char)-32599), 716166480 - (char)-13897, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-716166480 - -((char)-32598), 716166480 - (char)-12805, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (n2 == 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-716166480 - -((char)-32597), 716166480 - (char)-18470, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-716166480 - -((char)-32604), 716166480 - (char)-24320, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-716166480 - -((char)-32603), 716166480 - (char)-27936, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-716166480 - -((char)-32597), 716166480 - (char)-18470, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-716166480 - -((char)-32602), 716166480 - (char)-15384, (int)l2));
            if (ActionTimestamp.L() != null) {
                SshAgentIpcService.L(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 38854801360433L;
                    n3 = SshAgentIpcService.L();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 != 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 != 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 56205847952186L;
                int n3 = SshAgentIpcService.L();
                this.assertConnectionThread();
                n2 = n3;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 != 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1905888870 + -3407, 1905888870 + 14136, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1905888870 + -3411, 1905888870 + 17412, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1905888870 + -3406, 1905888870 + 25131, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1905888870 + -3411, 1905888870 + 17412, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1905888870 + -3405, -1905888870 + -8111, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1905888870 + -3407, 1905888870 + 14136, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1905888870 + -3411, 1905888870 + 17412, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1905888870 + -3404, -1905888870 + -25465, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 != 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1905888870 + -3407, 1905888870 + 14136, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1905888870 + -3411, 1905888870 + 17412, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1905888870 + -3403, -1905888870 + -3037, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1905888870 + -3411, 1905888870 + 17412, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1905888870 + -3402, 1905888870 + 13762, (int)l2) + ErrorToolsKt.prettyHRESULT(n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 != 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1905888870 + -3411, 1905888870 + 17412, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1905888870 + -3405, -1905888870 + -8111, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1905888870 + -3407, 1905888870 + 14136, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1905888870 + -3411, 1905888870 + 17412, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1905888870 + -3401, -1905888870 - -930, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 100723216899463L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1938787440 + (char)-24004, 1938787440 + (char)-6228, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 34862467072521L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(217576200 - (char)-15899, -217576200 - -((char)-8723), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00edN\u00b8\u008a?\u0088E\u00a3\u008d+9%\u00b3t\u00ab\u00cd\u00a7\u00bf\u00e9\u0014F\u00d3\u00cd?\u008a\u00fc\u008e\u00a8vL\u0083\u001d&\u008a\u00d8\u0099$\u00f3\u009eu";
                        var4_3 = "\u00edN\u00b8\u008a?\u0088E\u00a3\u008d+9%\u00b3t\u00ab\u00cd\u00a7\u00bf\u00e9\u0014F\u00d3\u00cd?\u008a\u00fc\u008e\u00a8vL\u0083\u001d&\u008a\u00d8\u0099$\u00f3\u009eu".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 11;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 54;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 108;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 125;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 36;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 26;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 39;
                                        break;
                                    }
                                    default: {
                                        v11 = 93;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x732B) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 46;
                            case 1 -> 151;
                            case 2 -> 218;
                            case 3 -> 165;
                            case 4 -> 100;
                            case 5 -> 176;
                            case 6 -> 168;
                            case 7 -> 84;
                            case 8 -> 64;
                            case 9 -> 208;
                            case 10 -> 166;
                            case 11 -> 224;
                            case 12 -> 223;
                            case 13 -> 19;
                            case 14 -> 182;
                            case 15 -> 76;
                            case 16 -> 157;
                            case 17 -> 114;
                            case 18 -> 162;
                            case 19 -> 239;
                            case 20 -> 103;
                            case 21 -> 146;
                            case 22 -> 232;
                            case 23 -> 222;
                            case 24 -> 20;
                            case 25 -> 172;
                            case 26 -> 88;
                            case 27 -> 220;
                            case 28 -> 158;
                            case 29 -> 77;
                            case 30 -> 56;
                            case 31 -> 170;
                            case 32 -> 26;
                            case 33 -> 73;
                            case 34 -> 199;
                            case 35 -> 253;
                            case 36 -> 4;
                            case 37 -> 41;
                            case 38 -> 42;
                            case 39 -> 132;
                            case 40 -> 107;
                            case 41 -> 121;
                            case 42 -> 21;
                            case 43 -> 126;
                            case 44 -> 98;
                            case 45 -> 177;
                            case 46 -> 74;
                            case 47 -> 52;
                            case 48 -> 217;
                            case 49 -> 236;
                            case 50 -> 116;
                            case 51 -> 43;
                            case 52 -> 99;
                            case 53 -> 9;
                            case 54 -> 57;
                            case 55 -> 128;
                            case 56 -> 35;
                            case 57 -> 111;
                            case 58 -> 30;
                            case 59 -> 133;
                            case 60 -> 7;
                            case 61 -> 238;
                            case 62 -> 12;
                            case 63 -> 65;
                            case 64 -> 89;
                            case 65 -> 200;
                            case 66 -> 148;
                            case 67 -> 83;
                            case 68 -> 10;
                            case 69 -> 147;
                            case 70 -> 112;
                            case 71 -> 163;
                            case 72 -> 122;
                            case 73 -> 81;
                            case 74 -> 187;
                            case 75 -> 227;
                            case 76 -> 8;
                            case 77 -> 229;
                            case 78 -> 15;
                            case 79 -> 211;
                            case 80 -> 247;
                            case 81 -> 139;
                            case 82 -> 69;
                            case 83 -> 197;
                            case 84 -> 136;
                            case 85 -> 130;
                            case 86 -> 32;
                            case 87 -> 25;
                            case 88 -> 153;
                            case 89 -> 40;
                            case 90 -> 17;
                            case 91 -> 125;
                            case 92 -> 161;
                            case 93 -> 38;
                            case 94 -> 135;
                            case 95 -> 245;
                            case 96 -> 0;
                            case 97 -> 234;
                            case 98 -> 190;
                            case 99 -> 24;
                            case 100 -> 155;
                            case 101 -> 143;
                            case 102 -> 251;
                            case 103 -> 127;
                            case 104 -> 225;
                            case 105 -> 3;
                            case 106 -> 141;
                            case 107 -> 61;
                            case 108 -> 102;
                            case 109 -> 231;
                            case 110 -> 129;
                            case 111 -> 94;
                            case 112 -> 108;
                            case 113 -> 246;
                            case 114 -> 188;
                            case 115 -> 131;
                            case 116 -> 5;
                            case 117 -> 209;
                            case 118 -> 193;
                            case 119 -> 194;
                            case 120 -> 210;
                            case 121 -> 63;
                            case 122 -> 202;
                            case 123 -> 215;
                            case 124 -> 47;
                            case 125 -> 80;
                            case 126 -> 97;
                            case 127 -> 201;
                            case 128 -> 207;
                            case 129 -> 123;
                            case 130 -> 82;
                            case 131 -> 241;
                            case 132 -> 235;
                            case 133 -> 2;
                            case 134 -> 70;
                            case 135 -> 1;
                            case 136 -> 13;
                            case 137 -> 159;
                            case 138 -> 142;
                            case 139 -> 230;
                            case 140 -> 14;
                            case 141 -> 203;
                            case 142 -> 219;
                            case 143 -> 169;
                            case 144 -> 101;
                            case 145 -> 206;
                            case 146 -> 6;
                            case 147 -> 152;
                            case 148 -> 62;
                            case 149 -> 36;
                            case 150 -> 53;
                            case 151 -> 113;
                            case 152 -> 31;
                            case 153 -> 51;
                            case 154 -> 91;
                            case 155 -> 144;
                            case 156 -> 255;
                            case 157 -> 60;
                            case 158 -> 145;
                            case 159 -> 174;
                            case 160 -> 248;
                            case 161 -> 183;
                            case 162 -> 50;
                            case 163 -> 104;
                            case 164 -> 216;
                            case 165 -> 22;
                            case 166 -> 67;
                            case 167 -> 72;
                            case 168 -> 244;
                            case 169 -> 191;
                            case 170 -> 233;
                            case 171 -> 117;
                            case 172 -> 96;
                            case 173 -> 29;
                            case 174 -> 93;
                            case 175 -> 66;
                            case 176 -> 250;
                            case 177 -> 115;
                            case 178 -> 95;
                            case 179 -> 86;
                            case 180 -> 173;
                            case 181 -> 109;
                            case 182 -> 167;
                            case 183 -> 71;
                            case 184 -> 180;
                            case 185 -> 205;
                            case 186 -> 150;
                            case 187 -> 196;
                            case 188 -> 189;
                            case 189 -> 138;
                            case 190 -> 58;
                            case 191 -> 28;
                            case 192 -> 160;
                            case 193 -> 92;
                            case 194 -> 134;
                            case 195 -> 110;
                            case 196 -> 198;
                            case 197 -> 226;
                            case 198 -> 75;
                            case 199 -> 120;
                            case 200 -> 34;
                            case 201 -> 214;
                            case 202 -> 156;
                            case 203 -> 184;
                            case 204 -> 39;
                            case 205 -> 68;
                            case 206 -> 186;
                            case 207 -> 204;
                            case 208 -> 221;
                            case 209 -> 137;
                            case 210 -> 195;
                            case 211 -> 59;
                            case 212 -> 178;
                            case 213 -> 85;
                            case 214 -> 249;
                            case 215 -> 243;
                            case 216 -> 185;
                            case 217 -> 254;
                            case 218 -> 252;
                            case 219 -> 90;
                            case 220 -> 33;
                            case 221 -> 106;
                            case 222 -> 175;
                            case 223 -> 212;
                            case 224 -> 49;
                            case 225 -> 237;
                            case 226 -> 23;
                            case 227 -> 16;
                            case 228 -> 79;
                            case 229 -> 119;
                            case 230 -> 124;
                            case 231 -> 164;
                            case 232 -> 213;
                            case 233 -> 78;
                            case 234 -> 228;
                            case 235 -> 45;
                            case 236 -> 18;
                            case 237 -> 37;
                            case 238 -> 27;
                            case 239 -> 149;
                            case 240 -> 118;
                            case 241 -> 48;
                            case 242 -> 242;
                            case 243 -> 140;
                            case 244 -> 181;
                            case 245 -> 171;
                            case 246 -> 11;
                            case 247 -> 179;
                            case 248 -> 44;
                            case 249 -> 55;
                            case 250 -> 240;
                            case 251 -> 105;
                            case 252 -> 192;
                            case 253 -> 87;
                            case 254 -> 154;
                            default -> 54;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 != 0) {
                ActionTimestamp.L("AJAKZ");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 4595085099657L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.L();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(529916010 - 626, -529916010 - -23703, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(529916010 - 630, -529916010 - -19523, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(529916010 - 649, -529916010 - -20686, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(529916010 - 626, -529916010 - -23703, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(529916010 - 630, -529916010 - -19523, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(529916010 - 650, 529916010 - 5008, (int)l3) + ErrorToolsKt.prettyHRESULT(n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 136193249695497L;
                        int n3 = SshAgentIpcService.L();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(163313220 - (char)-21027, 163313220 - (char)-11560, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 != 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 != 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(163313220 - (char)-21026, 163313220 - 32395, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 != 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 73330775711833L;
                int n3 = SshAgentIpcService.P();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    n2 = n3;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 == 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 == 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1495901910 + 22610, -1495901910 - -1491, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1495901910 + 22606, -1495901910 + -4129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1495901910 + 22623, -1495901910 + -2424, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1495901910 + 22606, -1495901910 + -4129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1495901910 + 22616, 1495901910 + 9138, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1495901910 + 22610, -1495901910 - -1491, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1495901910 + 22606, -1495901910 + -4129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1495901910 + 22622, 1495901910 - 8551, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1495901910 + 22610, -1495901910 - -1491, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1495901910 + 22606, -1495901910 + -4129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1495901910 + 22629, 1495901910 + 19432, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 == 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1495901910 + 22610, -1495901910 - -1491, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1495901910 + 22606, -1495901910 + -4129, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1495901910 + 22628, 1495901910 + 16268, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 114893509654551L;
                    Object object = this.lock;
                    n3 = SshAgentIpcService.L();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 != 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1160493780 + 11410, -1160493780 - -391, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1160493780 + 11414, -1160493780 - -3099, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1160493780 + 11427, -1160493780 - -6069, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1160493780 + 11426, -1160493780 + -6732, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1160493780 + 11410, -1160493780 - -391, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1160493780 + 11414, -1160493780 - -3099, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1160493780 + 11421, -1160493780 - -11335, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 != 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 != 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1160493780 + 11410, -1160493780 - -391, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1160493780 + 11414, -1160493780 - -3099, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1160493780 + 11420, -1160493780 + -14153, (int)l2) + ErrorToolsKt.prettyHRESULT(n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1160493780 + 11410, -1160493780 - -391, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1160493780 + 11414, -1160493780 - -3099, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1160493780 + 11423, 1160493780 - 999, (int)l2));
                    if (n3 != 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1160493780 + 11410, -1160493780 - -391, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1160493780 + 11414, -1160493780 - -3099, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1160493780 + 11422, -1160493780 + -17327, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u007f\u0011\u00b7Kt)\u001b\u00d9\u0014\u0012\u00a7\"z8\u0087=\u0016\u00a3a3\u00adE\u0087\u00eb\u00cb\u00de\u00e1KT\u0006\u00cd\u0014\u00e1\u00eb\u00d4|\u0018MM\u00a9\u0017\u00cb\u00efA\u00db\u00e4\u00a5\u00d4E\u00dfe\u00ea\u0015WST\u009f\u008c@\u008f\u00aa\t=*9J\u00b2\u00dbv\u0015>\u0005O\u00ed\u00b1\u00d4\u00c4\b\u009a\u00fb\u000bg\u00b1\u008a\u00a5O\u0005[V3\u00a3\u0094\u001e\u00d4\u0003\u00d7m\u0095d(\u00d0l\u00d0\u008el\u00d8`\u00a8\u00d1\u00feZ\u00b3J\u00dc\u00d5\u0089\u00d5!\u009eS;\u00fdX\u0010\u00db\u0002\u00d2\u0088b\u00ea \u00f8\u0010g\u008cg\u009eT\u00cf\u00c8\t_G\u00a3\u00f6\u00b2kP\u009c\u0014\u0010\u00f3P\u00d7\u00c2\u00c2\u00a34\u00d1\u0092B\u00dc\u00c3\u0094\u00c0\u008eZ?J\u00cb\ft\u00e3Nc\u00f9t$\u00c8\t\u00af:{\u00a3Aq9\u00ea\u0003\u0093\t{!\u00a3^(kl\u00bc\u0093\u0099\u00c5\u00c0\u0001\n\u009dz<(\u0097\u00167\u00f5\u008d\u00de\u008e\u00c2\u0093\u009f\n\u00d1\u0092o\u00b9\u00ee/\u00db\u00d1Y\u00faW\b\u00d7\u00dd\u00a2\u00a3\u0084\u0012\u0003\\\f\u00db\u00c03\u001b\u00abg\b\u00f5<\u008e[^F\u008b\u00b39u\u00ea\u00aa L9\u00b5\u00f1\u00fd\u001e\u00acRW\u0098\u0088\u0002zv\u00d3\u00a4A\u00a2\u00cf\u00dd\u00ae\u00a4\u0095\u007f\u0090\u00dd\u0013\u008a\u00fa\u0099\u00af\u00a3\u00be\u0080\u00d2\u0088d\u00f8b+\u000e\u009b{\u00d2\u00bd\u0097\u00f2\u00b1\u00ae\u00aa\u00b9\u00c5\u00bf\u00a9^\u0015\u00f8\n\u00ed\u0090\u0090\u00d0\u0088\u001f\u0084P\u00dd\u0007\u00d4)\u0000yi\u00e5.\u00ca\u00cc\u00a9!Y\u00b4\u00a3\u0087\u00bf\u0091\u00eb\u00f7\u00b9\u008f\u00c3\u0091\\\u00b8E\u00fe\u000b\u00bc\u0015\u00df\u00a160\u00bb\u001fJ\u00df\u009f\u0015F:\u0080G\u00da\u0084\u00ca\u00f4ZBU\u00f5\u001d\u00e2\u0006f\u00ab\u00d0\u00b9\u00a8`)%\u00c1\u00e95Ro\u00d0\u00b1s\u00fcm\u00e9\u00a0\u00c72\u0091\u00892\u00fb*\u00ee!\u00de\u00f8\u00c5\u00a2\u000f\bD;\u00e3{\u00b0\u00cbAl\u00fe`\u00c4\u00ee\u00cf\u0007\u00db\u0093<e\u00cc8\u0098\u0007\u00f3\u00d8]`\u0007w\u00f7(\u0096(\u00d3)\u00a5\u0086\u00d8\u00ab\u0002hiM\u0003\u00d2\u0004\u00b0H\u00bbmX]Q\u00c7=v\u00a6\u00cf\u00f3k$\u00dd\u0081\u008c\u00ffXGgxd\u001e\u000f\u0088\u00da^^\u00fc\u0004V8\u00a6\u0097\\\u00e3\u0005SZ\"\u009d\u00e9\u00fe0\u00b0\u00cf\u008c\u00a5\u00f8~\u001c\u00b9\u008d\u00c1\u00f3\u009fZ\u00da\u000bu\u001a\u00ca\u00e0\u00d5\u0091SH\u00e8\u0088\u0015\u00d8\u00b9\u00f9`\u000e\u00ee\u0084\u0092\u0095e}e\u0017\u00c0r\u0090_\u0090\u00ce\u001b\u00bfH\u00bf\t;[;\u008f\\\u00e6\u008e\u00cc\u0003\u008a\u0004\u00e0\f\u009f|A\u00cfx)%\u00e3 S\n\u00b6nZ\u00ca\u0093\u00c7\u00fd6/\u00b3\u0018\u00fa~\u0017\u00c2/\u009e\u0098i6\u00f3\u0001\u00f1K~\u00f1_\u00c5i\u0092\u00e6j\u00c7\u00c6\u0081)\u00c5{\u00f5b\u00d1\u0085\u00a0\u00ec}W\u00ac\u009c\u009c`*\u001e\u00f4\u00b6\u008b\u007f\u00da\u009b\u0011\u00a3I[\u0003\u00db\u0096\u001d\u0002.\u00a9\u00bf\u00b7v\u00fe\u0007\u00c4\u0002\u00cf";
                var4_3 = "\u007f\u0011\u00b7Kt)\u001b\u00d9\u0014\u0012\u00a7\"z8\u0087=\u0016\u00a3a3\u00adE\u0087\u00eb\u00cb\u00de\u00e1KT\u0006\u00cd\u0014\u00e1\u00eb\u00d4|\u0018MM\u00a9\u0017\u00cb\u00efA\u00db\u00e4\u00a5\u00d4E\u00dfe\u00ea\u0015WST\u009f\u008c@\u008f\u00aa\t=*9J\u00b2\u00dbv\u0015>\u0005O\u00ed\u00b1\u00d4\u00c4\b\u009a\u00fb\u000bg\u00b1\u008a\u00a5O\u0005[V3\u00a3\u0094\u001e\u00d4\u0003\u00d7m\u0095d(\u00d0l\u00d0\u008el\u00d8`\u00a8\u00d1\u00feZ\u00b3J\u00dc\u00d5\u0089\u00d5!\u009eS;\u00fdX\u0010\u00db\u0002\u00d2\u0088b\u00ea \u00f8\u0010g\u008cg\u009eT\u00cf\u00c8\t_G\u00a3\u00f6\u00b2kP\u009c\u0014\u0010\u00f3P\u00d7\u00c2\u00c2\u00a34\u00d1\u0092B\u00dc\u00c3\u0094\u00c0\u008eZ?J\u00cb\ft\u00e3Nc\u00f9t$\u00c8\t\u00af:{\u00a3Aq9\u00ea\u0003\u0093\t{!\u00a3^(kl\u00bc\u0093\u0099\u00c5\u00c0\u0001\n\u009dz<(\u0097\u00167\u00f5\u008d\u00de\u008e\u00c2\u0093\u009f\n\u00d1\u0092o\u00b9\u00ee/\u00db\u00d1Y\u00faW\b\u00d7\u00dd\u00a2\u00a3\u0084\u0012\u0003\\\f\u00db\u00c03\u001b\u00abg\b\u00f5<\u008e[^F\u008b\u00b39u\u00ea\u00aa L9\u00b5\u00f1\u00fd\u001e\u00acRW\u0098\u0088\u0002zv\u00d3\u00a4A\u00a2\u00cf\u00dd\u00ae\u00a4\u0095\u007f\u0090\u00dd\u0013\u008a\u00fa\u0099\u00af\u00a3\u00be\u0080\u00d2\u0088d\u00f8b+\u000e\u009b{\u00d2\u00bd\u0097\u00f2\u00b1\u00ae\u00aa\u00b9\u00c5\u00bf\u00a9^\u0015\u00f8\n\u00ed\u0090\u0090\u00d0\u0088\u001f\u0084P\u00dd\u0007\u00d4)\u0000yi\u00e5.\u00ca\u00cc\u00a9!Y\u00b4\u00a3\u0087\u00bf\u0091\u00eb\u00f7\u00b9\u008f\u00c3\u0091\\\u00b8E\u00fe\u000b\u00bc\u0015\u00df\u00a160\u00bb\u001fJ\u00df\u009f\u0015F:\u0080G\u00da\u0084\u00ca\u00f4ZBU\u00f5\u001d\u00e2\u0006f\u00ab\u00d0\u00b9\u00a8`)%\u00c1\u00e95Ro\u00d0\u00b1s\u00fcm\u00e9\u00a0\u00c72\u0091\u00892\u00fb*\u00ee!\u00de\u00f8\u00c5\u00a2\u000f\bD;\u00e3{\u00b0\u00cbAl\u00fe`\u00c4\u00ee\u00cf\u0007\u00db\u0093<e\u00cc8\u0098\u0007\u00f3\u00d8]`\u0007w\u00f7(\u0096(\u00d3)\u00a5\u0086\u00d8\u00ab\u0002hiM\u0003\u00d2\u0004\u00b0H\u00bbmX]Q\u00c7=v\u00a6\u00cf\u00f3k$\u00dd\u0081\u008c\u00ffXGgxd\u001e\u000f\u0088\u00da^^\u00fc\u0004V8\u00a6\u0097\\\u00e3\u0005SZ\"\u009d\u00e9\u00fe0\u00b0\u00cf\u008c\u00a5\u00f8~\u001c\u00b9\u008d\u00c1\u00f3\u009fZ\u00da\u000bu\u001a\u00ca\u00e0\u00d5\u0091SH\u00e8\u0088\u0015\u00d8\u00b9\u00f9`\u000e\u00ee\u0084\u0092\u0095e}e\u0017\u00c0r\u0090_\u0090\u00ce\u001b\u00bfH\u00bf\t;[;\u008f\\\u00e6\u008e\u00cc\u0003\u008a\u0004\u00e0\f\u009f|A\u00cfx)%\u00e3 S\n\u00b6nZ\u00ca\u0093\u00c7\u00fd6/\u00b3\u0018\u00fa~\u0017\u00c2/\u009e\u0098i6\u00f3\u0001\u00f1K~\u00f1_\u00c5i\u0092\u00e6j\u00c7\u00c6\u0081)\u00c5{\u00f5b\u00d1\u0085\u00a0\u00ec}W\u00ac\u009c\u009c`*\u001e\u00f4\u00b6\u008b\u007f\u00da\u009b\u0011\u00a3I[\u0003\u00db\u0096\u001d\u0002.\u00a9\u00bf\u00b7v\u00fe\u0007\u00c4\u0002\u00cf".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 105;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "d\u0011)\u00cf\u0004n=\u008a\u00e9\u001d\u00ac\u009c5s$J\u00f3\u00f8\u00fa8\u00b1\u009c\u00d2\u008d\u000eN\u009d]\u001bkp\u00cbZ\u009af\u008d\u009a\u00a9\u00d8";
                    var4_3 = "d\u0011)\u00cf\u0004n=\u008a\u00e9\u001d\u00ac\u009c5s$J\u00f3\u00f8\u00fa8\u00b1\u009c\u00d2\u008d\u000eN\u009d]\u001bkp\u00cbZ\u009af\u008d\u009a\u00a9\u00d8".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 44;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 57;
                            break;
                        }
                        case 1: {
                            v15 = 2;
                            break;
                        }
                        case 2: {
                            v15 = 53;
                            break;
                        }
                        case 3: {
                            v15 = 76;
                            break;
                        }
                        case 4: {
                            v15 = 78;
                            break;
                        }
                        case 5: {
                            v15 = 37;
                            break;
                        }
                        default: {
                            v15 = 54;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFF9F7A) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 146;
                case 1 -> 39;
                case 2 -> 149;
                case 3 -> 253;
                case 4 -> 40;
                case 5 -> 194;
                case 6 -> 142;
                case 7 -> 216;
                case 8 -> 72;
                case 9 -> 13;
                case 10 -> 205;
                case 11 -> 213;
                case 12 -> 28;
                case 13 -> 12;
                case 14 -> 158;
                case 15 -> 25;
                case 16 -> 83;
                case 17 -> 99;
                case 18 -> 154;
                case 19 -> 188;
                case 20 -> 192;
                case 21 -> 178;
                case 22 -> 193;
                case 23 -> 98;
                case 24 -> 134;
                case 25 -> 126;
                case 26 -> 139;
                case 27 -> 18;
                case 28 -> 223;
                case 29 -> 26;
                case 30 -> 143;
                case 31 -> 80;
                case 32 -> 43;
                case 33 -> 75;
                case 34 -> 167;
                case 35 -> 64;
                case 36 -> 233;
                case 37 -> 109;
                case 38 -> 57;
                case 39 -> 243;
                case 40 -> 230;
                case 41 -> 210;
                case 42 -> 96;
                case 43 -> 157;
                case 44 -> 207;
                case 45 -> 122;
                case 46 -> 123;
                case 47 -> 31;
                case 48 -> 27;
                case 49 -> 29;
                case 50 -> 71;
                case 51 -> 225;
                case 52 -> 221;
                case 53 -> 187;
                case 54 -> 190;
                case 55 -> 252;
                case 56 -> 202;
                case 57 -> 130;
                case 58 -> 37;
                case 59 -> 62;
                case 60 -> 180;
                case 61 -> 164;
                case 62 -> 59;
                case 63 -> 14;
                case 64 -> 61;
                case 65 -> 209;
                case 66 -> 114;
                case 67 -> 241;
                case 68 -> 82;
                case 69 -> 162;
                case 70 -> 226;
                case 71 -> 144;
                case 72 -> 34;
                case 73 -> 38;
                case 74 -> 68;
                case 75 -> 125;
                case 76 -> 87;
                case 77 -> 101;
                case 78 -> 249;
                case 79 -> 81;
                case 80 -> 117;
                case 81 -> 115;
                case 82 -> 138;
                case 83 -> 8;
                case 84 -> 237;
                case 85 -> 189;
                case 86 -> 163;
                case 87 -> 160;
                case 88 -> 50;
                case 89 -> 22;
                case 90 -> 15;
                case 91 -> 108;
                case 92 -> 168;
                case 93 -> 86;
                case 94 -> 63;
                case 95 -> 113;
                case 96 -> 56;
                case 97 -> 90;
                case 98 -> 236;
                case 99 -> 242;
                case 100 -> 6;
                case 101 -> 232;
                case 102 -> 246;
                case 103 -> 76;
                case 104 -> 9;
                case 105 -> 51;
                case 106 -> 46;
                case 107 -> 136;
                case 108 -> 244;
                case 109 -> 10;
                case 110 -> 133;
                case 111 -> 227;
                case 112 -> 66;
                case 113 -> 175;
                case 114 -> 174;
                case 115 -> 179;
                case 116 -> 199;
                case 117 -> 4;
                case 118 -> 155;
                case 119 -> 200;
                case 120 -> 0;
                case 121 -> 152;
                case 122 -> 137;
                case 123 -> 103;
                case 124 -> 220;
                case 125 -> 218;
                case 126 -> 140;
                case 127 -> 19;
                case 128 -> 203;
                case 129 -> 141;
                case 130 -> 124;
                case 131 -> 54;
                case 132 -> 184;
                case 133 -> 47;
                case 134 -> 235;
                case 135 -> 20;
                case 136 -> 78;
                case 137 -> 49;
                case 138 -> 121;
                case 139 -> 106;
                case 140 -> 172;
                case 141 -> 148;
                case 142 -> 247;
                case 143 -> 147;
                case 144 -> 30;
                case 145 -> 254;
                case 146 -> 104;
                case 147 -> 219;
                case 148 -> 151;
                case 149 -> 69;
                case 150 -> 97;
                case 151 -> 58;
                case 152 -> 92;
                case 153 -> 95;
                case 154 -> 41;
                case 155 -> 156;
                case 156 -> 222;
                case 157 -> 44;
                case 158 -> 211;
                case 159 -> 204;
                case 160 -> 185;
                case 161 -> 132;
                case 162 -> 88;
                case 163 -> 224;
                case 164 -> 60;
                case 165 -> 228;
                case 166 -> 186;
                case 167 -> 245;
                case 168 -> 118;
                case 169 -> 128;
                case 170 -> 212;
                case 171 -> 215;
                case 172 -> 107;
                case 173 -> 21;
                case 174 -> 110;
                case 175 -> 165;
                case 176 -> 102;
                case 177 -> 2;
                case 178 -> 239;
                case 179 -> 145;
                case 180 -> 11;
                case 181 -> 129;
                case 182 -> 42;
                case 183 -> 120;
                case 184 -> 3;
                case 185 -> 231;
                case 186 -> 173;
                case 187 -> 171;
                case 188 -> 195;
                case 189 -> 234;
                case 190 -> 183;
                case 191 -> 206;
                case 192 -> 7;
                case 193 -> 23;
                case 194 -> 170;
                case 195 -> 53;
                case 196 -> 255;
                case 197 -> 196;
                case 198 -> 5;
                case 199 -> 111;
                case 200 -> 153;
                case 201 -> 250;
                case 202 -> 131;
                case 203 -> 214;
                case 204 -> 65;
                case 205 -> 240;
                case 206 -> 89;
                case 207 -> 181;
                case 208 -> 208;
                case 209 -> 67;
                case 210 -> 55;
                case 211 -> 16;
                case 212 -> 36;
                case 213 -> 251;
                case 214 -> 135;
                case 215 -> 70;
                case 216 -> 84;
                case 217 -> 150;
                case 218 -> 105;
                case 219 -> 166;
                case 220 -> 32;
                case 221 -> 169;
                case 222 -> 116;
                case 223 -> 112;
                case 224 -> 127;
                case 225 -> 217;
                case 226 -> 248;
                case 227 -> 74;
                case 228 -> 91;
                case 229 -> 191;
                case 230 -> 45;
                case 231 -> 35;
                case 232 -> 79;
                case 233 -> 24;
                case 234 -> 73;
                case 235 -> 77;
                case 236 -> 48;
                case 237 -> 182;
                case 238 -> 238;
                case 239 -> 33;
                case 240 -> 176;
                case 241 -> 177;
                case 242 -> 201;
                case 243 -> 52;
                case 244 -> 93;
                case 245 -> 1;
                case 246 -> 229;
                case 247 -> 159;
                case 248 -> 85;
                case 249 -> 17;
                case 250 -> 161;
                case 251 -> 94;
                case 252 -> 119;
                case 253 -> 198;
                case 254 -> 197;
                default -> 100;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 8567431342639L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1028375220 + -22963, -1028375220 + -25597, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 125078259761306L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.L();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 != 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 != 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(222163650 + 22123, -222163650 + -11843, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(222163650 + 22124, -222163650 + -13358, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(222163650 + 22125, 222163650 + 14032, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00e9\u00bd6\u00db\u00ce\u0092\u00ed\u0081\u0010\u00e63&\u00abv'\u0003n;\u00e6\u00ec\u00dd;\u00a2TY";
                    var4_3 = "\u00e9\u00bd6\u00db\u00ce\u0092\u00ed\u0081\u0010\u00e63&\u00abv'\u0003n;\u00e6\u00ec\u00dd;\u00a2TY".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 113;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "Tdl\r\u00185\u0002c\u00b1\u0081q\u00b6\u0016\u001a\u0003>\u0094\u00eb.c\u001e\u0006M\u00e4H\u008d}8\u00c8\u00e4\u0090\u00983)\u0094\u00de,j\u0010\u0002\u00b9zBf\u00dfOh\u009aK\u00dc\u00b5\u00f3C\u0097\u0089\u0084Gsg";
                        var4_3 = "Tdl\r\u00185\u0002c\u00b1\u0081q\u00b6\u0016\u001a\u0003>\u0094\u00eb.c\u001e\u0006M\u00e4H\u008d}8\u00c8\u00e4\u0090\u00983)\u0094\u00de,j\u0010\u0002\u00b9zBf\u00dfOh\u009aK\u00dc\u00b5\u00f3C\u0097\u0089\u0084Gsg".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 52;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 10;
                                break;
                            }
                            case 1: {
                                v15 = 80;
                                break;
                            }
                            case 2: {
                                v15 = 27;
                                break;
                            }
                            case 3: {
                                v15 = 24;
                                break;
                            }
                            case 4: {
                                v15 = 26;
                                break;
                            }
                            case 5: {
                                v15 = 29;
                                break;
                            }
                            default: {
                                v15 = 6;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x49B6) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 90;
                    case 1 -> 222;
                    case 2 -> 253;
                    case 3 -> 200;
                    case 4 -> 203;
                    case 5 -> 179;
                    case 6 -> 136;
                    case 7 -> 101;
                    case 8 -> 141;
                    case 9 -> 218;
                    case 10 -> 245;
                    case 11 -> 238;
                    case 12 -> 55;
                    case 13 -> 63;
                    case 14 -> 225;
                    case 15 -> 243;
                    case 16 -> 38;
                    case 17 -> 50;
                    case 18 -> 135;
                    case 19 -> 119;
                    case 20 -> 197;
                    case 21 -> 16;
                    case 22 -> 23;
                    case 23 -> 83;
                    case 24 -> 7;
                    case 25 -> 156;
                    case 26 -> 62;
                    case 27 -> 91;
                    case 28 -> 124;
                    case 29 -> 158;
                    case 30 -> 86;
                    case 31 -> 184;
                    case 32 -> 173;
                    case 33 -> 231;
                    case 34 -> 122;
                    case 35 -> 75;
                    case 36 -> 216;
                    case 37 -> 133;
                    case 38 -> 111;
                    case 39 -> 228;
                    case 40 -> 235;
                    case 41 -> 150;
                    case 42 -> 240;
                    case 43 -> 227;
                    case 44 -> 49;
                    case 45 -> 35;
                    case 46 -> 99;
                    case 47 -> 74;
                    case 48 -> 160;
                    case 49 -> 177;
                    case 50 -> 139;
                    case 51 -> 207;
                    case 52 -> 221;
                    case 53 -> 154;
                    case 54 -> 39;
                    case 55 -> 36;
                    case 56 -> 233;
                    case 57 -> 18;
                    case 58 -> 142;
                    case 59 -> 165;
                    case 60 -> 2;
                    case 61 -> 68;
                    case 62 -> 95;
                    case 63 -> 147;
                    case 64 -> 163;
                    case 65 -> 115;
                    case 66 -> 60;
                    case 67 -> 113;
                    case 68 -> 121;
                    case 69 -> 33;
                    case 70 -> 26;
                    case 71 -> 12;
                    case 72 -> 43;
                    case 73 -> 107;
                    case 74 -> 28;
                    case 75 -> 11;
                    case 76 -> 51;
                    case 77 -> 40;
                    case 78 -> 210;
                    case 79 -> 250;
                    case 80 -> 205;
                    case 81 -> 82;
                    case 82 -> 104;
                    case 83 -> 118;
                    case 84 -> 185;
                    case 85 -> 189;
                    case 86 -> 214;
                    case 87 -> 114;
                    case 88 -> 232;
                    case 89 -> 211;
                    case 90 -> 247;
                    case 91 -> 125;
                    case 92 -> 220;
                    case 93 -> 246;
                    case 94 -> 24;
                    case 95 -> 81;
                    case 96 -> 10;
                    case 97 -> 137;
                    case 98 -> 196;
                    case 99 -> 161;
                    case 100 -> 212;
                    case 101 -> 192;
                    case 102 -> 52;
                    case 103 -> 194;
                    case 104 -> 167;
                    case 105 -> 213;
                    case 106 -> 112;
                    case 107 -> 143;
                    case 108 -> 44;
                    case 109 -> 206;
                    case 110 -> 4;
                    case 111 -> 45;
                    case 112 -> 242;
                    case 113 -> 190;
                    case 114 -> 66;
                    case 115 -> 155;
                    case 116 -> 93;
                    case 117 -> 67;
                    case 118 -> 53;
                    case 119 -> 56;
                    case 120 -> 241;
                    case 121 -> 170;
                    case 122 -> 1;
                    case 123 -> 58;
                    case 124 -> 145;
                    case 125 -> 209;
                    case 126 -> 248;
                    case 127 -> 70;
                    case 128 -> 0;
                    case 129 -> 109;
                    case 130 -> 166;
                    case 131 -> 149;
                    case 132 -> 31;
                    case 133 -> 78;
                    case 134 -> 22;
                    case 135 -> 25;
                    case 136 -> 27;
                    case 137 -> 87;
                    case 138 -> 175;
                    case 139 -> 54;
                    case 140 -> 73;
                    case 141 -> 140;
                    case 142 -> 76;
                    case 143 -> 65;
                    case 144 -> 106;
                    case 145 -> 79;
                    case 146 -> 126;
                    case 147 -> 172;
                    case 148 -> 6;
                    case 149 -> 186;
                    case 150 -> 148;
                    case 151 -> 180;
                    case 152 -> 151;
                    case 153 -> 21;
                    case 154 -> 131;
                    case 155 -> 100;
                    case 156 -> 61;
                    case 157 -> 103;
                    case 158 -> 153;
                    case 159 -> 48;
                    case 160 -> 159;
                    case 161 -> 13;
                    case 162 -> 84;
                    case 163 -> 252;
                    case 164 -> 178;
                    case 165 -> 219;
                    case 166 -> 198;
                    case 167 -> 5;
                    case 168 -> 98;
                    case 169 -> 120;
                    case 170 -> 199;
                    case 171 -> 117;
                    case 172 -> 144;
                    case 173 -> 226;
                    case 174 -> 30;
                    case 175 -> 71;
                    case 176 -> 123;
                    case 177 -> 29;
                    case 178 -> 132;
                    case 179 -> 230;
                    case 180 -> 162;
                    case 181 -> 116;
                    case 182 -> 19;
                    case 183 -> 9;
                    case 184 -> 208;
                    case 185 -> 223;
                    case 186 -> 169;
                    case 187 -> 3;
                    case 188 -> 130;
                    case 189 -> 229;
                    case 190 -> 59;
                    case 191 -> 129;
                    case 192 -> 183;
                    case 193 -> 224;
                    case 194 -> 157;
                    case 195 -> 195;
                    case 196 -> 42;
                    case 197 -> 236;
                    case 198 -> 80;
                    case 199 -> 97;
                    case 200 -> 105;
                    case 201 -> 110;
                    case 202 -> 234;
                    case 203 -> 127;
                    case 204 -> 176;
                    case 205 -> 89;
                    case 206 -> 249;
                    case 207 -> 171;
                    case 208 -> 77;
                    case 209 -> 64;
                    case 210 -> 193;
                    case 211 -> 251;
                    case 212 -> 8;
                    case 213 -> 244;
                    case 214 -> 20;
                    case 215 -> 146;
                    case 216 -> 215;
                    case 217 -> 85;
                    case 218 -> 92;
                    case 219 -> 187;
                    case 220 -> 108;
                    case 221 -> 188;
                    case 222 -> 94;
                    case 223 -> 47;
                    case 224 -> 239;
                    case 225 -> 254;
                    case 226 -> 182;
                    case 227 -> 88;
                    case 228 -> 46;
                    case 229 -> 41;
                    case 230 -> 174;
                    case 231 -> 128;
                    case 232 -> 102;
                    case 233 -> 134;
                    case 234 -> 17;
                    case 235 -> 237;
                    case 236 -> 202;
                    case 237 -> 15;
                    case 238 -> 32;
                    case 239 -> 57;
                    case 240 -> 34;
                    case 241 -> 204;
                    case 242 -> 168;
                    case 243 -> 191;
                    case 244 -> 152;
                    case 245 -> 14;
                    case 246 -> 181;
                    case 247 -> 69;
                    case 248 -> 96;
                    case 249 -> 72;
                    case 250 -> 164;
                    case 251 -> 138;
                    case 252 -> 217;
                    case 253 -> 201;
                    case 254 -> 37;
                    default -> 255;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 72603353647074L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u001fh\u00173aOTF\t\u0018b\u00049,\rIZ$";
                    var5_4 = "\u001fh\u00173aOTF\t\u0018b\u00049,\rIZ$".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 6;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 114;
                                    break;
                                }
                                case 1: {
                                    v11 = 11;
                                    break;
                                }
                                case 2: {
                                    v11 = 99;
                                    break;
                                }
                                case 3: {
                                    v11 = 91;
                                    break;
                                }
                                case 4: {
                                    v11 = 2;
                                    break;
                                }
                                case 5: {
                                    v11 = 37;
                                    break;
                                }
                                default: {
                                    v11 = 97;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 98319712819073L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "QDs,\nV[\u0004WZ\u007f6\n[Et6\u0006TCqD}\t[Et6\u0006TC}N\r\\Ci;\fYY}In1\rP";
                    var5_4 = "QDs,\nV[\u0004WZ\u007f6\n[Et6\u0006TCqD}\t[Et6\u0006TC}N\r\\Ci;\fYY}In1\rP".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 101;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "kvE\u001b:i`\u0006kvE\u001b6c";
                        var5_4 = "kvE\u001b:i`\u0006kvE\u001b6c".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 85;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 125;
                                break;
                            }
                            case 1: {
                                v15 = 79;
                                break;
                            }
                            case 2: {
                                v15 = 127;
                                break;
                            }
                            case 3: {
                                v15 = 61;
                                break;
                            }
                            case 4: {
                                v15 = 6;
                                break;
                            }
                            case 5: {
                                v15 = 82;
                                break;
                            }
                            default: {
                                v15 = 82;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 105896605829418L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(107870610 - (char)-2905, 107870610 - (char)-26863, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 61566840762960L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = ")\u0010\u00ea\u008c,\u0003\u0007\u00ba\u009b\u0005\u00dbG\u0092\u00a2\u00c0\r\u00e7\u00b1#6\u0003\u00ba\u0013\u00eb\u00df0\u00b5\u00a0M\u0010.\u007f\u00dd\u0004\u00e3i$\u00ac\u00f0\\\u00b3`k\u0080U2\u0005\u00b1\u00c6\u00df\u0092i3j\u0004\u00b5\u00bd;\u001a\u000f\u00d6\u00e8\u00ee;\u001f\u00bc>\u0083\u00fa\u00c1\u00ab\u00a92\u009e/\u0010\u0081\u008b\u00ac\u00ef\u0081W\u00bdd\u0090\u00df\u00ad\u00d8\u0002V$&\n\u009c\u0010\"}\u00e6~@Z\u0018\u00ebG";
                    var4_3 = ")\u0010\u00ea\u008c,\u0003\u0007\u00ba\u009b\u0005\u00dbG\u0092\u00a2\u00c0\r\u00e7\u00b1#6\u0003\u00ba\u0013\u00eb\u00df0\u00b5\u00a0M\u0010.\u007f\u00dd\u0004\u00e3i$\u00ac\u00f0\\\u00b3`k\u0080U2\u0005\u00b1\u00c6\u00df\u0092i3j\u0004\u00b5\u00bd;\u001a\u000f\u00d6\u00e8\u00ee;\u001f\u00bc>\u0083\u00fa\u00c1\u00ab\u00a92\u009e/\u0010\u0081\u008b\u00ac\u00ef\u0081W\u00bdd\u0090\u00df\u00ad\u00d8\u0002V$&\n\u009c\u0010\"}\u00e6~@Z\u0018\u00ebG".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 102;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00bc>\u00f7T\u00de\u001b\u00fb\u009as\u00e2\u00bb\u00cf\u0012\r\u0002\u00fbL_\u00cc|\u00c0\u0085A\u00fe\u00bfZ\u00d52\u0090-hv.\u0002\u0098V\u00daq.\u00bf{%`g\u00a6\u00c4h\u0081=\u000b\u008eK\u0002n\u0082c\u00c0z\u00ccI\u00e3\u00e6\u000b\u00f3\u00b4\u00e4zHO_\u00fb+*>\u0091\u00c7d\u00f6^F\u00d1\r\u0001\u00d1t;\u000f\u00e2\u0012\u007f \u00f4Z";
                        var4_3 = "\u00bc>\u00f7T\u00de\u001b\u00fb\u009as\u00e2\u00bb\u00cf\u0012\r\u0002\u00fbL_\u00cc|\u00c0\u0085A\u00fe\u00bfZ\u00d52\u0090-hv.\u0002\u0098V\u00daq.\u00bf{%`g\u00a6\u00c4h\u0081=\u000b\u008eK\u0002n\u0082c\u00c0z\u00ccI\u00e3\u00e6\u000b\u00f3\u00b4\u00e4zHO_\u00fb+*>\u0091\u00c7d\u00f6^F\u00d1\r\u0001\u00d1t;\u000f\u00e2\u0012\u007f \u00f4Z".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 125;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 121;
                                break;
                            }
                            case 1: {
                                v15 = 70;
                                break;
                            }
                            case 2: {
                                v15 = 98;
                                break;
                            }
                            case 3: {
                                v15 = 9;
                                break;
                            }
                            case 4: {
                                v15 = 42;
                                break;
                            }
                            case 5: {
                                v15 = 113;
                                break;
                            }
                            default: {
                                v15 = 96;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCDC1) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 27;
                    case 1 -> 159;
                    case 2 -> 147;
                    case 3 -> 207;
                    case 4 -> 55;
                    case 5 -> 57;
                    case 6 -> 12;
                    case 7 -> 25;
                    case 8 -> 54;
                    case 9 -> 133;
                    case 10 -> 56;
                    case 11 -> 128;
                    case 12 -> 109;
                    case 13 -> 149;
                    case 14 -> 1;
                    case 15 -> 7;
                    case 16 -> 202;
                    case 17 -> 157;
                    case 18 -> 219;
                    case 19 -> 123;
                    case 20 -> 183;
                    case 21 -> 170;
                    case 22 -> 231;
                    case 23 -> 107;
                    case 24 -> 155;
                    case 25 -> 139;
                    case 26 -> 180;
                    case 27 -> 45;
                    case 28 -> 41;
                    case 29 -> 21;
                    case 30 -> 86;
                    case 31 -> 201;
                    case 32 -> 29;
                    case 33 -> 38;
                    case 34 -> 127;
                    case 35 -> 78;
                    case 36 -> 20;
                    case 37 -> 81;
                    case 38 -> 3;
                    case 39 -> 179;
                    case 40 -> 40;
                    case 41 -> 195;
                    case 42 -> 190;
                    case 43 -> 185;
                    case 44 -> 15;
                    case 45 -> 234;
                    case 46 -> 73;
                    case 47 -> 253;
                    case 48 -> 51;
                    case 49 -> 94;
                    case 50 -> 113;
                    case 51 -> 49;
                    case 52 -> 163;
                    case 53 -> 32;
                    case 54 -> 84;
                    case 55 -> 125;
                    case 56 -> 2;
                    case 57 -> 64;
                    case 58 -> 122;
                    case 59 -> 173;
                    case 60 -> 164;
                    case 61 -> 135;
                    case 62 -> 199;
                    case 63 -> 74;
                    case 64 -> 79;
                    case 65 -> 154;
                    case 66 -> 11;
                    case 67 -> 148;
                    case 68 -> 215;
                    case 69 -> 221;
                    case 70 -> 35;
                    case 71 -> 119;
                    case 72 -> 92;
                    case 73 -> 141;
                    case 74 -> 8;
                    case 75 -> 61;
                    case 76 -> 193;
                    case 77 -> 246;
                    case 78 -> 192;
                    case 79 -> 224;
                    case 80 -> 131;
                    case 81 -> 165;
                    case 82 -> 9;
                    case 83 -> 52;
                    case 84 -> 117;
                    case 85 -> 62;
                    case 86 -> 166;
                    case 87 -> 82;
                    case 88 -> 206;
                    case 89 -> 23;
                    case 90 -> 75;
                    case 91 -> 129;
                    case 92 -> 175;
                    case 93 -> 46;
                    case 94 -> 102;
                    case 95 -> 50;
                    case 96 -> 252;
                    case 97 -> 18;
                    case 98 -> 103;
                    case 99 -> 115;
                    case 100 -> 189;
                    case 101 -> 137;
                    case 102 -> 244;
                    case 103 -> 150;
                    case 104 -> 168;
                    case 105 -> 70;
                    case 106 -> 237;
                    case 107 -> 249;
                    case 108 -> 126;
                    case 109 -> 96;
                    case 110 -> 236;
                    case 111 -> 225;
                    case 112 -> 47;
                    case 113 -> 101;
                    case 114 -> 239;
                    case 115 -> 146;
                    case 116 -> 169;
                    case 117 -> 151;
                    case 118 -> 17;
                    case 119 -> 34;
                    case 120 -> 0;
                    case 121 -> 66;
                    case 122 -> 162;
                    case 123 -> 223;
                    case 124 -> 14;
                    case 125 -> 171;
                    case 126 -> 132;
                    case 127 -> 83;
                    case 128 -> 118;
                    case 129 -> 210;
                    case 130 -> 235;
                    case 131 -> 105;
                    case 132 -> 200;
                    case 133 -> 144;
                    case 134 -> 216;
                    case 135 -> 226;
                    case 136 -> 229;
                    case 137 -> 214;
                    case 138 -> 243;
                    case 139 -> 182;
                    case 140 -> 60;
                    case 141 -> 247;
                    case 142 -> 198;
                    case 143 -> 110;
                    case 144 -> 208;
                    case 145 -> 136;
                    case 146 -> 124;
                    case 147 -> 160;
                    case 148 -> 186;
                    case 149 -> 205;
                    case 150 -> 217;
                    case 151 -> 254;
                    case 152 -> 255;
                    case 153 -> 33;
                    case 154 -> 203;
                    case 155 -> 59;
                    case 156 -> 251;
                    case 157 -> 120;
                    case 158 -> 178;
                    case 159 -> 30;
                    case 160 -> 167;
                    case 161 -> 204;
                    case 162 -> 19;
                    case 163 -> 85;
                    case 164 -> 13;
                    case 165 -> 158;
                    case 166 -> 140;
                    case 167 -> 48;
                    case 168 -> 153;
                    case 169 -> 222;
                    case 170 -> 232;
                    case 171 -> 10;
                    case 172 -> 112;
                    case 173 -> 233;
                    case 174 -> 138;
                    case 175 -> 5;
                    case 176 -> 242;
                    case 177 -> 143;
                    case 178 -> 230;
                    case 179 -> 26;
                    case 180 -> 69;
                    case 181 -> 228;
                    case 182 -> 245;
                    case 183 -> 24;
                    case 184 -> 213;
                    case 185 -> 116;
                    case 186 -> 174;
                    case 187 -> 58;
                    case 188 -> 31;
                    case 189 -> 44;
                    case 190 -> 220;
                    case 191 -> 250;
                    case 192 -> 108;
                    case 193 -> 181;
                    case 194 -> 156;
                    case 195 -> 227;
                    case 196 -> 89;
                    case 197 -> 97;
                    case 198 -> 93;
                    case 199 -> 77;
                    case 200 -> 39;
                    case 201 -> 197;
                    case 202 -> 177;
                    case 203 -> 188;
                    case 204 -> 6;
                    case 205 -> 248;
                    case 206 -> 42;
                    case 207 -> 16;
                    case 208 -> 130;
                    case 209 -> 184;
                    case 210 -> 91;
                    case 211 -> 176;
                    case 212 -> 114;
                    case 213 -> 218;
                    case 214 -> 22;
                    case 215 -> 142;
                    case 216 -> 196;
                    case 217 -> 67;
                    case 218 -> 87;
                    case 219 -> 211;
                    case 220 -> 72;
                    case 221 -> 111;
                    case 222 -> 238;
                    case 223 -> 100;
                    case 224 -> 212;
                    case 225 -> 172;
                    case 226 -> 145;
                    case 227 -> 191;
                    case 228 -> 161;
                    case 229 -> 121;
                    case 230 -> 80;
                    case 231 -> 187;
                    case 232 -> 68;
                    case 233 -> 53;
                    case 234 -> 98;
                    case 235 -> 71;
                    case 236 -> 104;
                    case 237 -> 76;
                    case 238 -> 99;
                    case 239 -> 28;
                    case 240 -> 90;
                    case 241 -> 65;
                    case 242 -> 152;
                    case 243 -> 241;
                    case 244 -> 4;
                    case 245 -> 37;
                    case 246 -> 240;
                    case 247 -> 43;
                    case 248 -> 95;
                    case 249 -> 36;
                    case 250 -> 209;
                    case 251 -> 134;
                    case 252 -> 63;
                    case 253 -> 88;
                    case 254 -> 194;
                    default -> 106;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 133114401431927L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(479978340 + (char)-9014, 479978340 + (char)-1489, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 105035616129999L;
                    int n3 = SshAgentIpcService.L();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-2104066710 - -29997, -2104066710 - -11456, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 != 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 117193533840245L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0004\u008f\u00d0\u00ad\u00a1\u0003\u00f7\u007f\u00f8";
                var4_3 = "\u0004\u008f\u00d0\u00ad\u00a1\u0003\u00f7\u007f\u00f8".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 23;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 79;
                                break;
                            }
                            case 1: {
                                v11 = 42;
                                break;
                            }
                            case 2: {
                                v11 = 100;
                                break;
                            }
                            case 3: {
                                v11 = 9;
                                break;
                            }
                            case 4: {
                                v11 = 127;
                                break;
                            }
                            case 5: {
                                v11 = 42;
                                break;
                            }
                            default: {
                                v11 = 24;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x6159) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 170;
                    case 1 -> 163;
                    case 2 -> 208;
                    case 3 -> 142;
                    case 4 -> 127;
                    case 5 -> 216;
                    case 6 -> 19;
                    case 7 -> 56;
                    case 8 -> 237;
                    case 9 -> 55;
                    case 10 -> 145;
                    case 11 -> 93;
                    case 12 -> 22;
                    case 13 -> 156;
                    case 14 -> 217;
                    case 15 -> 168;
                    case 16 -> 236;
                    case 17 -> 119;
                    case 18 -> 243;
                    case 19 -> 214;
                    case 20 -> 239;
                    case 21 -> 70;
                    case 22 -> 124;
                    case 23 -> 105;
                    case 24 -> 90;
                    case 25 -> 82;
                    case 26 -> 44;
                    case 27 -> 203;
                    case 28 -> 107;
                    case 29 -> 57;
                    case 30 -> 18;
                    case 31 -> 146;
                    case 32 -> 186;
                    case 33 -> 77;
                    case 34 -> 247;
                    case 35 -> 234;
                    case 36 -> 37;
                    case 37 -> 85;
                    case 38 -> 218;
                    case 39 -> 199;
                    case 40 -> 61;
                    case 41 -> 32;
                    case 42 -> 244;
                    case 43 -> 125;
                    case 44 -> 0;
                    case 45 -> 138;
                    case 46 -> 165;
                    case 47 -> 25;
                    case 48 -> 17;
                    case 49 -> 8;
                    case 50 -> 53;
                    case 51 -> 201;
                    case 52 -> 83;
                    case 53 -> 120;
                    case 54 -> 54;
                    case 55 -> 126;
                    case 56 -> 176;
                    case 57 -> 33;
                    case 58 -> 58;
                    case 59 -> 64;
                    case 60 -> 254;
                    case 61 -> 183;
                    case 62 -> 109;
                    case 63 -> 76;
                    case 64 -> 132;
                    case 65 -> 73;
                    case 66 -> 192;
                    case 67 -> 40;
                    case 68 -> 197;
                    case 69 -> 51;
                    case 70 -> 110;
                    case 71 -> 34;
                    case 72 -> 230;
                    case 73 -> 108;
                    case 74 -> 172;
                    case 75 -> 14;
                    case 76 -> 3;
                    case 77 -> 98;
                    case 78 -> 157;
                    case 79 -> 5;
                    case 80 -> 23;
                    case 81 -> 245;
                    case 82 -> 227;
                    case 83 -> 6;
                    case 84 -> 95;
                    case 85 -> 103;
                    case 86 -> 189;
                    case 87 -> 71;
                    case 88 -> 48;
                    case 89 -> 241;
                    case 90 -> 250;
                    case 91 -> 1;
                    case 92 -> 167;
                    case 93 -> 75;
                    case 94 -> 12;
                    case 95 -> 30;
                    case 96 -> 191;
                    case 97 -> 143;
                    case 98 -> 28;
                    case 99 -> 134;
                    case 100 -> 136;
                    case 101 -> 112;
                    case 102 -> 100;
                    case 103 -> 122;
                    case 104 -> 158;
                    case 105 -> 252;
                    case 106 -> 60;
                    case 107 -> 198;
                    case 108 -> 115;
                    case 109 -> 133;
                    case 110 -> 253;
                    case 111 -> 81;
                    case 112 -> 184;
                    case 113 -> 209;
                    case 114 -> 102;
                    case 115 -> 4;
                    case 116 -> 140;
                    case 117 -> 222;
                    case 118 -> 169;
                    case 119 -> 62;
                    case 120 -> 116;
                    case 121 -> 97;
                    case 122 -> 232;
                    case 123 -> 166;
                    case 124 -> 59;
                    case 125 -> 211;
                    case 126 -> 154;
                    case 127 -> 66;
                    case 128 -> 20;
                    case 129 -> 16;
                    case 130 -> 162;
                    case 131 -> 226;
                    case 132 -> 161;
                    case 133 -> 129;
                    case 134 -> 175;
                    case 135 -> 72;
                    case 136 -> 88;
                    case 137 -> 7;
                    case 138 -> 118;
                    case 139 -> 187;
                    case 140 -> 106;
                    case 141 -> 13;
                    case 142 -> 159;
                    case 143 -> 137;
                    case 144 -> 204;
                    case 145 -> 94;
                    case 146 -> 210;
                    case 147 -> 213;
                    case 148 -> 155;
                    case 149 -> 87;
                    case 150 -> 49;
                    case 151 -> 89;
                    case 152 -> 160;
                    case 153 -> 123;
                    case 154 -> 46;
                    case 155 -> 113;
                    case 156 -> 36;
                    case 157 -> 150;
                    case 158 -> 178;
                    case 159 -> 141;
                    case 160 -> 80;
                    case 161 -> 182;
                    case 162 -> 215;
                    case 163 -> 249;
                    case 164 -> 131;
                    case 165 -> 194;
                    case 166 -> 26;
                    case 167 -> 238;
                    case 168 -> 78;
                    case 169 -> 188;
                    case 170 -> 181;
                    case 171 -> 63;
                    case 172 -> 130;
                    case 173 -> 69;
                    case 174 -> 221;
                    case 175 -> 9;
                    case 176 -> 52;
                    case 177 -> 149;
                    case 178 -> 195;
                    case 179 -> 15;
                    case 180 -> 185;
                    case 181 -> 43;
                    case 182 -> 235;
                    case 183 -> 74;
                    case 184 -> 68;
                    case 185 -> 41;
                    case 186 -> 47;
                    case 187 -> 196;
                    case 188 -> 220;
                    case 189 -> 99;
                    case 190 -> 174;
                    case 191 -> 240;
                    case 192 -> 21;
                    case 193 -> 206;
                    case 194 -> 128;
                    case 195 -> 45;
                    case 196 -> 42;
                    case 197 -> 92;
                    case 198 -> 223;
                    case 199 -> 10;
                    case 200 -> 153;
                    case 201 -> 242;
                    case 202 -> 65;
                    case 203 -> 148;
                    case 204 -> 29;
                    case 205 -> 251;
                    case 206 -> 202;
                    case 207 -> 173;
                    case 208 -> 117;
                    case 209 -> 11;
                    case 210 -> 27;
                    case 211 -> 248;
                    case 212 -> 96;
                    case 213 -> 225;
                    case 214 -> 104;
                    case 215 -> 86;
                    case 216 -> 67;
                    case 217 -> 180;
                    case 218 -> 2;
                    case 219 -> 231;
                    case 220 -> 229;
                    case 221 -> 246;
                    case 222 -> 114;
                    case 223 -> 147;
                    case 224 -> 139;
                    case 225 -> 50;
                    case 226 -> 91;
                    case 227 -> 135;
                    case 228 -> 24;
                    case 229 -> 179;
                    case 230 -> 121;
                    case 231 -> 38;
                    case 232 -> 205;
                    case 233 -> 207;
                    case 234 -> 101;
                    case 235 -> 233;
                    case 236 -> 212;
                    case 237 -> 255;
                    case 238 -> 171;
                    case 239 -> 144;
                    case 240 -> 79;
                    case 241 -> 84;
                    case 242 -> 39;
                    case 243 -> 151;
                    case 244 -> 31;
                    case 245 -> 35;
                    case 246 -> 190;
                    case 247 -> 152;
                    case 248 -> 224;
                    case 249 -> 111;
                    case 250 -> 228;
                    case 251 -> 164;
                    case 252 -> 200;
                    case 253 -> 193;
                    case 254 -> 177;
                    default -> 219;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

