/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeConsoleAdditionalFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    public static final FileHyperlinkRawDataFinder FINDER = new NodeAdditionalFinder();

    public NodeConsoleAdditionalFilter(@NotNull Project project, @Nullable String baseDir) {
        if (project == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(0);
        }
        super(project, baseDir);
    }

    public NodeConsoleAdditionalFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(1);
        }
        super(project, baseDir == null ? null : baseDir.getPath());
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(2);
        }
        List list = FINDER.find(line);
        if (list == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public VirtualFile findFile(@NotNull String filePath) {
        if (filePath == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(4);
        }
        filePath = StringUtil.trimStart((String)filePath, (String)"file://");
        filePath = NodeConsoleAdditionalFilter.convertWslPath(filePath);
        return super.findFile(filePath);
    }

    @NotNull
    static String convertWslPath(@NotNull String wslPath) {
        if (wslPath == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(5);
        }
        if (!SystemInfo.isWindows) {
            String string = wslPath;
            if (string == null) {
                NodeConsoleAdditionalFilter.$$$reportNull$$$0(6);
            }
            return string;
        }
        String windowsPath = WSLUtil.getWindowsPath((String)wslPath, (String)"/mnt/");
        if (windowsPath == null && wslPath.startsWith("/c/Users/")) {
            windowsPath = WSLUtil.getWindowsPath((String)wslPath, (String)"/");
        }
        String string = (String)ObjectUtils.notNull((Object)windowsPath, (Object)wslPath);
        if (string == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static FileHyperlinkRawData parseFirefoxLikeLink(@NotNull String line) {
        if (line == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(8);
        }
        int startIndex = line.indexOf("@(");
        while (startIndex >= 0) {
            FileHyperlinkRawData result2 = NodeConsoleAdditionalFilter.parseFirefoxLikeLinkAt(line, startIndex + 2);
            if (result2 != null) {
                return result2;
            }
            startIndex = line.indexOf("@(", startIndex + 2);
        }
        return null;
    }

    @Nullable
    private static FileHyperlinkRawData parseFirefoxLikeLinkAt(@NotNull String line, int pathStartInd) {
        if (line == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(9);
        }
        int length = line.length();
        int pathEndInd = line.indexOf(58, pathStartInd);
        if (pathEndInd > 0 && pathEndInd - pathStartInd > 3) {
            int lineStartInd;
            int lineEndInd;
            for (lineEndInd = lineStartInd = pathEndInd + 1; lineEndInd < length && Character.isDigit(line.charAt(lineEndInd)); ++lineEndInd) {
            }
            if (lineStartInd == lineEndInd) {
                return null;
            }
            int documentColumn = -1;
            int closeParenInd = lineEndInd;
            if (lineEndInd < length && line.charAt(lineEndInd) == ':') {
                int columnStartInd;
                int columnEndInd;
                for (columnEndInd = columnStartInd = lineEndInd + 1; columnEndInd < length && Character.isDigit(line.charAt(columnEndInd)); ++columnEndInd) {
                }
                if (columnStartInd == columnEndInd) {
                    return null;
                }
                documentColumn = StringUtil.parseInt((String)line.substring(columnStartInd, columnEndInd), (int)-1) - 1;
                closeParenInd = columnEndInd;
            }
            if (closeParenInd < length && line.charAt(closeParenInd) == ')') {
                int documentLine = StringUtil.parseInt((String)line.substring(lineStartInd, lineEndInd), (int)-1) - 1;
                return new FileHyperlinkRawData(line.substring(pathStartInd, pathEndInd), documentLine, documentColumn, pathStartInd, closeParenInd);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWslPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertWslPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseFirefoxLikeLink";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseFirefoxLikeLinkAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class NodeAdditionalFinder
    implements FileHyperlinkRawDataFinder {
        private static final FileHyperlinkRawDataFinder PATTERN_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^(?:>> )?\\s*([/\\w].*?):(\\d+)(:\\d+)?(?:\\s|: |$)"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        private NodeAdditionalFinder() {
        }

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            FileHyperlinkRawData data2;
            if (line == null) {
                NodeAdditionalFinder.$$$reportNull$$$0(0);
            }
            if ((data2 = NodeConsoleAdditionalFilter.parseFirefoxLikeLink(line)) != null) {
                List<FileHyperlinkRawData> list = Collections.singletonList(data2);
                if (list == null) {
                    NodeAdditionalFinder.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = PATTERN_FINDER.find(line);
            if (list == null) {
                NodeAdditionalFinder.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter$NodeAdditionalFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter$NodeAdditionalFinder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "find";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

