/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.notification;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.InstallNodeLocalDependenciesAction;
import com.intellij.javascript.nodejs.packageJson.InstalledDependenciesChangeListener;
import com.intellij.javascript.nodejs.packageJson.NodeJsEnvironmentProvider;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.packageJson.UpdateDependenciesActionListener;
import com.intellij.javascript.nodejs.packageJson.notification.EnablePackageJsonMismatchedDependenciesNotificationAction;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonDependenciesVerifier;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonGetDependenciesAction;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonNotifierConfiguration;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonSeveralFilesAction;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonUpdateNotifier;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonBuildFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.Alarm;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="PackageJsonUpdateNotifier", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0001\u0018\u0000 C2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0004@ABCB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nJ\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u001e\u0010\u001e\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\u001cH\u0007J\b\u0010&\u001a\u00020\u001cH\u0002J\u0016\u0010'\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0(H\u0002J\b\u0010)\u001a\u00020\u001cH\u0002J\u0016\u0010*\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u000e\u0010.\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nJ\u0006\u0010/\u001a\u00020\u001cJ\u0016\u00100\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0(H\u0002J\u0016\u00101\u001a\u00020-2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0(H\u0002J\u001e\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u0002042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0(H\u0003J\u0010\u00105\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\nH\u0007J\u0010\u00106\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0018\u00108\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u00109\u001a\u00020\u000eH\u0002J\u001a\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020\n2\b\b\u0002\u0010<\u001a\u00020-H\u0002J\b\u0010=\u001a\u00020\u0002H\u0016J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006D"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "dismissedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "openedPackageJsonFiles", "shownNotifications", "", "Lcom/intellij/notification/Notification;", "testShownNotifications", "schedulingAlarm", "Lcom/intellij/util/Alarm;", "scheduledPackageJsonFiles", "Ljava/util/concurrent/BlockingQueue;", "myExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "packageJsonNotifierConfiguration", "Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonNotifierConfiguration;", "getPackageJsonNotifierConfiguration", "()Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonNotifierConfiguration;", "onPackageJsonUpdated", "", "packageJson", "scheduleProcessing", "findProjectPackageJson", "packageJsonFiles", "", "delayMillis", "", "dispose", "onProjectOpenedInTests", "onProjectOpened", "init", "", "trackOpenedFiles", "processPackageJsonFiles", "", "isPackageJsonNotificationSuppressed", "", "enableNotificationForPackageJson", "enableNotificationForAllPackageJsonFiles", "showNotification", "processEnvironmentValue", "showNotificationInUiThread", "packageJsonLink", "", "isNotificationShownInTests", "isNotificationShownFor", "hideNotificationLater", "register", "notification", "createFileLink", "file", "prependContentRootName", "getState", "loadState", "state", "PackageJsonDismissAction", "MyNotificationListener", "MyStartupActivity", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nPackageJsonUpdateNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,542:1\n3829#2:543\n4344#2,2:544\n*S KotlinDebug\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier\n*L\n181#1:543\n181#1:544,2\n*E\n"})
public final class PackageJsonUpdateNotifier
implements PersistentStateComponent<Element>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<VirtualFile> dismissedFiles;
    @NotNull
    private final Set<VirtualFile> openedPackageJsonFiles;
    @NotNull
    private final Map<VirtualFile, Notification> shownNotifications;
    @TestOnly
    @NotNull
    private final Set<VirtualFile> testShownNotifications;
    @NotNull
    private final Alarm schedulingAlarm;
    @NotNull
    private final BlockingQueue<VirtualFile> scheduledPackageJsonFiles;
    @NotNull
    private final ExecutorService myExecutor;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DISMISSED = "dismissed";
    private static final long MERGING_DELAY_MILLIS = 1000L;
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "Dependencies from package.json";
    @NotNull
    private static final String LOG_ONLY_NOTIFICATION_GROUP_ID = "Dismiss notifications about package.json";

    public PackageJsonUpdateNotifier(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.dismissedFiles = set;
        Set set2 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentSet(...)");
        this.openedPackageJsonFiles = set2;
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakValueMap(...)");
        this.shownNotifications = map2;
        Set set3 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"createConcurrentSet(...)");
        this.testShownNotifications = set3;
        this.schedulingAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.scheduledPackageJsonFiles = new LinkedBlockingQueue();
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PackageJsonUpdateNotifier", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.myExecutor = executorService;
        PackageJsonDependenciesExternalUpdateManager.Companion.getInstance(this.project).addUpdateActionListener(new UpdateDependenciesActionListener(){

            @Override
            public void updateActionFinished(VirtualFile packageJson) {
                if (packageJson != null) {
                    this.scheduleProcessing(packageJson);
                }
            }
        });
    }

    private final PackageJsonNotifierConfiguration getPackageJsonNotifierConfiguration() {
        Object object = this.project.getService(PackageJsonNotifierConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        return (PackageJsonNotifierConfiguration)object;
    }

    public final void onPackageJsonUpdated(@NotNull VirtualFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        if (LOG.isDebugEnabled()) {
            LOG.debug("checking " + packageJson.getPath());
        }
        Object[] objectArray = new Object[]{Pair.create((Object)this, (Object)packageJson)};
        ReadAction.nonBlocking(() -> PackageJsonUpdateNotifier.onPackageJsonUpdated$lambda$0(this, packageJson)).expireWith((Disposable)this).coalesceBy(objectArray).submit((Executor)this.myExecutor).onSuccess(arg_0 -> PackageJsonUpdateNotifier.onPackageJsonUpdated$lambda$2(arg_0 -> PackageJsonUpdateNotifier.onPackageJsonUpdated$lambda$1(this, arg_0), arg_0));
    }

    private final void scheduleProcessing(VirtualFile packageJson) {
        this.scheduleProcessing(SetsKt.setOf((Object)packageJson), 1000L);
    }

    private final VirtualFile findProjectPackageJson(VirtualFile packageJson) {
        VirtualFile projectPackageJson;
        if (this.project.isDisposed()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        if (fileIndex.isInContent(packageJson)) {
            return packageJson;
        }
        VirtualFile nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(packageJson);
        if (nodeModulesDir != null && (projectPackageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir)) != null && fileIndex.isInContent(projectPackageJson)) {
            return projectPackageJson;
        }
        return null;
    }

    private final void scheduleProcessing(Collection<? extends VirtualFile> packageJsonFiles, long delayMillis) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.processPackageJsonFiles((Set<? extends VirtualFile>)new HashSet<VirtualFile>(packageJsonFiles));
            return;
        }
        ReadAction.run(() -> PackageJsonUpdateNotifier.scheduleProcessing$lambda$4(this, packageJsonFiles, delayMillis));
    }

    public void dispose() {
    }

    @TestOnly
    public final void onProjectOpenedInTests() {
        this.onProjectOpened();
    }

    private final void onProjectOpened() {
        this.getPackageJsonNotifierConfiguration().detectPackageJsonFiles().onSuccess(arg_0 -> PackageJsonUpdateNotifier.onProjectOpened$lambda$6(arg_0 -> PackageJsonUpdateNotifier.onProjectOpened$lambda$5(this, arg_0), arg_0));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<PackageJsonFileManager.PackageJsonChangesListener> topic = PackageJsonFileManager.CHANGES_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"CHANGES_TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> PackageJsonUpdateNotifier.onProjectOpened$lambda$7(this, arg_0));
    }

    private final void init(List<? extends VirtualFile> packageJsonFiles) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.trackOpenedFiles();
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> PackageJsonUpdateNotifier.init$lambda$9(this, packageJsonFiles), this.project.getDisposed());
    }

    private final void trackOpenedFiles() {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ PackageJsonUpdateNotifier this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (PackageJsonUtil.isPackageJsonFile(file)) {
                    PackageJsonUpdateNotifier.access$getOpenedPackageJsonFiles$p(this.this$0).add(file);
                    PackageJsonUpdateNotifier.access$scheduleProcessing(this.this$0, file);
                }
            }

            public void fileClosed(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                PackageJsonUpdateNotifier.access$getOpenedPackageJsonFiles$p(this.this$0).remove(file);
                if (PackageJsonUtil.isPackageJsonFile(file)) {
                    ReadAction.nonBlocking(() -> trackOpenedFiles.1.fileClosed$lambda$0(this.this$0, file)).expireWith((Disposable)this.this$0).submit((Executor)PackageJsonUpdateNotifier.access$getMyExecutor$p(this.this$0)).onSuccess(arg_0 -> trackOpenedFiles.1.fileClosed$lambda$2(arg_0 -> trackOpenedFiles.1.fileClosed$lambda$1(this.this$0, file, arg_0), arg_0));
                }
            }

            private static final Boolean fileClosed$lambda$0(PackageJsonUpdateNotifier this$0, VirtualFile $file) {
                return PackageJsonUpdateNotifier.access$getPackageJsonNotifierConfiguration(this$0).isEssential($file);
            }

            private static final Unit fileClosed$lambda$1(PackageJsonUpdateNotifier this$0, VirtualFile $file, boolean essential) {
                if (!essential) {
                    PackageJsonUpdateNotifier.access$hideNotificationLater(this$0, $file);
                }
                return Unit.INSTANCE;
            }

            private static final void fileClosed$lambda$2(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        });
    }

    private final void processPackageJsonFiles(Set<? extends VirtualFile> packageJsonFiles) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processPackageJsonFiles " + packageJsonFiles);
        }
        List matchDepsPackageJsons = new ArrayList();
        ReadAction.run(() -> PackageJsonUpdateNotifier.processPackageJsonFiles$lambda$10(this, packageJsonFiles, matchDepsPackageJsons));
        List toShow = new ArrayList();
        for (VirtualFile packageJson : matchDepsPackageJsons) {
            boolean depsMatched = new PackageJsonDependenciesVerifier(this.project, packageJson).verify();
            if (depsMatched) {
                this.hideNotificationLater(packageJson);
                continue;
            }
            toShow.add(packageJson);
        }
        this.showNotification(toShow);
    }

    private final boolean isPackageJsonNotificationSuppressed(VirtualFile packageJson) {
        return this.dismissedFiles.contains(packageJson);
    }

    public final void enableNotificationForPackageJson(@NotNull VirtualFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        this.dismissedFiles.remove(packageJson);
        this.scheduleProcessing(packageJson);
    }

    public final void enableNotificationForAllPackageJsonFiles() {
        List packageJsonFiles = new ArrayList(this.dismissedFiles);
        this.dismissedFiles.clear();
        this.scheduleProcessing(packageJsonFiles, 1000L);
    }

    private final void showNotification(List<? extends VirtualFile> packageJsonFiles) {
        if (packageJsonFiles.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.testShownNotifications.addAll((Collection<VirtualFile>)packageJsonFiles);
            return;
        }
        if (this.processEnvironmentValue(packageJsonFiles)) {
            return;
        }
        ReadAction.nonBlocking(() -> PackageJsonUpdateNotifier.showNotification$lambda$11(this, packageJsonFiles)).expireWith((Disposable)this).finishOnUiThread(ModalityState.nonModal(), arg_0 -> PackageJsonUpdateNotifier.showNotification$lambda$13(arg_0 -> PackageJsonUpdateNotifier.showNotification$lambda$12(this, packageJsonFiles, arg_0), arg_0)).submit((Executor)this.myExecutor);
        PackageJsonDependenciesExternalUpdateManager.Companion.getInstance(this.project).addInstalledDependenciesChangeListener(new InstalledDependenciesChangeListener(packageJsonFiles, this){
            final /* synthetic */ List<VirtualFile> $packageJsonFiles;
            final /* synthetic */ PackageJsonUpdateNotifier this$0;
            {
                this.$packageJsonFiles = $packageJsonFiles;
                this.this$0 = $receiver;
            }

            public void installedDependenciesChanged() {
                for (VirtualFile packageJson : this.$packageJsonFiles) {
                    PackageJsonUpdateNotifier.access$scheduleProcessing(this.this$0, packageJson);
                }
            }
        }, this);
    }

    private final boolean processEnvironmentValue(List<? extends VirtualFile> packageJsonFiles) {
        Boolean environmentAction = NodeJsEnvironmentProvider.Companion.getInstallActionFromEnvironment();
        if (environmentAction != null) {
            if (environmentAction.booleanValue()) {
                for (VirtualFile virtualFile : packageJsonFiles) {
                    InstallNodeLocalDependenciesAction.runAndShowConsole(this.project, virtualFile);
                }
            } else {
                this.dismissedFiles.addAll((Collection<VirtualFile>)packageJsonFiles);
            }
            return true;
        }
        return false;
    }

    @RequiresEdt(generateAssertion=false)
    private final void showNotificationInUiThread(String packageJsonLink, List<? extends VirtualFile> packageJsonFiles) {
        NotificationGroup notificationGroup = Companion.getNotificationGroup();
        VirtualFile packageJson = (VirtualFile)CollectionsKt.first(packageJsonFiles);
        if (packageJsonFiles.size() > 1) {
            String string = JavaScriptBundle.message("package_json.install_dependencies.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{packageJsonLink, packageJsonFiles.size() - 1};
            String string2 = JavaScriptBundle.message("package_json.install_dependencies_multiple.notification.content", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Notification notification = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).setListener((NotificationListener)new MyNotificationListener());
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setListener(...)");
            Notification notification2 = notification;
            notification2.setSuggestionType(true);
            notification2.addAction((AnAction)new PackageJsonSeveralFilesAction(this.project, packageJsonFiles, notification2));
            notification2.addAction((AnAction)new PackageJsonDismissAction((Collection<? extends VirtualFile>)packageJsonFiles));
            notification2.notify(this.project);
        } else {
            if (this.isNotificationShownFor(packageJson)) {
                return;
            }
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
            String string = nodeModulesDir == null ? JavaScriptBundle.message("package_json.install_dependencies.notification.title", new Object[0]) : JavaScriptBundle.message("package_json.update_dependencies.notification.title", new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            String title = string;
            Object[] objectArray = new Object[]{packageJsonLink};
            String string3 = JavaScriptBundle.message("package_json.install_dependencies.notification.content", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            Notification notification = notificationGroup.createNotification(title, string3, NotificationType.INFORMATION).setListener((NotificationListener)new MyNotificationListener());
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setListener(...)");
            Notification notification3 = notification;
            notification3.setSuggestionType(true);
            notification3.addAction((AnAction)new PackageJsonGetDependenciesAction(this.project, packageJson, notification3));
            notification3.addAction((AnAction)new PackageJsonDismissAction((Collection<? extends VirtualFile>)packageJsonFiles));
            notification3.notify(this.project);
            this.register(packageJson, notification3);
        }
    }

    @TestOnly
    public final boolean isNotificationShownInTests(@NotNull VirtualFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        return this.testShownNotifications.contains(packageJson);
    }

    private final boolean isNotificationShownFor(VirtualFile packageJson) {
        Notification notification = this.shownNotifications.get(packageJson);
        if (notification != null) {
            Balloon balloon = notification.getBalloon();
            return balloon != null && !balloon.isDisposed();
        }
        return false;
    }

    private final void hideNotificationLater(VirtualFile packageJson) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.testShownNotifications.remove(packageJson);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> PackageJsonUpdateNotifier.hideNotificationLater$lambda$14(this, packageJson), this.project.getDisposed());
    }

    private final void register(VirtualFile packageJson, Notification notification) {
        Balloon balloon = notification.getBalloon();
        if (balloon != null) {
            this.shownNotifications.put(packageJson, notification);
            balloon.addListener(new JBPopupListener(this, packageJson){
                final /* synthetic */ PackageJsonUpdateNotifier this$0;
                final /* synthetic */ VirtualFile $packageJson;
                {
                    this.this$0 = $receiver;
                    this.$packageJson = $packageJson;
                }

                public void onClosed(LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    PackageJsonUpdateNotifier.access$getShownNotifications$p(this.this$0).remove(this.$packageJson);
                }
            });
        }
    }

    private final String createFileLink(VirtualFile file, boolean prependContentRootName) {
        String string = HtmlChunk.link((String)file.getPath(), (String)JsbtUtil.getRelativePath(this.project, file, prependContentRootName)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String createFileLink$default(PackageJsonUpdateNotifier packageJsonUpdateNotifier, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return packageJsonUpdateNotifier.createFileLink(virtualFile, bl);
    }

    @NotNull
    public Element getState() {
        Element root = new Element("root");
        List paths = new ArrayList();
        for (VirtualFile file : this.dismissedFiles) {
            if (!file.isValid()) continue;
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            paths.add(string);
        }
        Collections.sort(paths);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)root, (String)DISMISSED, (List)paths);
        return root;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)state, (String)DISMISSED);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenValueAttributes(...)");
        List paths = list;
        paths = new ArrayList(paths);
        List dismissedFiles = new ArrayList();
        Iterator iterator = ((ArrayList)paths).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String path2 = (String)iterator2.next();
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path2);
            if (file == null || !file.isValid() || !PackageJsonUtil.isPackageJsonFile(file)) continue;
            dismissedFiles.add(file);
        }
        this.dismissedFiles.clear();
        this.dismissedFiles.addAll(dismissedFiles);
    }

    private static final VirtualFile onPackageJsonUpdated$lambda$0(PackageJsonUpdateNotifier this$0, VirtualFile $packageJson) {
        return this$0.findProjectPackageJson($packageJson);
    }

    private static final Unit onPackageJsonUpdated$lambda$1(PackageJsonUpdateNotifier this$0, VirtualFile projectPackageJson) {
        if (projectPackageJson != null) {
            this$0.scheduleProcessing(projectPackageJson);
        }
        return Unit.INSTANCE;
    }

    private static final void onPackageJsonUpdated$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void scheduleProcessing$lambda$4$lambda$3(PackageJsonUpdateNotifier this$0) {
        Set copy = new HashSet(this$0.scheduledPackageJsonFiles.size());
        this$0.scheduledPackageJsonFiles.drainTo(copy);
        this$0.processPackageJsonFiles(copy);
    }

    private static final void scheduleProcessing$lambda$4(PackageJsonUpdateNotifier this$0, Collection $packageJsonFiles, long $delayMillis) {
        if (!this$0.project.isDisposed()) {
            this$0.schedulingAlarm.cancelAllRequests();
            this$0.scheduledPackageJsonFiles.addAll($packageJsonFiles);
            this$0.schedulingAlarm.addRequest(() -> PackageJsonUpdateNotifier.scheduleProcessing$lambda$4$lambda$3(this$0), $delayMillis);
        }
    }

    private static final Unit onProjectOpened$lambda$5(PackageJsonUpdateNotifier this$0, List it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.init(it);
        return Unit.INSTANCE;
    }

    private static final void onProjectOpened$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void onProjectOpened$lambda$7(PackageJsonUpdateNotifier this$0, List events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        for (PackageJsonFileManager.PackageJsonChangeEvent event : events) {
            if (event.getType() != PackageJsonFileManager.PackageJsonEventType.CREATED && event.getType() != PackageJsonFileManager.PackageJsonEventType.CHANGED) continue;
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            this$0.onPackageJsonUpdated(virtualFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void init$lambda$9(PackageJsonUpdateNotifier this$0, List $packageJsonFiles) {
        void $this$filterTo$iv$iv;
        PackageJsonBuildFileManager.getInstance(this$0.project).setPackageJsonFilesFromConfiguration($packageJsonFiles);
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this$0.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!PackageJsonUtil.isPackageJsonFile(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List openedPackageJsonFiles = (List)destination$iv$iv;
        Set set = ContainerUtil.union((Collection)$packageJsonFiles, (Collection)openedPackageJsonFiles);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"union(...)");
        this$0.scheduleProcessing(set, 300L);
        this$0.openedPackageJsonFiles.addAll(openedPackageJsonFiles);
        this$0.trackOpenedFiles();
    }

    private static final void processPackageJsonFiles$lambda$10(PackageJsonUpdateNotifier this$0, Set $packageJsonFiles, List $matchDepsPackageJsons) {
        if (this$0.project.isDisposed()) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !NodeJsInterpreterManager.getInstance(this$0.project).isInterpreterAvailable()) {
            return;
        }
        boolean externalUpdateRunning = PackageJsonDependenciesExternalUpdateManager.Companion.getInstance(this$0.project).isUpdateActionRunning();
        PackageJsonNotifierConfiguration packageJsonNotifierConfiguration = this$0.getPackageJsonNotifierConfiguration();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        for (VirtualFile file : $packageJsonFiles) {
            PackageJsonData data2;
            VirtualFile nodeModulesDir;
            if (!file.isValid() || !packageJsonNotifierConfiguration.isNpmPackageJson(file) || this$0.isPackageJsonNotificationSuppressed(file) || !PackageJsonUpdateNotifier.Companion.isNodeJsPackageJson(file, fileIndex) || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file)) == null && !packageJsonNotifierConfiguration.isEssential(file) && !this$0.openedPackageJsonFiles.contains(file) || PsiErrorElementUtil.hasErrors((Project)this$0.project, (VirtualFile)file)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)PackageJsonData.getOrCreate(file), (String)"getOrCreate(...)");
            if (data2.getAllDependencies().isEmpty()) continue;
            if (externalUpdateRunning) {
                this$0.hideNotificationLater(file);
                continue;
            }
            if (PackageJsonUpdateNotifier.Companion.isNodeModulesUpdatingExternally(file)) {
                this$0.hideNotificationLater(file);
                continue;
            }
            $matchDepsPackageJsons.add(file);
        }
    }

    private static final String showNotification$lambda$11(PackageJsonUpdateNotifier this$0, List $packageJsonFiles) {
        return PackageJsonUpdateNotifier.createFileLink$default(this$0, (VirtualFile)CollectionsKt.first((List)$packageJsonFiles), false, 2, null);
    }

    private static final Unit showNotification$lambda$12(PackageJsonUpdateNotifier this$0, List $packageJsonFiles, String packageJsonLink) {
        Intrinsics.checkNotNullParameter((Object)packageJsonLink, (String)"packageJsonLink");
        this$0.showNotificationInUiThread(packageJsonLink, $packageJsonFiles);
        return Unit.INSTANCE;
    }

    private static final void showNotification$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void hideNotificationLater$lambda$14(PackageJsonUpdateNotifier this$0, VirtualFile $packageJson) {
        Notification notification = this$0.shownNotifications.get($packageJson);
        if (notification != null && !notification.isExpired()) {
            notification.expire();
        }
    }

    @JvmStatic
    @NotNull
    public static final PackageJsonUpdateNotifier getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @NotNull
    public static final NotificationGroup getNotificationGroup() {
        return Companion.getNotificationGroup();
    }

    public static final /* synthetic */ Set access$getOpenedPackageJsonFiles$p(PackageJsonUpdateNotifier $this) {
        return $this.openedPackageJsonFiles;
    }

    public static final /* synthetic */ ExecutorService access$getMyExecutor$p(PackageJsonUpdateNotifier $this) {
        return $this.myExecutor;
    }

    public static final /* synthetic */ PackageJsonNotifierConfiguration access$getPackageJsonNotifierConfiguration(PackageJsonUpdateNotifier $this) {
        return $this.getPackageJsonNotifierConfiguration();
    }

    public static final /* synthetic */ void access$hideNotificationLater(PackageJsonUpdateNotifier $this, VirtualFile packageJson) {
        $this.hideNotificationLater(packageJson);
    }

    public static final /* synthetic */ Map access$getShownNotifications$p(PackageJsonUpdateNotifier $this) {
        return $this.shownNotifications;
    }

    static {
        Logger logger = Logger.getInstance(PackageJsonUpdateNotifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\bJ\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\b\u00a2\u0006\u0002\b\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u00178FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0003\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006!"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "DISMISSED", "", "MERGING_DELAY_MILLIS", "", "NOTIFICATION_GROUP_ID", "Lorg/jetbrains/annotations/NonNls;", "LOG_ONLY_NOTIFICATION_GROUP_ID", "getInstance", "Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier;", "project", "Lcom/intellij/openapi/project/Project;", "isNodeModulesUpdatingExternally", "", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getNotificationGroup$annotations", "getNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "logOnlyNotificationGroup", "getLogOnlyNotificationGroup", "notificationGroupId", "isNodeJsPackageJson", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PackageJsonUpdateNotifier getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(PackageJsonUpdateNotifier.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (PackageJsonUpdateNotifier)object;
        }

        private final boolean isNodeModulesUpdatingExternally(VirtualFile packageJson) {
            Object object = packageJson.getParent();
            if (object == null || (object = VirtualFileUtil.toNioPathOrNull((VirtualFile)object)) == null) {
                return false;
            }
            Object parent = object;
            return Files.isDirectory(parent.resolve("node_modules").resolve(".staging"), new LinkOption[0]);
        }

        @NotNull
        public final NotificationGroup getNotificationGroup() {
            return this.getNotificationGroup(PackageJsonUpdateNotifier.NOTIFICATION_GROUP_ID);
        }

        @JvmStatic
        public static /* synthetic */ void getNotificationGroup$annotations() {
        }

        @NotNull
        public final NotificationGroup getLogOnlyNotificationGroup() {
            return this.getNotificationGroup(PackageJsonUpdateNotifier.LOG_ONLY_NOTIFICATION_GROUP_ID);
        }

        @NotNull
        public final NotificationGroup getNotificationGroup(@NotNull String notificationGroupId) {
            Intrinsics.checkNotNullParameter((Object)notificationGroupId, (String)"notificationGroupId");
            NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup(notificationGroupId);
            if (group != null) {
                return group;
            }
            throw new AssertionError((Object)("Cannot find notificationGroup '" + notificationGroupId + "'"));
        }

        private final boolean isNodeJsPackageJson(VirtualFile packageJson, ProjectFileIndex fileIndex) {
            Module module = fileIndex.getModuleForFile(packageJson, true);
            if (module == null || module.isDisposed()) {
                return false;
            }
            ModuleType moduleType = ModuleType.get((Module)module);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            if (moduleType2 instanceof ModuleTypeWithWebFeatures && !((ModuleTypeWithWebFeatures)moduleType2).hasWebFeatures(module)) {
                return false;
            }
            VirtualFile contentRoot = JSProjectUtil.getBaseDirectoryForFile(module.getProject(), packageJson, true);
            return contentRoot != null && !NodeModuleUtil.hasNodeModulesDirInPath(packageJson, contentRoot);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyNotificationListener;", "Lcom/intellij/notification/NotificationListener;", "<init>", "(Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier;)V", "hyperlinkUpdate", "", "notification", "Lcom/intellij/notification/Notification;", "event", "Ljavax/swing/event/HyperlinkEvent;", "intellij.javascript.impl"})
    private final class MyNotificationListener
    implements NotificationListener {
        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            VirtualFile file;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && (file = LocalFileSystem.getInstance().findFileByPath(event.getDescription())) != null && file.isValid()) {
                FileEditorManager.getInstance((Project)PackageJsonUpdateNotifier.this.project).openFile(file, true);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javascript.impl"})
    public static final class MyStartupActivity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Companion.getInstance(project).onProjectOpened();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$PackageJsonDismissAction;", "Lcom/intellij/notification/NotificationAction;", "myPackageJsonFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier;Ljava/util/Collection;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nPackageJsonUpdateNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$PackageJsonDismissAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,542:1\n1557#2:543\n1628#2,3:544\n*S KotlinDebug\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$PackageJsonDismissAction\n*L\n460#1:543\n460#1:544,3\n*E\n"})
    private final class PackageJsonDismissAction
    extends NotificationAction {
        @NotNull
        private final Collection<VirtualFile> myPackageJsonFiles;

        public PackageJsonDismissAction(Collection<? extends VirtualFile> myPackageJsonFiles) {
            Intrinsics.checkNotNullParameter(myPackageJsonFiles, (String)"myPackageJsonFiles");
            super(JavaScriptBundle.messagePointer("action.don.t.ask.again.text", new Object[0]));
            this.myPackageJsonFiles = myPackageJsonFiles;
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            notification.expire();
            PackageJsonUpdateNotifier.this.dismissedFiles.addAll(this.myPackageJsonFiles);
            Iterable iterable = this.myPackageJsonFiles;
            PackageJsonUpdateNotifier packageJsonUpdateNotifier = PackageJsonUpdateNotifier.this;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(packageJsonUpdateNotifier.createFileLink((VirtualFile)it, this.myPackageJsonFiles.size() > 1));
            }
            List paths = (List)destination$iv$iv;
            Object[] objectArray = new Object[]{StringUtil.join((Collection)paths, (String)", "), EnablePackageJsonMismatchedDependenciesNotificationAction.ACTION_NAME.get()};
            String string = JavaScriptBundle.message("package_json.notifications_are_disabled.notification.content", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String content = string;
            Companion.getLogOnlyNotificationGroup().createNotification(content, NotificationType.INFORMATION).setListener((NotificationListener)new MyNotificationListener()).notify(PackageJsonUpdateNotifier.this.project);
        }
    }
}

