/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.terminal;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.codeInsight.PackageJsonCompletionUtil;
import com.intellij.javascript.terminal.PackageManager;
import com.intellij.lang.javascript.buildTools.npm.NpmScript;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.completion.spec.ShellRuntimeContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellRuntimeContextExtensionsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u001d\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"getRunNames", "", "", "packageManager", "Lcom/intellij/javascript/terminal/PackageManager;", "(Lcom/intellij/javascript/terminal/PackageManager;)[Ljava/lang/String;", "getRemoveNames", "getRequiredAddNames", "getOptionalAddNames", "findDeclaredPackages", "", "context", "Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;", "findPackageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "findNpmScripts", "Lcom/intellij/lang/javascript/buildTools/npm/NpmScript;", "suggestPackagesToInstall", "intellij.javascript.impl"})
public final class NpmShellCommandSpecsProviderKt {
    private static final String[] getRunNames(PackageManager packageManager) {
        return switch (WhenMappings.$EnumSwitchMapping$0[packageManager.ordinal()]) {
            case 1, 2 -> {
                String[] var1_1 = new String[]{"run", "run-script"};
                yield var1_1;
            }
            case 3, 4 -> {
                String[] var1_2 = new String[]{"run"};
                yield var1_2;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String[] getRemoveNames(PackageManager packageManager) {
        return switch (WhenMappings.$EnumSwitchMapping$0[packageManager.ordinal()]) {
            case 1 -> {
                String[] var1_1 = new String[]{"remove", "rm", "r", "un", "uninstall", "unlink"};
                yield var1_1;
            }
            case 3 -> {
                String[] var1_2 = new String[]{"remove"};
                yield var1_2;
            }
            case 2 -> {
                String[] var1_3 = new String[]{"rm", "uninstall", "un"};
                yield var1_3;
            }
            case 4 -> {
                String[] var1_4 = new String[]{"remove", "r"};
                yield var1_4;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String[] getRequiredAddNames(PackageManager packageManager) {
        return switch (WhenMappings.$EnumSwitchMapping$0[packageManager.ordinal()]) {
            case 1, 2, 3 -> {
                String[] var1_1 = new String[]{"add"};
                yield var1_1;
            }
            case 4 -> {
                String[] var1_2 = new String[]{"add", "a"};
                yield var1_2;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String[] getOptionalAddNames(PackageManager packageManager) {
        return switch (WhenMappings.$EnumSwitchMapping$0[packageManager.ordinal()]) {
            case 1, 2, 4 -> {
                String[] var1_1 = new String[]{"install", "i"};
                yield var1_1;
            }
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final List<String> findDeclaredPackages(ShellRuntimeContext context2) {
        VirtualFile virtualFile = NpmShellCommandSpecsProviderKt.findPackageJson(context2);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile packageJson = virtualFile;
        Set<String> set = PackageJsonData.getOrCreate(packageJson).getAllDependencies();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAllDependencies(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    private static final VirtualFile findPackageJson(ShellRuntimeContext context2) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(context2.getCurrentDirectory());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile dir = virtualFile;
        return PackageJsonUtil.findChildPackageJsonFile(dir);
    }

    private static final List<NpmScript> findNpmScripts(ShellRuntimeContext context2) {
        VirtualFile virtualFile = NpmShellCommandSpecsProviderKt.findPackageJson(context2);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile packageJson = virtualFile;
        List<NpmScript> list = NpmScriptsUtil.listTasks(ShellRuntimeContextExtensionsKt.getProject((ShellRuntimeContext)context2), packageJson).getScripts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getScripts(...)");
        return list;
    }

    private static final List<String> suggestPackagesToInstall(ShellRuntimeContext context2) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(context2.getCurrentDirectory());
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile directory = virtualFile;
        Set alreadyDeclaredPackages = CollectionsKt.toSet((Iterable)NpmShellCommandSpecsProviderKt.findDeclaredPackages(context2));
        List<String> result2 = Collections.synchronizedList(new ArrayList());
        PackageJsonCompletionUtil.searchPackagesByPrefix(ShellRuntimeContextExtensionsKt.getProject((ShellRuntimeContext)context2), directory, context2.getTypedPrefix(), ((CharSequence)context2.getTypedPrefix()).length() == 0 ? 20 : 10, arg_0 -> NpmShellCommandSpecsProviderKt.suggestPackagesToInstall$lambda$0(alreadyDeclaredPackages, arg_0), arg_0 -> NpmShellCommandSpecsProviderKt.suggestPackagesToInstall$lambda$1(result2, arg_0));
        Intrinsics.checkNotNull(result2);
        return result2;
    }

    private static final boolean suggestPackagesToInstall$lambda$0(Set $alreadyDeclaredPackages, NodePackageBasicInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$alreadyDeclaredPackages.contains(it.getName());
    }

    private static final void suggestPackagesToInstall$lambda$1(List $result, NodePackageBasicInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $result.add(it.getName());
    }

    public static final /* synthetic */ List access$suggestPackagesToInstall(ShellRuntimeContext context2) {
        return NpmShellCommandSpecsProviderKt.suggestPackagesToInstall(context2);
    }

    public static final /* synthetic */ String[] access$getRunNames(PackageManager packageManager) {
        return NpmShellCommandSpecsProviderKt.getRunNames(packageManager);
    }

    public static final /* synthetic */ String[] access$getRemoveNames(PackageManager packageManager) {
        return NpmShellCommandSpecsProviderKt.getRemoveNames(packageManager);
    }

    public static final /* synthetic */ String[] access$getRequiredAddNames(PackageManager packageManager) {
        return NpmShellCommandSpecsProviderKt.getRequiredAddNames(packageManager);
    }

    public static final /* synthetic */ String[] access$getOptionalAddNames(PackageManager packageManager) {
        return NpmShellCommandSpecsProviderKt.getOptionalAddNames(packageManager);
    }

    public static final /* synthetic */ List access$findNpmScripts(ShellRuntimeContext context2) {
        return NpmShellCommandSpecsProviderKt.findNpmScripts(context2);
    }

    public static final /* synthetic */ List access$findDeclaredPackages(ShellRuntimeContext context2) {
        return NpmShellCommandSpecsProviderKt.findDeclaredPackages(context2);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PackageManager.values().length];
            try {
                nArray[PackageManager.NPM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PackageManager.PNPM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PackageManager.YARN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PackageManager.BUN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

