/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.javascript.advancedSettings.JSAdvancedSettingsKt;
import com.intellij.javascript.advancedSettings.JSSemanticHighlightingAccuracy;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandler;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.highlighting.JSHighlightDescriptor;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JavaScriptHighlightDescriptor;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlightDescriptor;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSemanticHighlightingVisitor
extends JSElementVisitor {
    public static final ThreadLocal<Boolean> IS_FROM_SEMANTIC_HIGHLIGHTING = ThreadLocal.withInitial(() -> false);
    private static final Set<String> PREDEFINED_LOCAL_VARS = ContainerUtil.newHashSet((Object[])new String[]{"exports", "require", "module", "__filename", "__dirname"});
    @NotNull
    private final JSHighlighter highlighter;
    @NotNull
    private final AnnotationHolder holder;
    private static final boolean debug = ApplicationManager.getApplication().isUnitTestMode();

    public JSSemanticHighlightingVisitor(@NotNull JSHighlighter highlighter, @NotNull AnnotationHolder holder) {
        if (highlighter == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(1);
        }
        this.highlighter = highlighter;
        this.holder = holder;
    }

    public void visitElement(@NotNull PsiElement element) {
        IElementType elementType;
        if (element == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(2);
        }
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(elementType = element.getNode().getElementType())) {
            JSNamedElement namedElement;
            PsiElement parent = element.getParent();
            if (parent instanceof JSReferenceExpression) {
                JSReferenceExpression reference = (JSReferenceExpression)parent;
                this.highlightReference(reference, element);
            }
            if ((namedElement = JSPsiImplUtils.findElementFromNameIdentifier(element)) instanceof JSVariable) {
                this.highlightVariable((JSVariable)namedElement);
            } else if (namedElement instanceof JSProperty) {
                this.highlightProperty((JSProperty)namedElement);
            } else if (namedElement instanceof JSDestructuringProperty) {
                this.highlightDestructuringProperty((JSDestructuringProperty)((Object)namedElement));
            }
            if (namedElement instanceof JSFunction) {
                IElementType namedElementType = namedElement.getNode().getElementType();
                if (JSElementTypes.FUNCTION_DECLARATIONS.contains(namedElementType)) {
                    this.highlight((PsiElement)namedElement, (PsiElement)namedElement);
                }
            } else if (namedElement instanceof TypeScriptModule && !(parent instanceof JSReferenceExpression)) {
                this.highlightModule((TypeScriptModule)namedElement, element);
            } else if (namedElement instanceof JSClass) {
                this.highlightClass((JSClass)namedElement, element);
            }
        }
    }

    private static boolean isClassContext(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement context2 = element.getContext();
        if (context2 instanceof JSClass) {
            return true;
        }
        return context2 instanceof JSFile && context2.getContext() != null;
    }

    private static boolean isTypeScriptInterfaceReference(PsiElement element) {
        return element instanceof TypeScriptObjectType && JSSemanticHighlightingVisitor.isClassContext(element);
    }

    private void highlightReference(JSPsiReferenceElement node, @Nullable PsiElement identifierToHighlight) {
        if (identifierToHighlight == null) {
            return;
        }
        try {
            IS_FROM_SEMANTIC_HIGHLIGHTING.set(true);
            this.doHighlightReference(node, identifierToHighlight);
        }
        finally {
            IS_FROM_SEMANTIC_HIGHLIGHTING.set(false);
        }
    }

    private void doHighlightReference(JSPsiReferenceElement node, @NotNull PsiElement identifierToHighlight) {
        JSHighlightDescriptor info;
        ResolveResult[] results;
        if (identifierToHighlight == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(3);
        }
        if (!JSSemanticHighlightingVisitor.isAcceptableReferenceForHighlighting(node)) {
            return;
        }
        if (JSAdvancedSettingsKt.getHighlightingAccuracy().getLevel() >= JSSemanticHighlightingAccuracy.Basic.getLevel()) {
            results = node.multiResolve(false);
        } else {
            PsiElement localResolved = JSStubBasedPsiTreeUtil.resolveReferenceLocally(node, node.getReferenceName());
            if (localResolved != null) {
                ResolveResult[] resolveResultArray = new ResolveResult[1];
                v1 = resolveResultArray;
                resolveResultArray[0] = new JSResolveResult(localResolved);
            } else {
                v1 = results = ResolveResult.EMPTY_ARRAY;
            }
        }
        if (results.length == 0) {
            return;
        }
        if (JSResolveResult.isTooManyCandidatesResult(results) && node instanceof JSReferenceExpression) {
            JSHighlightDescriptor descriptor = JSSemanticHighlightingVisitor.guessHighlightingForReference((JSReferenceExpression)node);
            JSSemanticHighlightingVisitor.lineMarker((PsiElement)node, identifierToHighlight, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName(), this.holder);
            return;
        }
        if (JSSemanticHighlightingVisitor.isGlobalUndefined(node)) {
            this.holder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY).textAttributes(this.highlighter.getMappedKey(JSHighlighter.JS_KEYWORD)).create();
            return;
        }
        if (this.isActionScriptClass(results) && (info = JSSemanticHighlightingVisitor.buildHighlightForResolveResult(Objects.requireNonNull(results[0].getElement()), (PsiElement)node)) != null) {
            JSPsiReferenceElement jSPsiReferenceElement;
            ASTNode genericSignature = node.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
            JSPsiReferenceElement jSPsiReferenceElement2 = jSPsiReferenceElement = genericSignature == null ? node : node.getReferenceNameElement();
            if (jSPsiReferenceElement != null) {
                JSSemanticHighlightingVisitor.createBuilderForHighlight(this.holder, info.getDebugName()).range(identifierToHighlight).textAttributes(info.getAttributesKey(this.highlighter)).create();
                return;
            }
        }
        Object2IntOpenHashMap countByTypes = new Object2IntOpenHashMap();
        boolean tsdOccurred = false;
        for (ResolveResult r : results) {
            JSHighlightDescriptor descriptor;
            PsiElement resolve2 = r.getElement();
            if (resolve2 == null) continue;
            PsiFile file = resolve2.getContainingFile();
            boolean isFromTsd = TypeScriptUtil.isDefinitionFile(file);
            if (isFromTsd && !tsdOccurred) {
                tsdOccurred = true;
                countByTypes = new Object2IntOpenHashMap();
            }
            if (tsdOccurred && !isFromTsd || (descriptor = JSSemanticHighlightingVisitor.buildHighlightForResolveResult(resolve2, (PsiElement)node)) == null) continue;
            countByTypes.put((Object)descriptor, countByTypes.getInt((Object)descriptor) + 1);
        }
        IntRef intRef = new IntRef(0);
        JSHighlightDescriptor descriptor = null;
        for (Object2IntMap.Entry entry : countByTypes.object2IntEntrySet()) {
            JSHighlightDescriptor key = (JSHighlightDescriptor)entry.getKey();
            int count = entry.getIntValue();
            if (count > intRef.get()) {
                intRef.set(count);
                descriptor = key;
                continue;
            }
            if (count != intRef.get() || descriptor == null || descriptor.getDebugName().compareTo(key.getDebugName()) <= 0) continue;
            descriptor = key;
        }
        if (descriptor != null) {
            JSSemanticHighlightingVisitor.lineMarker((PsiElement)node, identifierToHighlight, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName(), this.holder);
        }
    }

    private static boolean isAcceptableReferenceForHighlighting(JSPsiReferenceElement node) {
        if (!(node instanceof JSReferenceExpression)) {
            return true;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)node;
        PsiElement parent = node.getParent();
        if (parent instanceof ES6Decorator || parent instanceof JSCallExpression && parent.getParent() instanceof ES6Decorator) {
            return false;
        }
        if (referenceExpression.getQualifier() != null) {
            return true;
        }
        return node.getNode().findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter) == null || !JSResolveUtil.isExprInTypeContext(referenceExpression);
    }

    private static boolean isGlobalUndefined(@NotNull JSPsiReferenceElement node) {
        if (node == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(4);
        }
        return "undefined".equals(node.getReferenceName()) && node instanceof JSQualifiedExpression && ((JSQualifiedExpression)((Object)node)).getQualifier() == null;
    }

    private boolean isActionScriptClass(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(5);
        }
        return results.length == 1 && this.highlighter.getDialectOptionsHolder() == DialectOptionHolder.ECMA_4 && results[0].getElement() instanceof JSClass;
    }

    @NotNull
    private static JSHighlightDescriptor guessHighlightingForReference(@NotNull JSReferenceExpression referenceExpression) {
        boolean isGlobal;
        PsiElement parent;
        if (referenceExpression == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(6);
        }
        boolean isMethod = (parent = referenceExpression.getParent()) instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == referenceExpression;
        boolean bl = isGlobal = referenceExpression.getQualifier() == null;
        if (isMethod) {
            JavaScriptHighlightDescriptor javaScriptHighlightDescriptor = isGlobal ? JavaScriptHighlightDescriptor.GLOBAL_FUNCTION : JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION;
            if (javaScriptHighlightDescriptor == null) {
                JSSemanticHighlightingVisitor.$$$reportNull$$$0(7);
            }
            return javaScriptHighlightDescriptor;
        }
        JavaScriptHighlightDescriptor javaScriptHighlightDescriptor = isGlobal ? JavaScriptHighlightDescriptor.GLOBAL_VARIABLE : JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE;
        if (javaScriptHighlightDescriptor == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(8);
        }
        return javaScriptHighlightDescriptor;
    }

    private void highlight(@NotNull PsiElement place, @NotNull PsiElement resolve2) {
        JSHighlightDescriptor descriptor;
        if (place == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(9);
        }
        if (resolve2 == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(10);
        }
        if ((descriptor = JSSemanticHighlightingVisitor.buildHighlightForResolveResult(resolve2, place)) != null) {
            JSSemanticHighlightingVisitor.lineMarker(place, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName(), this.holder);
        }
    }

    @Nullable
    public static JSHighlightDescriptor buildHighlightForResolveResult(@NotNull PsiElement resolve2, @NotNull PsiElement place) {
        PsiElement targetElement;
        JSHighlightDescriptor targetElementInfo;
        if (resolve2 == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(11);
        }
        if (place == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(12);
        }
        return (targetElementInfo = JSSemanticHighlightingVisitor.buildHighlightForElement(targetElement = JSSemanticHighlightingVisitor.calculateMeaningfulElementForHighlighting(resolve2), place)) != null ? targetElementInfo : JSSemanticHighlightingVisitor.buildHighlightForElement(resolve2, place);
    }

    private static JSHighlightDescriptor buildHighlightForElement(@NotNull PsiElement resolve2, @NotNull PsiElement place) {
        if (resolve2 == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(13);
        }
        if (place == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(14);
        }
        List handlers = JSFrameworkSpecificHandler.EP_NAME.allForLanguageOrAny(resolve2.getLanguage());
        for (JSFrameworkSpecificHandler handler : handlers) {
            JSHighlightDescriptor descriptor = handler.buildHighlightForElement(resolve2, place);
            if (descriptor == null) continue;
            return descriptor;
        }
        JSSemanticHighlightingBuilder builder2 = new JSSemanticHighlightingBuilder();
        if (resolve2 instanceof JSImplicitElement) {
            PsiElement provider;
            JSImplicitElement.Type kind;
            JSImplicitElement implicitElement = (JSImplicitElement)resolve2;
            if (implicitElement instanceof JSLocalImplicitElementImpl && (kind = ((JSLocalImplicitElementImpl)implicitElement).getExplicitKind()) == null && (provider = implicitElement.getParent()) != null && !(provider instanceof JSImplicitElement)) {
                return JSSemanticHighlightingVisitor.buildHighlightForElement(provider, place);
            }
            JSImplicitElement.Type type2 = implicitElement.getType();
            switch (type2) {
                case Class: {
                    return JSSemanticHighlightingVisitor.buildHighlightForClass(resolve2, false);
                }
                case Interface: {
                    return JSSemanticHighlightingVisitor.buildHighlightForClass(resolve2, true);
                }
                case Function: {
                    builder2.isFunction = true;
                    builder2.isProperty = implicitElement.getNamespace() != null;
                    builder2.isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                    break;
                }
                case Method: {
                    builder2.isFunction = true;
                    builder2.isProperty = true;
                    builder2.isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                    break;
                }
                case Namespace: {
                    return JavaScriptHighlightDescriptor.GLOBAL_VARIABLE;
                }
                case Variable: {
                    if (implicitElement.getNamespace() == null && implicitElement.isNamespaceExplicitlyDeclared()) {
                        return JavaScriptHighlightDescriptor.GLOBAL_VARIABLE;
                    }
                }
                case Property: 
                case Tag: {
                    builder2.isProperty = true;
                    builder2.isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                }
            }
        } else {
            JSParameter parameter;
            if (resolve2 instanceof JSClass) {
                if (resolve2 instanceof TypeScriptTypeAlias) {
                    return JavaScriptHighlightDescriptor.TYPE_ALIAS;
                }
                if (resolve2 instanceof TypeScriptEnum) {
                    return TypeScriptHighlightDescriptor.ENUM;
                }
                return JSSemanticHighlightingVisitor.buildHighlightForClass(resolve2, ((JSClass)resolve2).isInterface());
            }
            if (resolve2 instanceof TypeScriptModule) {
                return TypeScriptHighlightDescriptor.MODULE_NAME;
            }
            if (resolve2 instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter(parameter = (JSParameter)resolve2) || JSSemanticHighlightingVisitor.isArgumentsVariable(resolve2)) {
                JSParameter parameter2;
                if (resolve2 instanceof JSParameter && TypeScriptPsiUtil.isThisParameter(parameter2 = (JSParameter)resolve2)) {
                    return null;
                }
                return JavaScriptHighlightDescriptor.PARAMETER;
            }
            if (resolve2 instanceof TypeScriptEnumField) {
                return TypeScriptHighlightDescriptor.ENUM_MEMBER;
            }
            if (resolve2 instanceof JSFieldVariable) {
                JSFieldVariable fieldVariable = (JSFieldVariable)resolve2;
                JSSemanticHighlightingVisitor.buildHighlightForVariable(place, fieldVariable, builder2);
            } else {
                if (resolve2 instanceof TypeScriptGenericOrMappedTypeParameter) {
                    return TypeScriptHighlightDescriptor.TYPE_PARAMETER;
                }
                if (resolve2 instanceof JSAttributeListOwner) {
                    JSAttributeList attributeList = ((JSAttributeListOwner)resolve2).getAttributeList();
                    if (attributeList != null) {
                        builder2.isStatic = attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                    }
                    DialectOptionHolder dialect = DialectDetector.dialectOfElement(resolve2);
                    boolean bl = builder2.isFunction = resolve2 instanceof JSFunction && (!((JSFunction)resolve2).isConstructor() || dialect != null && dialect.isJavaScript());
                    if (builder2.isFunction) {
                        boolean bl2 = builder2.isProperty = JSSemanticHighlightingVisitor.isClassContext(resolve2) || JSSemanticHighlightingVisitor.isTypeScriptInterfaceReference(resolve2.getContext());
                    }
                    if (JSResolveUtil.isConstructorFunction(resolve2)) {
                        if (place == resolve2 && "constructor".equals(((JSAttributeListOwner)resolve2).getName())) {
                            return JavaScriptHighlightDescriptor.KEYWORD;
                        }
                        PsiElement context2 = resolve2.getContext();
                        return JSSemanticHighlightingVisitor.buildHighlightForClass(context2 instanceof JSClass ? context2 : resolve2, false);
                    }
                }
            }
        }
        if (place instanceof JSProperty) {
            builder2.isProperty = true;
        }
        if (!builder2.isProperty && resolve2 instanceof JSElementBase) {
            boolean bl = builder2.isProperty = resolve2 instanceof JSProperty || resolve2 instanceof JSDefinitionExpression || resolve2 instanceof JSField || ((JSElementBase)resolve2).getJSNamespace().hasQualifiedName();
        }
        if (resolve2 instanceof JSInitializerOwner) {
            JSSemanticHighlightingVisitor.buildHighlightForInitializerOwner((JSInitializerOwner)resolve2, place, builder2);
        }
        builder2.isExported = JSSemanticHighlightingVisitor.isExported(resolve2);
        if (!builder2.isFunction && resolve2 instanceof JSTypeOwner) {
            JSTypeOwner typeOwner = (JSTypeOwner)resolve2;
            builder2.isFunction = JSSemanticHighlightingVisitor.hasDeclaredFunctionType(typeOwner);
        }
        return builder2.toDescriptor(resolve2);
    }

    private static boolean hasDeclaredFunctionType(@NotNull JSTypeOwner typeOwner) {
        JSTypeDeclarationOwner typeDeclarationOwner;
        if (typeOwner == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(15);
        }
        if (typeOwner instanceof JSTypeDeclarationOwner && DialectDetector.isTypeScript((PsiElement)(typeDeclarationOwner = (JSTypeDeclarationOwner)typeOwner))) {
            return typeDeclarationOwner.getTypeElement() instanceof TypeScriptFunctionType;
        }
        return typeOwner.getJSType() instanceof JSFunctionType;
    }

    private static void buildHighlightForVariable(@NotNull PsiElement place, @NotNull JSFieldVariable resolve2, @NotNull JSSemanticHighlightingBuilder builder2) {
        JSParameter parameter;
        boolean resolveAllowed;
        Collection<JSFunctionWithSubstitutor> items;
        if (place == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(16);
        }
        if (resolve2 == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(17);
        }
        if (builder2 == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(18);
        }
        if (!(items = JSStubBasedPsiTreeUtil.calculatePossibleFunctions((PsiElement)resolve2, place, null, true, !(resolveAllowed = JSAdvancedSettingsKt.getHighlightingAccuracy().getLevel() >= JSSemanticHighlightingAccuracy.High.getLevel()))).isEmpty()) {
            JSFunctionItem item = ((JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(items)).myFunctionItem;
            builder2.isFunction = true;
            if (item instanceof JSField || item instanceof JSProperty || item.getContext() instanceof JSProperty) {
                builder2.isProperty = true;
                if (item instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)((Object)item), JSAttributeList.ModifierType.STATIC)) {
                    builder2.isStatic = true;
                }
            }
        } else if (JSPsiImplUtils.getRightmostInitializer(resolve2) instanceof JSFunctionItem) {
            builder2.isFunction = true;
        } else if (JSSemanticHighlightingVisitor.isClassContext(resolve2.getContext()) || resolve2.getNamespace() != null || resolve2 instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter(parameter = (JSParameter)resolve2)) {
            builder2.isProperty = true;
            builder2.isStatic = resolve2.getJSContext() == JSContext.STATIC;
        } else if (JSSemanticHighlightingVisitor.isLocalVariable(resolve2, place)) {
            builder2.isLocal = true;
        } else {
            builder2.isGlobal = true;
        }
    }

    @NotNull
    private static JSHighlightDescriptor buildHighlightForClass(@NotNull PsiElement resolve2, boolean isInterface) {
        if (resolve2 == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(19);
        }
        if (!isInterface && JSSemanticHighlightingVisitor.isExported(resolve2)) {
            JavaScriptHighlightDescriptor javaScriptHighlightDescriptor = JavaScriptHighlightDescriptor.EXPORTED_CLASS;
            if (javaScriptHighlightDescriptor == null) {
                JSSemanticHighlightingVisitor.$$$reportNull$$$0(20);
            }
            return javaScriptHighlightDescriptor;
        }
        JavaScriptHighlightDescriptor javaScriptHighlightDescriptor = isInterface ? JavaScriptHighlightDescriptor.INTERFACE : JavaScriptHighlightDescriptor.CLASS;
        if (javaScriptHighlightDescriptor == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(21);
        }
        return javaScriptHighlightDescriptor;
    }

    public static boolean isArgumentsVariable(@NotNull PsiElement element) {
        JSType type2;
        if (element == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(22);
        }
        return element instanceof ImplicitJSVariableImpl && JSNamedType.isNamedTypeWithName(type2 = ((ImplicitJSVariableImpl)element).getJSType(), "IArguments");
    }

    public static boolean isLocalVariable(@NotNull JSFieldVariable element, @NotNull PsiElement place) {
        PsiElement node;
        if (element == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(23);
        }
        if (place == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(24);
        }
        return (node = JSUseScopeProvider.getUseScopeElement(element)) != null && (!(node instanceof JSFile) || !DialectDetector.isActionScript(node)) || JSSemanticHighlightingVisitor.isPredefinedLocalVariable((PsiElement)element, place) || JSSemanticHighlightingVisitor.isFromEmbeddedModule((PsiElement)element);
    }

    private static boolean isFromEmbeddedModule(@NotNull PsiElement element) {
        if (element == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(25);
        }
        PsiElement node = JSUseScopeProvider.getLexicalScopeOrFile(element);
        return ES6PsiUtil.isEmbeddedModule(node);
    }

    private static boolean isPredefinedLocalVariable(@NotNull PsiElement resolvedElement, @NotNull PsiElement place) {
        JSReferenceExpression ref2;
        if (resolvedElement == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(26);
        }
        if (place == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(27);
        }
        if ((ref2 = (JSReferenceExpression)ObjectUtils.tryCast((Object)place, JSReferenceExpression.class)) != null && PREDEFINED_LOCAL_VARS.contains(ref2.getReferenceName())) {
            VirtualFile file = resolvedElement.getContainingFile().getViewProvider().getVirtualFile();
            String path2 = file.getPath();
            return path2.endsWith("/@types/node/index.d.ts") || path2.endsWith("/@types/node/globals.d.ts");
        }
        return false;
    }

    public static void lineMarker(@NotNull PsiElement element, TextAttributesKey attrKey, @NotNull String debugName, AnnotationHolder holder) {
        PsiElement markedNode;
        if (element == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(28);
        }
        if (debugName == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(29);
        }
        if ((markedNode = JSSemanticHighlightingVisitor.findLeafToHighlight(element)) == null) {
            return;
        }
        JSSemanticHighlightingVisitor.lineMarker(element, markedNode, attrKey, debugName, holder);
    }

    private static void lineMarker(@NotNull PsiElement element, @NotNull PsiElement identifierToHighlight, TextAttributesKey attrKey, @NotNull String debugName, AnnotationHolder holder) {
        if (element == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(30);
        }
        if (identifierToHighlight == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(31);
        }
        if (debugName == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(32);
        }
        if (attrKey == null) {
            return;
        }
        AnnotationBuilder builder2 = JSSemanticHighlightingVisitor.createBuilderForHighlight(holder, debugName);
        builder2.range(identifierToHighlight).textAttributes(attrKey).create();
    }

    @Nullable
    private static PsiElement findLeafToHighlight(@NotNull PsiElement element) {
        PsiElement markedNode;
        if (element == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(33);
        }
        if ((markedNode = element.getLastChild()) == null) {
            markedNode = element;
        }
        while (markedNode.getNode().getElementType() != JSTokenTypes.IDENTIFIER && markedNode.getNode().getElementType() != JSTokenTypes.PRIVATE_IDENTIFIER && !(markedNode instanceof ES6ComputedName) && markedNode.getPrevSibling() != null) {
            markedNode = markedNode.getPrevSibling();
        }
        if (element instanceof JSAttribute) {
            markedNode = element;
        } else if (element instanceof JSNamedElement) {
            PsiElement nameElement = ((JSNamedElement)element).getNameIdentifier();
            if (nameElement != null) {
                markedNode = nameElement;
            } else if (element instanceof JSProperty) {
                markedNode = null;
            }
        }
        return markedNode;
    }

    @NotNull
    private static AnnotationBuilder createBuilderForHighlight(@NotNull AnnotationHolder holder, @NotNull String debugName) {
        if (holder == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(34);
        }
        if (debugName == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(35);
        }
        AnnotationBuilder annotationBuilder = debug ? holder.newAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY, debugName) : holder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY);
        if (annotationBuilder == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(36);
        }
        return annotationBuilder;
    }

    public static HighlightInfo justLineMarker(PsiElement markedNode, TextAttributesKey attrKey, @Nullable String debugName) {
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(markedNode).textAttributes(attrKey);
        if (debug && debugName != null) {
            builder2.descriptionAndTooltip(debugName);
        }
        return builder2.create();
    }

    private void highlightProperty(@NotNull JSProperty node) {
        boolean isStatic;
        if (node == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(37);
        }
        if (node.isShorthanded()) {
            return;
        }
        if (node instanceof JSFunction) {
            return;
        }
        JSHighlightDescriptor resolveResultDescriptor = JSSemanticHighlightingVisitor.buildHighlightForResolveResult((PsiElement)node, (PsiElement)node);
        boolean isFunction = resolveResultDescriptor != null && JSSemanticHighlightingVisitor.isFunctionDescriptor(resolveResultDescriptor);
        boolean bl = isStatic = resolveResultDescriptor == JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION || resolveResultDescriptor == JavaScriptHighlightDescriptor.STATIC_MEMBER_VARIABLE;
        JavaScriptHighlightDescriptor descriptor = isStatic ? (isFunction ? JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION : JavaScriptHighlightDescriptor.STATIC_MEMBER_VARIABLE) : (isFunction ? JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION : JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE);
        JSSemanticHighlightingVisitor.lineMarker((PsiElement)node, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName(), this.holder);
    }

    private static boolean isFunctionDescriptor(@NotNull JSHighlightDescriptor descriptor) {
        if (descriptor == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(38);
        }
        if (descriptor instanceof JavaScriptHighlightDescriptor) {
            return switch ((JavaScriptHighlightDescriptor)descriptor) {
                case JavaScriptHighlightDescriptor.GLOBAL_FUNCTION, JavaScriptHighlightDescriptor.EXPORTED_FUNCTION, JavaScriptHighlightDescriptor.LOCAL_FUNCTION, JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION, JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION -> true;
                default -> false;
            };
        }
        return false;
    }

    private void highlightDestructuringProperty(JSDestructuringProperty node) {
        if (node instanceof JSDestructuringShorthandedProperty || node.isRest()) {
            return;
        }
        JavaScriptHighlightDescriptor descriptor = JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE;
        JSSemanticHighlightingVisitor.lineMarker((PsiElement)node, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName(), this.holder);
    }

    private static void buildHighlightForInitializerOwner(@NotNull JSInitializerOwner node, @Nullable PsiElement place, @NotNull JSSemanticHighlightingBuilder builder2) {
        boolean resolveAllowed;
        JSExpression initializer;
        if (node == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(39);
        }
        if (builder2 == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(40);
        }
        if ((initializer = node.getInitializerOrStub()) instanceof JSClass) {
            builder2.isClass = true;
        } else if (!builder2.isFunction && JSStubBasedPsiTreeUtil.calculatePossibleFunctions((PsiElement)node, place, null, true, !(resolveAllowed = JSAdvancedSettingsKt.getHighlightingAccuracy().getLevel() >= JSSemanticHighlightingAccuracy.Normal.getLevel())).size() == 1) {
            builder2.isFunction = true;
        }
    }

    private void highlightVariable(JSVariable node) {
        PsiElement nameIdentifier;
        if (!(node instanceof JSParameter) && ((nameIdentifier = node.getNameIdentifier()) == null || nameIdentifier instanceof JSReferenceExpression)) {
            return;
        }
        JSHighlightDescriptor descriptor = JSSemanticHighlightingVisitor.buildHighlightForResolveResult((PsiElement)node, (PsiElement)node);
        if (descriptor != null) {
            JSSemanticHighlightingVisitor.lineMarker((PsiElement)node, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName(), this.holder);
        }
    }

    @Override
    public void visitTypeScriptPropertySignature(@NotNull TypeScriptPropertySignature signature) {
        if (signature == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(41);
        }
        JSSemanticHighlightingVisitor.lineMarker(signature, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript property signature", this.holder);
    }

    @Override
    public void visitTypeScriptFunctionSignature(@NotNull TypeScriptFunctionSignature signature) {
        if (signature == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(42);
        }
        JSSemanticHighlightingVisitor.lineMarker(signature, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), "TypeScript function signature", this.holder);
    }

    @Override
    public void visitFunctionSignature(@NotNull JSFunctionSignature signature) {
        if (signature == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(43);
        }
        JSSemanticHighlightingVisitor.lineMarker(signature, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), "function signature", this.holder);
    }

    public void highlightTypeParameter(TypeScriptGenericOrMappedTypeParameter parameter) {
        TypeScriptHighlightDescriptor descriptor = TypeScriptHighlightDescriptor.TYPE_PARAMETER;
        JSSemanticHighlightingVisitor.lineMarker((PsiElement)parameter, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName(), this.holder);
    }

    @Override
    public void visitTypeScriptIndexSignature(@NotNull TypeScriptIndexSignature signature) {
        PsiElement element;
        if (signature == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(44);
        }
        if ((element = signature.getParameterNameElement()) != null) {
            JSSemanticHighlightingVisitor.lineMarker(element, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript index signature", this.holder);
        }
    }

    private void highlightModule(@NotNull TypeScriptModule module, @NotNull PsiElement identifierToHighlight) {
        if (module == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(45);
        }
        if (identifierToHighlight == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(46);
        }
        TextAttributesKey attrKey = DialectDetector.isTypeScript(module) ? this.highlighter.getMappedKey(TypeScriptHighlighter.TS_MODULE_NAME) : this.highlighter.getMappedKey(JSHighlighter.JS_MODULE_NAME);
        JSSemanticHighlightingVisitor.lineMarker(module, identifierToHighlight, attrKey, "moduleName", this.holder);
    }

    @Override
    public void visitES6MetaProperty(@NotNull Es6MetaProperty property) {
        PsiElement nameIdentifier;
        if (property == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(47);
        }
        if ((nameIdentifier = property.getNameIdentifier()) != null) {
            JSSemanticHighlightingVisitor.lineMarker(nameIdentifier, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "meta property", this.holder);
        }
    }

    private void highlightClass(@NotNull JSClass jsClass, @NotNull PsiElement identifierToHighlight) {
        if (jsClass == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(48);
        }
        if (identifierToHighlight == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(49);
        }
        if ("CoffeeScriptClassImpl".equals(jsClass.getClass().getSimpleName())) {
            return;
        }
        JSHighlightDescriptor descriptor = JSSemanticHighlightingVisitor.buildHighlightForElement(jsClass, jsClass);
        if (descriptor != null) {
            JSSemanticHighlightingVisitor.lineMarker(jsClass, identifierToHighlight, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName(), this.holder);
        }
    }

    @NotNull
    private static PsiElement calculateMeaningfulElementForHighlighting(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(50);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                JSSemanticHighlightingVisitor.$$$reportNull$$$0(51);
            }
            return psiElement;
        }
        VirtualFile file = psiFile.getVirtualFile();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        PsiElement psiElement = file != null && (index.isInContent(file) || index.isInLibrarySource(file)) ? JSStubBasedPsiTreeUtil.calculateTargetElementForHighlighting(element) : element;
        if (psiElement == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(52);
        }
        return psiElement;
    }

    private static boolean isExported(@NotNull PsiElement element) {
        List<? extends PsiElement> exportedElements;
        if (element == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(53);
        }
        if (ES6ImportHandler.isExportedWithNameOrDefaultOrAssignment(element)) {
            return true;
        }
        if (!(element instanceof JSElementBase)) {
            return false;
        }
        JSElementBase namedElement = (JSElementBase)element;
        if (CommonJSUtil.isExportNamespace(namedElement.getNamespace()) || CommonJSUtil.isModuleExportsAssigmentTarget(namedElement)) {
            return true;
        }
        if (namedElement.getJSNamespace().getQualifiedName() != null || !namedElement.getJSNamespace().isSourceStrict()) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof JSFile && (((JSFile)file).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.COMMONJS || ((JSFile)file).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS) && (exportedElements = JSResolveUtil.getExportedElements((JSFile)file)).size() == 1) {
            PsiElement exportedElement = (PsiElement)ContainerUtil.getFirstItem(exportedElements);
            return JSSemanticHighlightingVisitor.calculateMeaningfulElementForHighlighting(exportedElement) == element;
        }
        return false;
    }

    @Override
    public void visitImportSpecifier(@NotNull ES6ImportSpecifier node) {
        if (node == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(54);
        }
        this.highlightReference(node, node.getReferenceNameElement());
    }

    @Override
    public void visitES6ExportSpecifier(@NotNull ES6ExportSpecifier node) {
        if (node == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(55);
        }
        this.highlightReference(node, node.getReferenceNameElement());
    }

    @Override
    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        PsiElement ownNameIdentifier;
        if (node == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(56);
        }
        if ((ownNameIdentifier = node.getOwnNameIdentifier()) != null) {
            this.highlight(ownNameIdentifier, node);
        }
    }

    @Override
    public void visitJSFunctionProperty(@NotNull JSFunctionProperty functionProperty) {
        if (functionProperty == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(57);
        }
        this.highlight(functionProperty, functionProperty);
    }

    @Override
    public void visitES6ImportedBinding(@NotNull ES6ImportedBinding importedBinding) {
        Collection<PsiElement> referencedElements;
        PsiElement resolveResult;
        if (importedBinding == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(58);
        }
        if ((resolveResult = (PsiElement)ContainerUtil.getFirstItem(referencedElements = importedBinding.findReferencedElements())) != null) {
            resolveResult = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult);
            this.highlight((PsiElement)importedBinding, resolveResult);
        }
    }

    @Override
    public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
        PsiElement identifier;
        if (importStatement == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(59);
        }
        if ((identifier = importStatement.getNameIdentifier()) != null) {
            PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)importStatement);
            this.highlight(identifier, meaningfulElement);
        }
    }

    @Override
    public void visitTypeScriptEntityName(@NotNull TypeScriptEntityName entityName) {
        if (entityName == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(60);
        }
    }

    @Override
    public void visitTypeScriptTypeParameter(@NotNull TypeScriptTypeParameter typeParameter) {
        if (typeParameter == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(61);
        }
        this.highlightTypeParameter(typeParameter);
    }

    @Override
    public void visitTypeScriptInferType(@NotNull TypeScriptInferType inferType) {
        if (inferType == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(62);
        }
        this.highlightTypeParameter(inferType);
    }

    @Override
    public void visitTypeScriptMappedTypeParameter(@NotNull TypeScriptMappedTypeParameter typeParameter) {
        if (typeParameter == null) {
            JSSemanticHighlightingVisitor.$$$reportNull$$$0(63);
        }
        this.highlightTypeParameter(typeParameter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 20, 21, 36, 51, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 33: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 31: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierToHighlight";
                break;
            }
            case 4: 
            case 37: 
            case 39: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 36: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingVisitor";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOwner";
                break;
            }
            case 18: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionProperty";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedBinding";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityName";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingVisitor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "guessHighlightingForReference";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHighlightForClass";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderForHighlight";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMeaningfulElementForHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doHighlightReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalUndefined";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isActionScriptClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "guessHighlightingForReference";
                break;
            }
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 36: 
            case 51: 
            case 52: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForResolveResult";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclaredFunctionType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForVariable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isArgumentsVariable";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isLocalVariable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isFromEmbeddedModule";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedLocalVariable";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lineMarker";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findLeafToHighlight";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForHighlight";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "highlightProperty";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionDescriptor";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForInitializerOwner";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptPropertySignature";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptFunctionSignature";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitFunctionSignature";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptIndexSignature";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "highlightModule";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitES6MetaProperty";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "highlightClass";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElementForHighlighting";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isExported";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitImportSpecifier";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ExportSpecifier";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionExpression";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionProperty";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ImportedBinding";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptImportStatement";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptEntityName";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptTypeParameter";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptInferType";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptMappedTypeParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 20, 21, 36, 51, 52 -> new IllegalStateException(string);
        };
    }

    private static class JSSemanticHighlightingBuilder {
        boolean isStatic = false;
        boolean isFunction = false;
        boolean isExported = false;
        boolean isLocal = false;
        boolean isGlobal = false;
        boolean isClass = false;
        boolean isProperty = false;

        private JSSemanticHighlightingBuilder() {
        }

        @Nullable
        JSHighlightDescriptor toDescriptor(@NotNull PsiElement resolve2) {
            if (resolve2 == null) {
                JSSemanticHighlightingBuilder.$$$reportNull$$$0(0);
            }
            if (this.isExported) {
                return this.isFunction ? JavaScriptHighlightDescriptor.EXPORTED_FUNCTION : (this.isClass ? JavaScriptHighlightDescriptor.EXPORTED_CLASS : JavaScriptHighlightDescriptor.EXPORTED_VARIABLE);
            }
            if (this.isLocal) {
                return this.isFunction ? JavaScriptHighlightDescriptor.LOCAL_FUNCTION : JavaScriptHighlightDescriptor.LOCAL_VARIABLE;
            }
            if (this.isGlobal) {
                return this.isFunction ? JavaScriptHighlightDescriptor.GLOBAL_FUNCTION : JavaScriptHighlightDescriptor.GLOBAL_VARIABLE;
            }
            if (this.isProperty) {
                if (this.isFunction) {
                    return this.isStatic ? JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION : JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION;
                }
                return this.isStatic ? JavaScriptHighlightDescriptor.STATIC_MEMBER_VARIABLE : JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE;
            }
            if (this.isFunction) {
                return JSSemanticHighlightingVisitor.isExported(resolve2) ? JavaScriptHighlightDescriptor.EXPORTED_FUNCTION : (resolve2.getUseScope() instanceof LocalSearchScope || JSSemanticHighlightingVisitor.isFromEmbeddedModule(resolve2) ? JavaScriptHighlightDescriptor.LOCAL_FUNCTION : JavaScriptHighlightDescriptor.GLOBAL_FUNCTION);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingVisitor$JSSemanticHighlightingBuilder", "toDescriptor"));
        }
    }
}

