/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.destructuring.JSDestructuringIntentionBase;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSObjectLiteralIndexingToArrayDestructuringIntention
extends JSDestructuringIntentionBase {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSObjectLiteralIndexingToArrayDestructuringIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSObjectLiteralIndexingToArrayDestructuringIntention.$$$reportNull$$$0(1);
        }
        JSObjectLiteralExpression literal = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSObjectLiteralExpression.class, (boolean)false);
        assert (literal != null);
        class Data {
            JSExpression myExpression;
            List<JSProperty> myProperties;

            Data() {
            }
        }
        Data data2 = new Data();
        JSObjectLiteralIndexingToArrayDestructuringIntention.checkObjectLiteralForDestructuring(literal, (PairConsumer<JSExpression, List<JSProperty>>)((PairConsumer)(e, l) -> {
            data2.myExpression = e;
            data2.myProperties = l;
        }));
        DoubleArrayList indices = new DoubleArrayList();
        ArrayList<String> names = new ArrayList<String>();
        for (JSProperty initializer : data2.myProperties) {
            JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)initializer.getValue();
            assert (indexer != null);
            JSLiteralExpression expression = (JSLiteralExpression)indexer.getIndexExpression();
            assert (expression != null);
            double number = JSObjectLiteralIndexingToArrayDestructuringIntention.toDouble(expression);
            indices.add(number);
            names.add(initializer.getName());
        }
        StringBuilder destructuringString = new StringBuilder("let ");
        JSObjectLiteralIndexingToArrayDestructuringIntention.appendDestructuringArrayInitializer((DoubleList)indices, names, destructuringString);
        JSExpression qualifier = ((JSIndexedPropertyAccessExpression)data2.myExpression).getQualifier();
        assert (qualifier != null);
        JSStatement newStatement = JSPsiElementFactory.createJSStatement(String.valueOf(destructuringString) + " = " + qualifier.getText() + JSCodeStyleSettings.getSemicolon(element), element);
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)data2.myExpression, JSStatement.class);
        assert (statement != null);
        statement.addStatementBefore(newStatement);
        for (JSProperty property : data2.myProperties) {
            String name = property.getName();
            assert (name != null);
            property.replace(JSChangeUtil.createObjectLiteralPropertyFromText(name, (PsiElement)property));
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("refactoring.destructuring.vars.intention.replace.shorthand", new Object[0]);
        if (string == null) {
            JSObjectLiteralIndexingToArrayDestructuringIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSObjectLiteralIndexingToArrayDestructuringIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSObjectLiteralIndexingToArrayDestructuringIntention.$$$reportNull$$$0(4);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSObjectLiteralExpression literal = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSObjectLiteralExpression.class, (boolean)false);
        if (literal == null) {
            return false;
        }
        Ref found = Ref.create((Object)false);
        JSObjectLiteralIndexingToArrayDestructuringIntention.checkObjectLiteralForDestructuring(literal, (PairConsumer<JSExpression, List<JSProperty>>)((PairConsumer)(e, l) -> found.set((Object)true)));
        return (Boolean)found.get();
    }

    private static void checkObjectLiteralForDestructuring(JSObjectLiteralExpression element, PairConsumer<JSExpression, List<JSProperty>> consumer) {
        String nm;
        if (!DialectDetector.hasFeature((PsiElement)element, JSLanguageFeature.DESTRUCTURING_ASSIGNMENT)) {
            return;
        }
        String indexedExpressionString = null;
        ArrayList<JSProperty> allPropertiesInScope = new ArrayList<JSProperty>();
        for (JSProperty propertyDeclaration : element.getProperties()) {
            JSExpression value;
            JSExpression e2;
            if (propertyDeclaration.isGetProperty() || propertyDeclaration.isSetProperty() || propertyDeclaration.isShorthanded() || propertyDeclaration.getName() == null || (e2 = JSObjectLiteralIndexingToArrayDestructuringIntention.checkValidIndexerExpressionInValue(value = propertyDeclaration.getValue())) == null) continue;
            if (indexedExpressionString == null) {
                allPropertiesInScope.add(propertyDeclaration);
                indexedExpressionString = e2.getText();
                continue;
            }
            if (!indexedExpressionString.equals(e2.getText())) {
                JSObjectLiteralIndexingToArrayDestructuringIntention.checkIndexerAndEmitHint(allPropertiesInScope, consumer);
                return;
            }
            allPropertiesInScope.add(propertyDeclaration);
        }
        JSStatement ownerStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        if (ownerStatement != null && (nm = indexedExpressionString) != null && SyntaxTraverser.psiTraverser((PsiElement)ownerStatement).filter(JSReferenceExpression.class).filter(e -> !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)e, (boolean)true) && nm.equals(e.getReferenceName())).first() != null) {
            return;
        }
        JSObjectLiteralIndexingToArrayDestructuringIntention.checkIndexerAndEmitHint(allPropertiesInScope, consumer);
    }

    private static void checkIndexerAndEmitHint(List<JSProperty> allPropertiesInScope, PairConsumer<JSExpression, List<JSProperty>> consumer) {
        if (allPropertiesInScope.isEmpty()) {
            return;
        }
        if (allPropertiesInScope.size() == 1) {
            allPropertiesInScope.remove(0);
            return;
        }
        DoubleArrayList indices = new DoubleArrayList();
        ArrayList<JSProperty> allExpressions = new ArrayList<JSProperty>();
        JSStatement scope2 = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)allPropertiesInScope.get(0)), JSStatement.class);
        for (JSProperty initializer : allPropertiesInScope) {
            JSLiteralExpression argumentsEnumerableSingleItem;
            String newName;
            String named = initializer.getName();
            String string = newName = named == null ? null : JSNameSuggestionsUtil.ensureUniqueVariableName(named, (PsiElement)scope2, ContainerUtil.emptyList(), false);
            if (named != null && !named.equals(newName)) {
                allPropertiesInScope.clear();
                return;
            }
            JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)initializer.getValue();
            JSLiteralExpression jSLiteralExpression = argumentsEnumerableSingleItem = indexer == null ? null : (JSLiteralExpression)ObjectUtils.tryCast((Object)indexer.getIndexExpression(), JSLiteralExpression.class);
            if (argumentsEnumerableSingleItem == null || !argumentsEnumerableSingleItem.getExpressionKind(false).isNumeric()) {
                allPropertiesInScope.clear();
                return;
            }
            indices.add(JSObjectLiteralIndexingToArrayDestructuringIntention.toDouble(argumentsEnumerableSingleItem));
            allExpressions.add(initializer);
        }
        if (new DoubleOpenHashSet(indices.toDoubleArray()).size() != indices.size()) {
            allPropertiesInScope.clear();
            return;
        }
        consumer.consume((Object)((JSProperty)allExpressions.get(0)).getValue(), allExpressions);
        allPropertiesInScope.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/destructuring/JSObjectLiteralIndexingToArrayDestructuringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSObjectLiteralIndexingToArrayDestructuringIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

