/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.MessageStreamLoggerKt;
import com.intellij.lang.javascript.service.MessageStreamLoggerServiceKt;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\r\u0010\u001d\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/service/MessageStreamLogger;", "", "logPath", "Ljava/nio/file/Path;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Ljava/nio/file/Path;Lkotlinx/coroutines/CoroutineScope;)V", "getLogPath$intellij_javascript_impl", "()Ljava/nio/file/Path;", "flushRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "flushRequestJob", "Lkotlinx/coroutines/Job;", "writer", "Ljava/io/PrintWriter;", "getWriter", "()Ljava/io/PrintWriter;", "writer$delegate", "Lkotlin/Lazy;", "logInbound", "jsonBody", "", "logOutbound", "logError", "message", "formatCurrentTime", "", "close", "close$intellij_javascript_impl", "intellij.javascript.impl"})
public final class MessageStreamLogger {
    @NotNull
    private final Path logPath;
    @NotNull
    private final MutableSharedFlow<Unit> flushRequests;
    @NotNull
    private final Job flushRequestJob;
    @NotNull
    private final Lazy writer$delegate;

    public MessageStreamLogger(@NotNull Path logPath, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.logPath = logPath;
        this.flushRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.writer$delegate = LazyKt.lazy(() -> MessageStreamLogger.writer_delegate$lambda$0(this));
        this.flushRequestJob = BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MessageStreamLogger this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.debounce-HG0u8IE((Flow)FlowKt.sample-HG0u8IE((Flow)((Flow)this.this$0.flushRequests), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)), (long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS)).collect(new FlowCollector(){

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                this$0.getWriter().flush();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Path getLogPath$intellij_javascript_impl() {
        return this.logPath;
    }

    private final PrintWriter getWriter() {
        Lazy lazy = this.writer$delegate;
        return (PrintWriter)lazy.getValue();
    }

    public final void logInbound(@NotNull CharSequence jsonBody) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.getWriter().write(this.formatCurrentTime() + " IN  " + jsonBody + "\n");
        if (!this.flushRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public final void logOutbound(@NotNull CharSequence jsonBody) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.getWriter().write(this.formatCurrentTime() + " OUT " + jsonBody + "\n");
        if (!this.flushRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public final void logError(@NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getWriter().write(this.formatCurrentTime() + " ERR " + message + "\n");
        if (!this.flushRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private final String formatCurrentTime() {
        String string = MessageStreamLoggerKt.access$getTIMESTAMP_FORMAT$p().format(MessageStreamLoggerServiceKt.millisToDate(System.currentTimeMillis()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public final void close$intellij_javascript_impl() {
        Job.DefaultImpls.cancel$default((Job)this.flushRequestJob, null, (int)1, null);
        this.getWriter().close();
    }

    private static final PrintWriter writer_delegate$lambda$0(MessageStreamLogger this$0) {
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        return new PrintWriter(new BufferedOutputStream(Files.newOutputStream(this$0.logPath, openOptionArray)));
    }
}

