/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FixPropertyNameTypoQuickFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    private final String myExistingPropertyName;

    public FixPropertyNameTypoQuickFix(@NotNull JSReferenceExpression node, @NotNull String existingPropertyName) {
        if (node == null) {
            FixPropertyNameTypoQuickFix.$$$reportNull$$$0(0);
        }
        if (existingPropertyName == null) {
            FixPropertyNameTypoQuickFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)node);
        this.myExistingPropertyName = existingPropertyName;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("javascript.fix.property.spelling.text", this.myExistingPropertyName);
        if (string == null) {
            FixPropertyNameTypoQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            FixPropertyNameTypoQuickFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            FixPropertyNameTypoQuickFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            FixPropertyNameTypoQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            FixPropertyNameTypoQuickFix.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().runWriteAction(() -> ((JSReferenceExpression)startElement).getReferenceNameElement().replace(JSChangeUtil.createTokenElement(startElement, JSTokenTypes.IDENTIFIER, this.myExistingPropertyName)));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.fix.property.spelling.family", new Object[0]);
        if (string == null) {
            FixPropertyNameTypoQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingPropertyName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/FixPropertyNameTypoQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/FixPropertyNameTypoQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }
}

