/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSXNamespaceInfo;
import com.intellij.lang.javascript.inspections.ES6UnusedImportsInspection;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.typescript.imports.JSXNamespaceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6UnusedImportsHelper {
    private static final ParameterizedCachedValueProvider<Pair<JSXNamespaceInfo, Collection<String>>, JSElement> JSX_INFO_PROVIDER = param -> {
        JSXNamespaceInfo namespace = JSXNamespaceProvider.getDefaultNamespace((PsiElement)param);
        Collection<String> tags = ES6UnusedImportsHelper.calcUsedJSXTags(param);
        return CachedValueProvider.Result.create((Object)Pair.create((Object)namespace, tags), (Object[])new Object[]{param, JSTypeUtils.getTypeInvalidationDependency()});
    };
    public static final Key<ParameterizedCachedValue<Pair<JSXNamespaceInfo, Collection<String>>, JSElement>> JSX_INFO_KEY = Key.create((String)"jsx.namespace.info");

    public static boolean isES6SuppressedUnused(@NotNull ES6ImportDeclaration importDeclaration) {
        if (importDeclaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(0);
        }
        return new JSInspectionSuppressor().isSuppressedFor((PsiElement)importDeclaration, ES6UnusedImportsInspection.SHORT_NAME);
    }

    public static boolean isTypeScriptSuppressedUnused(@NotNull TypeScriptImportStatement importDeclaration) {
        if (importDeclaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(1);
        }
        return new JSInspectionSuppressor().isSuppressedFor((PsiElement)importDeclaration, ES6UnusedImportsInspection.SHORT_NAME);
    }

    @NotNull
    public static UnusedInfo getInfo(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(2);
        }
        UnusedInfo info = new UnusedInfo(declaration);
        info.fillUsages(Collections.emptySet());
        UnusedInfo unusedInfo = info;
        if (unusedInfo == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(3);
        }
        return unusedInfo;
    }

    @NotNull
    public static UnusedInfo getInfo(@NotNull ES6ImportDeclaration declaration, int position, @Nullable UnusedInfo prevAnchor, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        if (declaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(4);
        }
        if (ignoredRefs == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(5);
        }
        UnusedInfo info = new UnusedInfo(declaration, position, prevAnchor);
        info.fillUsages(ignoredRefs);
        UnusedInfo unusedInfo = info;
        if (unusedInfo == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(6);
        }
        return unusedInfo;
    }

    public static boolean isUnusedTypeScriptImport(@NotNull TypeScriptImportStatement statement, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        if (statement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(7);
        }
        if (ignoredRefs == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(8);
        }
        if (statement.isExported()) {
            return false;
        }
        String name = statement.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        if (statement.getExternalModuleReference() == null && statement.getInternalModuleReference() == null) {
            return false;
        }
        return ES6UnusedImportsHelper.isUnusedInContainer(name, (PsiElement)statement, ignoredRefs);
    }

    private static boolean isImplicitlyUsed(@NotNull PsiElement element) {
        if (element == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(9);
        }
        return ContainerUtil.exists((Iterable)ImplicitUsageProvider.EP_NAME.getExtensionList(), it -> it.isImplicitUsage(element));
    }

    private static boolean isUnusedAlias(@NotNull ES6ImportSpecifierAlias alias, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        if (alias == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(10);
        }
        if (ignoredRefs == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(11);
        }
        return ES6UnusedImportsHelper.isUnusedInContainer(alias.getName(), (PsiElement)alias, ignoredRefs);
    }

    private static boolean isUnusedSpecifier(@NotNull ES6ImportSpecifier specifier, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        if (specifier == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(12);
        }
        if (ignoredRefs == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(13);
        }
        if (ES6UnusedImportsHelper.isImplicitlyUsed((PsiElement)specifier)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope((PsiElement)specifier);
        if (container == null) {
            return false;
        }
        if (ES6UnusedImportsHelper.hasJSXReference(specifier.getReferenceName(), container)) {
            return false;
        }
        Object[] resolveResults = specifier.multiResolve(false);
        List validResolveResults = ContainerUtil.filter((Object[])resolveResults, ES6UnusedImportsHelper::isValid);
        if (resolveResults.length == 0) {
            return !ES6UnusedImportsHelper.hasLocalReferences((PsiElement)specifier, (PsiElement)container, ignoredRefs);
        }
        if (validResolveResults.isEmpty()) {
            return false;
        }
        for (ResolveResult resolveResult : validResolveResults) {
            PsiElement element = resolveResult.getElement();
            assert (element != null);
            Query<PsiReference> query = ES6UnusedImportsHelper.getLocalReferencesQuery(element, (PsiElement)container);
            boolean result2 = query.forEach(reference -> {
                JSElement containerForReference;
                ApplicationManager.getApplication().assertReadAccessAllowed();
                ProgressManager.checkCanceled();
                PsiElement referenceElement = reference.getElement();
                if (referenceElement instanceof ES6ImportSpecifier && container == (containerForReference = ES6PsiUtil.getExportScope(referenceElement))) {
                    return true;
                }
                if (referenceElement instanceof JSReferenceExpression) {
                    JSReferenceExpression referenceExpression = (JSReferenceExpression)referenceElement;
                    return ignoredRefs.contains(referenceExpression) || !ES6UnusedImportsHelper.isReferenceExpressionResolvedThroughSpecifier(referenceExpression, (PsiElement)specifier);
                }
                return !ES6UnusedImportsHelper.isReferenceCanBeResolvedToSpecifier(referenceElement, (PsiElement)specifier, reference.getCanonicalText());
            });
            if (result2) continue;
            return false;
        }
        return true;
    }

    private static boolean isValid(@NotNull ResolveResult result2) {
        JSResolveResult jsResolveResult;
        JSResolveResult.ProblemKind kind;
        PsiElement element;
        if (result2 == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(14);
        }
        if ((element = result2.getElement()) == null) {
            return false;
        }
        if (result2.isValidResult()) {
            return true;
        }
        return result2 instanceof JSResolveResult && (kind = (jsResolveResult = (JSResolveResult)result2).getResolveProblemKind()) == JSResolveResult.ProblemKind.TS_NEED_TO_BE_INCLUDED_TO_CONFIG;
    }

    private static boolean isUnusedImportedBinding(@NotNull ES6ImportedBinding binding, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        if (binding == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(15);
        }
        if (ignoredRefs == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(16);
        }
        String name = binding.getName();
        return ES6UnusedImportsHelper.isUnusedInContainer(name, (PsiElement)binding, ignoredRefs);
    }

    private static boolean isReferenceExpressionResolvedThroughSpecifier(@NotNull JSReferenceExpression referenceExpression, @NotNull PsiElement importSpecifier) {
        if (referenceExpression == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(17);
        }
        if (importSpecifier == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(18);
        }
        for (ResolveResult _resolveResult : referenceExpression.multiResolve(false)) {
            JSResolveResult resolveResult;
            if (!(_resolveResult instanceof JSResolveResult) || !importSpecifier.equals((resolveResult = (JSResolveResult)_resolveResult).getES6Import())) continue;
            return true;
        }
        return false;
    }

    private static boolean isReferenceCanBeResolvedToSpecifier(@NotNull PsiElement referenceElement, @NotNull PsiElement importSpecifier, @NotNull String name) {
        if (referenceElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(19);
        }
        if (importSpecifier == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(20);
        }
        if (name == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(21);
        }
        ResolveResultSink sink = new ResolveResultSink(referenceElement, name);
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(sink);
        processor.setTypeContext(true);
        processor.setLocalResolve(true);
        return !processor.execute(importSpecifier, ResolveState.initial());
    }

    public static boolean isUnusedInContainer(@Nullable String name, @NotNull PsiElement refElement, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(22);
        }
        if (ignoredRefs == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(23);
        }
        if (ES6UnusedImportsHelper.isImplicitlyUsed(refElement)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope(refElement);
        if (container == null || name == null || ES6UnusedImportsHelper.hasJSXReference(name, container)) {
            return false;
        }
        return !ES6UnusedImportsHelper.hasLocalReferences(refElement, (PsiElement)container, ignoredRefs);
    }

    private static boolean hasJSXReference(@Nullable String name, @NotNull JSElement container) {
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(24);
        }
        if (name == null || !DialectDetector.isJSX((PsiElement)container)) {
            return false;
        }
        Pair<JSXNamespaceInfo, Collection<String>> pair = ES6UnusedImportsHelper.getUsedJSXInfo(container);
        JSXNamespaceInfo info = (JSXNamespaceInfo)pair.first;
        Collection tags = (Collection)pair.second;
        if (tags.isEmpty()) {
            return false;
        }
        if (Objects.equals(name, info.getFragmentFactoryOrDefault()) && tags.contains("")) {
            return true;
        }
        return tags.contains(name) || Objects.equals(info.jsxFactory, name);
    }

    private static boolean hasLocalReferences(@NotNull PsiElement refElement, @NotNull PsiElement container, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(25);
        }
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(26);
        }
        if (ignoredRefs == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(27);
        }
        Query<PsiReference> search = ES6UnusedImportsHelper.getLocalReferencesQuery(refElement, container);
        return ignoredRefs.isEmpty() ? search.findFirst() != null : search.filtering(ref2 -> !ignoredRefs.contains(ref2)).findFirst() != null;
    }

    @NotNull
    private static Query<PsiReference> getLocalReferencesQuery(@NotNull PsiElement refElement, @NotNull PsiElement container) {
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(28);
        }
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(29);
        }
        LocalSearchScope scope2 = new LocalSearchScope(container);
        Query query = ReferencesSearch.search((PsiElement)refElement, (SearchScope)scope2, (boolean)true);
        if (query == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(30);
        }
        return query;
    }

    @NotNull
    public static Pair<JSXNamespaceInfo, Collection<String>> getUsedJSXInfo(@NotNull JSElement element) {
        if (element == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(31);
        }
        Pair pair = (Pair)CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)element, JSX_INFO_KEY, JSX_INFO_PROVIDER, false, (Object)element);
        if (pair == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(32);
        }
        return pair;
    }

    @NotNull
    private static Collection<String> calcUsedJSXTags(@NotNull JSElement container) {
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(33);
        }
        final HashSet<String> results = new HashSet<String>();
        container.accept(new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node instanceof XmlTag) {
                    String name = node.getName();
                    if (!StringUtil.isEmpty((String)name)) {
                        List strings = StringUtil.split((String)name, (String)".");
                        if (!strings.isEmpty()) {
                            results.add((String)ContainerUtil.getFirstItem((List)strings));
                        }
                    } else {
                        results.add("");
                    }
                }
                super.visitJSLiteralExpression(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$1", "visitJSLiteralExpression"));
            }
        });
        HashSet<String> hashSet = results;
        if (hashSet == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(34);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 30, 32, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: 
            case 6: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRefs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpecifier";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 24: 
            case 26: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalReferencesQuery";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedJSXInfo";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "calcUsedJSXTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isES6SuppressedUnused";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptSuppressedUnused";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 3: 
            case 6: 
            case 30: 
            case 32: 
            case 34: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedTypeScriptImport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitlyUsed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedAlias";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedSpecifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedImportedBinding";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceExpressionResolvedThroughSpecifier";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceCanBeResolvedToSpecifier";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedInContainer";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasJSXReference";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalReferences";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLocalReferencesQuery";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getUsedJSXInfo";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "calcUsedJSXTags";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 30, 32, 34 -> new IllegalStateException(string);
        };
    }

    public static class UnusedInfo {
        @NotNull
        private final ES6ImportDeclaration myDeclaration;
        private final Collection<ES6ImportedBinding> myUnusedBindings;
        private final Collection<ES6ImportSpecifier> myUnusedSpecifiers;
        private boolean myIsUnused;
        private boolean mySideEffectImport;
        private final int myPosition;
        @Nullable
        private final UnusedInfo myPrevAnchor;

        @NotNull
        public ES6ImportDeclaration getDeclaration() {
            ES6ImportDeclaration eS6ImportDeclaration = this.myDeclaration;
            if (eS6ImportDeclaration == null) {
                UnusedInfo.$$$reportNull$$$0(0);
            }
            return eS6ImportDeclaration;
        }

        @NotNull
        public Collection<ES6ImportedBinding> getUnusedBindings() {
            Collection<ES6ImportedBinding> collection = this.myUnusedBindings;
            if (collection == null) {
                UnusedInfo.$$$reportNull$$$0(1);
            }
            return collection;
        }

        @NotNull
        public Collection<ES6ImportSpecifier> getUnusedSpecifiers() {
            Collection<ES6ImportSpecifier> collection = this.myUnusedSpecifiers;
            if (collection == null) {
                UnusedInfo.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public boolean isAllUnused() {
            return this.myIsUnused;
        }

        public UnusedInfo(@NotNull ES6ImportDeclaration declaration) {
            if (declaration == null) {
                UnusedInfo.$$$reportNull$$$0(3);
            }
            this.myUnusedBindings = new HashSet<ES6ImportedBinding>();
            this.myUnusedSpecifiers = new HashSet<ES6ImportSpecifier>();
            this.myDeclaration = declaration;
            this.myPosition = -1;
            this.myPrevAnchor = null;
        }

        public UnusedInfo(@NotNull ES6ImportDeclaration declaration, int pos, @Nullable UnusedInfo prevAnchor) {
            if (declaration == null) {
                UnusedInfo.$$$reportNull$$$0(4);
            }
            this.myUnusedBindings = new HashSet<ES6ImportedBinding>();
            this.myUnusedSpecifiers = new HashSet<ES6ImportSpecifier>();
            this.myDeclaration = declaration;
            this.myPosition = pos;
            this.myPrevAnchor = prevAnchor;
        }

        public boolean isEmpty() {
            return this.myDeclaration.getImportSpecifiers().length == 0 && this.myDeclaration.getImportedBindings().length == 0;
        }

        public boolean isSideEffectImport() {
            return this.mySideEffectImport;
        }

        private void fillUsages(@NotNull Set<JSReferenceExpression> ignoredRefs) {
            ES6ImportedBinding[] bindings;
            ES6ImportSpecifier[] specifiers;
            if (ignoredRefs == null) {
                UnusedInfo.$$$reportNull$$$0(5);
            }
            boolean hasUsages2 = false;
            for (ES6ImportSpecifier specifier : specifiers = this.myDeclaration.getImportSpecifiers()) {
                ES6ImportSpecifierAlias alias = specifier.getAlias();
                if (alias != null && ES6UnusedImportsHelper.isUnusedAlias(alias, ignoredRefs) || alias == null && ES6UnusedImportsHelper.isUnusedSpecifier(specifier, ignoredRefs)) {
                    this.myUnusedSpecifiers.add(specifier);
                    continue;
                }
                hasUsages2 = true;
            }
            for (ES6ImportedBinding binding : bindings = this.myDeclaration.getImportedBindings()) {
                if (ES6UnusedImportsHelper.isUnusedImportedBinding(binding, ignoredRefs)) {
                    this.myUnusedBindings.add(binding);
                    continue;
                }
                hasUsages2 = true;
            }
            this.mySideEffectImport = !StringUtil.isEmpty((String)this.myDeclaration.getImportModuleText());
            this.myIsUnused = !this.mySideEffectImport && !hasUsages2;
        }

        public int getPosition() {
            return this.myPosition;
        }

        @Nullable
        public UnusedInfo getPrevAnchor() {
            return this.myPrevAnchor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$UnusedInfo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoredRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnusedBindings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnusedSpecifiers";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$UnusedInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fillUsages";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

