/*
 * Decompiled with CFR 0.152.
 */
package training.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.content.Content;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.learn.lesson.LessonStateManager;
import training.ui.LearnToolWindow;
import training.ui.LearningUiManager;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\b\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"\u001a\u0016\u0010#\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\u0003\u001a\u0018\u0010$\u001a\u0004\u0018\u00010\u00032\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\b\u001a\u0018\u0010$\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\b\u001a\u000e\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u000200\u001a\u0010\u00101\u001a\u00020\u00032\b\b\u0001\u00102\u001a\u00020\u0003\u001a\u000e\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u0003\u001a\u0010\u00105\u001a\u000206*\b\u0012\u0004\u0012\u00020807\u001a\u0016\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<\u001a\u0016\u0010>\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<\u001a\u0012\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010!\u001a\u00020\"H\u0000\u001a\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020@0BH\u0000\u001a\u0014\u0010C\u001a\u0004\u0018\u00010D2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0000\u001a\b\u0010E\u001a\u0004\u0018\u00010D\u001a\b\u0010F\u001a\u0004\u0018\u00010D\u001a\u0016\u0010G\u001a\u00020\u00032\f\u0010H\u001a\b\u0012\u0004\u0012\u00020D0BH\u0007\u001a\u0010\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010!\u001a\u00020\"\u001a\u000e\u0010K\u001a\u0004\u0018\u00010\u0003*\u0004\u0018\u000108\u001a\u0014\u0010L\u001a\u00020\b*\u0004\u0018\u0001082\u0006\u0010M\u001a\u00020\u0003\u001a\u0010\u0010N\u001a\u0002002\b\b\u0001\u00102\u001a\u00020\u0003\u001a\u0014\u0010O\u001a\u0004\u0018\u00010\u00032\b\u0010P\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\f\u0010Q\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\f\u0010R\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\u001c\u0010Y\u001a\b\u0012\u0004\u0012\u00020D0B2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020D0BH\u0000\" \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0013\u001a\u00020\u00038@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\"\u0011\u0010\u0018\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0011\u0010(\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001a\"\u0011\u0010*\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001a\"\u0011\u0010,\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001a\"\u0014\u0010S\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010\u001a\"\u000e\u0010U\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010V\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010W\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010\u001a\"\u0011\u0010[\u001a\u00020\\8F\u00a2\u0006\u0006\u001a\u0004\b]\u0010^\u00a8\u0006_"}, d2={"createNamedSingleThreadExecutor", "Ljava/util/concurrent/ExecutorService;", "name", "", "excludedLanguages", "", "", "courseCanBeUsed", "", "languageId", "findLanguageByID", "Lcom/intellij/lang/Language;", "id", "createBalloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "text", "delay", "", "trainerPluginConfigName", "featureTrainerVersion", "getFeatureTrainerVersion", "()Ljava/lang/String;", "featureTrainerVersion$delegate", "Lkotlin/Lazy;", "adaptToNotNativeLocalization", "getAdaptToNotNativeLocalization", "()Z", "clearTrainingProgress", "", "resetPrimaryLanguage", "newLanguageId", "findLanguageSupport", "Ltraining/lang/LangSupport;", "project", "Lcom/intellij/openapi/project/Project;", "isLearningProject", "getFeedbackLink", "langSupport", "ownRegistry", "langName", "useShortOnboardingLesson", "getUseShortOnboardingLesson", "switchOnExperimentalLessons", "getSwitchOnExperimentalLessons", "enableLessonsAndPromoters", "getEnableLessonsAndPromoters", "invokeActionForFocusContext", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "getCallBackActionId", "actionId", "openLinkInBrowser", "link", "wrapWithUrlPanel", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "rigid", "Ljava/awt/Component;", "width", "", "height", "scaledRigid", "getLearnToolWindowForProject", "Ltraining/ui/LearnToolWindow;", "getAllLearnToolWindows", "", "lessonOpenedInProject", "Ltraining/learn/course/Lesson;", "getNextLessonForCurrent", "getPreviousLessonForCurrent", "learningProgressString", "lessons", "learningToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toNullableString", "isToStringContains", "string", "getActionById", "excludeNullCheck", "value", "replaceSpacesWithNonBreakSpace", "surroundWithNonBreakSpaces", "iftPluginIsUsing", "getIftPluginIsUsing", "SHOW_NEW_LESSONS_NOTIFICATION", "LEARNING_PANEL_OPENED_IN", "learningPanelWasOpenedInCurrentVersion", "getLearningPanelWasOpenedInCurrentVersion", "filterUnseenLessons", "newLessons", "iftNotificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getIftNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ntraining/util/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n774#2:295\n865#2,2:296\n774#2:299\n865#2,2:300\n1#3:298\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ntraining/util/UtilsKt\n*L\n282#1:295\n282#1:296,2\n287#1:299\n287#1:300,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Map<String, String[]> excludedLanguages;
    @NotNull
    public static final String trainerPluginConfigName = "ide-features-trainer.xml";
    @NotNull
    private static final Lazy featureTrainerVersion$delegate;
    @NotNull
    public static final String SHOW_NEW_LESSONS_NOTIFICATION = "ift.show.new.lessons.notification";
    @NotNull
    public static final String LEARNING_PANEL_OPENED_IN = "ift.learning.panel.opened.in";

    @NotNull
    public static final ExecutorService createNamedSingleThreadExecutor(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(name).build());
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        return executorService;
    }

    public static final boolean courseCanBeUsed(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Object[] excludedCourses = excludedLanguages.get(ApplicationNamesInfo.getInstance().getProductName());
        return excludedCourses == null || !ArraysKt.contains((Object[])excludedCourses, (Object)languageId);
    }

    @Nullable
    public static final Language findLanguageByID(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String effectiveId = StringsKt.equals((String)id, (String)"cpp", (boolean)true) ? "ObjectiveC" : id;
        return Language.findLanguageByID((String)effectiveId);
    }

    @NotNull
    public static final Balloon createBalloon(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return UtilsKt.createBalloon(text, 3000L);
    }

    @NotNull
    public static final Balloon createBalloon(@Nls @NotNull String text, long delay) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text, MessageType.WARNING, null).setHideOnClickOutside(true).setCloseButtonEnabled(true).setHideOnKeyOutside(true).setAnimationCycle(0).setFadeoutTime(delay).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        return balloon;
    }

    @NotNull
    public static final String getFeatureTrainerVersion() {
        Lazy lazy = featureTrainerVersion$delegate;
        return (String)lazy.getValue();
    }

    public static final boolean getAdaptToNotNativeLocalization() {
        return Registry.Companion.is("ift.adapt.to.not.native.localization") || !Intrinsics.areEqual((Object)DynamicBundle.getLocale(), (Object)Locale.ENGLISH);
    }

    public static final void clearTrainingProgress() {
        LessonManager.Companion.getInstance().stopLesson();
        LessonStateManager.INSTANCE.resetPassedStatus();
        for (LearnToolWindow toolWindow : UtilsKt.getAllLearnToolWindows()) {
            toolWindow.reinitViews$intellij_featuresTrainer();
            toolWindow.setModulesPanel$intellij_featuresTrainer();
        }
        LearningUiManager.INSTANCE.setActiveToolWindow$intellij_featuresTrainer(null);
    }

    public static final boolean resetPrimaryLanguage(@NotNull String newLanguageId) {
        Intrinsics.checkNotNullParameter((Object)newLanguageId, (String)"newLanguageId");
        String oldLanguageId = LangManager.Companion.getInstance().getLanguageId();
        if (!Intrinsics.areEqual((Object)newLanguageId, (Object)oldLanguageId)) {
            LessonManager.Companion.getInstance().stopLesson();
            LangManager.Companion.getInstance().updateLangSupport(newLanguageId);
            LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
            if (learnToolWindow != null) {
                learnToolWindow.setModulesPanel$intellij_featuresTrainer();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static final LangSupport findLanguageSupport(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = LangManager.Companion.getInstance().getLanguageId();
        if (string == null) {
            return null;
        }
        String languageId = string;
        if (UtilsKt.isLearningProject(project, languageId)) {
            return LangManager.Companion.getInstance().getLangSupport();
        }
        return null;
    }

    public static final boolean isLearningProject(@NotNull Project project, @NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return FileUtil.pathsEqual((String)project.getBasePath(), (String)LangManager.Companion.getInstance().getLearningProjectPath(languageId));
    }

    @Nullable
    public static final String getFeedbackLink(@NotNull LangSupport langSupport, boolean ownRegistry) {
        Intrinsics.checkNotNullParameter((Object)langSupport, (String)"langSupport");
        String string = langSupport.getPrimaryLanguage().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return UtilsKt.getFeedbackLink(string, ownRegistry);
    }

    @Nullable
    public static final String getFeedbackLink(@NotNull String langName, boolean ownRegistry) {
        Intrinsics.checkNotNullParameter((Object)langName, (String)"langName");
        boolean needToShow = Registry.Companion.is("ift.show.feedback.link" + (String)(ownRegistry ? "." + langName : ""), false);
        return needToShow ? "https://surveys.jetbrains.com/s3/features-trainer-feedback-" + langName : null;
    }

    public static final boolean getUseShortOnboardingLesson() {
        return Registry.Companion.is("ift.short.onboarding.lesson", false);
    }

    public static final boolean getSwitchOnExperimentalLessons() {
        return Registry.Companion.is("ift.experimental.lessons", false);
    }

    public static final boolean getEnableLessonsAndPromoters() {
        return ExperimentalUI.Companion.isNewUI() || Registry.Companion.is("ift.enable.in.old.ui", false) || PlatformUtils.isDataSpell();
    }

    public static final void invokeActionForFocusContext(@NotNull AnAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> UtilsKt.invokeActionForFocusContext$lambda$3(arg_0 -> UtilsKt.invokeActionForFocusContext$lambda$2(action, arg_0), arg_0));
    }

    @NotNull
    public static final String getCallBackActionId(@org.intellij.lang.annotations.Language(value="devkit-action-id") @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        AnAction action = UtilsKt.getActionById(actionId);
        return LearningUiManager.INSTANCE.addCallback((Function0<Unit>)((Function0)() -> UtilsKt.getCallBackActionId$lambda$4(action)));
    }

    public static final void openLinkInBrowser(@NotNull String link) {
        Desktop desktop;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(new URI(link));
        }
    }

    @NotNull
    public static final JPanel wrapWithUrlPanel(@NotNull LinkLabel<Object> $this$wrapWithUrlPanel) {
        Intrinsics.checkNotNullParameter($this$wrapWithUrlPanel, (String)"<this>");
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add((Component)$this$wrapWithUrlPanel, "Center");
        jPanel.add((Component)new JLabel(AllIcons.Ide.External_link_arrow), "East");
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    @NotNull
    public static final Component rigid(int width, int height) {
        return UtilsKt.scaledRigid(JBUI.scale((int)width), JBUI.scale((int)height));
    }

    @NotNull
    public static final Component scaledRigid(int width, int height) {
        JComponent jComponent;
        Component component2 = Box.createRigidArea(new Dimension(width, height));
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent $this$scaledRigid_u24lambda_u245 = jComponent = (JComponent)component2;
        boolean bl = false;
        $this$scaledRigid_u24lambda_u245.setAlignmentX(0.0f);
        $this$scaledRigid_u24lambda_u245.setAlignmentY(0.0f);
        return jComponent;
    }

    @Nullable
    public static final LearnToolWindow getLearnToolWindowForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Learn");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        Content content = toolWindow2.getContentManagerIfCreated();
        JComponent jComponent = content != null && (content = content.getContents()) != null && (content = (Content)ArraysKt.singleOrNull((Object[])content)) != null ? content.getComponent() : null;
        return jComponent instanceof LearnToolWindow ? (LearnToolWindow)((Object)jComponent) : null;
    }

    @NotNull
    public static final List<LearnToolWindow> getAllLearnToolWindows() {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)ProjectUtil.getOpenedProjects(), UtilsKt::getAllLearnToolWindows$lambda$6));
    }

    @Nullable
    public static final Lesson lessonOpenedInProject(@Nullable Project project) {
        return project != null && UtilsKt.getLearnToolWindowForProject(project) != null ? LessonManager.Companion.getInstance().getCurrentLesson() : null;
    }

    @Nullable
    public static final Lesson getNextLessonForCurrent() {
        Lesson lesson = LessonManager.Companion.getInstance().getCurrentLesson();
        if (lesson == null) {
            return null;
        }
        Lesson lesson2 = lesson;
        List<Lesson> lessonsForModules = CourseManager.Companion.getInstance().getLessonsForModules();
        int index = lessonsForModules.indexOf(lesson2);
        if (index < 0 || index >= lessonsForModules.size() - 1) {
            return null;
        }
        return lessonsForModules.get(index + 1);
    }

    @Nullable
    public static final Lesson getPreviousLessonForCurrent() {
        Lesson lesson = LessonManager.Companion.getInstance().getCurrentLesson();
        if (lesson == null) {
            return null;
        }
        Lesson lesson2 = lesson;
        List<Lesson> lessonsForModules = CourseManager.Companion.getInstance().getLessonsForModules();
        int index = lessonsForModules.indexOf(lesson2);
        if (index <= 0) {
            return null;
        }
        return lessonsForModules.get(index - 1);
    }

    @Nls
    @NotNull
    public static final String learningProgressString(@NotNull List<? extends Lesson> lessons) {
        String string;
        Intrinsics.checkNotNullParameter(lessons, (String)"lessons");
        int total = lessons.size();
        int done = 0;
        for (Lesson lesson : lessons) {
            if (!lesson.getPassed$intellij_featuresTrainer()) continue;
            ++done;
        }
        if (done == total) {
            string = LearnBundle.INSTANCE.message("learn.module.progress.completed", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{done, total};
            string = LearnBundle.INSTANCE.message("learn.module.progress", objectArray);
        }
        return string;
    }

    @Nullable
    public static final ToolWindow learningToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ToolWindowManager.Companion.getInstance(project).getToolWindow("Learn");
    }

    @Nullable
    public static final String toNullableString(@Nullable Object $this$toNullableString) {
        Object object = $this$toNullableString;
        return object == null ? null : UtilsKt.excludeNullCheck(object.toString());
    }

    public static final boolean isToStringContains(@Nullable Object $this$isToStringContains, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = UtilsKt.toNullableString($this$isToStringContains);
        return string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)string, (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public static final AnAction getActionById(@org.intellij.lang.annotations.Language(value="devkit-action-id") @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        AnAction anAction = ActionManager.getInstance().getAction(actionId);
        if (anAction == null) {
            throw new IllegalStateException(("No action with id " + actionId + " in " + ApplicationNamesInfo.getInstance().getFullProductNameWithEdition()).toString());
        }
        return anAction;
    }

    private static final String excludeNullCheck(String value) {
        return value;
    }

    @NotNull
    public static final String replaceSpacesWithNonBreakSpace(@NotNull String $this$replaceSpacesWithNonBreakSpace) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceSpacesWithNonBreakSpace, (String)"<this>");
        return StringsKt.replace$default((String)$this$replaceSpacesWithNonBreakSpace, (String)" ", (String)"\u00a0", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String surroundWithNonBreakSpaces(@NotNull String $this$surroundWithNonBreakSpaces) {
        Intrinsics.checkNotNullParameter((Object)$this$surroundWithNonBreakSpaces, (String)"<this>");
        String spaces = "\u00a0\u00a0";
        return spaces + $this$surroundWithNonBreakSpaces + spaces;
    }

    public static final boolean getIftPluginIsUsing() {
        return LessonStateManager.INSTANCE.getPassedLessonsNumber() >= 5;
    }

    public static final boolean getLearningPanelWasOpenedInCurrentVersion() {
        String string = PropertiesComponent.getInstance().getValue(LEARNING_PANEL_OPENED_IN);
        if (string == null) {
            return false;
        }
        String savedValue = string;
        BuildNumber buildNumber = BuildNumber.fromString((String)savedValue);
        if (buildNumber == null) {
            return false;
        }
        BuildNumber savedBuild = buildNumber;
        return savedBuild.compareTo(ApplicationInfo.getInstance().getBuild()) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Lesson> filterUnseenLessons(@NotNull List<? extends Lesson> newLessons) {
        List list;
        block16: {
            void $this$filterTo$iv$iv;
            BuildNumber maxSeenVersion;
            BuildNumber zeroBuild;
            block15: {
                Object object;
                block10: {
                    String string;
                    Object lesson;
                    Iterator $i$f$filter22;
                    block12: {
                        block11: {
                            block9: {
                                void $this$filterTo$iv$iv2;
                                Intrinsics.checkNotNullParameter(newLessons, (String)"newLessons");
                                zeroBuild = new BuildNumber("", 0, 0);
                                Iterable $this$filter$iv = newLessons;
                                boolean $i$f$filter22 = false;
                                Iterable iterable = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList();
                                boolean $i$f$filterTo = false;
                                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                                    Lesson it = (Lesson)element$iv$iv;
                                    boolean bl = false;
                                    if (!it.getPassed$intellij_featuresTrainer()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $i$f$filter22 = ((Iterable)((List)destination$iv$iv)).iterator();
                                if ($i$f$filter22.hasNext()) break block9;
                                object = null;
                                break block10;
                            }
                            lesson = (Lesson)$i$f$filter22.next();
                            boolean bl = false;
                            string = ((Lesson)lesson).getProperties().getAvailableSince();
                            if (string == null) break block11;
                            String it = string;
                            boolean bl2 = false;
                            BuildNumber buildNumber = BuildNumber.fromString((String)it);
                            string = buildNumber;
                            if (buildNumber != null) break block12;
                        }
                        string = zeroBuild;
                    }
                    lesson = (Comparable)((Object)string);
                    while ($i$f$filter22.hasNext()) {
                        String string2;
                        Object lesson2;
                        block14: {
                            block13: {
                                lesson2 = (Lesson)$i$f$filter22.next();
                                boolean bl = false;
                                string2 = ((Lesson)lesson2).getProperties().getAvailableSince();
                                if (string2 == null) break block13;
                                String it = string2;
                                boolean bl3 = false;
                                BuildNumber buildNumber = BuildNumber.fromString((String)it);
                                string2 = buildNumber;
                                if (buildNumber != null) break block14;
                            }
                            string2 = zeroBuild;
                        }
                        if (lesson.compareTo(lesson2 = (Comparable)((Object)string2)) >= 0) continue;
                        lesson = lesson2;
                    }
                    object = lesson;
                }
                maxSeenVersion = (BuildNumber)object;
                if (maxSeenVersion != null) break block15;
                list = newLessons;
                break block16;
            }
            Iterable $this$filter$iv = newLessons;
            boolean $i$f$filter = false;
            Iterable lesson2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String string;
                block18: {
                    block17: {
                        Lesson lesson = (Lesson)element$iv$iv;
                        boolean bl = false;
                        string = lesson.getProperties().getAvailableSince();
                        if (string == null) break block17;
                        String it = string;
                        boolean bl4 = false;
                        BuildNumber buildNumber = BuildNumber.fromString((String)it);
                        string = buildNumber;
                        if (buildNumber != null) break block18;
                    }
                    string = zeroBuild;
                }
                if (!(string.compareTo(maxSeenVersion) > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List unseenLessons = list;
        return unseenLessons;
    }

    @NotNull
    public static final NotificationGroup getIftNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("IDE Features Trainer");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    private static final String featureTrainerVersion_delegate$lambda$0() {
        Object object = PluginManager.getPluginByClass(CourseManager.class);
        if (object == null || (object = object.getVersion()) == null) {
            object = "UNKNOWN";
        }
        return object;
    }

    private static final Unit invokeActionForFocusContext$lambda$2$lambda$1(AnAction $action, DataContext $dataContext) {
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)$action, null, (String)"LearnToolwindow", (DataContext)$dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
        AnActionEvent event = anActionEvent;
        event.getPresentation().setPerformGroup(true);
        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)$action, (AnActionEvent)event);
        return Unit.INSTANCE;
    }

    private static final Unit invokeActionForFocusContext$lambda$2(AnAction $action, DataContext dataContext) {
        ActionsKt.invokeLater$default(null, () -> UtilsKt.invokeActionForFocusContext$lambda$2$lambda$1($action, dataContext), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void invokeActionForFocusContext$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit getCallBackActionId$lambda$4(AnAction $action) {
        UtilsKt.invokeActionForFocusContext($action);
        return Unit.INSTANCE;
    }

    private static final LearnToolWindow getAllLearnToolWindows$lambda$6(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilsKt.getLearnToolWindowForProject(it);
    }

    static {
        Pair[] pairArray = new Pair[2];
        String[] stringArray = new String[]{"JavaScript"};
        pairArray[0] = TuplesKt.to((Object)"AppCode", (Object)stringArray);
        stringArray = new String[]{"Python"};
        pairArray[1] = TuplesKt.to((Object)"DataSpell", (Object)stringArray);
        excludedLanguages = MapsKt.mapOf((Pair[])pairArray);
        featureTrainerVersion$delegate = LazyKt.lazy(UtilsKt::featureTrainerVersion_delegate$lambda$0);
    }
}

