/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyParsingBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.FollowingCommentBinder;
import com.jetbrains.python.parsing.LeadingCommentsBinder;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.ParsingScope;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementType;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementParsing
extends Parsing
implements ITokenTypeRemapper {
    private static final Logger LOG = Logger.getInstance(StatementParsing.class);
    @NonNls
    protected static final String TOK_FUTURE_IMPORT = "__future__";
    @NonNls
    protected static final String TOK_PRINT_FUNCTION = "print_function";
    @NonNls
    protected static final String TOK_WITH = "with";
    @NonNls
    protected static final String TOK_AS = "as";
    @NonNls
    protected static final String TOK_PRINT = "print";
    @NonNls
    protected static final String TOK_NONE = "None";
    @NonNls
    protected static final String TOK_TRUE = "True";
    @NonNls
    protected static final String TOK_DEBUG = "__debug__";
    @NonNls
    protected static final String TOK_FALSE = "False";
    @NonNls
    protected static final String TOK_NONLOCAL = "nonlocal";
    @NonNls
    protected static final String TOK_EXEC = "exec";
    @NonNls
    public static final String TOK_ASYNC = "async";
    @NonNls
    protected static final String TOK_AWAIT = "await";
    @NonNls
    protected static final String TOK_OBJECT = "object";
    @NonNls
    protected static final String TOK_TYPE = "type";
    @NonNls
    protected static final String TOK_IMPORT = "import";
    @NonNls
    protected static final String TOK_IN = "in";
    @NonNls
    protected static final String TOK_FROM = "from";
    @NonNls
    protected static final String TOK_MATCH = "match";
    @NonNls
    protected static final String TOK_CASE = "case";
    private Phase myFutureImportPhase = Phase.NONE;
    protected Set<FutureFeature> myFutureFlags = EnumSet.noneOf(FutureFeature.class);

    public StatementParsing(ParsingContext context) {
        super(context);
    }

    public void parseStatement() {
        while (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            this.myBuilder.advanceLexer();
        }
        IElementType firstToken = this.myBuilder.getTokenType();
        if (firstToken == null) {
            return;
        }
        if (firstToken == PyTokenTypes.WHILE_KEYWORD) {
            this.parseWhileStatement();
            return;
        }
        if (firstToken == PyTokenTypes.IF_KEYWORD) {
            this.parseIfStatement(PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.ELSE_KEYWORD, PyElementTypes.IF_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.FOR_KEYWORD) {
            this.parseForStatement(this.myBuilder.mark());
            return;
        }
        if (firstToken == PyTokenTypes.TRY_KEYWORD) {
            this.parseTryStatement();
            return;
        }
        if (firstToken == PyTokenTypes.DEF_KEYWORD) {
            this.getFunctionParser().parseFunctionDeclaration(this.myBuilder.mark(), false);
            return;
        }
        if (firstToken == PyTokenTypes.AT) {
            this.getFunctionParser().parseDecoratedDeclaration();
            return;
        }
        if (firstToken == PyTokenTypes.CLASS_KEYWORD) {
            this.parseClassDeclaration();
            return;
        }
        if (firstToken == PyTokenTypes.WITH_KEYWORD) {
            this.parseWithStatement(this.myBuilder.mark());
            return;
        }
        if (firstToken == PyTokenTypes.ASYNC_KEYWORD) {
            this.parseAsyncStatement(false);
            return;
        }
        if (this.atToken(PyTokenTypes.IDENTIFIER, TOK_TYPE) && this.parseTypeAliasStatement()) {
            return;
        }
        if (this.atToken(PyTokenTypes.IDENTIFIER, TOK_ASYNC) && this.parseAsyncStatement(true)) {
            return;
        }
        if (this.atToken(PyTokenTypes.IDENTIFIER, TOK_MATCH) && this.parseMatchStatement()) {
            return;
        }
        this.parseSimpleStatement();
    }

    private boolean parseTypeAliasStatement() {
        assert (this.atToken(PyTokenTypes.IDENTIFIER, TOK_TYPE));
        SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
        this.myBuilder.remapCurrentToken((IElementType)PyTokenTypes.TYPE_KEYWORD);
        this.nextToken();
        if (!this.atToken(PyTokenTypes.IDENTIFIER)) {
            mark.rollbackTo();
            this.myBuilder.remapCurrentToken((IElementType)PyTokenTypes.IDENTIFIER);
            return false;
        }
        this.parseIdentifierOrSkip(PyTokenTypes.LBRACKET, PyTokenTypes.EQ);
        this.parseTypeParameterList();
        this.checkMatches(PyTokenTypes.EQ, PyParsingBundle.message("PARSE.eq.expected", new Object[0]));
        this.myContext.getExpressionParser().parseExpression();
        this.checkEndOfStatement();
        mark.done(PyElementTypes.TYPE_ALIAS_STATEMENT);
        return true;
    }

    private boolean parseMatchStatement() {
        assert (this.atToken(PyTokenTypes.IDENTIFIER, TOK_MATCH));
        SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
        this.myBuilder.remapCurrentToken((IElementType)PyTokenTypes.MATCH_KEYWORD);
        this.myBuilder.advanceLexer();
        boolean followedBySubject = this.myContext.getExpressionParser().parseExpressionOptional();
        if (!followedBySubject || !this.matchToken(PyTokenTypes.COLON)) {
            mark.rollbackTo();
            this.myBuilder.remapCurrentToken((IElementType)PyTokenTypes.IDENTIFIER);
            return false;
        }
        this.parseCaseClauses();
        mark.done((IElementType)PyElementTypes.MATCH_STATEMENT);
        return true;
    }

    private boolean parseCaseClauses() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            boolean indentFound;
            this.myBuilder.advanceLexer();
            boolean bl = indentFound = this.myBuilder.getTokenType() == PyTokenTypes.INDENT;
            if (indentFound) {
                this.myBuilder.advanceLexer();
                while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != PyTokenTypes.DEDENT) {
                    if (this.parseCaseClause()) continue;
                    SyntaxTreeBuilder.Marker illegalStatement = this.myBuilder.mark();
                    this.parseStatement();
                    illegalStatement.error(PyParsingBundle.message("PARSE.expected.case.clause", new Object[0]));
                }
                if (!this.myBuilder.eof()) {
                    assert (this.myBuilder.getTokenType() == PyTokenTypes.DEDENT);
                    this.myBuilder.advanceLexer();
                }
            } else {
                this.myBuilder.error(PyParsingBundle.message("indent.expected", new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean parseCaseClause() {
        if (this.atToken(PyTokenTypes.IDENTIFIER, TOK_CASE)) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            this.myBuilder.remapCurrentToken((IElementType)PyTokenTypes.CASE_KEYWORD);
            this.myBuilder.advanceLexer();
            if (!this.getPatternParser().parseCasePattern()) {
                SyntaxTreeBuilder.Marker patternError = this.myBuilder.mark();
                while (!this.myBuilder.eof() && !this.atAnyOfTokens(PyTokenTypes.IF_KEYWORD, PyTokenTypes.COLON, PyTokenTypes.STATEMENT_BREAK)) {
                    this.nextToken();
                }
                patternError.error(PyParsingBundle.message("PARSE.expected.pattern", new Object[0]));
            }
            if (this.matchToken(PyTokenTypes.IF_KEYWORD) && !this.getExpressionParser().parseNamedTestExpression(false, false)) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
            }
            this.parseColonAndSuite();
            mark.done((IElementType)PyElementTypes.CASE_CLAUSE);
            return true;
        }
        return false;
    }

    protected void parseSimpleStatement() {
        this.parseSimpleStatement(true);
    }

    protected void parseSimpleStatement(boolean checkLanguageLevel) {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        IElementType firstToken = builder.getTokenType();
        if (firstToken == null) {
            return;
        }
        if (firstToken == PyTokenTypes.PRINT_KEYWORD && this.hasPrintStatement()) {
            this.parsePrintStatement(builder);
            return;
        }
        if (firstToken == PyTokenTypes.ASSERT_KEYWORD) {
            this.parseAssertStatement();
            return;
        }
        if (firstToken == PyTokenTypes.BREAK_KEYWORD) {
            this.parseKeywordStatement(builder, PyElementTypes.BREAK_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.CONTINUE_KEYWORD) {
            this.parseKeywordStatement(builder, PyElementTypes.CONTINUE_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.DEL_KEYWORD) {
            this.parseDelStatement();
            return;
        }
        if (firstToken == PyTokenTypes.EXEC_KEYWORD) {
            this.parseExecStatement();
            return;
        }
        if (firstToken == PyTokenTypes.GLOBAL_KEYWORD) {
            this.parseNameDefiningStatement(PyElementTypes.GLOBAL_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.NONLOCAL_KEYWORD) {
            this.parseNameDefiningStatement(PyElementTypes.NONLOCAL_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.IMPORT_KEYWORD) {
            this.parseImportStatement(PyElementTypes.IMPORT_STATEMENT, PyElementTypes.IMPORT_ELEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.FROM_KEYWORD) {
            this.parseFromImportStatement();
            return;
        }
        if (firstToken == PyTokenTypes.PASS_KEYWORD) {
            this.parseKeywordStatement(builder, PyElementTypes.PASS_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.RETURN_KEYWORD) {
            this.parseReturnStatement(builder);
            return;
        }
        if (firstToken == PyTokenTypes.RAISE_KEYWORD) {
            this.parseRaiseStatement();
            return;
        }
        SyntaxTreeBuilder.Marker exprStatement = builder.mark();
        if (builder.getTokenType() == PyTokenTypes.YIELD_KEYWORD) {
            this.getExpressionParser().parseYieldOrTupleExpression(false);
            this.checkEndOfStatement();
            exprStatement.done((IElementType)PyElementTypes.EXPRESSION_STATEMENT);
            return;
        }
        if (this.getExpressionParser().parseExpressionOptional()) {
            PyElementType statementType;
            block26: {
                statementType = PyElementTypes.EXPRESSION_STATEMENT;
                if (PyTokenTypes.AUG_ASSIGN_OPERATIONS.contains(builder.getTokenType())) {
                    statementType = PyElementTypes.AUG_ASSIGNMENT_STATEMENT;
                    builder.advanceLexer();
                    if (!this.getExpressionParser().parseYieldOrTupleExpression(false)) {
                        builder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
                    }
                } else if (this.atToken(PyTokenTypes.EQ) || this.atToken(PyTokenTypes.COLON) && (!checkLanguageLevel || this.myContext.getLanguageLevel().isPy3K())) {
                    exprStatement.rollbackTo();
                    exprStatement = builder.mark();
                    this.getExpressionParser().parseExpression(false, true);
                    LOG.assertTrue(builder.getTokenType() == PyTokenTypes.EQ || builder.getTokenType() == PyTokenTypes.COLON, (Object)builder.getTokenType());
                    if (builder.getTokenType() == PyTokenTypes.COLON) {
                        statementType = PyElementTypes.TYPE_DECLARATION_STATEMENT;
                        this.getFunctionParser().parseParameterAnnotation();
                    }
                    if (builder.getTokenType() == PyTokenTypes.EQ) {
                        SyntaxTreeBuilder.Marker maybeExprMarker;
                        statementType = PyElementTypes.ASSIGNMENT_STATEMENT;
                        builder.advanceLexer();
                        while (true) {
                            boolean isYieldExpr;
                            maybeExprMarker = builder.mark();
                            boolean bl = isYieldExpr = builder.getTokenType() == PyTokenTypes.YIELD_KEYWORD;
                            if (!this.getExpressionParser().parseYieldOrTupleExpression(false)) {
                                maybeExprMarker.drop();
                                builder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
                                break block26;
                            }
                            if (builder.getTokenType() != PyTokenTypes.EQ) break;
                            if (isYieldExpr) {
                                maybeExprMarker.drop();
                                builder.error(PyParsingBundle.message("cannot.assign.to.yield.expression", new Object[0]));
                            } else {
                                maybeExprMarker.rollbackTo();
                                this.getExpressionParser().parseExpression(false, true);
                                LOG.assertTrue(builder.getTokenType() == PyTokenTypes.EQ, (Object)builder.getTokenType());
                            }
                            builder.advanceLexer();
                        }
                        maybeExprMarker.drop();
                    }
                }
            }
            this.checkEndOfStatement();
            exprStatement.done((IElementType)statementType);
            return;
        }
        exprStatement.drop();
        builder.advanceLexer();
        this.reportParseStatementError(builder, firstToken);
    }

    protected void reportParseStatementError(SyntaxTreeBuilder builder, IElementType firstToken) {
        if (firstToken == PyTokenTypes.INCONSISTENT_DEDENT) {
            builder.error(PyParsingBundle.message("unindent.does.not.match.any.outer.indent", new Object[0]));
        } else if (firstToken == PyTokenTypes.INDENT) {
            builder.error(PyParsingBundle.message("unexpected.indent", new Object[0]));
        } else {
            builder.error(PyParsingBundle.message("statement.expected.found.0", firstToken.toString()));
        }
    }

    protected boolean hasPrintStatement() {
        return this.myContext.getLanguageLevel().hasPrintStatement() && !this.myFutureFlags.contains((Object)FutureFeature.PRINT_FUNCTION);
    }

    protected void checkEndOfStatement() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        ParsingScope scope = this.getParsingContext().getScope();
        if (builder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            builder.advanceLexer();
            scope.setAfterSemicolon(false);
        } else if (builder.getTokenType() == PyTokenTypes.SEMICOLON) {
            if (!scope.isSuite()) {
                builder.advanceLexer();
                scope.setAfterSemicolon(true);
                if (builder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
                    builder.advanceLexer();
                    scope.setAfterSemicolon(false);
                }
            }
        } else if (!builder.eof()) {
            builder.error(PyParsingBundle.message("end.of.statement.expected", new Object[0]));
        }
    }

    private void parsePrintStatement(SyntaxTreeBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == PyTokenTypes.PRINT_KEYWORD);
        SyntaxTreeBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == PyTokenTypes.GTGT) {
            SyntaxTreeBuilder.Marker target = builder.mark();
            builder.advanceLexer();
            this.getExpressionParser().parseSingleExpression(false);
            target.done((IElementType)PyElementTypes.PRINT_TARGET);
        } else {
            this.getExpressionParser().parseSingleExpression(false);
        }
        while (builder.getTokenType() == PyTokenTypes.COMMA) {
            builder.advanceLexer();
            if (this.getEndOfStatementsTokens().contains(builder.getTokenType())) break;
            this.getExpressionParser().parseSingleExpression(false);
        }
        this.checkEndOfStatement();
        statement.done((IElementType)PyElementTypes.PRINT_STATEMENT);
    }

    protected void parseKeywordStatement(SyntaxTreeBuilder builder, IElementType statementType) {
        SyntaxTreeBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        this.checkEndOfStatement();
        statement.done(statementType);
    }

    private void parseReturnStatement(SyntaxTreeBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == PyTokenTypes.RETURN_KEYWORD);
        SyntaxTreeBuilder.Marker returnStatement = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() != null && !this.getEndOfStatementsTokens().contains(builder.getTokenType())) {
            this.getExpressionParser().parseExpression();
        }
        this.checkEndOfStatement();
        returnStatement.done((IElementType)PyElementTypes.RETURN_STATEMENT);
    }

    private void parseDelStatement() {
        this.assertCurrentToken(PyTokenTypes.DEL_KEYWORD);
        SyntaxTreeBuilder.Marker delStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getExpressionParser().parseSingleExpression(false)) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
        }
        while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            this.myBuilder.advanceLexer();
            if (this.getEndOfStatementsTokens().contains(this.myBuilder.getTokenType()) || this.getExpressionParser().parseSingleExpression(false)) continue;
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
        }
        this.checkEndOfStatement();
        delStatement.done((IElementType)PyElementTypes.DEL_STATEMENT);
    }

    private void parseRaiseStatement() {
        this.assertCurrentToken(PyTokenTypes.RAISE_KEYWORD);
        SyntaxTreeBuilder.Marker raiseStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getEndOfStatementsTokens().contains(this.myBuilder.getTokenType())) {
            this.getExpressionParser().parseSingleExpression(false);
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                this.getExpressionParser().parseSingleExpression(false);
                if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                    this.myBuilder.advanceLexer();
                    this.getExpressionParser().parseSingleExpression(false);
                }
            } else if (this.myBuilder.getTokenType() == PyTokenTypes.FROM_KEYWORD) {
                this.myBuilder.advanceLexer();
                if (!this.getExpressionParser().parseSingleExpression(false)) {
                    this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
                }
            }
        }
        this.checkEndOfStatement();
        raiseStatement.done((IElementType)PyElementTypes.RAISE_STATEMENT);
    }

    private void parseAssertStatement() {
        this.assertCurrentToken(PyTokenTypes.ASSERT_KEYWORD);
        SyntaxTreeBuilder.Marker assertStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.getExpressionParser().parseSingleExpression(false)) {
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                if (!this.getExpressionParser().parseSingleExpression(false)) {
                    this.myContext.getBuilder().error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
                }
            }
            this.checkEndOfStatement();
        } else {
            this.myContext.getBuilder().error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
        }
        assertStatement.done((IElementType)PyElementTypes.ASSERT_STATEMENT);
    }

    protected void parseImportStatement(IElementType statementType, IElementType elementType) {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        SyntaxTreeBuilder.Marker importStatement = builder.mark();
        builder.advanceLexer();
        this.parseImportElements(elementType, true, false, false);
        this.checkEndOfStatement();
        importStatement.done(statementType);
    }

    private void parseFromImportStatement() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        this.assertCurrentToken(PyTokenTypes.FROM_KEYWORD);
        this.myFutureImportPhase = Phase.FROM;
        SyntaxTreeBuilder.Marker fromImportStatement = builder.mark();
        builder.advanceLexer();
        boolean from_future = false;
        boolean had_dots = this.parseRelativeImportDots();
        IElementType statementType = PyElementTypes.FROM_IMPORT_STATEMENT;
        if (had_dots && this.parseOptionalDottedName() || this.parseDottedName()) {
            ImportTypes types = this.checkFromImportKeyword();
            statementType = types.statement;
            IElementType elementType = types.element;
            if (this.myFutureImportPhase == Phase.FUTURE) {
                this.myFutureImportPhase = Phase.IMPORT;
                from_future = true;
            }
            if (builder.getTokenType() == PyTokenTypes.MULT) {
                SyntaxTreeBuilder.Marker star_import_mark = builder.mark();
                builder.advanceLexer();
                star_import_mark.done(types.starElement);
            } else if (builder.getTokenType() == PyTokenTypes.LPAR) {
                builder.advanceLexer();
                this.parseImportElements(elementType, false, true, from_future);
                this.checkMatches(PyTokenTypes.RPAR, PyParsingBundle.message("PARSE.expected.rpar", new Object[0]));
            } else {
                this.parseImportElements(elementType, false, false, from_future);
            }
        } else if (had_dots) {
            ImportTypes types = this.checkFromImportKeyword();
            statementType = types.statement;
            this.parseImportElements(types.element, false, false, from_future);
        }
        this.checkEndOfStatement();
        fromImportStatement.done(statementType);
        this.myFutureImportPhase = Phase.NONE;
    }

    protected ImportTypes checkFromImportKeyword() {
        this.checkMatches(PyTokenTypes.IMPORT_KEYWORD, PyParsingBundle.message("import.expected", new Object[0]));
        return new ImportTypes(PyElementTypes.FROM_IMPORT_STATEMENT, PyElementTypes.IMPORT_ELEMENT, PyElementTypes.STAR_IMPORT_ELEMENT);
    }

    private boolean parseRelativeImportDots() {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        boolean had_dots = false;
        while (builder.getTokenType() == PyTokenTypes.DOT) {
            had_dots = true;
            builder.advanceLexer();
        }
        return had_dots;
    }

    private void parseImportElements(IElementType elementType, boolean is_module_import, boolean in_parens, boolean from_future) {
        SyntaxTreeBuilder builder = this.myContext.getBuilder();
        do {
            SyntaxTreeBuilder.Marker asMarker = builder.mark();
            if (is_module_import) {
                if (!this.parseDottedNameAsAware(false)) {
                    asMarker.drop();
                    break;
                }
            } else {
                String token_text = this.parseIdentifier(this.getReferenceType());
                if (from_future && TOK_PRINT_FUNCTION.equals(token_text)) {
                    this.myFutureFlags.add(FutureFeature.PRINT_FUNCTION);
                }
            }
            if (builder.getTokenType() == PyTokenTypes.AS_KEYWORD) {
                builder.advanceLexer();
                this.parseIdentifier(PyElementTypes.TARGET_EXPRESSION);
            }
            asMarker.done(elementType);
            if (builder.getTokenType() != PyTokenTypes.COMMA) break;
            builder.advanceLexer();
        } while (!in_parens || builder.getTokenType() != PyTokenTypes.RPAR);
    }

    @Nullable
    private String parseIdentifier(IElementType elementType) {
        SyntaxTreeBuilder.Marker idMarker = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
            String id_text = this.myBuilder.getTokenText();
            this.myBuilder.advanceLexer();
            idMarker.done(elementType);
            return id_text;
        }
        this.myBuilder.error(PyParsingBundle.message("PARSE.expected.identifier", new Object[0]));
        idMarker.drop();
        return null;
    }

    public boolean parseOptionalDottedName() {
        return this.parseDottedNameAsAware(true);
    }

    public boolean parseDottedName() {
        return this.parseDottedNameAsAware(false);
    }

    protected boolean parseDottedNameAsAware(boolean optional) {
        if (this.myBuilder.getTokenType() != PyTokenTypes.IDENTIFIER) {
            if (optional) {
                return true;
            }
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.identifier", new Object[0]));
            return false;
        }
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        marker.done(this.getReferenceType());
        while (this.myBuilder.getTokenType() == PyTokenTypes.DOT) {
            marker = marker.precede();
            this.myBuilder.advanceLexer();
            this.checkMatches(PyTokenTypes.IDENTIFIER, PyParsingBundle.message("PARSE.expected.identifier", new Object[0]));
            marker.done(this.getReferenceType());
        }
        return true;
    }

    private void parseNameDefiningStatement(PyElementType elementType) {
        SyntaxTreeBuilder.Marker globalStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.parseIdentifier(PyElementTypes.TARGET_EXPRESSION);
        while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            this.myBuilder.advanceLexer();
            this.parseIdentifier(PyElementTypes.TARGET_EXPRESSION);
        }
        this.checkEndOfStatement();
        globalStatement.done((IElementType)elementType);
    }

    private void parseExecStatement() {
        this.assertCurrentToken(PyTokenTypes.EXEC_KEYWORD);
        SyntaxTreeBuilder.Marker execStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.getExpressionParser().parseExpression(true, false);
        if (this.myBuilder.getTokenType() == PyTokenTypes.IN_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.getExpressionParser().parseSingleExpression(false);
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                this.getExpressionParser().parseSingleExpression(false);
            }
        }
        this.checkEndOfStatement();
        execStatement.done((IElementType)PyElementTypes.EXEC_STATEMENT);
    }

    protected void parseIfStatement(PyElementType ifKeyword, PyElementType elifKeyword, PyElementType elseKeyword, PyElementType elementType) {
        this.assertCurrentToken(ifKeyword);
        SyntaxTreeBuilder.Marker ifStatement = this.myBuilder.mark();
        SyntaxTreeBuilder.Marker ifPart = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getExpressionParser().parseNamedTestExpression(false, false)) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
        }
        this.parseColonAndSuite();
        ifPart.done((IElementType)PyElementTypes.IF_PART_IF);
        SyntaxTreeBuilder.Marker elifPart = this.myBuilder.mark();
        while (this.myBuilder.getTokenType() == elifKeyword) {
            this.myBuilder.advanceLexer();
            if (!this.getExpressionParser().parseNamedTestExpression(false, false)) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
            }
            this.parseColonAndSuite();
            elifPart.done((IElementType)PyElementTypes.IF_PART_ELIF);
            elifPart = this.myBuilder.mark();
        }
        elifPart.drop();
        SyntaxTreeBuilder.Marker elsePart = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == elseKeyword) {
            this.myBuilder.advanceLexer();
            this.parseColonAndSuite();
            elsePart.done((IElementType)PyElementTypes.ELSE_PART);
        } else {
            elsePart.drop();
        }
        ifStatement.done((IElementType)elementType);
    }

    private boolean expectColon() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.COLON) {
            this.myBuilder.advanceLexer();
            return true;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.colon", new Object[0]));
            return true;
        }
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        while (!this.atAnyOfTokens(null, PyTokenTypes.DEDENT, PyTokenTypes.STATEMENT_BREAK, PyTokenTypes.COLON)) {
            this.myBuilder.advanceLexer();
        }
        boolean result = this.matchToken(PyTokenTypes.COLON);
        if (!result && this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
            this.myBuilder.advanceLexer();
        }
        marker.error(PyParsingBundle.message("PARSE.expected.colon", new Object[0]));
        return result;
    }

    private void parseForStatement(SyntaxTreeBuilder.Marker endMarker) {
        this.assertCurrentToken(PyTokenTypes.FOR_KEYWORD);
        this.parseForPart();
        SyntaxTreeBuilder.Marker elsePart = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.ELSE_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.parseColonAndSuite();
            elsePart.done((IElementType)PyElementTypes.ELSE_PART);
        } else {
            elsePart.drop();
        }
        endMarker.done((IElementType)PyElementTypes.FOR_STATEMENT);
    }

    protected void parseForPart() {
        SyntaxTreeBuilder.Marker forPart = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.getExpressionParser().parseStarTargets();
        this.checkMatches(PyTokenTypes.IN_KEYWORD, PyParsingBundle.message("PARSE.expected.in", new Object[0]));
        this.getExpressionParser().parseExpression();
        this.parseColonAndSuite();
        forPart.done((IElementType)PyElementTypes.FOR_PART);
    }

    private void parseWhileStatement() {
        this.assertCurrentToken(PyTokenTypes.WHILE_KEYWORD);
        SyntaxTreeBuilder.Marker statement = this.myBuilder.mark();
        SyntaxTreeBuilder.Marker whilePart = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getExpressionParser().parseNamedTestExpression(false, false)) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
        }
        this.parseColonAndSuite();
        whilePart.done((IElementType)PyElementTypes.WHILE_PART);
        SyntaxTreeBuilder.Marker elsePart = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.ELSE_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.parseColonAndSuite();
            elsePart.done((IElementType)PyElementTypes.ELSE_PART);
        } else {
            elsePart.drop();
        }
        statement.done((IElementType)PyElementTypes.WHILE_STATEMENT);
    }

    private void parseTryStatement() {
        this.assertCurrentToken(PyTokenTypes.TRY_KEYWORD);
        SyntaxTreeBuilder.Marker statement = this.myBuilder.mark();
        SyntaxTreeBuilder.Marker tryPart = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.parseColonAndSuite();
        tryPart.done((IElementType)PyElementTypes.TRY_PART);
        boolean haveExceptClause = false;
        if (this.myBuilder.getTokenType() == PyTokenTypes.EXCEPT_KEYWORD) {
            haveExceptClause = true;
            while (this.myBuilder.getTokenType() == PyTokenTypes.EXCEPT_KEYWORD) {
                this.parseExceptClause();
            }
            SyntaxTreeBuilder.Marker elsePart = this.myBuilder.mark();
            if (this.myBuilder.getTokenType() == PyTokenTypes.ELSE_KEYWORD) {
                this.myBuilder.advanceLexer();
                this.parseColonAndSuite();
                elsePart.done((IElementType)PyElementTypes.ELSE_PART);
            } else {
                elsePart.drop();
            }
        }
        SyntaxTreeBuilder.Marker finallyPart = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.FINALLY_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.parseColonAndSuite();
            finallyPart.done((IElementType)PyElementTypes.FINALLY_PART);
        } else {
            finallyPart.drop();
            if (!haveExceptClause) {
                this.myBuilder.error(PyParsingBundle.message("except.or.finally.expected", new Object[0]));
            }
        }
        statement.done((IElementType)PyElementTypes.TRY_EXCEPT_STATEMENT);
    }

    private void parseExceptClause() {
        SyntaxTreeBuilder.Marker exceptBlock = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        boolean star = this.matchToken(PyTokenTypes.MULT);
        if (this.myBuilder.getTokenType() != PyTokenTypes.COLON) {
            if (this.myContext.getLanguageLevel().isAtLeast(LanguageLevel.PYTHON314)) {
                if (!this.getExpressionParser().parseExpressionOptional(false)) {
                    this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
                }
                if (this.myBuilder.getTokenType() == PyTokenTypes.AS_KEYWORD) {
                    this.myBuilder.advanceLexer();
                    if (!this.getExpressionParser().parseSingleExpression(true)) {
                        this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
                    }
                }
            } else {
                if (!this.getExpressionParser().parseSingleExpression(false)) {
                    this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
                }
                if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA || this.myBuilder.getTokenType() == PyTokenTypes.AS_KEYWORD) {
                    this.myBuilder.advanceLexer();
                    if (!this.getExpressionParser().parseSingleExpression(true)) {
                        this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
                    }
                }
            }
        } else if (star) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
        }
        this.parseColonAndSuite();
        exceptBlock.done(PyElementTypes.EXCEPT_PART);
    }

    private void parseColonAndSuite() {
        if (this.expectColon()) {
            this.parseSuite();
        } else {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            mark.done(PyElementTypes.STATEMENT_LIST);
        }
    }

    private void parseWithStatement(SyntaxTreeBuilder.Marker endMarker) {
        this.assertCurrentToken(PyTokenTypes.WITH_KEYWORD);
        this.myBuilder.advanceLexer();
        if (!this.parseParenthesizedWithItems() && !this.parseWithItems(false)) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
        }
        this.parseColonAndSuite();
        endMarker.done((IElementType)PyElementTypes.WITH_STATEMENT);
    }

    private boolean parseParenthesizedWithItems() {
        if (!this.atToken(PyTokenTypes.LPAR)) {
            return false;
        }
        SyntaxTreeBuilder.Marker leftPar = this.myBuilder.mark();
        this.nextToken();
        if (!this.parseWithItems(true)) {
            leftPar.rollbackTo();
            return false;
        }
        if (!this.matchToken(PyTokenTypes.RPAR)) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.rpar", new Object[0]));
        }
        if (!this.atAnyOfTokens(PyTokenTypes.COLON, PyTokenTypes.STATEMENT_BREAK)) {
            leftPar.rollbackTo();
            return false;
        }
        leftPar.drop();
        return true;
    }

    private boolean parseWithItems(boolean insideParentheses) {
        if (!this.parseWithItem()) {
            return false;
        }
        while (this.matchToken(PyTokenTypes.COMMA)) {
            if (this.parseWithItem()) continue;
            if (insideParentheses) break;
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
            break;
        }
        return true;
    }

    private boolean parseWithItem() {
        SyntaxTreeBuilder.Marker withItem = this.myBuilder.mark();
        if (!this.getExpressionParser().parseSingleExpression(false)) {
            withItem.drop();
            return false;
        }
        if (this.matchToken(PyTokenTypes.AS_KEYWORD) && !this.getExpressionParser().parseSingleExpression(true)) {
            this.myBuilder.error(PyParsingBundle.message("PARSE.expected.identifier", new Object[0]));
        }
        withItem.done((IElementType)PyElementTypes.WITH_ITEM);
        return true;
    }

    private void parseClassDeclaration() {
        SyntaxTreeBuilder.Marker classMarker = this.myBuilder.mark();
        this.parseClassDeclaration(classMarker);
    }

    public void parseClassDeclaration(SyntaxTreeBuilder.Marker classMarker) {
        this.assertCurrentToken(PyTokenTypes.CLASS_KEYWORD);
        this.myBuilder.advanceLexer();
        this.parseIdentifierOrSkip(PyTokenTypes.LPAR, PyTokenTypes.LBRACKET, PyTokenTypes.COLON);
        this.parseTypeParameterList();
        if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
            this.getExpressionParser().parseArgumentList();
        } else {
            SyntaxTreeBuilder.Marker inheritMarker = this.myBuilder.mark();
            inheritMarker.done((IElementType)PyElementTypes.ARGUMENT_LIST);
        }
        ParsingContext context = this.getParsingContext();
        context.pushScope(context.getScope().withClass());
        this.parseColonAndSuite();
        context.popScope();
        classMarker.done(PyElementTypes.CLASS_DECLARATION);
    }

    private boolean parseAsyncStatement(boolean falseAsync) {
        if (!falseAsync) {
            this.assertCurrentToken(PyTokenTypes.ASYNC_KEYWORD);
        }
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        this.advanceAsync(falseAsync);
        IElementType token = this.myBuilder.getTokenType();
        if (token == PyTokenTypes.DEF_KEYWORD) {
            this.getFunctionParser().parseFunctionDeclaration(marker, true);
            return true;
        }
        if (token == PyTokenTypes.WITH_KEYWORD) {
            this.parseWithStatement(marker);
            return true;
        }
        if (token == PyTokenTypes.FOR_KEYWORD) {
            this.parseForStatement(marker);
            return true;
        }
        if (falseAsync) {
            marker.rollbackTo();
        } else {
            marker.drop();
            this.myBuilder.error(PyParsingBundle.message("def.or.with.or.for.expected", new Object[0]));
        }
        return false;
    }

    public void parseSuite() {
        this.parseSuite(null, null);
    }

    public void parseSuite(@Nullable SyntaxTreeBuilder.Marker endMarker, @Nullable IElementType elType) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            boolean indentFound;
            this.myBuilder.advanceLexer();
            SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
            boolean bl = indentFound = this.myBuilder.getTokenType() == PyTokenTypes.INDENT;
            if (indentFound) {
                this.myBuilder.advanceLexer();
                while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != PyTokenTypes.DEDENT) {
                    this.parseStatement();
                }
            } else {
                this.myBuilder.error(PyParsingBundle.message("indent.expected", new Object[0]));
            }
            marker.done(PyElementTypes.STATEMENT_LIST);
            marker.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)LeadingCommentsBinder.INSTANCE, (WhitespacesAndCommentsBinder)FollowingCommentBinder.INSTANCE);
            if (endMarker != null) {
                endMarker.done(elType);
            }
            if (indentFound && !this.myBuilder.eof()) {
                assert (this.myBuilder.getTokenType() == PyTokenTypes.DEDENT);
                this.myBuilder.advanceLexer();
            }
        } else {
            SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
            if (this.myBuilder.eof()) {
                this.myBuilder.error(PyParsingBundle.message("expected.statement", new Object[0]));
            } else {
                ParsingContext context = this.getParsingContext();
                context.pushScope(context.getScope().withSuite());
                this.parseSimpleStatement();
                context.popScope();
                while (this.matchToken(PyTokenTypes.SEMICOLON) && !this.matchToken(PyTokenTypes.STATEMENT_BREAK)) {
                    context.pushScope(context.getScope().withSuite());
                    this.parseSimpleStatement();
                    context.popScope();
                }
            }
            marker.done(PyElementTypes.STATEMENT_LIST);
            if (endMarker != null) {
                endMarker.done(elType);
            }
        }
    }

    public void parseTypeParameterList() {
        if (this.atToken(PyTokenTypes.LBRACKET)) {
            SyntaxTreeBuilder.Marker typeParamList = this.myBuilder.mark();
            this.nextToken();
            do {
                if (!this.parseTypeParameter()) {
                    this.myBuilder.error(PyParsingBundle.message("PARSE.expected.type.parameter", new Object[0]));
                }
                if (this.atToken(PyTokenTypes.COMMA)) {
                    this.nextToken();
                    continue;
                }
                if (!this.atToken(PyTokenTypes.RBRACKET)) break;
            } while (!this.atToken(PyTokenTypes.RBRACKET));
            this.checkMatches(PyTokenTypes.RBRACKET, PyParsingBundle.message("PARSE.expected.symbols", ",", "]"));
            typeParamList.done(PyElementTypes.TYPE_PARAMETER_LIST);
        }
    }

    private boolean parseTypeParameter() {
        if (StatementParsing.isIdentifier(this.myBuilder) || this.atToken(PyTokenTypes.MULT) || this.atToken(PyTokenTypes.EXP)) {
            SyntaxTreeBuilder.Marker typeParamMarker = this.myBuilder.mark();
            if (this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP)) {
                this.nextToken();
            }
            if (!this.parseIdentifierOrSkip(PyTokenTypes.RBRACKET, PyTokenTypes.COMMA, PyTokenTypes.COLON, PyTokenTypes.EQ)) {
                typeParamMarker.drop();
                return false;
            }
            if (this.matchToken(PyTokenTypes.COLON) && !this.myContext.getExpressionParser().parseSingleExpression(false)) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
            }
            if (this.matchToken(PyTokenTypes.EQ) && !this.myContext.getExpressionParser().parseSingleExpression(false)) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.expression", new Object[0]));
            }
            typeParamMarker.done(PyElementTypes.TYPE_PARAMETER);
            return true;
        }
        return false;
    }

    @NotNull
    public IElementType filter(@NotNull IElementType source, int start, int end, @NotNull CharSequence text) {
        if (source == null) {
            StatementParsing.$$$reportNull$$$0(0);
        }
        if (text == null) {
            StatementParsing.$$$reportNull$$$0(1);
        }
        IElementType iElementType = this.filter(source, start, end, text, true);
        if (iElementType == null) {
            StatementParsing.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    @NotNull
    protected IElementType filter(@NotNull IElementType source, int start, int end, @NotNull CharSequence text, boolean checkLanguageLevel) {
        if (source == null) {
            StatementParsing.$$$reportNull$$$0(3);
        }
        if (text == null) {
            StatementParsing.$$$reportNull$$$0(4);
        }
        if (source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text, start, end, TOK_AS)) {
            PyElementType pyElementType = PyTokenTypes.AS_KEYWORD;
            if (pyElementType == null) {
                StatementParsing.$$$reportNull$$$0(5);
            }
            return pyElementType;
        }
        if (this.myFutureImportPhase == Phase.FROM && source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text, start, end, TOK_FUTURE_IMPORT)) {
            this.myFutureImportPhase = Phase.FUTURE;
            IElementType iElementType = source;
            if (iElementType == null) {
                StatementParsing.$$$reportNull$$$0(6);
            }
            return iElementType;
        }
        if (source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text, start, end, TOK_WITH)) {
            PyElementType pyElementType = PyTokenTypes.WITH_KEYWORD;
            if (pyElementType == null) {
                StatementParsing.$$$reportNull$$$0(7);
            }
            return pyElementType;
        }
        if (this.hasPrintStatement() && source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text, start, end, TOK_PRINT)) {
            PyElementType pyElementType = PyTokenTypes.PRINT_KEYWORD;
            if (pyElementType == null) {
                StatementParsing.$$$reportNull$$$0(8);
            }
            return pyElementType;
        }
        if ((this.myContext.getLanguageLevel().isPy3K() || !checkLanguageLevel) && source == PyTokenTypes.IDENTIFIER) {
            if (StatementParsing.isWordAtPosition(text, start, end, TOK_NONE)) {
                PyElementType pyElementType = PyTokenTypes.NONE_KEYWORD;
                if (pyElementType == null) {
                    StatementParsing.$$$reportNull$$$0(9);
                }
                return pyElementType;
            }
            if (StatementParsing.isWordAtPosition(text, start, end, TOK_TRUE)) {
                PyElementType pyElementType = PyTokenTypes.TRUE_KEYWORD;
                if (pyElementType == null) {
                    StatementParsing.$$$reportNull$$$0(10);
                }
                return pyElementType;
            }
            if (StatementParsing.isWordAtPosition(text, start, end, TOK_FALSE)) {
                PyElementType pyElementType = PyTokenTypes.FALSE_KEYWORD;
                if (pyElementType == null) {
                    StatementParsing.$$$reportNull$$$0(11);
                }
                return pyElementType;
            }
            if (StatementParsing.isWordAtPosition(text, start, end, TOK_DEBUG)) {
                PyElementType pyElementType = PyTokenTypes.DEBUG_KEYWORD;
                if (pyElementType == null) {
                    StatementParsing.$$$reportNull$$$0(12);
                }
                return pyElementType;
            }
            if (StatementParsing.isWordAtPosition(text, start, end, TOK_NONLOCAL)) {
                PyElementType pyElementType = PyTokenTypes.NONLOCAL_KEYWORD;
                if (pyElementType == null) {
                    StatementParsing.$$$reportNull$$$0(13);
                }
                return pyElementType;
            }
            LanguageLevel languageLevel = this.myContext.getLanguageLevel();
            if (languageLevel.isAtLeast(LanguageLevel.PYTHON35) || !checkLanguageLevel) {
                if (StatementParsing.isWordAtPosition(text, start, end, TOK_ASYNC) && (languageLevel.isAtLeast(LanguageLevel.PYTHON37) || this.myContext.getScope().isAsync() || this.myBuilder.lookAhead(1) == PyTokenTypes.DEF_KEYWORD)) {
                    PyElementType pyElementType = PyTokenTypes.ASYNC_KEYWORD;
                    if (pyElementType == null) {
                        StatementParsing.$$$reportNull$$$0(14);
                    }
                    return pyElementType;
                }
                if (StatementParsing.isWordAtPosition(text, start, end, TOK_AWAIT) && (languageLevel.isAtLeast(LanguageLevel.PYTHON37) || this.myContext.getScope().isAsync())) {
                    PyElementType pyElementType = PyTokenTypes.AWAIT_KEYWORD;
                    if (pyElementType == null) {
                        StatementParsing.$$$reportNull$$$0(15);
                    }
                    return pyElementType;
                }
            }
        } else if ((this.myContext.getLanguageLevel().isPython2() || !checkLanguageLevel) && source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text, start, end, TOK_EXEC)) {
            PyElementType pyElementType = PyTokenTypes.EXEC_KEYWORD;
            if (pyElementType == null) {
                StatementParsing.$$$reportNull$$$0(16);
            }
            return pyElementType;
        }
        IElementType iElementType = source;
        if (iElementType == null) {
            StatementParsing.$$$reportNull$$$0(17);
        }
        return iElementType;
    }

    protected TokenSet getEndOfStatementsTokens() {
        return PyTokenTypes.END_OF_STATEMENT;
    }

    private static boolean isWordAtPosition(CharSequence text, int start, int end, String tokenText) {
        return CharArrayUtil.regionMatches((CharSequence)text, (int)start, (int)end, (CharSequence)tokenText) && end - start == tokenText.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/parsing/StatementParsing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/parsing/StatementParsing";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    protected static enum Phase {
        NONE,
        FROM,
        FUTURE,
        IMPORT;

    }

    public static class ImportTypes {
        public final IElementType statement;
        public final IElementType element;
        public IElementType starElement;

        public ImportTypes(IElementType statement, IElementType element, IElementType starElement) {
            this.statement = statement;
            this.element = element;
            this.starElement = starElement;
        }
    }
}

