/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.GeometryKt;
import org.jetbrains.letsPlot.commons.interval.IntSpan;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u001aL\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\b\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\b\u0007\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u001a<\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001aB\u0010\u0010\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0006\u001a4\u0010\u0011\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0002\u001a:\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\u000e\u001aB\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00012\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u000e\u001a+\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0004\"\u0006\b\u0000\u0010\u0002\u0018\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0086\b\u001a@\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\u000e\u001a2\u0010\u0019\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u001a\b\u0002\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\u000e\u001a&\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u000bH\u0002\u00a8\u0006\u001c"}, d2={"calculateArea", "", "T", "ring", "", "x", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "y", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "findRingIntervals", "Lorg/jetbrains/letsPlot/commons/interval/IntSpan;", "path", "eq", "Lkotlin/Function2;", "", "isClockwise", "isRingNormalized", "makeClosed", "normalizeRing", "reduce", "points", "dropDistance", "distance", "splitRings", "isClosed", "sublist", "range", "commons"})
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\norg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/GeometryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1804#2,4:139\n1549#2:143\n1620#2,3:144\n1313#3,2:147\n1313#3,2:149\n1#4:151\n*S KotlinDebug\n*F\n+ 1 Geometry.kt\norg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/GeometryKt\n*L\n13#1:139,4\n25#1:143\n25#1:144,3\n64#1:147,2\n85#1:149,2\n*E\n"})
public final class GeometryKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> reduce(@NotNull List<? extends T> points2, double dropDistance, @NotNull Function2<? super T, ? super T, Double> distance) {
        void $this$foldIndexed$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter(points2, (String)"points");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        Iterable iterable = points2;
        List list2 = new ArrayList();
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void el;
            void acc;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = element$iv;
            void var13_12 = accumulator$iv;
            int i = n;
            boolean bl = false;
            if (i == 0) {
                acc.add(el);
            } else if (i == CollectionsKt.getLastIndex(points2)) {
                acc.add(el);
            } else if (((Number)distance.invoke(CollectionsKt.last((List)acc), (Object)el)).doubleValue() >= dropDistance) {
                acc.add(el);
            }
            accumulator$iv = acc;
        }
        return accumulator$iv;
    }

    public static final /* synthetic */ <T> List<List<T>> splitRings(List<? extends T> points2) {
        Intrinsics.checkNotNullParameter(points2, (String)"points");
        boolean $i$f$splitRings = false;
        Intrinsics.needClassReification();
        return GeometryKt.splitRings(points2, splitRings.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<List<T>> splitRings(@NotNull List<? extends T> points2, @NotNull Function2<? super T, ? super T, Boolean> eq) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(points2, (String)"points");
        Intrinsics.checkNotNullParameter(eq, (String)"eq");
        Iterable $this$map$iv = GeometryKt.findRingIntervals(points2, eq);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IntSpan intSpan = (IntSpan)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GeometryKt.sublist(points2, (IntSpan)p0));
        }
        List rings = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (!((Collection)rings).isEmpty() && !GeometryKt.isClosed((List)CollectionsKt.last((List)rings), eq)) {
            rings.set(CollectionsKt.getLastIndex((List)rings), GeometryKt.makeClosed((List)CollectionsKt.last((List)rings)));
        }
        return rings;
    }

    private static final <T> List<T> makeClosed(List<? extends T> path2) {
        return CollectionsKt.plus((Collection)CollectionsKt.toMutableList((Collection)path2), (Object)CollectionsKt.first(path2));
    }

    public static final <T> boolean isClosed(@NotNull List<? extends T> $this$isClosed, @NotNull Function2<? super T, ? super T, Boolean> eq) {
        Intrinsics.checkNotNullParameter($this$isClosed, (String)"<this>");
        Intrinsics.checkNotNullParameter(eq, (String)"eq");
        return (Boolean)eq.invoke(CollectionsKt.first($this$isClosed), CollectionsKt.last($this$isClosed));
    }

    public static /* synthetic */ boolean isClosed$default(List list2, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            function2 = isClosed.1.INSTANCE;
        }
        return GeometryKt.isClosed(list2, function2);
    }

    private static final <T> List<IntSpan> findRingIntervals(List<? extends T> path2, Function2<? super T, ? super T, Boolean> eq) {
        ArrayList<IntSpan> intervals = new ArrayList<IntSpan>();
        int startIndex = 0;
        int n = path2.size();
        for (int i = 0; i < n; ++i) {
            if (startIndex == i || !((Boolean)eq.invoke(path2.get(startIndex), path2.get(i))).booleanValue()) continue;
            intervals.add(new IntSpan(startIndex, i + 1));
            startIndex = i + 1;
        }
        if (startIndex != path2.size()) {
            intervals.add(new IntSpan(startIndex, path2.size()));
        }
        return intervals;
    }

    public static final <T> boolean isRingNormalized(@NotNull List<? extends T> ring, @NotNull Function2<? super T, ? super T, Boolean> eq) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        Intrinsics.checkNotNullParameter(eq, (String)"eq");
        if (ring.isEmpty()) {
            return true;
        }
        boolean isRingOpened = false;
        isRingOpened = true;
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)ring), (int)1);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            if (!((Boolean)eq.invoke(it, CollectionsKt.first(ring))).booleanValue()) {
                if (isRingOpened) continue;
                return false;
            }
            isRingOpened = !isRingOpened;
        }
        return !isRingOpened;
    }

    @NotNull
    public static final <T> List<T> normalizeRing(@NotNull List<? extends T> ring, @NotNull Function2<? super T, ? super T, Boolean> eq) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        Intrinsics.checkNotNullParameter(eq, (String)"eq");
        if (GeometryKt.isRingNormalized(ring, eq)) {
            return ring;
        }
        List normalizedRing = new ArrayList();
        normalizedRing.add(CollectionsKt.first(ring));
        boolean isRingOpened = false;
        isRingOpened = true;
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)ring), (int)1);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            if (!((Boolean)eq.invoke(it, CollectionsKt.first(ring))).booleanValue()) {
                if (!isRingOpened) {
                    normalizedRing.add(CollectionsKt.first(ring));
                    isRingOpened = true;
                }
            } else {
                isRingOpened = !isRingOpened;
            }
            normalizedRing.add(it);
        }
        if (isRingOpened) {
            normalizedRing.add(CollectionsKt.first(ring));
        }
        return normalizedRing;
    }

    private static final <T> List<T> sublist(List<? extends T> $this$sublist, IntSpan range) {
        return $this$sublist.subList(range.getLowerEnd(), range.getUpperEnd());
    }

    public static final double calculateArea(@NotNull List<DoubleVector> ring) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        return GeometryKt.calculateArea(ring, (Function1)calculateArea.1.INSTANCE, (Function1)calculateArea.2.INSTANCE);
    }

    public static final <T> boolean isClockwise(@NotNull List<? extends T> ring, @NotNull Function1<? super T, Double> x2, @NotNull Function1<? super T, Double> y2) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        Intrinsics.checkNotNullParameter(x2, (String)"x");
        Intrinsics.checkNotNullParameter(y2, (String)"y");
        if (!(!((Collection)ring).isEmpty())) {
            boolean bl = false;
            String string = "Ring shouldn't be empty to calculate clockwise";
            throw new IllegalStateException(string.toString());
        }
        double sum2 = 0.0;
        T prev = ring.get(ring.size() - 1);
        for (T point2 : ring) {
            sum2 += ((Number)x2.invoke(prev)).doubleValue() * ((Number)y2.invoke(point2)).doubleValue() - ((Number)x2.invoke(point2)).doubleValue() * ((Number)y2.invoke(prev)).doubleValue();
            prev = point2;
        }
        return sum2 < 0.0;
    }

    public static final <T> double calculateArea(@NotNull List<? extends T> ring, @NotNull Function1<? super T, Double> x2, @NotNull Function1<? super T, Double> y2) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        Intrinsics.checkNotNullParameter(x2, (String)"x");
        Intrinsics.checkNotNullParameter(y2, (String)"y");
        double area2 = 0.0;
        int j = ring.size() - 1;
        int i = 0;
        int n = ring.size();
        while (i < n) {
            T p1 = ring.get(i);
            T p2 = ring.get(j);
            area2 += (((Number)x2.invoke(p2)).doubleValue() + ((Number)x2.invoke(p1)).doubleValue()) * (((Number)y2.invoke(p2)).doubleValue() - ((Number)y2.invoke(p1)).doubleValue());
            j = i++;
        }
        return Math.abs(area2 / (double)2);
    }
}

