/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.maven;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.maven.MavenDiagramCategoryManager;
import com.intellij.uml.maven.MavenElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

final class MavenUmlElementManager
extends AbstractDiagramElementManager<MavenElement> {
    MavenUmlElementManager() {
    }

    @Override
    @Nullable
    public MavenElement findInDataContext(@NotNull DataContext context) {
        PsiFile psiFile;
        Project project;
        if (context == null) {
            MavenUmlElementManager.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            return null;
        }
        if (!(MavenDataKeys.MAVEN_PROJECTS_TREE.getData(context) != null || (psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null && "pom.xml".equalsIgnoreCase(psiFile.getName()))) {
            return null;
        }
        MavenProject mavenProject = MavenActionUtil.getMavenProject((DataContext)context);
        return mavenProject == null ? null : new MavenElement(project, mavenProject, null);
    }

    @Override
    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof MavenElement;
    }

    @Override
    @Nls
    @NotNull
    public String getElementTitle(MavenElement element) {
        return MavenUmlElementManager.getPresentableName(element, null);
    }

    @Override
    @NotNull
    public String getElementTitle(MavenElement element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            MavenUmlElementManager.$$$reportNull$$$0(1);
        }
        String classifier = MavenUmlElementManager.getElementClassifier(element);
        String string = MavenUmlElementManager.getPresentableName(element, builder.getDataModel().getNodeContentManager()) + (String)(StringUtil.isNotEmpty((String)classifier) ? " :" + classifier : "");
        if (string == null) {
            MavenUmlElementManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String getPresentableName(MavenElement element, @Nullable DiagramNodeContentManager nodeContentManager) {
        Object elementName = element.getName();
        if (nodeContentManager != null && nodeContentManager.isCategoryEnabled(MavenDiagramCategoryManager.ARTIFACTS_FQN)) {
            MavenId id = element.getMavenId();
            elementName = id.getGroupId() + ":" + id.getArtifactId() + ":" + id.getVersion();
        }
        String string = elementName;
        if (string == null) {
            MavenUmlElementManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    private static String getElementClassifier(MavenElement element) {
        MavenArtifactNode artifactNode = element.getArtifact();
        if (artifactNode == null) {
            return null;
        }
        MavenArtifact artifact = artifactNode.getArtifact();
        if (artifact == null) {
            return null;
        }
        return artifact.getClassifier();
    }

    @Override
    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            MavenUmlElementManager.$$$reportNull$$$0(4);
        }
        if (element instanceof MavenElement) {
            MavenElement mavenElement = (MavenElement)element;
            int style = 1;
            if (mavenElement.getState() == MavenArtifactState.EXCLUDED) {
                style = 4;
            }
            SimpleTextAttributes attr = new SimpleTextAttributes(style, mavenElement.getTitleColor());
            return new SimpleColoredText(MavenUmlElementManager.getPresentableName(mavenElement, null), attr);
        }
        return null;
    }

    @Override
    @Nullable
    @Nls
    public String getNodeTooltip(MavenElement element) {
        return element.getDescription();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/maven/MavenUmlElementManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/maven/MavenUmlElementManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementTitle";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

