/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.NoCredentialsAuthProvider;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.util.AsyncTaskKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExceptionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0016\u0018\u0000 %2\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J,\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u001a\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/database/dataSource/DatabaseCredentialsAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "<init>", "()V", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "getId", "", "getDisplayName", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "loadAuthConfig", "Lcom/intellij/database/dataSource/DatabaseCredentialsAuthProvider$UserPassCredentials;", "external", "saveAuthConfig", "", "data", "", "setNewPassword", "newPass", "UserPassCredentials", "Companion", "intellij.database.core.impl"})
public class DatabaseCredentialsAuthProvider
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String USER_KEY = "user";
    @NotNull
    private static final String PASSWORD_KEY = "password";

    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        return DatabaseCredentialsAuthProvider.interceptConnection$suspendImpl(this, proto2, silent, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object interceptConnection$suspendImpl(DatabaseCredentialsAuthProvider var0, DatabaseConnectionInterceptor.ProtoConnection var1_1, boolean var2_2, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof interceptConnection.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseCredentialsAuthProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseCredentialsAuthProvider.interceptConnection$suspendImpl(this.this$0, null, false, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = DatabaseCredentialsAuthProvider.Companion.applyInitialCredentials((DatabaseConnectionInterceptor.ProtoConnection)proto, silent != false, (Continuation<? super Unit>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        AuthWidgetBuilder builder = DatabaseCoreUiService.getInstance().createAuthWidgetBuilder();
        AuthWidgetBuilder authWidgetBuilder = builder;
        return authWidgetBuilder != null && (authWidgetBuilder = authWidgetBuilder.addUserField()) != null && (authWidgetBuilder = authWidgetBuilder.addPasswordField()) != null ? authWidgetBuilder.build(project, credentials, config) : null;
    }

    @Override
    @NotNull
    public String getId() {
        return "user-pass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("database.auth.type.user.password", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        boolean applicable;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        LocalDataSource localDataSource = point.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        boolean bl = applicable = !NoCredentialsAuthProvider.Companion.isAuthRequired(localDataSource, false, false);
        if (!applicable) {
            DatabaseDriver driver = DbImplUtilCore.guessDatabaseDriver(point.getDbms());
            applicable = driver == null || !driver.isPredefined();
        }
        return (applicable ? DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT : DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE).clamp(level);
    }

    @Override
    @Nullable
    public UserPassCredentials loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return Companion.loadCredentialsConfig(point, credentials, external);
    }

    @Override
    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Companion.saveCredentialsConfig(config, credentials, data instanceof UserPassCredentials ? (UserPassCredentials)data : null, external);
    }

    @Override
    public void setNewPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable String newPass) {
        Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
        Companion.applyNewPassword(proto2, newPass);
    }

    @JvmStatic
    @Nullable
    public static final UserPassCredentials loadCredentialsConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        return Companion.loadCredentialsConfig(point, credentials, external);
    }

    @JvmStatic
    public static final void saveCredentialsConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable UserPassCredentials data, boolean external) {
        Companion.saveCredentialsConfig(config, credentials, data, external);
    }

    @JvmStatic
    public static final void applyNewPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable String newPass) {
        Companion.applyNewPassword(proto2, newPass);
    }

    @JvmStatic
    @Nullable
    public static final Credentials extractCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection p2) {
        return Companion.extractCredentials(p2);
    }

    @JvmStatic
    @NotNull
    public static final DatabaseConnectionInterceptor.ProtoConnection applyCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable Credentials credentials, boolean cancelOnEmpty) {
        return Companion.applyCredentials(proto2, credentials, cancelOnEmpty);
    }

    @JvmStatic
    @Nullable
    public static final Credentials getCredentials(@Nullable LocalDataSource dataSource) {
        return Companion.getCredentials(dataSource);
    }

    static {
        Logger logger2 = Logger.getInstance(DatabaseCredentialsAuthProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0007J\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010 JD\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u001c\u0010#\u001a\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00110$2\u0006\u0010\u001f\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010'J1\u0010(\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\r\u0010)\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u0011H\u0007J7\u0010.\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\r\u0010)\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010/J\"\u00100\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u001c2\u0006\u00101\u001a\u00020\u0011H\u0007J\u0010\u00102\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u00103\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u00104\u001a\u0004\u0018\u00010\u001c2\b\u00105\u001a\u0004\u0018\u000106H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/database/dataSource/DatabaseCredentialsAuthProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "USER_KEY", "", "PASSWORD_KEY", "loadCredentialsConfig", "Lcom/intellij/database/dataSource/DatabaseCredentialsAuthProvider$UserPassCredentials;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "", "saveCredentialsConfig", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "applyNewPassword", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "newPass", "extractCredentials", "Lcom/intellij/credentialStore/Credentials;", "p", "applyInitialCredentials", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "provider", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "applier", "Lkotlin/Function2;", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Lcom/intellij/database/dataSource/DatabaseAuthProvider;Lkotlin/jvm/functions/Function2;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "askNoCredentials", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "askCredentialsWhenFailedSync", "message", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "error", "", "unsure", "askCredentialsWhenFailed", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/String;Ljava/lang/Throwable;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyCredentials", "cancelOnEmpty", "getUser", "getPassword", "getCredentials", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final UserPassCredentials loadCredentialsConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
            LocalDataSource.Storage storage;
            String user;
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            String string = user = external ? null : LocalDataSource.getUsername(point);
            if (external) {
                storage = LocalDataSource.Storage.MEMORY;
            } else {
                LocalDataSource.Storage storage2 = LocalDataSource.getPasswordStorage(point);
                storage = storage2;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)storage2), (String)"getPasswordStorage(...)");
            }
            LocalDataSource.Storage storage3 = storage;
            DatabaseCredentials databaseCredentials = credentials;
            OneTimeString password = databaseCredentials != null ? DatabaseCredentials.loadPassword$default(databaseCredentials, point, null, 2, null) : null;
            UserPassCredentials res2 = new UserPassCredentials(user, password, storage3);
            return res2.isEmpty() ? null : res2;
        }

        @JvmStatic
        public final void saveCredentialsConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable UserPassCredentials data, boolean external) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                if (!external) {
                    UserPassCredentials userPassCredentials = data;
                    LocalDataSource.setUsername(config, userPassCredentials != null ? userPassCredentials.username : null);
                    Object object = data;
                    if (object == null || (object = object.storage) == null) {
                        object = LocalDataSource.Storage.MEMORY;
                    }
                    LocalDataSource.setPasswordStorage(config, (LocalDataSource.Storage)((Object)object));
                }
                DatabaseCredentials databaseCredentials = credentials;
                if (databaseCredentials == null) break block2;
                UserPassCredentials userPassCredentials = data;
                databaseCredentials.storePassword(config, (OneTimeString)(userPassCredentials != null ? userPassCredentials.password : null));
            }
        }

        @JvmStatic
        public final void applyNewPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable String newPass) {
            Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
            DatabaseCredentials databaseCredentials = proto2.getCredentials();
            LocalDataSource localDataSource = proto2.getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            DatabaseConnectionConfig databaseConnectionConfig = localDataSource;
            String string = newPass;
            Intrinsics.checkNotNull((Object)string);
            databaseCredentials.storePassword(databaseConnectionConfig, new OneTimeString(string));
            this.applyCredentials(proto2, new Credentials(this.getUser(proto2), newPass), false);
        }

        @JvmStatic
        @Nullable
        public final Credentials extractCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection p2) {
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
            String user = this.getUser(p2);
            String pass = this.getPassword(p2);
            return StringUtil.isEmpty((String)user) && StringUtil.isEmpty((String)pass) ? null : new Credentials(user, pass);
        }

        @Nullable
        public final Object applyInitialCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Unit> $completion) {
            DatabaseConnectionPoint point = proto2.getConnectionPoint();
            LocalDataSource localDataSource = point.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource = localDataSource;
            boolean canAskPassword = !silent;
            LocalDataSource.Storage storage = LocalDataSource.getPasswordStorage(point);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)storage), (String)"getPasswordStorage(...)");
            LocalDataSource.Storage passwordStorage = storage;
            if (!passwordStorage.isPersisted() && dataSource.isConfiguredByUrl()) {
                JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(dataSource);
                boolean hardcoded = parsed != null && parsed.isValid() && parsed.getParameter(DatabaseCredentialsAuthProvider.PASSWORD_KEY) != null;
                canAskPassword &= !hardcoded;
            }
            Object object = DatabaseCredentials.Companion.getInitialCredentials(passwordStorage, canAskPassword, (Function1)new Function1<Continuation<? super Boolean>, Object>(proto2, point, null){
                int label;
                final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                final /* synthetic */ DatabaseConnectionPoint $point;
                {
                    this.$proto = $proto;
                    this.$point = $point;
                    super(1, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Credentials>, Object>(this.$proto, this.$point, null){
                                int label;
                                final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                                final /* synthetic */ DatabaseConnectionPoint $point;
                                {
                                    this.$proto = $proto;
                                    this.$point = $point;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            return this.$proto.getCredentials().getCredentials(this.$point);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Credentials> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            c = (Credentials)v0;
                            DatabaseCredentialsAuthProvider.Companion.applyCredentials(this.$proto, c, false);
                            return Boxing.boxBoolean((boolean)(c.getPassword() == null));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Boolean> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }, (Function2)new Function2<Throwable, Continuation<? super Boolean>, Object>(proto2, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                {
                    this.$proto = $proto;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    void $result;
                    Throwable th;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            th = (Throwable)this.L$0;
                            if (th != null) break;
                            this.label = 1;
                            Object object3 = com.intellij.database.dataSource.DatabaseCredentialsAuthProvider$Companion.access$askNoCredentials(DatabaseCredentialsAuthProvider.Companion, this.$proto, (Continuation)this);
                            if (object3 != object2) return Boxing.boxBoolean((boolean)false);
                            return object2;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Boxing.boxBoolean((boolean)false);
                        }
                    }
                    this.label = 2;
                    Object object4 = DatabaseCredentialsAuthProvider.Companion.askCredentialsWhenFailed(this.$proto, th.getMessage(), th, false, (Continuation<? super Unit>)((Continuation)this));
                    if (object4 != object2) return Boxing.boxBoolean((boolean)false);
                    return object2;
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return Boxing.boxBoolean((boolean)false);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(Throwable p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, Companion::applyInitialCredentials$lambda$0, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Nullable
        public final Object applyInitialCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull DatabaseAuthProvider provider, @NotNull Function2<? super DatabaseConnectionInterceptor.ProtoConnection, Object, Boolean> applier, boolean silent, @NotNull Continuation<? super Unit> $completion) {
            DatabaseConnectionPoint point = proto2.getConnectionPoint();
            LocalDataSource localDataSource = point.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource = localDataSource;
            boolean canAskPassword = !silent;
            LocalDataSource.Storage storage = LocalDataSource.getPasswordStorage(point);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)storage), (String)"getPasswordStorage(...)");
            LocalDataSource.Storage passwordStorage = storage;
            Object object = DatabaseCredentials.Companion.getInitialCredentials(passwordStorage, canAskPassword, (Function1)new Function1<Continuation<? super Boolean>, Object>(provider, point, proto2, applier, null){
                int label;
                final /* synthetic */ DatabaseAuthProvider $provider;
                final /* synthetic */ DatabaseConnectionPoint $point;
                final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                final /* synthetic */ Function2<DatabaseConnectionInterceptor.ProtoConnection, Object, Boolean> $applier;
                {
                    this.$provider = $provider;
                    this.$point = $point;
                    this.$proto = $proto;
                    this.$applier = $applier;
                    super(1, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Object config = this.$provider.loadAuthConfig(this.$point, this.$proto.getCredentials(), false);
                            boolean isEmpty = Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)this.$applier.invoke((Object)this.$proto, config));
                            return Boxing.boxBoolean((isEmpty ? 1 : 0) != 0);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Boolean> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }, (Function2)new Function2<Throwable, Continuation<? super Boolean>, Object>(proto2, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                {
                    this.$proto = $proto;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    void $result;
                    Throwable th;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            th = (Throwable)this.L$0;
                            if (th != null) break;
                            this.label = 1;
                            Object object3 = com.intellij.database.dataSource.DatabaseCredentialsAuthProvider$Companion.access$askNoCredentials(DatabaseCredentialsAuthProvider.Companion, this.$proto, (Continuation)this);
                            if (object3 != object2) return Boxing.boxBoolean((boolean)false);
                            return object2;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Boxing.boxBoolean((boolean)false);
                        }
                    }
                    this.label = 2;
                    Object object4 = DatabaseCredentialsAuthProvider.Companion.askCredentialsWhenFailed(this.$proto, th.getMessage(), th, false, (Continuation<? super Unit>)((Continuation)this));
                    if (object4 != object2) return Boxing.boxBoolean((boolean)false);
                    return object2;
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return Boxing.boxBoolean((boolean)false);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(Throwable p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, Companion::applyInitialCredentials$lambda$1, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        private final Object askNoCredentials(DatabaseConnectionInterceptor.ProtoConnection proto2, Continuation<? super Unit> $completion) {
            Object object = this.askCredentialsWhenFailed(proto2, DatabaseBundle.message("dialog.message.html.please.provide.database.credentials.html", new Object[0]), null, false, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Deprecated(message="Use coroutines", replaceWith=@ReplaceWith(expression="askCredentialsWhenFailed", imports={}))
        public final void askCredentialsWhenFailedSync(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable String message, @Nullable Throwable error, boolean unsure) {
            Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
            com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(proto2, message, error, unsure, null){
                int label;
                final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                final /* synthetic */ String $message;
                final /* synthetic */ Throwable $error;
                final /* synthetic */ boolean $unsure;
                {
                    this.$proto = $proto;
                    this.$message = $message;
                    this.$error = $error;
                    this.$unsure = $unsure;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DatabaseCredentialsAuthProvider.Companion.askCredentialsWhenFailed(this.$proto, this.$message, this.$error, this.$unsure, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Nullable
        public final Object askCredentialsWhenFailed(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable String message, @Nullable Throwable error, boolean unsure, @NotNull Continuation<? super Unit> $completion) {
            DatabaseConnectionPoint point = proto2.getConnectionPoint();
            Project project = proto2.getProject();
            DatabaseCredentials dc = proto2.getCredentials();
            if (project.isDefault()) {
                throw new CancellationException("default project");
            }
            Credentials c1 = dc.getCredentials(point);
            String string = DatabaseBundle.message("progress.title.re.ask.credentials", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object object = AsyncTaskKt.traceableFrame(string, (Function1)new Function1<Continuation<? super Boolean>, Object>(dc, point, c1, error, proto2, message, project, unsure, null){
                int label;
                final /* synthetic */ DatabaseCredentials $dc;
                final /* synthetic */ DatabaseConnectionPoint $point;
                final /* synthetic */ Credentials $c1;
                final /* synthetic */ Throwable $error;
                final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                final /* synthetic */ String $message;
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $unsure;
                {
                    this.$dc = $dc;
                    this.$point = $point;
                    this.$c1 = $c1;
                    this.$error = $error;
                    this.$proto = $proto;
                    this.$message = $message;
                    this.$project = $project;
                    this.$unsure = $unsure;
                    super(1, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$dc, this.$point, this.$c1, this.$error, this.$proto, this.$message, this.$project, this.$unsure, null){
                                int label;
                                final /* synthetic */ DatabaseCredentials $dc;
                                final /* synthetic */ DatabaseConnectionPoint $point;
                                final /* synthetic */ Credentials $c1;
                                final /* synthetic */ Throwable $error;
                                final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                                final /* synthetic */ String $message;
                                final /* synthetic */ Project $project;
                                final /* synthetic */ boolean $unsure;
                                {
                                    this.$dc = $dc;
                                    this.$point = $point;
                                    this.$c1 = $c1;
                                    this.$error = $error;
                                    this.$proto = $proto;
                                    this.$message = $message;
                                    this.$project = $project;
                                    this.$unsure = $unsure;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object var1_1) {
                                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            c2 = this.$dc.getCredentials(this.$point);
                                            if (Intrinsics.areEqual((Object)this.$c1, (Object)c2)) {
                                                this.label = 1;
                                                v0 = com.intellij.openapi.progress.CoroutinesKt.blockingContext((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String java.lang.Throwable com.intellij.database.dataSource.DatabaseConnectionPoint com.intellij.openapi.project.Project com.intellij.database.access.DatabaseCredentials boolean ), ()Lkotlin/Unit;)((String)this.$message, (Throwable)this.$error, (DatabaseConnectionPoint)this.$point, (Project)this.$project, (DatabaseCredentials)this.$dc, (boolean)this.$unsure), (Continuation)((Continuation)this));
                                                ** if (v0 != var5_2) goto lbl13
lbl12:
                                                // 1 sources

                                                return var5_2;
                                            }
lbl13:
                                            // 3 sources

                                            ** GOTO lbl24
                                        }
                                        case 1: {
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
                                            }
                                            catch (ProcessCanceledException e) {
                                                if (this.$error != null) {
                                                    throw this.$error;
                                                }
                                                throw ExceptionsKt.CancellationException(null, (Throwable)e);
                                            }
lbl24:
                                            // 2 sources

                                            v1 = this.$point.getAuthProviderId();
                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getAuthProviderId(...)");
                                            provider = DatabaseAuthProvider.Companion.get(v1);
                                            if (provider == null) {
                                                var4_6 = this.$point.getDataSource();
                                                Intrinsics.checkNotNullExpressionValue((Object)var4_6, (String)"getDataSource(...)");
                                                provider = DatabaseAuthProvider.Companion.getDefault(var4_6);
                                            }
                                            this.label = 2;
                                            v2 = provider.interceptConnection(this.$proto, true, (Continuation<? super Boolean>)((Continuation)this));
                                            if (v2 == var5_2) {
                                                return var5_2;
                                            }
                                            ** GOTO lbl39
                                        }
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl39:
                                            // 2 sources

                                            return v2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final Unit invokeSuspend$lambda$0(String $message, Throwable $error, DatabaseConnectionPoint $point, Project $project, DatabaseCredentials $dc, boolean $unsure) {
                                    DatabaseCoreUiService.getInstance().askCredentials($message, $error != null, $point.getMutableConfig(), $project, $dc, $unsure);
                                    return Unit.INSTANCE;
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Boolean> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final DatabaseConnectionInterceptor.ProtoConnection applyCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable Credentials credentials, boolean cancelOnEmpty) {
            Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
            if (credentials == null && cancelOnEmpty) {
                throw new ProcessCanceledException();
            }
            Credentials credentials2 = credentials;
            String userName = credentials2 != null ? credentials2.getUserName() : null;
            CharSequence charSequence = userName;
            if (!(charSequence == null || charSequence.length() == 0)) {
                LOG.info("Connecting as: " + userName);
                proto2.getConnectionProperties().put(DatabaseCredentialsAuthProvider.USER_KEY, userName);
            } else {
                LOG.info("No user name provided (may be in url)");
                proto2.getConnectionProperties().remove(DatabaseCredentialsAuthProvider.USER_KEY);
            }
            Credentials credentials3 = credentials;
            String password = credentials3 != null ? credentials3.getPasswordAsString() : null;
            CharSequence charSequence2 = password;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                proto2.getConnectionProperties().put(DatabaseCredentialsAuthProvider.PASSWORD_KEY, password);
            } else {
                proto2.getConnectionProperties().remove(DatabaseCredentialsAuthProvider.PASSWORD_KEY);
            }
            return proto2;
        }

        @Nullable
        public final String getUser(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2) {
            Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
            return proto2.getConnectionProperties().get(DatabaseCredentialsAuthProvider.USER_KEY);
        }

        @Nullable
        public final String getPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2) {
            Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
            return proto2.getConnectionProperties().get(DatabaseCredentialsAuthProvider.PASSWORD_KEY);
        }

        @JvmStatic
        @Nullable
        public final Credentials getCredentials(@Nullable LocalDataSource dataSource) {
            return dataSource == null ? null : DatabaseCredentials.Companion.getInstance().getCredentials(dataSource);
        }

        private static final boolean applyInitialCredentials$lambda$0(boolean it) {
            return it;
        }

        private static final boolean applyInitialCredentials$lambda$1(boolean it) {
            return it;
        }

        public static final /* synthetic */ Object access$askNoCredentials(Companion $this, DatabaseConnectionInterceptor.ProtoConnection proto2, Continuation $completion) {
            return $this.askNoCredentials(proto2, (Continuation<? super Unit>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/DatabaseCredentialsAuthProvider$UserPassCredentials;", "", "username", "", "password", "Lcom/intellij/credentialStore/OneTimeString;", "storage", "Lcom/intellij/database/dataSource/LocalDataSource$Storage;", "<init>", "(Ljava/lang/String;Lcom/intellij/credentialStore/OneTimeString;Lcom/intellij/database/dataSource/LocalDataSource$Storage;)V", "(Lcom/intellij/credentialStore/OneTimeString;)V", "equals", "", "other", "hashCode", "", "isEmpty", "intellij.database.core.impl"})
    public static class UserPassCredentials {
        @JvmField
        @Nullable
        public final String username;
        @JvmField
        @Nullable
        public final OneTimeString password;
        @JvmField
        @NotNull
        public final LocalDataSource.Storage storage;

        public UserPassCredentials(@Nullable String username, @Nullable OneTimeString password, @NotNull LocalDataSource.Storage storage) {
            Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
            this.username = username;
            this.password = password;
            this.storage = storage;
        }

        public UserPassCredentials(@Nullable OneTimeString password) {
            this(null, password, LocalDataSource.Storage.MEMORY);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof UserPassCredentials && Intrinsics.areEqual((Object)this.username, (Object)((UserPassCredentials)other).username) && Intrinsics.areEqual((Object)this.password, (Object)((UserPassCredentials)other).password) && this.storage == ((UserPassCredentials)other).storage;
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.username, this.password, this.storage};
            return Objects.hash(objectArray);
        }

        public boolean isEmpty() {
            CharSequence charSequence = this.username;
            return (charSequence == null || charSequence.length() == 0) && this.password == null && this.storage == LocalDataSource.Storage.MEMORY;
        }
    }
}

