/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_31;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "schemaProperties", "", "", "tableProperties", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConverter_4_31.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter_4_31.kt\ncom/intellij/database/model/serialization/converters/Converter_4_31\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class Converter_4_31
extends Converter {
    @NotNull
    public static final Converter_4_31 INSTANCE = new Converter_4_31();
    @NotNull
    private static final Map<String, String> schemaProperties;
    @NotNull
    private static final Map<String, String> tableProperties;

    private Converter_4_31() {
        int[] nArray = new int[]{4, 31};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        if (!modelMem.getDbms().eq(Dbms.CASSANDRA)) {
            return;
        }
        String schemaKind = ObjectKind.SCHEMA.code();
        String tableKind = ObjectKind.TABLE.code();
        for (ModelElementMem node : modelMem.getNodes()) {
            Map<String, String> map2;
            if (Intrinsics.areEqual((Object)node.getKind(), (Object)tableKind)) {
                map2 = tableProperties;
            } else {
                if (!Intrinsics.areEqual((Object)node.getKind(), (Object)schemaKind)) continue;
                map2 = schemaProperties;
            }
            Map<String, String> properties2 = map2;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : properties2.entrySet()) {
                MutableNameAndValue mutableNameAndValue;
                String property = entry.getKey();
                String name2 = entry.getValue();
                if (ModelSerializationFun.remove(node.getProperties(), property) == null) continue;
                boolean bl = false;
                String value = mutableNameAndValue.component2();
                sb.append(name2).append(":").append(value).append("\n");
            }
            if (!(((CharSequence)sb).length() > 0)) continue;
            List<MutableNameAndValue> list = node.getProperties();
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            list.add(new MutableNameAndValue("Properties", string));
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Replication", (Object)"replication"), TuplesKt.to((Object)"DurableWrites", (Object)"durable_writes")};
        schemaProperties = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"BloomFilterFpChance", (Object)"bloom_filter_fp_chance"), TuplesKt.to((Object)"Caching", (Object)"caching"), TuplesKt.to((Object)"Cdc", (Object)"cdc"), TuplesKt.to((Object)"Compaction", (Object)"compaction"), TuplesKt.to((Object)"Compression", (Object)"compression"), TuplesKt.to((Object)"CrcCheckChance", (Object)"crc_check_chance"), TuplesKt.to((Object)"DclocalReadRepairChance", (Object)"dclocal_read_repair_chance"), TuplesKt.to((Object)"DefaultTimeToLive", (Object)"default_time_to_live"), TuplesKt.to((Object)"SpeculativeRetry", (Object)"speculative_retry"), TuplesKt.to((Object)"GcGraceSeconds", (Object)"gc_grace_seconds"), TuplesKt.to((Object)"MaxIndexInterval", (Object)"max_index_interval"), TuplesKt.to((Object)"MemtableFlushPeriodInMs", (Object)"memtable_flush_period_in_ms"), TuplesKt.to((Object)"MinIndexInterval", (Object)"min_index_interval"), TuplesKt.to((Object)"ReadRepairChance", (Object)"read_repair_chance")};
        tableProperties = MapsKt.mapOf((Pair[])pairArray);
    }
}

