/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbObjectImpl;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseDialogsHelperCore;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbRoutineImpl
extends DbObjectImpl<DasRoutine, DbElement>
implements DbRoutine {
    protected DbRoutineImpl(@NotNull DbElement parent, @NotNull DasRoutine delegate) {
        if (parent == null) {
            DbRoutineImpl.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            DbRoutineImpl.$$$reportNull$$$0(1);
        }
        super(parent, delegate);
    }

    @Override
    public String getPackageName() {
        return ((DasRoutine)this.myDelegate).getPackageName();
    }

    @Override
    @NotNull
    public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = ((DasRoutine)this.myDelegate).getRoutineKind();
        if (kind == null) {
            DbRoutineImpl.$$$reportNull$$$0(2);
        }
        return kind;
    }

    @Override
    @NotNull
    public Iterable<? extends DasArgument> getArguments() {
        Iterable<? extends DasArgument> iterable = ((DasRoutine)this.myDelegate).getArguments();
        if (iterable == null) {
            DbRoutineImpl.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    @Override
    @Nullable
    public DasArgument getReturnArgument() {
        return ((DasRoutine)this.myDelegate).getReturnArgument();
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation(boolean hover) {
        StringBuilder sb = this.createDocHeaderColored().cast(StringBuilder.class);
        if (!this.appendDefinition(sb)) {
            sb.append("<br><code><pre>");
            sb.append(this.sql2Html(DatabaseDefinitionHelper.generateDefinition(this, new StringBuilder())));
            sb.append("</pre></code>");
            if (!hover && DbImplUtilCore.canConnectTo(this) && DatabaseDefinitionHelper.isRawDefinitionAvailable(this)) {
                this.scheduleAsyncDocumentationUpdate(sb, this::loadSlowDocumentationInner);
            }
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DbRoutineImpl.$$$reportNull$$$0(4);
        }
        return stringBuilder;
    }

    private void loadSlowDocumentationInner(@NotNull Appendable consumer, @NotNull ConnectionProvider provider) throws Exception {
        if (consumer == null) {
            DbRoutineImpl.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            DbRoutineImpl.$$$reportNull$$$0(6);
        }
        consumer.append("<br>");
        StringBuilder builder = new StringBuilder();
        DatabaseDefinitionHelper.loadDefinition(provider, this, builder);
        if (!builder.toString().trim().isEmpty()) {
            consumer.append("<b>Definition:</b><br><code><pre>");
            consumer.append(this.sql2Html(builder));
            consumer.append("</pre></code>");
        } else {
            consumer.append("<b>No definition found</b>");
        }
    }

    public String getPresentableText() {
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(this);
        String proto2 = dialect.sqlDefinePrototype(DatabaseDialogsHelperCore.createDdlBuilder(this, true), this, false, false).getStatement();
        return StringUtil.notNullize((String)super.getPresentableText()) + StringUtil.shortenTextWithEllipsis((String)proto2, (int)50, (int)1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbRoutineImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbRoutineImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutineKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadSlowDocumentationInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

