/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbObjectCollectionModelApplier;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbStructureFamilyModelApplier<E extends BasicElement, C extends BasicElement>
extends DbObjectCollectionModelApplier<E, C, DbStructureObjectModelState<C>, DbStructureFamilyModelState<C>> {
    private final BasicMetaObject<C> myMeta;
    private final int myWeight;

    public static boolean isFamilyId(@NotNull BasicMetaId id) {
        if (id == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(0);
        }
        return id.name.startsWith("FAMILY_") && id.name.endsWith("_ID");
    }

    public DbStructureFamilyModelApplier(@NotNull BasicMetaObject<C> meta) {
        if (meta == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(1);
        }
        super(BasicMetaId.create("FAMILY_" + meta.kind.name() + "_ID"));
        this.myMeta = meta;
        this.myWeight = DbPresentationCore.getWeight(this.myMeta.kind, 0);
    }

    public int getWeight() {
        return this.myWeight;
    }

    @Override
    protected void removeChildrenSyncPending(@NotNull ElementOwner owner, @NotNull E e) {
        ModFamily<BasicModElement> family;
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(2);
        }
        if (e == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(3);
        }
        if ((family = this.getModFamily(e)) == null) {
            return;
        }
        ArrayList elements = ContainerUtil.newArrayList(family);
        for (BasicModElement c2 : elements) {
            if (!c2.isSyncPending()) continue;
            ElementIdentity<BasicModElement> identity = owner.findIdentity(c2);
            if (identity != null) {
                owner.drop(identity);
                continue;
            }
            c2.drop();
        }
        family.sort();
    }

    @Override
    protected void applyChild(@NotNull ElementOwner owner, @NotNull E e, @NotNull DbModelRef<C, DbStructureObjectModelState<C>> desc) {
        Object object;
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(4);
        }
        if (e == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(5);
        }
        if (desc == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(6);
        }
        if ((object = owner.findOrCreate(desc.getIdentity())) == null) {
            return;
        }
        ((BasicModElement)object).resetSyncPending();
    }

    @Override
    public boolean differsFromImpl(@NotNull DbEditorModel<E, DbStructureFamilyModelState<C>> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(7);
        }
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(8);
        }
        if (e == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(9);
        }
        return false;
    }

    @Nullable
    private ModFamily<BasicModElement> getModFamily(@NotNull E e) {
        BasicMetaObject<BasicModElement> modMeta;
        if (e == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(10);
        }
        return (modMeta = this.getMetaObject().tryCast(BasicModElement.class)) == null ? null : (ModFamily)BasicMetaUtils.getFamily(e, modMeta);
    }

    @Override
    protected void markChildrenSyncPending(@NotNull ElementOwner owner, @NotNull E e) {
        ModFamily<BasicModElement> family;
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(11);
        }
        if (e == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(12);
        }
        if ((family = this.getModFamily(e)) != null) {
            family.markChildrenAsSyncPending();
        }
    }

    @Override
    @NotNull
    protected Iterable<C> extractObjects(@NotNull DbEditorModel<E, DbStructureFamilyModelState<C>> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(13);
        }
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(14);
        }
        if (e == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(15);
        }
        JBIterable jBIterable = owner.getChildren(model.getIdentity(), this.getMetaObject()).filterMap(cId -> owner.findOrCreate(cId)).sort(ModelUtil.DISPLAY_ORDER_COMPARATOR).collect();
        if (jBIterable == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @Override
    public BasicMetaObject<C> getMetaObject() {
        return this.myMeta;
    }

    @Override
    @NotNull
    public DbModelRef<C, DbStructureObjectModelState<C>> createModel(@NotNull DbEditorModel<E, DbStructureFamilyModelState<C>> model, @Nullable ElementIdentity<C> id) {
        if (model == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(17);
        }
        if (id == null) {
            id = this.createObject(model);
        }
        DbEditorModel<C, DbStructureObjectModelState<C>> res2 = model.getController().createStructureNodeModel(id);
        res2.register();
        return new DbModelRef<C, DbStructureObjectModelState<C>>(res2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbStructureFamilyModelApplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbStructureFamilyModelApplier";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFamilyId";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChildrenSyncPending";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyChild";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "differsFromImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModFamily";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "markChildrenSyncPending";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractObjects";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }
}

