/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MetadataXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public MetadataXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public MetadataXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser2, String tagName, String alias, Set<String> parsed) throws XmlPullParserException {
        if (!parser2.getName().equals(tagName) && !parser2.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser2, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser2, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser2, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser2, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser2.getName() + "'", parser2, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser2.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser2, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser2, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser2);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser2) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser2, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser2, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser2, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser2, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser2) throws IOException, XmlPullParserException {
        int eventType = parser2.next();
        if (eventType == 4) {
            eventType = parser2.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser2, null);
        }
        return eventType;
    }

    public Metadata read(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        Metadata metadata = null;
        int eventType = parser2.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"metadata".equals(parser2.getName())) {
                    throw new XmlPullParserException("Expected root element 'metadata' but found '" + parser2.getName() + "'", parser2, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'metadata'", parser2, null);
                }
                metadata = this.parseMetadata(parser2, strict);
                metadata.setModelEncoding(parser2.getInputEncoding());
                parsed = true;
            }
            eventType = parser2.next();
        }
        if (parsed) {
            return metadata;
        }
        throw new XmlPullParserException("Expected root element 'metadata' but found no element at all: invalid XML document", parser2, null);
    }

    public Metadata read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser2 = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser2.setInput(reader);
        return this.read(parser2, strict);
    }

    public Metadata read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Metadata read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(new XmlStreamReader(in), strict);
    }

    public Metadata read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(new XmlStreamReader(in));
    }

    private Metadata parseMetadata(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Metadata metadata = new Metadata();
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0 || "xmlns".equals(name2)) continue;
            if ("modelVersion".equals(name2)) {
                metadata.setModelVersion(this.interpolatedTrimmed(value, "modelVersion"));
                continue;
            }
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                metadata.setGroupId(this.interpolatedTrimmed(parser2.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                metadata.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "versioning", null, parsed)) {
                metadata.setVersioning(this.parseVersioning(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                metadata.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                metadata.setPlugins(plugins);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return metadata;
    }

    private Plugin parsePlugin(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Plugin plugin = new Plugin();
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                plugin.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "prefix", null, parsed)) {
                plugin.setPrefix(this.interpolatedTrimmed(parser2.nextText(), "prefix"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                plugin.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return plugin;
    }

    private Snapshot parseSnapshot(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Snapshot snapshot = new Snapshot();
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "timestamp", null, parsed)) {
                snapshot.setTimestamp(this.interpolatedTrimmed(parser2.nextText(), "timestamp"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "buildNumber", null, parsed)) {
                snapshot.setBuildNumber(this.getIntegerValue(this.interpolatedTrimmed(parser2.nextText(), "buildNumber"), "buildNumber", parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "localCopy", null, parsed)) {
                snapshot.setLocalCopy(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "localCopy"), "localCopy", parser2, "false"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return snapshot;
    }

    private SnapshotVersion parseSnapshotVersion(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        SnapshotVersion snapshotVersion = new SnapshotVersion();
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "classifier", null, parsed)) {
                snapshotVersion.setClassifier(this.interpolatedTrimmed(parser2.nextText(), "classifier"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "extension", null, parsed)) {
                snapshotVersion.setExtension(this.interpolatedTrimmed(parser2.nextText(), "extension"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "value", null, parsed)) {
                snapshotVersion.setVersion(this.interpolatedTrimmed(parser2.nextText(), "value"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "updated", null, parsed)) {
                snapshotVersion.setUpdated(this.interpolatedTrimmed(parser2.nextText(), "updated"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return snapshotVersion;
    }

    private Versioning parseVersioning(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Versioning versioning = new Versioning();
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "latest", null, parsed)) {
                versioning.setLatest(this.interpolatedTrimmed(parser2.nextText(), "latest"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "release", null, parsed)) {
                versioning.setRelease(this.interpolatedTrimmed(parser2.nextText(), "release"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "versions", null, parsed)) {
                ArrayList<String> versions = new ArrayList<String>();
                while (parser2.nextTag() == 2) {
                    if ("version".equals(parser2.getName())) {
                        versions.add(this.interpolatedTrimmed(parser2.nextText(), "versions"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                versioning.setVersions(versions);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "lastUpdated", null, parsed)) {
                versioning.setLastUpdated(this.interpolatedTrimmed(parser2.nextText(), "lastUpdated"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "snapshot", null, parsed)) {
                versioning.setSnapshot(this.parseSnapshot(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "snapshotVersions", null, parsed)) {
                ArrayList<SnapshotVersion> snapshotVersions = new ArrayList<SnapshotVersion>();
                while (parser2.nextTag() == 2) {
                    if ("snapshotVersion".equals(parser2.getName())) {
                        snapshotVersions.add(this.parseSnapshotVersion(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                versioning.setSnapshotVersions(snapshotVersions);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return versioning;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

