/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.Collection;
import java.util.List;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.noding.InteriorIntersectionFinderAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.snapround.HotPixel;
import org.locationtech.jts.noding.snapround.MCIndexPointSnapper;

@Deprecated
public class MCIndexSnapRounder
implements Noder {
    private final PrecisionModel pm;
    private LineIntersector li;
    private final double scaleFactor;
    private MCIndexNoder noder;
    private MCIndexPointSnapper pointSnapper;
    private Collection nodedSegStrings;

    public MCIndexSnapRounder(PrecisionModel pm) {
        this.pm = pm;
        this.li = new RobustLineIntersector();
        this.li.setPrecisionModel(pm);
        this.scaleFactor = pm.getScale();
    }

    @Override
    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }

    @Override
    public void computeNodes(Collection inputSegmentStrings) {
        this.nodedSegStrings = inputSegmentStrings;
        this.noder = new MCIndexNoder();
        this.pointSnapper = new MCIndexPointSnapper(this.noder.getIndex());
        this.snapRound(inputSegmentStrings, this.li);
    }

    private void snapRound(Collection segStrings, LineIntersector li) {
        List intersections = this.findInteriorIntersections(segStrings, li);
        this.computeIntersectionSnaps(intersections);
        this.computeVertexSnaps(segStrings);
    }

    private List findInteriorIntersections(Collection segStrings, LineIntersector li) {
        InteriorIntersectionFinderAdder intFinderAdder = new InteriorIntersectionFinderAdder(li);
        this.noder.setSegmentIntersector(intFinderAdder);
        this.noder.computeNodes(segStrings);
        return intFinderAdder.getInteriorIntersections();
    }

    private void computeIntersectionSnaps(Collection snapPts) {
        for (Coordinate snapPt : snapPts) {
            HotPixel hotPixel = new HotPixel(snapPt, this.scaleFactor);
            this.pointSnapper.snap(hotPixel);
        }
    }

    public void computeVertexSnaps(Collection edges) {
        for (NodedSegmentString edge0 : edges) {
            this.computeVertexSnaps(edge0);
        }
    }

    private void computeVertexSnaps(NodedSegmentString e) {
        Coordinate[] pts0 = e.getCoordinates();
        for (int i2 = 0; i2 < pts0.length; ++i2) {
            HotPixel hotPixel = new HotPixel(pts0[i2], this.scaleFactor);
            boolean isNodeAdded = this.pointSnapper.snap(hotPixel, e, i2);
            if (!isNodeAdded) continue;
            e.addIntersection(pts0[i2], i2);
        }
    }
}

