/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tec.uom.lib.common.function.ValueSupplier;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.function.LogConverter;

public final class ExpConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private static final long serialVersionUID = -8851436813812059827L;
    private final double base;
    private final double logOfBase;

    public ExpConverter(double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
    }

    public static ExpConverter of(double base) {
        return new ExpConverter(base);
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    protected boolean isSimpleCompositionWith(AbstractConverter that) {
        if (that instanceof LogConverter) {
            return ((LogConverter)that).getBase() == this.base;
        }
        return false;
    }

    @Override
    protected AbstractConverter simpleCompose(AbstractConverter that) {
        return AbstractConverter.IDENTITY;
    }

    @Override
    public AbstractConverter inverseWhenNotIdentity() {
        return new LogConverter(this.base);
    }

    @Override
    public final String transformationLiteral() {
        if (this.base == Math.E) {
            return "x -> e^x";
        }
        if (this.base < 0.0) {
            return String.format("x -> (%s)^x", this.base);
        }
        return String.format("x -> %s^x", this.base);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExpConverter) {
            ExpConverter that = (ExpConverter)obj;
            return Objects.equals(this.base, that.base);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base);
    }

    @Override
    public double convertWhenNotIdentity(double amount) {
        return Math.exp(this.logOfBase * amount);
    }

    @Override
    public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.convert(value.doubleValue()));
    }

    @Override
    public boolean isLinear() {
        return false;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof ValueSupplier) {
            return this.getValue().compareTo(String.valueOf(((ValueSupplier)((Object)o)).getValue()));
        }
        return -1;
    }
}

