/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker;

import com.intellij.docker.remote.run.common.PathsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.utils.RemoteDockerRuntimeUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.docker.PyDockerBundle;
import com.intellij.python.docker.RegenerateSkeletonsException;
import com.intellij.python.remoteInterpreter.PyRemoteSkeletonGeneratorBase;
import com.intellij.remote.ExceptionFix;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 (2\u00020\u0001:\u0001(B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0005H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0018H$J\b\u0010\u0019\u001a\u00020\u0005H\u0004J6\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010 H\u0002J6\u0010!\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010 H$J\u0010\u0010$\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u0005H\u0004J\b\u0010&\u001a\u00020\u0005H\u0004J\b\u0010'\u001a\u00020\u0005H$R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/intellij/python/docker/PyDockerSkeletonGeneratorBase;", "Lcom/intellij/python/remoteInterpreter/PyRemoteSkeletonGeneratorBase;", "project", "Lcom/intellij/openapi/project/Project;", "skeletonPath", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "skeletonsVolumeName", "remoteSdkAdditionalData", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;", "getRemoteSdkAdditionalData", "()Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;", "getRemoteSkeletonsPath", "refreshGeneratedSkeletons", "", "removeSkeletonsVolume", "createDockerRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "computeSkeletonsVolumeName", "downloadSources", "srcRemotePath", "targetLocalPath", "volumesBuilder", "Lcom/intellij/docker/remote/run/common/VolumesBuilder;", "map", "", "doDownloadSources", "targetLocalDir", "Ljava/io/File;", "ensureOutputDirectoryExists", "getSkeletonsVolumeName", "prepareSkeletonsVolume", "setupSkeletonsVolume", "Companion", "intellij.python.docker"})
public abstract class PyDockerSkeletonGeneratorBase
extends PyRemoteSkeletonGeneratorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Sdk sdk;
    @Nullable
    private String skeletonsVolumeName;
    @NotNull
    public static final String BIN_TRUE_CMD = "/bin/true";
    @NotNull
    public static final String ROOT_USER = "root";
    @NotNull
    public static final String SKELETONS_CONTAINER_PATH = "/opt/pycharm/skeletons";
    @NotNull
    public static final String SKELETONS_OUTPUT_CONTAINER_PATH = "/opt/pycharm/skeletons/output";

    public PyDockerSkeletonGeneratorBase(@Nullable Project project, @NotNull String skeletonPath, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)skeletonPath, (String)"skeletonPath");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        super(skeletonPath, sdk, null);
        this.project = project;
        this.sdk = sdk;
    }

    @Nullable
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final Sdk getSdk() {
        return this.sdk;
    }

    @NotNull
    protected final PyRemoteSdkAdditionalData getRemoteSdkAdditionalData() {
        SdkAdditionalData sdkAdditionalData = this.sdk.getSdkAdditionalData();
        Intrinsics.checkNotNull((Object)sdkAdditionalData, (String)"null cannot be cast to non-null type com.jetbrains.python.remote.PyRemoteSdkAdditionalData");
        return (PyRemoteSdkAdditionalData)sdkAdditionalData;
    }

    @Override
    @NotNull
    protected String getRemoteSkeletonsPath() {
        return SKELETONS_OUTPUT_CONTAINER_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGeneratedSkeletons() {
        long started = System.currentTimeMillis();
        try {
            String sourcesLocalPath = ((Object)PySdkExtKt.getRemoteSourcesLocalPath((Sdk)this.sdk)).toString();
            List<PyRemoteSourceItem> list = this.listSources(this.sdk, CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"listSources(...)");
            List<PyRemoteSourceItem> sourcesToDownload = list;
            for (PyRemoteSourceItem item : sourcesToDownload) {
                item.setLocalPrefix(item.generateRootFolderName());
            }
            PathMappingSettings pathMappingSettings = this.getRemoteSdkAdditionalData().getPathMappings();
            Intrinsics.checkNotNullExpressionValue((Object)pathMappingSettings, (String)"getPathMappings(...)");
            PathMappingSettings mappingSettings = pathMappingSettings;
            PathsBuilder pathsBuilder = PathsBuilder.builder();
            Intrinsics.checkNotNullExpressionValue((Object)pathsBuilder, (String)"builder(...)");
            PathsBuilder remotePathsBuilder = pathsBuilder;
            for (PyRemoteSourceItem item : sourcesToDownload) {
                item.addRootMappingTo(mappingSettings, sourcesLocalPath);
                remotePathsBuilder.addPath(item.getRootPath());
            }
            SdkModificator sdkModificator = this.sdk.getSdkModificator();
            SdkModificator $this$refreshGeneratedSkeletons_u24lambda_u243 = sdkModificator;
            boolean bl = false;
            SdkAdditionalData sdkAdditionalData = $this$refreshGeneratedSkeletons_u24lambda_u243.getSdkAdditionalData();
            Intrinsics.checkNotNull((Object)sdkAdditionalData, (String)"null cannot be cast to non-null type com.jetbrains.python.remote.PyRemoteSdkAdditionalData");
            ((PyRemoteSdkAdditionalData)sdkAdditionalData).setPathMappings(mappingSettings);
            Application it = ApplicationManager.getApplication();
            boolean bl2 = false;
            it.invokeAndWait(() -> PyDockerSkeletonGeneratorBase.refreshGeneratedSkeletons$lambda$3$lambda$2$lambda$1(it, $this$refreshGeneratedSkeletons_u24lambda_u243));
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (PyRemoteSourceItem item : sourcesToDownload) {
                map.put(item.getPath(), item.getLocalRelativePath());
            }
            for (String path2 : remotePathsBuilder.build()) {
                Intrinsics.checkNotNull((Object)path2);
                VolumesBuilder volumesBuilder = VolumesBuilder.builder();
                Intrinsics.checkNotNullExpressionValue((Object)volumesBuilder, (String)"builder(...)");
                this.downloadSources(path2, sourcesLocalPath, volumesBuilder, (Map<String, String>)map);
            }
            VolumesBuilder volumesBuilder = VolumesBuilder.builder();
            String string = this.skeletonsVolumeName;
            Intrinsics.checkNotNull((Object)string);
            VolumesBuilder volumesBuilder2 = volumesBuilder.addBoundVolume(SKELETONS_CONTAINER_PATH, string, true);
            Intrinsics.checkNotNullExpressionValue((Object)volumesBuilder2, (String)"addBoundVolume(...)");
            VolumesBuilder volumesBuilder3 = volumesBuilder2;
            String string2 = this.getRemoteSkeletonsPath();
            String string3 = this.getSkeletonsPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSkeletonsPath(...)");
            this.downloadSources(string2, string3, volumesBuilder3, null);
        }
        catch (InvalidSdkException e) {
            PyRemoteSkeletonGeneratorBase.LOG.info((Throwable)e);
        }
        catch (ExecutionException e) {
            PyRemoteSkeletonGeneratorBase.LOG.info((Throwable)e);
        }
        finally {
            this.removeSkeletonsVolume();
        }
        long time = PyRemoteSkeletonGeneratorBase.doneIn(started);
        PyRemoteSkeletonGeneratorBase.LOG.info("Sources and skeletons are loaded in " + time + " millis.");
    }

    private final void removeSkeletonsVolume() {
        block3: {
            String string = this.skeletonsVolumeName;
            if (string == null) break block3;
            String it = string;
            boolean bl = false;
            try {
                RemoteDockerRuntime dockerRuntime = this.createDockerRuntime();
                RemoteDockerRuntimeUtil.executeAgentTask((CompletableFuture)dockerRuntime.getAgent().removeVolume(it));
                PyRemoteSkeletonGeneratorBase.LOG.debug("Docker volume \"" + it + "\" used for skeletons and remote sources removed");
            }
            catch (ServerRuntimeException e) {
                PyRemoteSkeletonGeneratorBase.LOG.debug("Error occurred while finish skeletons generation", (Throwable)e);
            }
            catch (RemoteSdkException e) {
                PyRemoteSkeletonGeneratorBase.LOG.debug("Error occurred while finish skeletons generation", (Throwable)e);
            }
        }
    }

    @NotNull
    protected abstract RemoteDockerRuntime createDockerRuntime() throws ServerRuntimeException, RemoteSdkException;

    @NotNull
    protected final String computeSkeletonsVolumeName() {
        String string = this.sdk.getHomePath();
        if (string == null) {
            throw new IllegalStateException("Home path must not be null for SDK " + this.sdk);
        }
        String homePath = string;
        return "pycharm_skeletons_" + FileUtil.toSystemIndependentName((String)homePath).hashCode();
    }

    private final void downloadSources(String srcRemotePath, String targetLocalPath, VolumesBuilder volumesBuilder, Map<String, String> map) throws InvalidSdkException {
        try {
            File targetLocalDir = this.ensureOutputDirectoryExists(targetLocalPath);
            this.doDownloadSources(srcRemotePath, targetLocalDir, volumesBuilder, map);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{srcRemotePath, targetLocalPath};
            throw new InvalidSdkException(PyDockerBundle.message("failed.to.download.remote.sources", objectArray), (Throwable)e);
        }
        catch (ServerRuntimeException e) {
            Object[] objectArray = new Object[]{srcRemotePath, targetLocalPath};
            throw new InvalidSdkException(PyDockerBundle.message("failed.to.download.remote.sources", objectArray), (Throwable)e);
        }
        catch (RemoteSdkException e) {
            throw new InvalidSdkException(e.getMessage(), (Throwable)e);
        }
        PyDockerSkeletonGeneratorBase.Companion.refreshDownloadedSources(targetLocalPath);
    }

    protected abstract void doDownloadSources(@NotNull String var1, @NotNull File var2, @NotNull VolumesBuilder var3, @Nullable Map<String, String> var4) throws RemoteSdkException, IOException, ServerRuntimeException;

    private final File ensureOutputDirectoryExists(String targetLocalPath) throws IOException {
        File outputDirectory = new File(targetLocalPath);
        if (outputDirectory.exists()) {
            if (!outputDirectory.isDirectory()) {
                throw new IOException("Output path " + targetLocalPath + " exists but it is not a directory");
            }
        } else if (!outputDirectory.mkdirs()) {
            throw new IOException("Failed to create output directories " + targetLocalPath);
        }
        return outputDirectory;
    }

    @NotNull
    protected final String getSkeletonsVolumeName() {
        String string = this.sdk.getHomePath();
        Intrinsics.checkNotNull((Object)string);
        return "pycharm_skeletons_" + FileUtil.toSystemIndependentName((String)string).hashCode();
    }

    @NotNull
    protected final String prepareSkeletonsVolume() throws RemoteSdkException, ServerRuntimeException, IOException {
        String skeletonsVolumeName = this.skeletonsVolumeName;
        if (skeletonsVolumeName == null) {
            this.skeletonsVolumeName = skeletonsVolumeName = this.setupSkeletonsVolume();
        }
        return skeletonsVolumeName;
    }

    @NotNull
    protected abstract String setupSkeletonsVolume() throws ExecutionException, ServerRuntimeException, IOException;

    private static final void refreshGeneratedSkeletons$lambda$3$lambda$2$lambda$1$lambda$0(SdkModificator $this_apply) {
        $this_apply.commitChanges();
    }

    private static final void refreshGeneratedSkeletons$lambda$3$lambda$2$lambda$1(Application $it, SdkModificator $this_apply) {
        $it.runWriteAction(() -> PyDockerSkeletonGeneratorBase.refreshGeneratedSkeletons$lambda$3$lambda$2$lambda$1$lambda$0($this_apply));
    }

    @JvmStatic
    @Contract(value="_ -> fail")
    @NotNull
    public static final InvalidSdkException propagateRecoverableException(@NotNull Exception e) throws InvalidSdkException {
        return Companion.propagateRecoverableException(e);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/docker/PyDockerSkeletonGeneratorBase$Companion;", "", "<init>", "()V", "BIN_TRUE_CMD", "", "ROOT_USER", "SKELETONS_CONTAINER_PATH", "SKELETONS_OUTPUT_CONTAINER_PATH", "propagateRecoverableException", "Lcom/jetbrains/python/sdk/InvalidSdkException;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "refreshDownloadedSources", "", "localPath", "intellij.python.docker"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Contract(value="_ -> fail")
        @NotNull
        public final InvalidSdkException propagateRecoverableException(@NotNull Exception e) throws InvalidSdkException {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (ExceptionUtil.causedBy((Throwable)e, ExceptionFix.class)) {
                if (e instanceof InvalidSdkException) {
                    throw e;
                }
                throw new InvalidSdkException(e.getMessage(), (Throwable)e);
            }
            throw new InvalidSdkException(e.getMessage(), (Throwable)new RegenerateSkeletonsException(e.getMessage(), e));
        }

        private final void refreshDownloadedSources(String localPath) {
            VirtualFile localSourcesFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(localPath);
            if (localSourcesFile != null) {
                localSourcesFile.refresh(true, true);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

