/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.scientific.PyScientificBundle;
import com.intellij.python.scientific.figures.base.FigureContentPanelBase;
import com.intellij.python.scientific.ui.PyPlotToolWindow;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/scientific/actions/SaveAsHtmlAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "toolWindow", "Lcom/intellij/python/scientific/ui/PyPlotToolWindow;", "<init>", "(Lcom/intellij/python/scientific/ui/PyPlotToolWindow;)V", "getToolWindow", "()Lcom/intellij/python/scientific/ui/PyPlotToolWindow;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.python.scientific"})
public final class SaveAsHtmlAction
extends DumbAwareAction {
    @NotNull
    private final PyPlotToolWindow toolWindow;

    public SaveAsHtmlAction(@NotNull PyPlotToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super(PyScientificBundle.message("plots.save.as.html", new Object[0]));
        this.toolWindow = toolWindow;
    }

    @NotNull
    public final PyPlotToolWindow getToolWindow() {
        return this.toolWindow;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        FigureContentPanelBase contentPanel = this.toolWindow.getContentPanel$intellij_python_scientific(project);
        boolean isEnabled = false;
        if (contentPanel != null && Intrinsics.areEqual((Object)contentPanel.getFormat(), (Object)"html")) {
            isEnabled = true;
        }
        e.getPresentation().setEnabledAndVisible(isEnabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        FigureContentPanelBase contentPanel = this.toolWindow.getContentPanel$intellij_python_scientific(project);
        if (contentPanel != null) {
            VirtualFile virtualFile = contentPanel.getEditor().getFile();
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                Object object = ReadAction.compute(() -> SaveAsHtmlAction.actionPerformed$lambda$0(document));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
                String string = (String)object;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] content = byArray;
                PyPlotToolWindow.Companion.saveAsFile$intellij_python_scientific(content, project, "html");
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final String actionPerformed$lambda$0(Document $document) {
        return $document.getText();
    }
}

