/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.TextRangeAndMarkupContent;
import com.intellij.platform.lsp.impl.completion.LspCompletionUtilKt;
import com.intellij.platform.lsp.impl.highlighting.LspDocumentHighlightingCache;
import com.intellij.platform.lsp.impl.workspaceSymbol.LspWorkspaceSymbolCache;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.future.FutureKt;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001WB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0004\u0012\u00020\u000f0\u0011H\u0000\u00a2\u0006\u0002\b\u0014J6\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\u001c\u0010\u0010\u001a\u0018\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00170\u0011H\u0080@\u00a2\u0006\u0004\b\u0018\u0010\u0019J?\u0010\u001a\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u001c\u0010\u0010\u001a\u0018\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00170\u0011H\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJG\u0010\u001f\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00162\u001c\u0010\u0010\u001a\u0018\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00170\u00112\u0014\u0010 \u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0016\u0012\u0004\u0012\u00020\u000f0\u0011H\u0000\u00a2\u0006\u0002\b!JL\u0010\"\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0016\u0018\u00010\u0017\"\u0004\b\u0000\u0010\u00162\u001c\u0010\u0010\u001a\u0018\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00170\u00112\u0014\u0010 \u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0016\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J6\u0010#\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0016\u0018\u00010\u0017\"\u0004\b\u0000\u0010\u00162\u001c\u0010\u0010\u001a\u0018\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00170\u0011H\u0002J\u0014\u0010$\u001a\u00020\u000f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J=\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H'0)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003\u00a2\u0006\u0002\u0010.J\r\u0010/\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b0Jr\u00101\u001a\u0004\u0018\u0001H2\"\u0004\b\u0000\u001022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001c2K\u00106\u001aG\u0012\u0013\u0012\u001104\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\u0013\u0012\u00110;\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(<\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(=\u0012\u0004\u0012\u0002H207H\u0003\u00a2\u0006\u0002\u0010>J\"\u0010?\u001a\u0004\u0018\u00010@2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020+H\u0007J(\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010@0\u00172\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020+H\u0007J\"\u0010C\u001a\u0004\u0018\u00010D2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020+H\u0002J\u001e\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001cH\u0007J#\u0010H\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\bIJ9\u0010J\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0F\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0F\u0018\u00010K2\u0006\u0010N\u001a\u00020-2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\bOJ%\u0010P\u001a\n\u0012\u0004\u0012\u00020Q\u0018\u00010F2\u0006\u00103\u001a\u0002042\u0006\u0010R\u001a\u00020SH\u0001\u00a2\u0006\u0002\bTJ$\u0010U\u001a\u0004\u0018\u00010V2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001c2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;", "", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "LspRequestExecutorImpl", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "hoverResultCache", "Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache;", "workspaceSymbolCache", "Lcom/intellij/platform/lsp/impl/workspaceSymbol/LspWorkspaceSymbolCache;", "documentHighlightCache", "Lcom/intellij/platform/lsp/impl/highlighting/LspDocumentHighlightingCache;", "sendNotification", "", "lsp4jSender", "Lkotlin/Function1;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "sendNotification$intellij_platform_lsp_impl", "sendRequest", "Lsp4jResponse", "Ljava/util/concurrent/CompletableFuture;", "sendRequest$intellij_platform_lsp_impl", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendRequestSync", "timeoutMs", "", "sendRequestSync$intellij_platform_lsp_impl", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "sendRequestAsyncButWaitForResponseWithCheckCanceled", "lsp4jResponseConsumer", "sendRequestAsyncButWaitForResponseWithCheckCanceled$intellij_platform_lsp_impl", "d", "d", "d", "lsp4jResponseFuture", "d", "T", "future", "Ljava/util/concurrent/Future;", "cancelOnPCE", "", "debugName", "", "(Ljava/util/concurrent/Future;ZLjava/lang/String;I)Ljava/lang/Object;", "shutdownNow", "shutdownNow$intellij_platform_lsp_impl", "d", "Lsp4jParams", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "lsp4jParamsCreator", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "hostFile", "Lcom/intellij/openapi/editor/Document;", "hostDocument", "hostOffset", "(Lcom/intellij/openapi/vfs/VirtualFile;ILkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "getCompletionList", "Lorg/eclipse/lsp4j/CompletionList;", "isAutoPopup", "getCompletionListAsync", "d", "Lorg/eclipse/lsp4j/CompletionParams;", "getElementDefinitions", "", "Lorg/eclipse/lsp4j/LocationLink;", "getTypeDefinitions", "getTypeDefinitions$intellij_platform_lsp_impl", "getWorkspaceSymbolsCaching", "Lorg/eclipse/lsp4j/jsonrpc/messages/Either;", "Lorg/eclipse/lsp4j/SymbolInformation;", "Lorg/eclipse/lsp4j/WorkspaceSymbol;", "query", "getWorkspaceSymbolsCaching$intellij_platform_lsp_impl", "getDocumentHighlightsCaching", "Lorg/eclipse/lsp4j/DocumentHighlight;", "position", "Lorg/eclipse/lsp4j/Position;", "getDocumentHighlightsCaching$intellij_platform_lsp_impl", "getHoverInformation", "Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "HoverResultCache", "intellij.platform.lsp.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLspRequestExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,410:1\n1#2:411\n1563#3:412\n1634#3,3:413\n1563#3:416\n1634#3,3:417\n*S KotlinDebug\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl\n*L\n280#1:412\n280#1:413,3\n293#1:416\n293#1:417,3\n*E\n"})
public final class LspRequestExecutorImpl {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final HoverResultCache hoverResultCache;
    @NotNull
    private final LspWorkspaceSymbolCache workspaceSymbolCache;
    @NotNull
    private final LspDocumentHighlightingCache documentHighlightCache;

    public LspRequestExecutorImpl(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        this.lspServer = lspServer;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)("LSP Executor: " + this.lspServer.getDescriptor()), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executorService = executorService;
        this.hoverResultCache = new HoverResultCache();
        this.workspaceSymbolCache = new LspWorkspaceSymbolCache();
        this.documentHighlightCache = new LspDocumentHighlightingCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendNotification$intellij_platform_lsp_impl(@NotNull Function1<? super LanguageServer, Unit> lsp4jSender) {
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            boolean bl2 = false;
            if (!this.executorService.isShutdown()) {
                this.executorService.execute(() -> LspRequestExecutorImpl.d(lsp4jSender, this));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final <Lsp4jResponse> Object sendRequest$intellij_platform_lsp_impl(@NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender, @NotNull Continuation<? super Lsp4jResponse> $completion) {
        CompletableFuture<Lsp4jResponse> completableFuture = this.d(lsp4jSender);
        if (completableFuture == null) {
            return null;
        }
        CompletableFuture<Lsp4jResponse> completableFuture2 = completableFuture;
        return FutureKt.await((CompletionStage)completableFuture2, $completion);
    }

    @RequiresBackgroundThread
    @Nullable
    public final <Lsp4jResponse> Lsp4jResponse sendRequestSync$intellij_platform_lsp_impl(int timeoutMs, @NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender) {
        Lsp4jResponse Lsp4jResponse;
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        CompletableFuture<Lsp4jResponse> completableFuture = this.d(lsp4jSender);
        if (completableFuture != null) {
            CompletableFuture<Lsp4jResponse> completableFuture2 = completableFuture;
            boolean bl2 = false;
            Future future = completableFuture2;
            String string = lsp4jSender.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Lsp4jResponse = (Lsp4jResponse)this.d(future, true, string, timeoutMs);
        } else {
            Lsp4jResponse = null;
        }
        return Lsp4jResponse;
    }

    public static /* synthetic */ Object sendRequestSync$intellij_platform_lsp_impl$default(LspRequestExecutorImpl lspRequestExecutorImpl, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 10000;
        }
        return lspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl(n2, function1);
    }

    public final <Lsp4jResponse> void sendRequestAsyncButWaitForResponseWithCheckCanceled$intellij_platform_lsp_impl(@NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender, @NotNull Function1<? super Lsp4jResponse, Unit> lsp4jResponseConsumer) {
        block0: {
            Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
            Intrinsics.checkNotNullParameter(lsp4jResponseConsumer, (String)"lsp4jResponseConsumer");
            CompletableFuture<? super Lsp4jResponse> completableFuture = this.d(lsp4jSender, lsp4jResponseConsumer);
            if (completableFuture == null) break block0;
            CompletableFuture<? super Lsp4jResponse> completableFuture2 = completableFuture;
            boolean bl2 = false;
            Future future = completableFuture2;
            String string = lsp4jSender.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.d(future, false, string, 10000);
        }
    }

    private final <Lsp4jResponse> CompletableFuture<Lsp4jResponse> d(Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> function1, Function1<? super Lsp4jResponse, Unit> function12) {
        CompletableFuture<Lsp4jResponse> completableFuture = this.d(function1);
        if (completableFuture == null) {
            function12.invoke(null);
            return null;
        }
        return completableFuture.whenComplete((arg_0, arg_1) -> LspRequestExecutorImpl.d((arg_0, arg_1) -> LspRequestExecutorImpl.d(function12, arg_0, arg_1), arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <Lsp4jResponse> CompletableFuture<Lsp4jResponse> d(Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> function1) {
        if (this.lspServer.getState() != LspServerState.Running) {
            this.lspServer.logDebug$intellij_platform_lsp_impl("Server not initialized yet, skipping request " + function1.getClass().getName());
            return null;
        }
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            block5: {
                boolean bl2 = false;
                if (!this.executorService.isShutdown()) break block5;
                CompletableFuture<Lsp4jResponse> completableFuture = null;
                return completableFuture;
            }
            CompletableFuture completableFuture = new CompletableFuture();
            this.executorService.execute(() -> LspRequestExecutorImpl.d(function1, this, completableFuture));
            CompletableFuture completableFuture2 = completableFuture;
            return completableFuture2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void d(CompletableFuture<?> completableFuture) {
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            boolean bl2 = false;
            if (!this.executorService.isShutdown()) {
                this.executorService.execute(() -> LspRequestExecutorImpl.c(completableFuture));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @RequiresBackgroundThread
    private final <T> T d(Future<T> future, boolean bl2, String string, int n2) {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < (long)n2) {
            try {
                ProgressManager.checkCanceled();
            }
            catch (ProcessCanceledException processCanceledException) {
                if (bl2) {
                    future.cancel(true);
                }
                throw processCanceledException;
            }
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException executionException) {
                LspServerImpl.logWarn$intellij_platform_lsp_impl$default(this.lspServer, "Error response from server: " + executionException.getCause(), null, 2, null);
                return null;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        this.lspServer.logInfo$intellij_platform_lsp_impl("No response from the server in " + n2 + "ms for: " + string);
        future.cancel(true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdownNow$intellij_platform_lsp_impl() {
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            boolean bl2 = false;
            List<Runnable> list = this.executorService.shutdownNow();
        }
        this.hoverResultCache.clearCache();
        this.workspaceSymbolCache.clear();
        this.documentHighlightCache.clear();
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    private final <Lsp4jParams> Lsp4jParams d(VirtualFile virtualFile, int n2, Function3<? super VirtualFile, ? super Document, ? super Integer, ? extends Lsp4jParams> function3) {
        ProgressManager.checkCanceled();
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            Lsp4jParams Lsp4jParams;
            Lsp4jParams Lsp4jParams2 = Lsp4jParams = null;
            boolean bl2 = false;
            this.lspServer.logError$intellij_platform_lsp_impl("No document for file " + virtualFile);
            return Lsp4jParams;
        }
        Document document2 = document;
        VirtualFileWindow virtualFileWindow = virtualFile instanceof VirtualFileWindow ? (VirtualFileWindow)virtualFile : null;
        if (virtualFileWindow == null || (virtualFileWindow = virtualFileWindow.getDelegate()) == null) {
            virtualFileWindow = virtualFile;
        }
        VirtualFileWindow virtualFileWindow2 = virtualFileWindow;
        Document document3 = PsiDocumentManagerBase.getTopLevelDocument((Document)document2);
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getTopLevelDocument(...)");
        Document document4 = document3;
        DocumentWindow documentWindow = document2 instanceof DocumentWindow ? (DocumentWindow)document2 : null;
        int n3 = documentWindow != null ? documentWindow.injectedToHost(n2) : n2;
        return (Lsp4jParams)function3.invoke((Object)virtualFileWindow2, (Object)document4, (Object)n3);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public final CompletionList getCompletionList(@NotNull VirtualFile file, int offset, boolean isAutoPopup) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CompletionParams completionParams = this.d(file, offset, isAutoPopup);
        Either either = (Either)LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(this, 0, arg_0 -> LspRequestExecutorImpl.c(completionParams, arg_0), 1, null);
        if (either == null) {
            return null;
        }
        Either either2 = either;
        return LspCompletionUtilKt.asCompletionList((Either<List<CompletionItem>, CompletionList>)either2);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final CompletableFuture<CompletionList> getCompletionListAsync(@NotNull VirtualFile file, int offset, boolean isAutoPopup) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CompletionParams completionParams = this.d(file, offset, isAutoPopup);
        CompletableFuture<Object> completableFuture = this.d(arg_0 -> LspRequestExecutorImpl.d(completionParams, arg_0));
        if (completableFuture == null) {
            completableFuture = CompletableFuture.completedFuture(null);
        }
        CompletableFuture completableFuture2 = completableFuture;
        CompletionStage completionStage = completableFuture2.thenApply(arg_0 -> LspRequestExecutorImpl.d(LspRequestExecutorImpl::d, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final CompletionParams d(VirtualFile virtualFile, int n2, boolean bl2) {
        return (CompletionParams)this.d(virtualFile, n2, (arg_0, arg_1, arg_2) -> LspRequestExecutorImpl.d(this, bl2, arg_0, arg_1, arg_2));
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final List<LocationLink> getElementDefinitions(@NotNull VirtualFile file, int offset) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DefinitionParams definitionParams = (DefinitionParams)this.d(file, offset, (arg_0, arg_1, arg_2) -> LspRequestExecutorImpl.d(this, arg_0, arg_1, arg_2));
        Either either = (Either)LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(this, 0, arg_0 -> LspRequestExecutorImpl.d(definitionParams, arg_0), 1, null);
        if (either == null) {
            return CollectionsKt.emptyList();
        }
        Either either2 = either;
        if (either2.isRight()) {
            Object object = either2.getRight();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRight(...)");
            list = CollectionsKt.distinct((Iterable)((Iterable)object));
        } else {
            Object object = either2.getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
            Iterable iterable = (Iterable)object;
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl3 = false;
            for (Object t2 : iterable2) {
                Location location = (Location)t2;
                Collection collection2 = collection;
                boolean bl4 = false;
                collection2.add(new LocationLink(location.getUri(), location.getRange(), location.getRange()));
            }
            list = CollectionsKt.distinct((Iterable)((List)collection));
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final List<LocationLink> getTypeDefinitions$intellij_platform_lsp_impl(@NotNull VirtualFile file, int offset) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TypeDefinitionParams typeDefinitionParams = (TypeDefinitionParams)this.d(file, offset, (arg_0, arg_1, arg_2) -> LspRequestExecutorImpl.d(this, arg_0, arg_1, arg_2));
        Either either = (Either)LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(this, 0, arg_0 -> LspRequestExecutorImpl.d(typeDefinitionParams, arg_0), 1, null);
        if (either == null) {
            return CollectionsKt.emptyList();
        }
        Either either2 = either;
        if (either2.isRight()) {
            Object object = either2.getRight();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRight(...)");
            list = (List)object;
        } else {
            Object object = either2.getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
            Iterable iterable = (Iterable)object;
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl3 = false;
            for (Object t2 : iterable2) {
                Location location = (Location)t2;
                Collection collection2 = collection;
                boolean bl4 = false;
                collection2.add(new LocationLink(location.getUri(), location.getRange(), location.getRange()));
            }
            list = (List)collection;
        }
        return list;
    }

    @RequiresBackgroundThread
    @Nullable
    public final Either<List<SymbolInformation>, List<WorkspaceSymbol>> getWorkspaceSymbolsCaching$intellij_platform_lsp_impl(@NotNull String query, int timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Project project = this.lspServer.getProject();
        Either<List<SymbolInformation>, List<WorkspaceSymbol>> either = this.workspaceSymbolCache.get(project, query);
        if (either != null) {
            return either;
        }
        WorkspaceSymbolParams workspaceSymbolParams = new WorkspaceSymbolParams(query);
        Either either2 = (Either)this.sendRequestSync$intellij_platform_lsp_impl(timeoutMs, arg_0 -> LspRequestExecutorImpl.d(workspaceSymbolParams, arg_0));
        if (either2 == null) {
            return null;
        }
        Either either3 = either2;
        this.workspaceSymbolCache.update(project, query, (Either<List<SymbolInformation>, List<WorkspaceSymbol>>)either3);
        return either3;
    }

    public static /* synthetic */ Either getWorkspaceSymbolsCaching$intellij_platform_lsp_impl$default(LspRequestExecutorImpl lspRequestExecutorImpl, String string, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 10000;
        }
        return lspRequestExecutorImpl.getWorkspaceSymbolsCaching$intellij_platform_lsp_impl(string, n2);
    }

    @RequiresBackgroundThread
    @Nullable
    public final List<DocumentHighlight> getDocumentHighlightsCaching$intellij_platform_lsp_impl(@NotNull VirtualFile file, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.documentHighlightCache.getOrCompute(this.lspServer.getProject(), file, position, (Function0<? extends List<? extends DocumentHighlight>>)((Function0)() -> LspRequestExecutorImpl.d(this, file, position)));
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public final TextRangeAndMarkupContent getHoverInformation(@NotNull VirtualFile file, int offset, int timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.hoverResultCache.getHoverInformation(file, offset, timeoutMs);
    }

    public static /* synthetic */ TextRangeAndMarkupContent getHoverInformation$default(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 10000;
        }
        return lspRequestExecutorImpl.getHoverInformation(virtualFile, n2, n3);
    }

    private static final void d(Function1 function1, LspRequestExecutorImpl lspRequestExecutorImpl) {
        function1.invoke((Object)lspRequestExecutorImpl.lspServer.getLsp4jServer$intellij_platform_lsp_impl());
    }

    private static final Unit d(Function1 function1, Object object, Throwable throwable) {
        function1.invoke(object);
        return Unit.INSTANCE;
    }

    private static final void d(Function2 function2, Object object, Object object2) {
        function2.invoke(object, object2);
    }

    private static final void d(Function1 function1, LspRequestExecutorImpl lspRequestExecutorImpl, CompletableFuture completableFuture) {
        CompletableFuture completableFuture2 = (CompletableFuture)function1.invoke((Object)lspRequestExecutorImpl.lspServer.getLsp4jServer$intellij_platform_lsp_impl());
        completableFuture2.whenComplete((arg_0, arg_1) -> LspRequestExecutorImpl.c((arg_0, arg_1) -> LspRequestExecutorImpl.d(completableFuture, arg_0, arg_1), arg_0, arg_1));
        completableFuture.whenComplete((arg_0, arg_1) -> LspRequestExecutorImpl.g((arg_0, arg_1) -> LspRequestExecutorImpl.d(completableFuture, lspRequestExecutorImpl, completableFuture2, arg_0, arg_1), arg_0, arg_1));
    }

    private static final Unit d(CompletableFuture completableFuture, Object object, Throwable throwable) {
        boolean bl2 = throwable == null ? completableFuture.complete(object) : completableFuture.completeExceptionally(throwable);
        return Unit.INSTANCE;
    }

    private static final void c(Function2 function2, Object object, Object object2) {
        function2.invoke(object, object2);
    }

    private static final Unit d(CompletableFuture completableFuture, LspRequestExecutorImpl lspRequestExecutorImpl, CompletableFuture completableFuture2, Object object, Throwable throwable) {
        if (completableFuture.isCancelled()) {
            lspRequestExecutorImpl.d(completableFuture2);
        }
        return Unit.INSTANCE;
    }

    private static final void g(Function2 function2, Object object, Object object2) {
        function2.invoke(object, object2);
    }

    private static final void c(CompletableFuture completableFuture) {
        completableFuture.cancel(true);
    }

    private static final CompletableFuture c(CompletionParams completionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().completion(completionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"completion(...)");
        return completableFuture;
    }

    private static final CompletableFuture d(CompletionParams completionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().completion(completionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"completion(...)");
        return completableFuture;
    }

    private static final CompletionList d(Either either) {
        Either either2 = either;
        return either2 != null ? LspCompletionUtilKt.asCompletionList((Either<List<CompletionItem>, CompletionList>)either2) : null;
    }

    private static final CompletionList d(Function1 function1, Object object) {
        return (CompletionList)function1.invoke(object);
    }

    private static final CompletionParams d(LspRequestExecutorImpl lspRequestExecutorImpl, boolean bl2, VirtualFile virtualFile, Document document, int n2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"hostDocument");
        return LspCompletionUtilKt.createCompletionParams(lspRequestExecutorImpl.lspServer, virtualFile, document, n2, bl2);
    }

    private static final DefinitionParams d(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile, Document document, int n2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"hostDocument");
        return new DefinitionParams(lspRequestExecutorImpl.lspServer.getDocumentIdentifier(virtualFile), Lsp4jUtilKt.getLsp4jPosition(document, n2));
    }

    private static final CompletableFuture d(DefinitionParams definitionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().definition(definitionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"definition(...)");
        return completableFuture;
    }

    private static final TypeDefinitionParams d(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile, Document document, int n2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"hostDocument");
        return new TypeDefinitionParams(lspRequestExecutorImpl.lspServer.getDocumentIdentifier(virtualFile), Lsp4jUtilKt.getLsp4jPosition(document, n2));
    }

    private static final CompletableFuture d(TypeDefinitionParams typeDefinitionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().typeDefinition(typeDefinitionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"typeDefinition(...)");
        return completableFuture;
    }

    private static final CompletableFuture d(WorkspaceSymbolParams workspaceSymbolParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getWorkspaceService().symbol(workspaceSymbolParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"symbol(...)");
        return completableFuture;
    }

    private static final List d(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile, Position position) {
        DocumentHighlightParams documentHighlightParams = new DocumentHighlightParams(lspRequestExecutorImpl.lspServer.getDocumentIdentifier(virtualFile), position);
        return (List)LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(lspRequestExecutorImpl, 0, arg_0 -> LspRequestExecutorImpl.d(documentHighlightParams, arg_0), 1, null);
    }

    private static final CompletableFuture d(DocumentHighlightParams documentHighlightParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().documentHighlight(documentHighlightParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"documentHighlight(...)");
        return completableFuture;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache;", "", "LspRequestExecutorImpl$HoverResultCache", "(Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;)V", "lastResult", "Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "lastPsiModificationCount", "", "lastFilePath", "", "getHoverInformation", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "", "timeoutMs", "clearCache", "", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspRequestExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,410:1\n23#2:411\n*S KotlinDebug\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache\n*L\n342#1:411\n*E\n"})
    private final class HoverResultCache {
        @Nullable
        private TextRangeAndMarkupContent lastResult;
        private long lastPsiModificationCount = -1L;
        @NotNull
        private String lastFilePath = "";

        @RequiresReadLock
        @RequiresBackgroundThread
        @Nullable
        public final synchronized TextRangeAndMarkupContent getHoverInformation(@NotNull VirtualFile file, int offset, int timeoutMs) {
            TextRangeAndMarkupContent textRangeAndMarkupContent;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ProgressManager.checkCanceled();
            if (file instanceof VirtualFileWindow) {
                HoverResultCache hoverResultCache = this;
                boolean bl2 = false;
                Logger logger = Logger.getInstance(HoverResultCache.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("VirtualFileWindow not expected here");
                return null;
            }
            Project project = LspRequestExecutorImpl.this.lspServer.getProject();
            TextRangeAndMarkupContent textRangeAndMarkupContent2 = this.lastResult;
            long l2 = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String string2 = string;
            if (textRangeAndMarkupContent2 != null && this.lastPsiModificationCount == l2 && Intrinsics.areEqual((Object)this.lastFilePath, (Object)string2) && textRangeAndMarkupContent2.getTextRange().contains(offset)) {
                return textRangeAndMarkupContent2;
            }
            HoverParams hoverParams = (HoverParams)LspRequestExecutorImpl.this.d(file, offset, (arg_0, arg_1, arg_2) -> HoverResultCache.d(LspRequestExecutorImpl.this, arg_0, arg_1, arg_2));
            Hover hover = (Hover)LspRequestExecutorImpl.this.sendRequestSync$intellij_platform_lsp_impl(timeoutMs, arg_0 -> HoverResultCache.d(hoverParams, arg_0));
            if (hover == null) {
                return null;
            }
            Hover hover2 = hover;
            this.lastResult = textRangeAndMarkupContent = TextRangeAndMarkupContent.Companion.fromHover$intellij_platform_lsp_impl(hover2, file, offset);
            this.lastPsiModificationCount = l2;
            this.lastFilePath = string2;
            return textRangeAndMarkupContent;
        }

        public final void clearCache() {
            this.lastResult = null;
            this.lastPsiModificationCount = -1L;
            this.lastFilePath = "";
        }

        private static final HoverParams d(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile, Document document, int n2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"hostFile");
            Intrinsics.checkNotNullParameter((Object)document, (String)"hostDocument");
            return new HoverParams(lspRequestExecutorImpl.lspServer.getDocumentIdentifier(virtualFile), Lsp4jUtilKt.getLsp4jPosition(document, n2));
        }

        private static final CompletableFuture d(HoverParams hoverParams, LanguageServer languageServer) {
            Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
            CompletableFuture completableFuture = languageServer.getTextDocumentService().hover(hoverParams);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"hover(...)");
            return completableFuture;
        }
    }
}

