/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic;

import com.intellij.database.Dbms;
import com.intellij.database.HSet;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.LimitPlace;
import com.intellij.database.dialects.generic.GenericDbms;
import com.intellij.database.dialects.generic.GenericDmlHelperKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J:\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u001c\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/generic/GenericDmlHelper;", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "needAliasInUpdateStatement", "", "getNeedAliasInUpdateStatement", "()Z", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/LimitPlace;", "appendLimit", "Lcom/intellij/database/util/DdlBuilder;", "table", "Lcom/intellij/database/model/DasObject;", "builder", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "shouldUseLimit", "intellij.database.dialects.generic"})
public final class GenericDmlHelper
extends BaseDmlHelper {
    public GenericDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    public boolean getNeedAliasInUpdateStatement() {
        return !Intrinsics.areEqual((Object)this.getDbms(), (Object)GenericDbms.FRONTBASE);
    }

    @NotNull
    public LimitPlace getPlaceForLimit() {
        Dbms dbms = this.getDbms();
        return Intrinsics.areEqual((Object)dbms, (Object)GenericDbms.TIBERO) ? LimitPlace.BOTH : (ModelFun.contains((HSet)GenericDmlHelperKt.access$getDEFAULT_LIMIT_DBS$p(), (Dbms)dbms) || Intrinsics.areEqual((Object)dbms, (Object)GenericDbms.FILEMAKER) ? LimitPlace.END : LimitPlace.BEGIN);
    }

    @NotNull
    public DdlBuilder appendLimit(@Nullable DasObject table, @NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if (!this.shouldUseLimit() || GridUtilCore.isPageSizeUnlimited((int)limit)) {
            return builder;
        }
        Dbms dbms = this.getDbms();
        return ModelFun.contains((HSet)GenericDmlHelperKt.access$getDEFAULT_LIMIT_DBS$p(), (Dbms)dbms) ? super.appendLimit(table, builder, dialect, limit, offset, atBeginning) : (ModelFun.contains((HSet)GenericDmlHelperKt.TOP_LIMIT_DBS, (Dbms)dbms) ? this.top(builder, "TOP", limit) : (Intrinsics.areEqual((Object)dbms, (Object)GenericDbms.INGRES) ? this.top(builder, "FIRST", limit) : (Intrinsics.areEqual((Object)dbms, (Object)GenericDbms.TIBERO) ? this.rowNumLimit(builder, limit, atBeginning) : (Intrinsics.areEqual((Object)dbms, (Object)GenericDbms.FILEMAKER) ? this.fetchFirst(builder, limit) : builder))));
    }

    public boolean isEditableTable(@Nullable ObjectKind kind, @Nullable ModelHelper.ObjectKindVariant variant) {
        Dbms dbms;
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW) ? Intrinsics.areEqual((Object)(dbms = this.getDbms()), (Object)GenericDbms.FIREBIRD) || Intrinsics.areEqual((Object)dbms, (Object)GenericDbms.INFORMIX) || Intrinsics.areEqual((Object)dbms, (Object)GenericDbms.TERADATA) || Intrinsics.areEqual((Object)dbms, (Object)GenericDbms.OPENEDGE) || Intrinsics.areEqual((Object)dbms, (Object)GenericDbms.TIBERO) : super.isEditableTable(kind, variant);
    }

    private final boolean shouldUseLimit() {
        return Registry.Companion.is("database.generic_dialect.limit", true);
    }
}

