/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.jetbrains.clones.configuration.DuplicatesBundle;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.toolwindow.DuplicateViewManager;
import com.jetbrains.clones.toolwindow.ShowAllDuplicatesPanel;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/clones/toolwindow/DuplicateViewManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "registerToolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "showClonesData", "", "report", "Lcom/jetbrains/clones/structures/TextClone;", "getWindow", "createContent", "Lcom/intellij/ui/content/Content;", "toolWindow", "Companion", "intellij.platform.duplicatesDetector"})
public class DuplicateViewManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public DuplicateViewManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final ToolWindow registerToolwindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.project);
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
        ToolWindowAnchor toolWindowAnchor2 = toolWindowAnchor;
        Supplier<String> supplier = DuplicatesBundle.messagePointer("duplicate.toolwindow.id", new Object[0]);
        Icon icon = AllIcons.Toolwindows.ToolWindowDuplicates;
        ToolWindow window = toolWindowManager.registerToolWindow(new RegisterToolWindowTask("Duplicates", toolWindowAnchor2, null, false, false, false, false, null, icon, supplier, 220, null));
        window.getContentManager().addContentManagerListener(new ContentManagerListener(window){
            final /* synthetic */ ToolWindow $window;
            {
                this.$window = $window;
            }

            public void contentRemoved(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ContentManager contentManager = event.getContent().getManager();
                Intrinsics.checkNotNull((Object)contentManager);
                Content[] contentArray = contentManager.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                if (((Object[])contentArray).length == 0) {
                    this.$window.hide(() -> registerToolwindow.1.contentRemoved$lambda$0(this.$window));
                }
            }

            private static final void contentRemoved$lambda$0(ToolWindow $window) {
                $window.setAvailable(false);
            }
        });
        return window;
    }

    public void showClonesData(@NotNull TextClone report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        ToolWindow toolWindow = this.getWindow();
        toolWindow.setAvailable(true);
        toolWindow.show(() -> DuplicateViewManager.showClonesData$lambda$0(this, toolWindow, report));
    }

    private final ToolWindow getWindow() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Duplicates");
        if (toolWindow == null) {
            toolWindow = this.registerToolwindow();
        }
        ToolWindow window = toolWindow;
        window.hide(null);
        window.setAvailable(false);
        return window;
    }

    private final Content createContent(ToolWindow toolWindow, TextClone report) {
        List reportedRanges = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)report.getMain()), (Iterable)report.getDuplicates());
        ShowAllDuplicatesPanel panel = new ShowAllDuplicatesPanel(this.project, reportedRanges);
        IntRange lines = report.getMain().getLines();
        String string = report.getMain().getFile().getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        String fileName = string;
        Object[] objectArray = new Object[]{fileName, lines.getFirst(), lines.getLast()};
        String description = DuplicatesBundle.INSTANCE.message("duplicate.toolwindow.class", objectArray);
        Content content = toolWindow.getContentManager().getFactory().createContent((JComponent)((Object)panel), description, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setPreferredFocusableComponent(panel.getPreferredFocusableComponent());
        content2.setDisposer((Disposable)panel);
        content2.setShouldDisposeContent(true);
        return content2;
    }

    private static final void showClonesData$lambda$0(DuplicateViewManager this$0, ToolWindow $toolWindow, TextClone $report) {
        Content content = this$0.createContent($toolWindow, $report);
        $toolWindow.getContentManager().addContent(content);
        $toolWindow.getContentManager().setSelectedContent(content);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/clones/toolwindow/DuplicateViewManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/clones/toolwindow/DuplicateViewManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.duplicatesDetector"})
    @SourceDebugExtension(value={"SMAP\nDuplicateViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateViewManager.kt\ncom/jetbrains/clones/toolwindow/DuplicateViewManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n30#2,2:66\n*S KotlinDebug\n*F\n+ 1 DuplicateViewManager.kt\ncom/jetbrains/clones/toolwindow/DuplicateViewManager$Companion\n*L\n15#1:66,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DuplicateViewManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DuplicateViewManager> serviceClass$iv = DuplicateViewManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DuplicateViewManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

