/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure.forest;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.database.view.structure.forest.DvForest;
import com.intellij.database.view.structure.forest.DvForestGartner;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="db-tree-configuration", storages={@Storage(value="db-forest-config.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/view/structure/forest/DvForestService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/database/view/structure/forest/DvForestService$ForestState;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "forest", "Lcom/intellij/database/view/structure/forest/DvForest;", "Lcom/intellij/database/view/DataSourceNode;", "getForest", "()Lcom/intellij/database/view/structure/forest/DvForest;", "getState", "loadState", "", "state", "importRestDataSources", "ForestState", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvForestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestService.kt\ncom/intellij/database/view/structure/forest/DvForestService\n+ 2 DvForest.kt\ncom/intellij/database/view/structure/forest/DvForest$Companion\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,95:1\n26#2:96\n682#3:97\n712#3,4:98\n*S KotlinDebug\n*F\n+ 1 DvForestService.kt\ncom/intellij/database/view/structure/forest/DvForestService\n*L\n31#1:96\n47#1:97\n47#1:98,4\n*E\n"})
public final class DvForestService
implements PersistentStateComponent<ForestState> {
    @NotNull
    private final Project project;
    @NotNull
    private final DvForest<DataSourceNode> forest;

    public DvForestService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        DvForest.Companion this_$iv = DvForest.Companion;
        boolean $i$f$createForest = false;
        this.forest = new DvForest<DataSourceNode>(DataSourceNode.class);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DvForest<DataSourceNode> getForest() {
        return this.forest;
    }

    @NotNull
    public ForestState getState() {
        DvForestGartner<DataSourceNode> gartner = new DvForestGartner<DataSourceNode>(this.forest);
        String stateText = gartner.exportState();
        ForestState state = new ForestState(stateText);
        return state;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull ForestState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String text2 = StringKt.nullize$default((String)state.data, (boolean)false, (int)1, null);
        if (text2 != null) {
            void $this$associateByTo$iv$iv;
            Sequence<DataSourceNode> dsNodes;
            DvForestGartner<DataSourceNode> gartner = new DvForestGartner<DataSourceNode>(this.forest);
            BasicModelRegistry mRegistry = BasicModelRegistry.Companion.instance();
            Sequence<DataSourceNode> $this$associateBy$iv = dsNodes = mRegistry.listDataSourceNodesForProject(this.project);
            boolean $i$f$associateBy = false;
            Sequence<DataSourceNode> sequence = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                DataSourceNode dataSourceNode = (DataSourceNode)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.dataSource.getUniqueId(), element$iv$iv);
            }
            Map dsMap = destination$iv$iv;
            gartner.importState(text2, (Function1<String, DataSourceNode>)((Function1)new Function1<String, DataSourceNode>((Object)dsMap){

                public final DataSourceNode invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (DataSourceNode)((Map)this.receiver).get(p0);
                }
            }));
        }
        this.importRestDataSources();
    }

    @ApiStatus.Internal
    public final void importRestDataSources() {
        BasicModelRegistry mRegistry = BasicModelRegistry.Companion.instance();
        Sequence<DataSourceNode> dsNodes = mRegistry.listDataSourceNodesForProject(this.project);
        this.forest.modifyTree(() -> DvForestService.importRestDataSources$lambda$0(dsNodes, this));
    }

    private static final Unit importRestDataSources$lambda$0(Sequence $dsNodes, DvForestService this$0) {
        for (DataSourceNode dsNode : $dsNodes) {
            if (this$0.forest.isBushRegistered((DataSourceNode)((BasicUniqueBush)dsNode))) continue;
            String pathStr = StringFun.trimOrNull((String)dsNode.getGroupName());
            DvFolder folder = null;
            if (pathStr == null) {
                folder = this$0.forest.getRoot();
            } else {
                String[] path = pathStr.split("/");
                folder = this$0.forest.ensureFolderPath$intellij_database_core_impl(path);
            }
            folder.createNewInnerBush((BasicUniqueBush)dsNode);
        }
        this$0.forest.renumberAll();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/view/structure/forest/DvForestService$ForestState;", "", "data", "", "<init>", "(Ljava/lang/String;)V", "()V", "toString", "component1", "copy", "equals", "", "other", "hashCode", "", "intellij.database.core.impl"})
    public static final class ForestState {
        @JvmField
        @Nullable
        public String data;

        public ForestState(@Nullable String data) {
            this.data = data;
        }

        public ForestState() {
            this(null);
        }

        @NotNull
        public String toString() {
            String string = this.data;
            if (string == null) {
                string = "<nothing>";
            }
            return string;
        }

        @Nullable
        public final String component1() {
            return this.data;
        }

        @NotNull
        public final ForestState copy(@Nullable String data) {
            return new ForestState(data);
        }

        public static /* synthetic */ ForestState copy$default(ForestState forestState, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = forestState.data;
            }
            return forestState.copy(string);
        }

        public int hashCode() {
            return this.data == null ? 0 : this.data.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ForestState)) {
                return false;
            }
            ForestState forestState = (ForestState)other;
            return Intrinsics.areEqual((Object)this.data, (Object)forestState.data);
        }
    }
}

