/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.couchbase.model.CouchbaseSchema;
import com.intellij.database.dialects.couchbase.model.CouchbaseTable;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007 !\"#$%&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ*\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J,\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u000eH\u0002J*\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n0\u000eJ\"\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\n0\u000eR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "<init>", "()V", "retrieveSchemas", "", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "processTables", "", "sc", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseSchema;", "action", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTable;", "retrieveTableAdditional", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTableSettings;", "table", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseTable;", "systemKeyspaces", "", "systemKeyspaces7", "retrieveTableColumns", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTableColumns;", "inferTableSchemaInner", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneInferTableInfo;", "inferTableSchema", "processIndices", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndex;", "processIndicesAdditional", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndexAdditional;", "OneSchema", "OneTable", "OneTableSettings", "OneTableColumns", "OneInferTableInfo", "OneIndex", "OneIndexAdditional", "intellij.database.dialects.couchbase"})
@SourceDebugExtension(value={"SMAP\nCouchbaseIntroQueries.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CouchbaseIntroQueries.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries\n+ 2 BaseIntroQueries.kt\ncom/intellij/database/dialects/base/introspector/BaseIntroQueries\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n25#2:151\n25#2:155\n25#2:156\n22#2:157\n25#2:158\n25#2:159\n25#2:160\n25#2:161\n1869#3:152\n1870#3:154\n1#4:153\n*S KotlinDebug\n*F\n+ 1 CouchbaseIntroQueries.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries\n*L\n22#1:151\n56#1:155\n58#1:156\n64#1:157\n81#1:158\n89#1:159\n132#1:160\n147#1:161\n50#1:152\n50#1:154\n*E\n"})
public final class CouchbaseIntroQueries
extends BaseIntroQueries {
    @NotNull
    public static final CouchbaseIntroQueries INSTANCE = new CouchbaseIntroQueries();
    @NotNull
    private static final List<String> systemKeyspaces;
    @NotNull
    private static final List<String> systemKeyspaces7;

    private CouchbaseIntroQueries() {
        super(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OneSchema> retrieveSchemas(@NotNull DBTransaction transaction) {
        void this_$iv;
        Object query$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Object object = this;
        String string = "SELECT datastore_id, id, name FROM system:namespaces";
        boolean expandMaps$iv = true;
        boolean $i$f$listQuery = false;
        SqlQuery sqlQuery = new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, OneSchema.class, (boolean)expandMaps$iv)));
        query$iv = object = new OneSchema();
        Collection collection = (Collection)BaseIntroQueries.retrieve$default((BaseIntroQueries)this, (SqlQuery)sqlQuery, (DBTransaction)transaction, null, (int)2, null);
        boolean bl = false;
        $this$retrieveSchemas_u24lambda_u240.id = "system";
        $this$retrieveSchemas_u24lambda_u240.name = "system";
        return CollectionsKt.plus((Collection)collection, (Object)object);
    }

    public final void processTables(@NotNull DBTransaction transaction, @NotNull CouchbaseSchema sc, @NotNull Function1<? super OneTable, Unit> action) {
        SqlQuery sqlQuery;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        int[] nArray = new int[]{7};
        boolean isV7 = this.getDbVersion((BasicElement)sc).isOrGreater(nArray);
        if (Intrinsics.areEqual((Object)sc.getName(), (Object)"system")) {
            Iterable $this$forEach$iv = isV7 ? systemKeyspaces7 : systemKeyspaces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OneTable oneTable;
                String it = (String)element$iv;
                boolean bl = false;
                OneTable oneTable2 = oneTable = new OneTable();
                Function1<? super OneTable, Unit> function1 = action;
                boolean bl2 = false;
                $this$processTables_u24lambda_u240_u240.id = it;
                function1.invoke((Object)oneTable);
            }
            return;
        }
        if (isV7) {
            BaseIntroQueries $i$f$forEach = this;
            String string = "SELECT datastore_id, name, namespace_id FROM system:buckets WHERE namespace_id = ?;";
            expandMaps$iv = true;
            $i$f$listQuery = false;
            sqlQuery = new SqlQuery(query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, OneTable.class, (boolean)expandMaps$iv)));
        } else {
            this_$iv = this;
            query$iv = "SELECT datastore_id, id, name, namespace_id FROM system:keyspaces WHERE namespace_id = ?";
            expandMaps$iv = true;
            $i$f$listQuery = false;
            sqlQuery = new SqlQuery(query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, OneTable.class, (boolean)expandMaps$iv)));
        }
        SqlQuery query = sqlQuery;
        Object[] objectArray = new String[]{sc.getName()};
        BaseIntroQueries.processList$default((BaseIntroQueries)this, (SqlQuery)query, (DBTransaction)transaction, (Object[])objectArray, null, null, action, (int)12, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final OneTableSettings retrieveTableAdditional(@NotNull DBTransaction transaction, @NotNull CouchbaseTable table) {
        void this_$iv;
        void query$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        BaseIntroQueries baseIntroQueries = this;
        String string = "DESCRIBE BUCKET SETTINGS `" + table.getName() + "`";
        boolean expandMaps$iv = true;
        boolean $i$f$structQuery = false;
        return (OneTableSettings)BaseIntroQueries.retrieve$default((BaseIntroQueries)this, (SqlQuery)new SqlQuery((String)query$iv, Layouts.rowOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, OneTableSettings.class, (boolean)expandMaps$iv))), (DBTransaction)transaction, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OneTableColumns> retrieveTableColumns(@NotNull DBTransaction transaction, @NotNull CouchbaseTable table) {
        void this_$iv;
        void query$iv;
        BaseIntroQueries baseIntroQueries;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        BaseIntroQueries baseIntroQueries2 = baseIntroQueries = (BaseIntroQueries)this;
        Object object = table.getSchema();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        String string = "DESCRIBE BUCKET COLUMNS " + (String)object + ":`" + table.getName() + "`";
        boolean expandMaps$iv = true;
        boolean $i$f$listQuery = false;
        return (List)BaseIntroQueries.retrieve$default((BaseIntroQueries)baseIntroQueries2, (SqlQuery)new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, OneTableColumns.class, (boolean)expandMaps$iv))), (DBTransaction)transaction, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void inferTableSchemaInner(DBTransaction transaction, CouchbaseTable table, Function1<? super OneInferTableInfo, Unit> action) {
        void this_$iv;
        void query$iv;
        BaseIntroQueries baseIntroQueries = this;
        String string = "INFER `" + table.getName() + "` WITH {'num_sample_values': 0, 'similarity_metric': 0}";
        boolean expandMaps$iv = true;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.processList$default((BaseIntroQueries)this, (SqlQuery)new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, OneInferTableInfo.class, (boolean)expandMaps$iv))), (DBTransaction)transaction, null, null, null, action, (int)14, null);
    }

    public final void inferTableSchema(@NotNull DBTransaction transaction, @NotNull CouchbaseTable table, @NotNull Function1<? super OneInferTableInfo, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean retry = true;
        while (retry) {
            try {
                this.inferTableSchemaInner(transaction, table, action);
                retry = false;
            }
            catch (Exception e) {
                String message;
                retry = false;
                if (e.getMessage() == null) {
                    throw e;
                }
                if (StringUtil.containsIgnoreCase((String)message, (String)"No documents found")) {
                    if (!ApplicationManager.getApplication().isUnitTestMode()) continue;
                    Thread.sleep(500L);
                    retry = true;
                    continue;
                }
                if (StringUtil.containsIgnoreCase((String)message, (String)"has no documents")) continue;
                throw e;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processIndices(@NotNull DBTransaction transaction, @NotNull CouchbaseSchema sc, @NotNull Function1<? super OneIndex, Unit> action) {
        void expandMaps$iv;
        void this_$iv;
        void query$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Object[] objectArray = (Object[])this;
        String string = "SELECT id AS index_id, name, datastore_id, namespace_id, keyspace_id, \n      index_key, `using`, state, condition, is_primary, `partition`\n      FROM system:indexes WHERE namespace_id = ?;";
        boolean bl = true;
        boolean $i$f$listQuery = false;
        objectArray = new String[]{sc.getName()};
        BaseIntroQueries.processList$default((BaseIntroQueries)this, (SqlQuery)new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, OneIndex.class, (boolean)expandMaps$iv))), (DBTransaction)transaction, (Object[])objectArray, null, null, action, (int)12, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void processIndicesAdditional(@NotNull DBTransaction transaction, @NotNull Function1<? super OneIndexAdditional, Unit> action) {
        void this_$iv;
        void query$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        String string = "DESCRIBE INDEXES";
        boolean expandMaps$iv = true;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.processList$default((BaseIntroQueries)this, (SqlQuery)new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, OneIndexAdditional.class, (boolean)expandMaps$iv))), (DBTransaction)transaction, null, null, null, action, (int)14, null);
    }

    static {
        Object[] objectArray = new String[]{"datastores", "namespaces", "keyspaces", "indexes", "prepareds", "completed_requests", "active_requests", "my_user_info", "user_info", "nodes", "applicable_roles", "dual"};
        systemKeyspaces = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"buckets", "scopes"};
        systemKeyspaces7 = CollectionsKt.plus((Collection)systemKeyspaces, (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndex;", "", "<init>", "()V", "index_id", "", "name", "keyspace_id", "namespace_id", "datastore_id", "index_key", "", "using", "state", "condition", "is_primary", "", "partition", "intellij.database.dialects.couchbase"})
    public static final class OneIndex {
        @JvmField
        @Nullable
        public String index_id;
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @NotNull
        public String keyspace_id = "";
        @JvmField
        @Nullable
        public String namespace_id;
        @JvmField
        @Nullable
        public String datastore_id;
        @JvmField
        @Nullable
        public List<String> index_key;
        @JvmField
        @Nullable
        public String using;
        @JvmField
        @Nullable
        public String state;
        @JvmField
        @Nullable
        public String condition;
        @JvmField
        public boolean is_primary;
        @JvmField
        @Nullable
        public String partition;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndexAdditional;", "", "<init>", "()V", "indexName", "", "numReplica", "", "Ljava/lang/Integer;", "definition", "bucket", "numPartition", "intellij.database.dialects.couchbase"})
    public static final class OneIndexAdditional {
        @JvmField
        @Nullable
        public String indexName;
        @JvmField
        @Nullable
        public Integer numReplica;
        @JvmField
        @Nullable
        public String definition;
        @JvmField
        @Nullable
        public String bucket;
        @JvmField
        @Nullable
        public Integer numPartition;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneInferTableInfo;", "", "<init>", "()V", "properties", "", "intellij.database.dialects.couchbase"})
    public static final class OneInferTableInfo {
        @JvmField
        @Nullable
        public Map<Object, ? extends Object> properties;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneSchema;", "", "<init>", "()V", "id", "", "name", "datastore_id", "intellij.database.dialects.couchbase"})
    public static final class OneSchema {
        @JvmField
        @NotNull
        public String id = "";
        @JvmField
        @Nullable
        public String name;
        @JvmField
        @Nullable
        public String datastore_id;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTable;", "", "<init>", "()V", "id", "", "name", "namespace_id", "datastore_id", "intellij.database.dialects.couchbase"})
    public static final class OneTable {
        @JvmField
        @Nullable
        public String id;
        @JvmField
        @Nullable
        public String name;
        @JvmField
        @Nullable
        public String namespace_id;
        @JvmField
        @Nullable
        public String datastore_id;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\t\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTableColumns;", "", "<init>", "()V", "name", "", "type", "", "Ljava/lang/Integer;", "typeName", "intellij.database.dialects.couchbase"})
    public static final class OneTableColumns {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public Integer type;
        @JvmField
        @NotNull
        public String typeName = "";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneTableSettings;", "", "<init>", "()V", "flushEnabled", "", "Ljava/lang/Boolean;", "ramQuotaMB", "", "Ljava/lang/Long;", "replicaNumber", "", "Ljava/lang/Integer;", "replicaIndexes", "maxTTL", "compressionMode", "", "bucketType", "conflictResolutionType", "evictionPolicy", "intellij.database.dialects.couchbase"})
    public static final class OneTableSettings {
        @JvmField
        @Nullable
        public Boolean flushEnabled;
        @JvmField
        @Nullable
        public Long ramQuotaMB;
        @JvmField
        @Nullable
        public Integer replicaNumber;
        @JvmField
        @Nullable
        public Boolean replicaIndexes;
        @JvmField
        @Nullable
        public Integer maxTTL;
        @JvmField
        @Nullable
        public String compressionMode;
        @JvmField
        @Nullable
        public String bucketType;
        @JvmField
        @Nullable
        public String conflictResolutionType;
        @JvmField
        @Nullable
        public String evictionPolicy;
    }
}

