/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.couchbase;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.couchbase.CouchGeneratedParserUtil;
import com.intellij.sql.dialects.couchbase.CouchbaseDdlParsing;
import com.intellij.sql.dialects.couchbase.CouchbaseDialect;
import com.intellij.sql.dialects.couchbase.CouchbaseDmlParsing;
import com.intellij.sql.dialects.couchbase.CouchbaseExpressionParsing;
import com.intellij.sql.dialects.couchbase.CouchbaseGeneratedParser;
import com.intellij.sql.psi.SqlReferenceElementType;
import org.jetbrains.annotations.Nullable;

public class CouchbaseParser
extends SqlParser {
    public CouchbaseParser() {
        super((SqlLanguageDialectEx)CouchbaseDialect.INSTANCE);
    }

    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return CouchbaseGeneratedParser.statement(builder, level);
    }

    public boolean parseOdbcSequence(PsiBuilder builder) {
        return false;
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return CouchbaseGeneratedParser.parse_root_(root, builder, level);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return CouchbaseGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return CouchbaseDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return CouchbaseDdlParsing.type_element(builder, level);
    }

    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType resultType) {
        return super.parseParameterReferenceInner(builder, (IElementType)SQL_PARAMETER_REFERENCE);
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, CouchbaseExpressionParsing::evaluable_expression);
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return CouchbaseGeneratedParser.table_opt_column_list(builder, level);
    }

    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result = super.consumeCustomParameterReference(builder);
        if (result != null) {
            return result;
        }
        if (!SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_DOLLAR)) {
            return null;
        }
        IElementType type = builder.rawLookup(1);
        if (!this.isIdentifierToken(builder, type, true, false) && type != SQL_INTEGER_TOKEN) {
            return null;
        }
        builder.advanceLexer();
        builder.advanceLexer();
        while (SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)SQL_COLON)) {
            SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_COLON);
            SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_IDENT);
        }
        if (SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)SQL_LEFT_PAREN)) {
            SqlParserUtil.consumeAllTokensUpTo((PsiBuilder)builder, (IElementType[])new IElementType[]{SQL_RIGHT_PAREN, SQL_SEMICOLON});
            SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_RIGHT_PAREN);
        }
        return SQL_PARAMETER_REFERENCE;
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = CouchbaseExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(SqlBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        boolean res = super.parseFunctionCallTail(builder, level);
        if (res) {
            CouchbaseGeneratedParser.analytic_clause(builder, level);
        }
        return res;
    }

    public boolean parseReferenceExpressionInner(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        if (refType == SQL_COLUMN_REFERENCE) {
            CouchGeneratedParserUtil.setTableRefAsColumnRef(builder, 0, false);
        }
        if (refType == SQL_TABLE_REFERENCE && this.parseNamespaceTableReference(builder, optional, force)) {
            return true;
        }
        return super.parseReferenceExpressionInner(builder, optional, force, refType);
    }

    private boolean parseNamespaceTableReference(PsiBuilder builder, boolean optional, boolean force) {
        if (builder.rawLookup(1) != SQL_COLON) {
            return false;
        }
        return super.parseReferenceExpressionInner(builder, optional, force, SQL_REFERENCE) && SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_COLON) && this.parseIdentifier(builder, optional);
    }
}

