/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.application.options.editor.XmlFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssStylesheetElementTypeBase;
import com.intellij.psi.css.util.CssUriUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected void buildLanguageFoldRegions(final @NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement psiElement, final @NotNull Document document, boolean quick) {
        CssStylesheet stylesheet;
        if (descriptors == null) {
            CssFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            CssFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            CssFoldingBuilder.$$$reportNull$$$0(2);
        }
        if ((stylesheet = CssFoldingBuilder.getStylesheet(psiElement)) == null) {
            return;
        }
        stylesheet.accept((PsiElementVisitor)new CssElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                element.acceptChildren((PsiElementVisitor)this);
            }

            @Override
            public void visitCssBlock(CssBlock block) {
                TextRange textRange;
                if (!this.isOneLiner((PsiElement)block) && (textRange = block.getTextRange()).getLength() > 1) {
                    descriptors.add(CssFoldingBuilder.this.createDescriptor((PsiElement)block, textRange));
                }
                super.visitCssBlock(block);
            }

            @Override
            public void visitCssUri(CssUri uri) {
                PsiElement valueElement = uri.getValueElement();
                if (CssUriUtil.isDataUri((PsiElement)uri) && valueElement != null) {
                    descriptors.add(CssFoldingBuilder.this.createDescriptor((PsiElement)uri, valueElement.getTextRange()));
                }
                super.visitCssUri(uri);
            }

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!this.isOneLiner((PsiElement)comment)) {
                    TextRange textRange = comment.getTextRange();
                    ASTNode node = comment.getNode();
                    if (textRange.getLength() >= 2 && node != null) {
                        descriptors.add(new FoldingDescriptor(node, textRange));
                    }
                }
                super.visitComment(comment);
            }

            @Override
            public void visitAtRule(CssAtRule atRule) {
                ASTNode rBrace;
                ASTNode lBrace;
                ASTNode node = atRule.getNode();
                if (node != null && !this.isOneLiner((PsiElement)atRule) && (lBrace = node.findChildByType(CssElementTypes.CSS_LBRACE)) != null && (rBrace = node.findChildByType(CssElementTypes.CSS_RBRACE, lBrace)) != null) {
                    descriptors.add(new FoldingDescriptor(node, new TextRange(lBrace.getStartOffset(), rBrace.getStartOffset() + 1)));
                }
                super.visitAtRule(atRule);
            }

            private boolean isOneLiner(PsiElement element) {
                int endLine;
                TextRange textRange = element.getTextRange();
                int startLine = document.getLineNumber(textRange.getStartOffset());
                return startLine == (endLine = document.getLineNumber(textRange.getEndOffset() - 1));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comment";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssFoldingBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitComment";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected FoldingDescriptor createDescriptor(PsiElement element, TextRange textRange) {
        return new FoldingDescriptor(element, textRange);
    }

    @Nullable
    protected static CssStylesheet getStylesheet(PsiElement psiElement) {
        if (psiElement instanceof StylesheetFile) {
            return ((StylesheetFile)psiElement).getStylesheet();
        }
        if (psiElement instanceof CssStylesheet) {
            return (CssStylesheet)psiElement;
        }
        return null;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            CssFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            CssFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (node instanceof CssRuleset || node instanceof CssBlock || node.getElementType() == CssElementTypes.CSS_MEDIA) {
            return "{...}";
        }
        if (node instanceof PsiComment) {
            return "/*...*/";
        }
        if (CssUriUtil.isDataUri(node.getPsi())) {
            String value = ((CssUri)node).getValue();
            int firstSemicolonPosition = (value = StringUtil.stripQuotesAroundValue((String)value)).indexOf(";");
            return firstSemicolonPosition > 0 ? value.substring(0, firstSemicolonPosition) : "data";
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            CssFoldingBuilder.$$$reportNull$$$0(5);
        }
        return XmlFoldingSettings.getInstance().isCollapseDataUri() && CssUriUtil.isDataUri(node.getPsi());
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            CssFoldingBuilder.$$$reportNull$$$0(6);
        }
        return node.getElementType() instanceof CssStylesheetElementTypeBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

