/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.settings;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.css.codeStyle.CssCodeStyleGroupService;
import com.intellij.psi.css.codeStyle.CssLanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.settings.SASSCodeStyleMainPanel;
import org.jetbrains.plugins.sass.settings.SassCodeStyleSettings;

public class SASSLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        SASSLanguage sASSLanguage = SASSLanguage.INSTANCE;
        if (sASSLanguage == null) {
            SASSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return sASSLanguage;
    }

    public CodeStyleGroup getGroup() {
        return CssCodeStyleGroupService.getCodeStyleGroup();
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            SASSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return "table.hl\n  margin: 2em 0\n  td.ln\n    text-align: right\n\nli\n  font:\n    family: serif\n    weight: bold\n    size: 1.2em";
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            SASSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (indentOptions == null) {
            SASSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        commonSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
        indentOptions.INDENT_SIZE = 2;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            SASSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return new SassCodeStyleSettings(settings);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            SASSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == null) {
            SASSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            CssLanguageCodeStyleSettingsProvider.customizeStyleSheetBlankLinesSettings((CodeStyleSettingsCustomizable)consumer, SassCodeStyleSettings.class);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_AT_FIRST_COLUMN.name(), CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_ADD_SPACE.name()});
        }
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            SASSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (modelSettings == null) {
            SASSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        return new CodeStyleAbstractConfigurable(this, baseSettings, modelSettings, this.getConfigurableDisplayName()){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new SASSCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.sass";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/sass/settings/SASSLanguageCodeStyleSettingsProvider$1", "createPanel"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/settings/SASSLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/settings/SASSLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

