/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class ForNode
extends IterNode {
    private Node iterNode;

    public ForNode(SourcePosition position, Node varNode, Node bodyNode, Node iterNode, StaticScope scope) {
        super(position, varNode, scope, bodyNode);
        assert (iterNode != null) : "iterNode is not null";
        this.iterNode = this.adopt(iterNode);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        ForNode other = (ForNode)node;
        if (this.getVar() == null && other.getVar() == null) {
            return this.getIter().isSame(other.getIter()) && this.getBody().isSame(other.getBody());
        }
        if (this.getVar() == null || other.getVar() == null) {
            return false;
        }
        return this.getVar().isSame(other.getVar()) && this.getIter().isSame(other.getIter()) && this.getBody().isSame(other.getBody());
    }

    public NodeType getNodeType() {
        return NodeType.FORNODE;
    }

    public Node getIter() {
        return this.iterNode;
    }

    @Deprecated
    public Node getIterNode() {
        return this.getIter();
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitForNode(this);
    }
}

