/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stubs.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.packaging.PyRequirement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\r\u001a\f0\u0006\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/codeInsight/stubs/fixes/IgnoreStubCompatibilityQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "stubRequirement", "Lcom/jetbrains/python/packaging/PyRequirement;", "ignoredStubPkgs", "", "", "<init>", "(Lcom/jetbrains/python/packaging/PyRequirement;Ljava/util/List;)V", "getStubRequirement", "()Lcom/jetbrains/python/packaging/PyRequirement;", "getIgnoredStubPkgs", "()Ljava/util/List;", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.python.community.impl"})
public final class IgnoreStubCompatibilityQuickFix
implements LocalQuickFix {
    @NotNull
    private final PyRequirement stubRequirement;
    @NotNull
    private final List<String> ignoredStubPkgs;

    public IgnoreStubCompatibilityQuickFix(@NotNull PyRequirement stubRequirement, @NotNull List<String> ignoredStubPkgs) {
        Intrinsics.checkNotNullParameter((Object)stubRequirement, (String)"stubRequirement");
        Intrinsics.checkNotNullParameter(ignoredStubPkgs, (String)"ignoredStubPkgs");
        this.stubRequirement = stubRequirement;
        this.ignoredStubPkgs = ignoredStubPkgs;
    }

    @NotNull
    public final PyRequirement getStubRequirement() {
        return this.stubRequirement;
    }

    @NotNull
    public final List<String> getIgnoredStubPkgs() {
        return this.ignoredStubPkgs;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message((String)"INSP.stub.packages.compatibility.ignore", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        String string = this.stubRequirement.getPresentableText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableText(...)");
        if (this.ignoredStubPkgs.add(string)) {
            ProjectInspectionProfileManager.Companion.getInstance(project).fireProfileChanged();
        }
    }
}

