/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.actions.CommandQueueForPythonConsoleService;
import com.jetbrains.python.console.pydev.AbstractConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PythonDebugConsoleCommunication
extends AbstractConsoleCommunication {
    private static final Logger LOG = Logger.getInstance(PythonDebugConsoleCommunication.class);
    private final PyDebugProcess myDebugProcess;
    private boolean myNeedsMore;
    private boolean firstExecution;
    @NotNull
    private final PythonConsoleView myConsoleView;
    private boolean isExecuting;

    public PythonDebugConsoleCommunication(@NotNull Project project, @NotNull PyDebugProcess debugProcess, @NotNull PythonConsoleView consoleView) {
        if (project == null) {
            PythonDebugConsoleCommunication.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            PythonDebugConsoleCommunication.$$$reportNull$$$0(1);
        }
        if (consoleView == null) {
            PythonDebugConsoleCommunication.$$$reportNull$$$0(2);
        }
        super(project);
        this.myNeedsMore = false;
        this.firstExecution = true;
        this.isExecuting = false;
        this.myDebugProcess = debugProcess;
        this.myConsoleView = consoleView;
    }

    public void setContext() {
        PsiFile psiFile = PsiUtilCore.getPsiFile((Project)this.myProject, (VirtualFile)this.myConsoleView.getVirtualFile());
        if (psiFile instanceof PyExpressionCodeFragmentImpl) {
            PyExpressionCodeFragmentImpl editorPsiFile = (PyExpressionCodeFragmentImpl)psiFile;
            PsiElement debuggerContext = PyDebuggerEditorsProvider.getContextElement(this.myProject, this.myDebugProcess.getSession().getCurrentPosition());
            editorPsiFile.setContext(debuggerContext);
        }
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String text, String actualToken) throws Exception {
        List<PydevCompletionVariant> list = this.myDebugProcess.getCompletions(actualToken);
        if (list == null) {
            PythonDebugConsoleCommunication.$$$reportNull$$$0(3);
        }
        return list;
    }

    public String getDescription(String refExpression) throws Exception {
        return this.myDebugProcess.getDescription(refExpression);
    }

    public boolean needsMore() {
        return this.myNeedsMore;
    }

    public boolean isExecuting() {
        return this.isExecuting;
    }

    protected void exec(ConsoleCommunication.ConsoleCodeFragment command, final PyDebugCallback<Pair<String, Boolean>> callback) {
        if (this.firstExecution) {
            this.firstExecution = false;
            this.myConsoleView.addConsoleFolding(true, false);
        }
        this.myDebugProcess.consoleExec(command.getText(), new PyDebugCallback<String>(){

            public void ok(String value) {
                callback.ok((Object)AbstractConsoleCommunication.parseExecResponseString((String)value));
                if (PyConsoleUtil.isCommandQueueEnabled(PythonDebugConsoleCommunication.this.myProject)) {
                    ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).removeCommand((ConsoleCommunication)PythonDebugConsoleCommunication.this, false);
                }
            }

            public void error(PyDebuggerException exception) {
                callback.error(exception);
                if (PyConsoleUtil.isCommandQueueEnabled(PythonDebugConsoleCommunication.this.myProject)) {
                    ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).removeCommand((ConsoleCommunication)PythonDebugConsoleCommunication.this, true);
                }
            }
        });
    }

    public void execInterpreter(ConsoleCommunication.ConsoleCodeFragment code, final Function<InterpreterResponse, Object> callback) {
        this.isExecuting = true;
        if (this.waitingForInput) {
            OutputStream processInput = this.myDebugProcess.getProcessHandler().getProcessInput();
            if (processInput != null) {
                try {
                    Charset defaultCharset = EncodingProjectManager.getInstance((Project)this.myDebugProcess.getProject()).getDefaultCharset();
                    processInput.write(code.getText().getBytes(defaultCharset));
                    processInput.flush();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
            }
            this.myNeedsMore = false;
            this.isExecuting = false;
            this.waitingForInput = false;
            this.notifyCommandExecuted(this.waitingForInput);
        } else {
            this.exec(new ConsoleCommunication.ConsoleCodeFragment(code.getText(), false), new PyDebugCallback<Pair<String, Boolean>>(){

                public void ok(Pair<String, Boolean> executed) {
                    boolean more;
                    PythonDebugConsoleCommunication.this.myNeedsMore = more = ((Boolean)executed.second).booleanValue();
                    PythonDebugConsoleCommunication.this.isExecuting = false;
                    PythonDebugConsoleCommunication.this.notifyCommandExecuted(more);
                    callback.fun((Object)new InterpreterResponse(more, PythonDebugConsoleCommunication.this.isWaitingForInput()));
                }

                public void error(PyDebuggerException exception) {
                    PythonDebugConsoleCommunication.this.myNeedsMore = false;
                    PythonDebugConsoleCommunication.this.isExecuting = false;
                    PythonDebugConsoleCommunication.this.notifyCommandExecuted(false);
                    callback.fun((Object)new InterpreterResponse(false, PythonDebugConsoleCommunication.this.isWaitingForInput()));
                }
            });
        }
    }

    public void notifyInputRequested() {
        this.waitingForInput = true;
        super.notifyInputRequested();
    }

    public void interrupt() {
        this.myDebugProcess.interruptDebugConsole();
    }

    public boolean isSuspended() {
        return this.myDebugProcess.getSession().isSuspended();
    }

    public void resume() {
        this.myDebugProcess.getSession().resume();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PythonDebugConsoleCommunication";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PythonDebugConsoleCommunication";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

