/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ExceptionBreakpointProperties;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PositionConverterProvider;
import com.jetbrains.python.debugger.PyBreakpointHandlerFactory;
import com.jetbrains.python.debugger.PyBreakpointType;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyConcurrencyService;
import com.jetbrains.python.debugger.PyDebugNotificationForCythonExtension;
import com.jetbrains.python.debugger.PyDebugShowingNotificationsService;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueDescriptor;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PyExceptionBreakpointHandler;
import com.jetbrains.python.debugger.PyExecutionStack;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.PyLineBreakpointHandler;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PySuspendContext;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.PyUnitTestsDebuggingService;
import com.jetbrains.python.debugger.PyUserTypeRenderer;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import com.jetbrains.python.debugger.containerview.PyViewNumericContainerAction;
import com.jetbrains.python.debugger.pydev.ClientModeMultiProcessDebugger;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.MultiProcessDebugger;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandBuilder;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandResult;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoContext;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoHandler;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariant;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.ConfigureTypeRenderersActionKt;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.ConfigureTypeRenderersHyperLink;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserNodeRenderer;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserTypeRenderersSettings;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.remote.RemoteProcessControl;
import com.jetbrains.python.tables.TableCommandParameters;
import com.jetbrains.python.tables.TableCommandType;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugProcess
extends XDebugProcess
implements IPyDebugProcess,
ProcessListener {
    private static final Logger LOG = Logger.getInstance(PyDebugProcess.class);
    private static final int CONNECTION_TIMEOUT = 60000;
    private final ProcessDebugger myDebugger;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final PyDebuggerEditorsProvider myEditorsProvider;
    private final ProcessHandler myProcessHandler;
    private final ExecutionConsole myExecutionConsole;
    private final Map<PySourcePosition, XLineBreakpoint<?>> myRegisteredBreakpoints;
    private final Map<String, XBreakpoint<? extends ExceptionBreakpointProperties<?>>> myRegisteredExceptionBreakpoints;
    private final Set<PyThreadInfo> mySuspendedThreads;
    private final List<BreakpointHitContext> myBreakpointHits;
    private final Map<String, XValueChildrenList> myStackFrameCache;
    private final Object myFrameCacheObject;
    private final Map<String, PyDebugValue> myNewVariableValue;
    private boolean myDownloadSources;
    protected PyPositionConverter myPositionConverter;
    @NotNull
    private final XSmartStepIntoHandler<?> mySmartStepIntoHandler;
    private boolean myWaitingForConnection;
    private PyStackFrame myConsoleContextFrame;
    private PyReferrersLoader myReferrersProvider;
    private final List<PyFrameListener> myFrameListeners;
    @Nullable
    private XCompositeNode myCurrentRootNode;
    private final Map<String, Map<String, PyDebugValueDescriptor>> myDescriptorsCache;
    private final AtomicBoolean myInlayForFailedTestIsAlreadyShownSentinel;

    public static NotificationGroup getNotificationGroup() {
        return NotificationGroupManager.getInstance().getNotificationGroup("Python Debugger");
    }

    public PyDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, boolean multiProcess) {
        if (session == null) {
            PyDebugProcess.$$$reportNull$$$0(0);
        }
        if (serverSocket == null) {
            PyDebugProcess.$$$reportNull$$$0(1);
        }
        if (executionConsole == null) {
            PyDebugProcess.$$$reportNull$$$0(2);
        }
        this(session, multiProcess ? process2 -> process2.createMultiprocessDebugger(serverSocket) : process2 -> new RemoteDebugger((IPyDebugProcess)process2, serverSocket, process2.getConnectTimeout()), executionConsole, processHandler);
    }

    public PyDebugProcess(@NotNull XDebugSession session, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull String serverHost, int serverPort) {
        if (session == null) {
            PyDebugProcess.$$$reportNull$$$0(3);
        }
        if (executionConsole == null) {
            PyDebugProcess.$$$reportNull$$$0(4);
        }
        if (serverHost == null) {
            PyDebugProcess.$$$reportNull$$$0(5);
        }
        this(session, process2 -> new ClientModeMultiProcessDebugger((IPyDebugProcess)process2, serverHost, serverPort), executionConsole, processHandler);
    }

    private PyDebugProcess(final @NotNull XDebugSession session, @NotNull DebuggerFactory debuggerFactory, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler) {
        if (session == null) {
            PyDebugProcess.$$$reportNull$$$0(6);
        }
        if (debuggerFactory == null) {
            PyDebugProcess.$$$reportNull$$$0(7);
        }
        if (executionConsole == null) {
            PyDebugProcess.$$$reportNull$$$0(8);
        }
        super(session);
        this.myRegisteredBreakpoints = new ConcurrentHashMap();
        this.myRegisteredExceptionBreakpoints = new ConcurrentHashMap();
        this.mySuspendedThreads = Collections.synchronizedSet(new HashSet());
        this.myBreakpointHits = new LinkedList<BreakpointHitContext>();
        this.myStackFrameCache = Maps.newConcurrentMap();
        this.myFrameCacheObject = new Object();
        this.myNewVariableValue = Maps.newHashMap();
        this.myDownloadSources = false;
        this.myWaitingForConnection = false;
        this.myConsoleContextFrame = null;
        this.myFrameListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDescriptorsCache = Maps.newConcurrentMap();
        this.myInlayForFailedTestIsAlreadyShownSentinel = new AtomicBoolean();
        session.setPauseActionSupported(true);
        this.myDebugger = debuggerFactory.createDebugger(this);
        ArrayList<XBreakpointHandler> breakpointHandlers = new ArrayList<XBreakpointHandler>();
        breakpointHandlers.add(new PyLineBreakpointHandler(this));
        breakpointHandlers.add(new PyExceptionBreakpointHandler(this));
        for (PyBreakpointHandlerFactory factory : PyBreakpointHandlerFactory.EP_NAME.getExtensionList()) {
            breakpointHandlers.add(factory.createBreakpointHandler(this));
        }
        this.myBreakpointHandlers = breakpointHandlers.toArray(XBreakpointHandler.EMPTY_ARRAY);
        this.myEditorsProvider = new PyDebuggerEditorsProvider();
        this.myProcessHandler = processHandler;
        this.myExecutionConsole = executionConsole;
        if (this.myProcessHandler != null) {
            this.myProcessHandler.addProcessListener((ProcessListener)this);
        }
        this.myPositionConverter = processHandler instanceof PositionConverterProvider ? ((PositionConverterProvider)processHandler).createPositionConverter(this) : new PyLocalPositionConverter();
        this.mySmartStepIntoHandler = new PySmartStepIntoHandler(this);
        final PyDebugValueExecutionService executionService = PyDebugValueExecutionService.getInstance((Project)this.getProject());
        executionService.sessionStarted((PyFrameAccessor)this);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                executionService.sessionStopped((PyFrameAccessor)PyDebugProcess.this);
            }
        });
        this.myDebugger.addCloseListener(new RemoteDebuggerCloseListener(){

            public void closed() {
                PyDebugProcess.this.handleStop();
            }

            public void communicationError() {
                PyDebugProcess.this.detachDebuggedProcess();
            }

            public void detached() {
                PyDebugProcess.this.detachDebuggedProcess();
            }
        });
        session.addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                XSuspendContext suspendContext;
                String currentFrameThreadId = null;
                XStackFrame currentFrame = session.getCurrentStackFrame();
                if (currentFrame instanceof PyStackFrame) {
                    currentFrameThreadId = ((PyStackFrame)currentFrame).getThreadId();
                }
                if ((suspendContext = session.getSuspendContext()) == null) {
                    return;
                }
                XExecutionStack activeStack = suspendContext.getActiveExecutionStack();
                if (activeStack == null || currentFrameThreadId == null) {
                    return;
                }
                XStackFrame frameFromSuspendContext = activeStack.getTopFrame();
                String activeStackThreadId = null;
                if (frameFromSuspendContext instanceof PyStackFrame) {
                    activeStackThreadId = ((PyStackFrame)frameFromSuspendContext).getThreadId();
                }
                if (!currentFrameThreadId.equals(activeStackThreadId)) {
                    PyThreadInfo threadInfo = null;
                    for (PyThreadInfo info : PyDebugProcess.this.mySuspendedThreads) {
                        if (!info.getId().equals(currentFrameThreadId)) continue;
                        threadInfo = info;
                        break;
                    }
                    if (threadInfo != null) {
                        PyDebugProcess.this.getSession().positionReached((XSuspendContext)PyDebugProcess.this.createSuspendContext(threadInfo));
                    }
                }
                PyFrameListener.publisher().frameChanged();
                for (PyFrameListener listener2 : PyDebugProcess.this.myFrameListeners) {
                    listener2.frameChanged();
                }
            }

            public void sessionStopped() {
                PyFrameListener.publisher().sessionStopped(null);
                super.sessionStopped();
                for (PyFrameListener listener2 : PyDebugProcess.this.myFrameListeners) {
                    listener2.sessionStopped(null);
                }
            }
        });
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                PyUnitTestsDebuggingService.removeInlaysAssociatedWithSession(session);
            }
        });
    }

    private MultiProcessDebugger createMultiprocessDebugger(ServerSocket serverSocket) {
        boolean useDispatcher = Registry.get((String)"python.debugger.use.dispatcher").asBoolean();
        MultiProcessDebugger debugger = new MultiProcessDebugger((IPyDebugProcess)this, serverSocket, this.getConnectTimeout(), useDispatcher);
        debugger.addOtherDebuggerCloseListener(new MultiProcessDebugger.DebuggerProcessListener(){

            public void threadsClosed(Set<String> threadIds) {
                for (PyThreadInfo t : PyDebugProcess.this.mySuspendedThreads) {
                    if (!threadIds.contains(t.getId()) || !PyDebugProcess.this.getSession().isSuspended()) continue;
                    PyDebugProcess.this.getSession().resume();
                    break;
                }
            }
        });
        return debugger;
    }

    protected void detachDebuggedProcess() {
        this.handleStop();
    }

    protected void handleStop() {
        this.getSession().stop();
    }

    public void setPositionConverter(PyPositionConverter positionConverter) {
        this.myPositionConverter = positionConverter;
    }

    public PyPositionConverter getPositionConverter() {
        return this.myPositionConverter;
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            PyDebugProcess.$$$reportNull$$$0(9);
        }
        return this.myBreakpointHandlers;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        PyDebuggerEditorsProvider pyDebuggerEditorsProvider = this.myEditorsProvider;
        if (pyDebuggerEditorsProvider == null) {
            PyDebugProcess.$$$reportNull$$$0(10);
        }
        return pyDebuggerEditorsProvider;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.myExecutionConsole;
        if (executionConsole == null) {
            PyDebugProcess.$$$reportNull$$$0(11);
        }
        return executionConsole;
    }

    @NotNull
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        XSmartStepIntoHandler<?> xSmartStepIntoHandler = this.mySmartStepIntoHandler;
        if (xSmartStepIntoHandler == null) {
            PyDebugProcess.$$$reportNull$$$0(12);
        }
        return xSmartStepIntoHandler;
    }

    public void sessionInitialized() {
        if (PyDebuggerOptionsProvider.getInstance(this.getProject()).isRunDebuggerInServerMode() && Registry.is((String)"python.debug.use.single.port")) {
            return;
        }
        this.waitForConnection(this.getConnectionMessage(), this.getConnectionTitle());
    }

    protected void waitForConnection(final @NlsContexts.ProgressText String connectionMessage, @NlsContexts.ProgressTitle String connectionTitle) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getSession().getProject(), connectionTitle, false){

            public void run(@NotNull ProgressIndicator indicator) {
                block4: {
                    if (indicator == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    indicator.setText(connectionMessage);
                    try {
                        PyDebugProcess.this.beforeConnect();
                        PyDebugProcess.this.myWaitingForConnection = true;
                        PyDebugProcess.this.myDebugger.waitForConnect();
                        PyDebugProcess.this.myWaitingForConnection = false;
                        PyDebugProcess.this.afterConnect();
                        PyDebugProcess.this.handshake();
                        PyDebugProcess.this.init();
                        PyDebugProcess.this.myDebugger.run();
                    }
                    catch (Exception e) {
                        PyDebugProcess.this.myWaitingForConnection = false;
                        if (PyDebugProcess.this.myProcessHandler != null) {
                            PyDebugProcess.this.myProcessHandler.destroyProcess();
                        }
                        if (!PyDebugProcess.this.shouldLogConnectionException(e)) break block4;
                        PyDebugProcess.getNotificationGroup().createNotification(PyBundle.message("debug.notification.title.connection.failed", new Object[0]), e.getMessage(), NotificationType.ERROR).setDisplayId("connection.failed").notify(this.myProject);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/debugger/PyDebugProcess$6", "run"));
            }
        });
    }

    protected boolean shouldLogConnectionException(Exception e) {
        return true;
    }

    public void init() {
        this.getSession().rebuildViews();
        this.registerBreakpoints();
        this.setUserTypeRenderersSettings();
        this.setShowReturnValues(PyDebuggerSettings.getInstance().isWatchReturnValues());
        this.setUnitTestDebuggingMode();
    }

    public int handleDebugPort(int localPort) throws IOException {
        if (this.myProcessHandler instanceof RemoteProcessControl) {
            return (Integer)PyDebugProcess.getRemoteHostPortForDebuggerConnection(localPort, (RemoteProcessControl)this.myProcessHandler).getSecond();
        }
        return localPort;
    }

    protected static Pair<String, Integer> getRemoteHostPortForDebuggerConnection(int localPort, @NotNull RemoteProcessControl handler) throws IOException {
        if (handler == null) {
            PyDebugProcess.$$$reportNull$$$0(13);
        }
        try {
            return handler.getRemoteSocket(localPort);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void recordSignature(PySignature signature) {
        PySignatureCacheManager.getInstance((Project)this.getSession().getProject()).recordSignature(this.myPositionConverter.convertSignature(signature));
    }

    public void recordLogEvent(PyConcurrencyEvent event) {
        PyConcurrencyService.getInstance(this.getSession().getProject()).recordEvent(this.getSession(), event, event.isAsyncio());
    }

    public void showConsole(PyThreadInfo thread) {
        this.myConsoleContextFrame = new PyExecutionStack(this, thread).getTopFrame();
        ExecutionConsole executionConsole = this.myExecutionConsole;
        if (executionConsole instanceof PythonDebugLanguageConsoleView) {
            PythonDebugLanguageConsoleView consoleView = (PythonDebugLanguageConsoleView)executionConsole;
            UIUtil.invokeLaterIfNeeded(() -> {
                consoleView.enableConsole(false);
                consoleView.getPydevConsoleView().setConsoleEnabled(true);
            });
        }
    }

    public void consoleInputRequested(boolean isStarted) {
        if (this.myExecutionConsole instanceof PythonDebugLanguageConsoleView) {
            PythonConsoleView consoleView = ((PythonDebugLanguageConsoleView)this.myExecutionConsole).getPydevConsoleView();
            if (isStarted) {
                consoleView.inputRequested();
            } else {
                consoleView.inputReceived();
            }
        }
    }

    public void showWarning(String warningId) {
        if (warningId.equals("cython") && !PyDebugShowingNotificationsService.getInstance().isCythonNotificationShown()) {
            PyDebugNotificationForCythonExtension.showCythonExtensionWarning(this.getSession().getProject());
            PyDebugShowingNotificationsService.getInstance().setCythonNotificationShown(true);
        }
    }

    protected void afterConnect() {
    }

    protected void beforeConnect() {
    }

    @NlsContexts.ProgressText
    protected String getConnectionMessage() {
        return PyBundle.message("python.debugger.settings.waiting.for.connection", new Object[0]);
    }

    @NlsContexts.ProgressTitle
    protected String getConnectionTitle() {
        return PyBundle.message("python.debugger.settings.connecting.to.debugger", new Object[0]);
    }

    private void handshake() throws PyDebuggerException {
        String remoteVersion = this.myDebugger.handshake();
        String currentBuild = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
        remoteVersion = "@@BUILD_NUMBER@@".equals(remoteVersion) ? currentBuild : StringUtil.trimStart((String)remoteVersion, (String)"PY-");
        this.printToConsole(PyBundle.message("debugger.connected.to.pydev.debugger.build", remoteVersion), ConsoleViewContentType.SYSTEM_OUTPUT);
        if (!remoteVersion.startsWith(currentBuild)) {
            LOG.warn(String.format("Wrong debugger version. Remote version: %s Current build: %s", remoteVersion, currentBuild));
            this.printToConsole(PyBundle.message("debugger.warning.wrong.debugger.version", currentBuild), ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    public void printToConsole(@Nls String text, ConsoleViewContentType contentType) {
        ((ConsoleView)this.myExecutionConsole).print(text, contentType);
    }

    private void registerBreakpoints() {
        this.registerLineBreakpoints();
        this.registerExceptionBreakpoints();
    }

    private void registerExceptionBreakpoints() {
        for (XBreakpoint<? extends ExceptionBreakpointProperties<?>> xBreakpoint : this.myRegisteredExceptionBreakpoints.values()) {
            this.addExceptionBreakpoint(xBreakpoint);
        }
    }

    public void setUserTypeRenderersSettings() {
        ArrayList<PyUserTypeRenderer> renderersList;
        PyUserTypeRenderersSettings settings = PyUserTypeRenderersSettings.getInstance();
        if (settings == null) {
            return;
        }
        if (this.isConnected() && !(renderersList = settings.getApplicableRenderers()).isEmpty()) {
            this.myDebugger.setUserTypeRenderers(renderersList);
        }
    }

    @Nullable
    public XDebuggerTreeNodeHyperlink getUserTypeRenderersLink(@NotNull String typeRendererId) {
        if (typeRendererId == null) {
            PyDebugProcess.$$$reportNull$$$0(14);
        }
        return new ConfigureTypeRenderersHyperLink(typeRendererId, this.getProject(), null);
    }

    public void registerLineBreakpoints() {
        for (Map.Entry<PySourcePosition, XLineBreakpoint<?>> entry : this.myRegisteredBreakpoints.entrySet()) {
            this.addBreakpoint(entry.getKey(), entry.getValue());
        }
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            PyDebugProcess.$$$reportNull$$$0(15);
        }
        if (topToolbar == null) {
            PyDebugProcess.$$$reportNull$$$0(16);
        }
        if (settings == null) {
            PyDebugProcess.$$$reportNull$$$0(17);
        }
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        settings.add((AnAction)new WatchReturnValuesAction(this));
        settings.add((AnAction)new PyVariableViewSettings.SimplifiedView(this));
        settings.add((AnAction)new PyVariableViewSettings.VariablesPolicyGroup());
        settings.add((AnAction)new PyVariableViewSettings.QuotingPolicyGroup());
    }

    public void setShowReturnValues(boolean showReturnValues) {
        this.myDebugger.setShowReturnValues(showReturnValues);
    }

    public void setUnitTestDebuggingMode() {
        ExecutionEnvironment environment = this.getSession().getExecutionEnvironment();
        if (environment == null) {
            return;
        }
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile instanceof AbstractPythonTestRunConfiguration && PyDebuggerOptionsProvider.getInstance(this.getProject()).isDropIntoDebuggerOnFailedTest()) {
            this.myDebugger.setUnitTestDebuggingMode();
        }
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.passToCurrentThread(context, ResumeOrStepCommand.Mode.STEP_OVER);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.passToCurrentThread(context, ResumeOrStepCommand.Mode.STEP_INTO);
    }

    public void startStepIntoMyCode(@Nullable XSuspendContext context) {
        if (!this.checkCanPerformCommands()) {
            return;
        }
        this.getSession().sessionResumed();
        this.passToCurrentThread(context, ResumeOrStepCommand.Mode.STEP_INTO_MY_CODE);
    }

    public void startSetNextStatement(@Nullable XSuspendContext context, @NotNull XSourcePosition sourcePosition, @NotNull PyDebugCallback<Pair<Boolean, String>> callback) {
        if (sourcePosition == null) {
            PyDebugProcess.$$$reportNull$$$0(18);
        }
        if (callback == null) {
            PyDebugProcess.$$$reportNull$$$0(19);
        }
        if (!this.checkCanPerformCommands()) {
            return;
        }
        this.dropFrameCaches();
        if (this.isConnected()) {
            String threadId = PyDebugProcess.threadIdBeforeResumeOrStep(context);
            for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                if (threadId == null || !threadId.equals(suspendedThread.getId())) continue;
                this.myDebugger.setNextStatement(threadId, sourcePosition, this.getFunctionName(sourcePosition), callback);
                break;
            }
        }
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.passToCurrentThread(context, ResumeOrStepCommand.Mode.STEP_OUT);
    }

    public void startSmartStepInto(@NotNull PySmartStepIntoVariant variant) {
        if (variant == null) {
            PyDebugProcess.$$$reportNull$$$0(20);
        }
        String threadId = variant.getContext().getFrame().getThreadId();
        String frameId = variant.getContext().getFrame().getFrameId();
        if (this.isConnected()) {
            this.dropFrameCaches();
            for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                if (!threadId.equals(suspendedThread.getId())) continue;
                PySmartStepIntoContext context = variant.getContext();
                this.myDebugger.smartStepInto(threadId, frameId, variant.getFunctionName(), variant.getCallOrder(), context.getStartLine(), context.getEndLine());
                break;
            }
        }
    }

    @NotNull
    public List<Pair<String, Boolean>> getSmartStepIntoVariants(int startContextLine, int endContextLine) {
        List<Pair<String, Boolean>> list;
        try {
            PyStackFrame frame = this.currentFrame();
            List<Pair<String, Boolean>> smartStepIntoVariants = this.myDebugger.getSmartStepIntoVariants(frame.getThreadId(), frame.getFrameId(), startContextLine, endContextLine);
            list = smartStepIntoVariants != null ? smartStepIntoVariants : Collections.emptyList();
        }
        catch (PyDebuggerException e) {
            List<Pair<String, Boolean>> list2 = Collections.emptyList();
            if (list2 == null) {
                PyDebugProcess.$$$reportNull$$$0(22);
            }
            return list2;
        }
        if (list == null) {
            PyDebugProcess.$$$reportNull$$$0(21);
        }
        return list;
    }

    public void stop() {
        this.myDebugger.close();
    }

    public void resume(@Nullable XSuspendContext context) {
        if (this.myBreakpointHits.isEmpty()) {
            this.passResumeToAllThreads();
        } else {
            BreakpointHitContext breakpointHitContext = this.myBreakpointHits.remove(0);
            boolean shouldStop = this.getSession().breakpointReached(breakpointHitContext.breakpoint, breakpointHitContext.evaluatedLogExpression, breakpointHitContext.suspendContext);
            if (!shouldStop) {
                this.resume(breakpointHitContext.suspendContext);
            }
        }
    }

    public void startPausing() {
        if (this.isConnected()) {
            this.myDebugger.suspendAllThreads();
        }
    }

    public void suspendAllOtherThreads(PyThreadInfo thread) {
        this.myDebugger.suspendOtherThreads(thread);
    }

    public boolean isSuspendedOnAllThreadsPolicy() {
        if (this.getSession().isSuspended()) {
            for (PyThreadInfo threadInfo : this.getThreads()) {
                String exceptionName;
                List frames = threadInfo.getFrames();
                if (threadInfo.getState() != PyThreadInfo.State.SUSPENDED || frames == null) continue;
                XBreakpoint<? extends ExceptionBreakpointProperties<?>> breakpoint = null;
                if (threadInfo.isStopOnBreakpoint()) {
                    PySourcePosition position = ((PyStackFrameInfo)frames.get(0)).getPosition();
                    breakpoint = (XBreakpoint<? extends ExceptionBreakpointProperties<?>>)this.myRegisteredBreakpoints.get(position);
                } else if (threadInfo.isExceptionBreak() && (exceptionName = threadInfo.getMessage()) != null) {
                    breakpoint = this.myRegisteredExceptionBreakpoints.get(exceptionName);
                }
                if (breakpoint == null || !breakpoint.getType().isSuspendThreadSupported() || breakpoint.getSuspendPolicy() != SuspendPolicy.ALL) continue;
                return true;
            }
        }
        return false;
    }

    private void passResumeToAllThreads() {
        this.dropFrameCaches();
        this.myInlayForFailedTestIsAlreadyShownSentinel.set(false);
        if (this.isConnected()) {
            for (PyThreadInfo thread : this.myDebugger.getThreads()) {
                this.myDebugger.resumeOrStep(thread.getId(), ResumeOrStepCommand.Mode.RESUME);
            }
        }
    }

    private void passToCurrentThread(@Nullable XSuspendContext context, ResumeOrStepCommand.Mode mode) {
        this.dropFrameCaches();
        this.myBreakpointHits.clear();
        if (this.isConnected()) {
            String threadId = PyDebugProcess.threadIdBeforeResumeOrStep(context);
            for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                if (threadId != null && !threadId.equals(suspendedThread.getId())) continue;
                this.myDebugger.resumeOrStep(suspendedThread.getId(), mode);
                break;
            }
        }
    }

    @Nullable
    private static String threadIdBeforeResumeOrStep(@Nullable XSuspendContext context) {
        if (context instanceof PySuspendContext) {
            return ((PySuspendContext)context).getActiveExecutionStack().getThreadId();
        }
        return null;
    }

    public boolean isConnected() {
        return this.myDebugger.isConnected();
    }

    protected void disconnect() {
        this.myDebugger.disconnect();
        this.cleanUp();
    }

    public boolean isDownloadSources() {
        return this.myDownloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.myDownloadSources = downloadSources;
    }

    protected void cleanUp() {
        this.mySuspendedThreads.clear();
        this.myDownloadSources = false;
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            PyDebugProcess.$$$reportNull$$$0(23);
        }
        this.dropFrameCaches();
        if (this.isConnected() && !this.mySuspendedThreads.isEmpty()) {
            PySourcePosition pyPosition = this.myPositionConverter.convertToPython(position);
            String type2 = (String)ReadAction.compute(() -> {
                String breakpointTypeId = "python-line";
                Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
                if (document != null) {
                    for (XBreakpointType breakpointType : XBreakpointType.EXTENSION_POINT_NAME.getExtensionList()) {
                        if (!(breakpointType instanceof PyBreakpointType) || !((PyBreakpointType)breakpointType).isBreakpointTypeAllowedInDocument(this.getSession().getProject(), document)) continue;
                        breakpointTypeId = breakpointType.getId();
                        break;
                    }
                }
                return breakpointTypeId;
            });
            this.myDebugger.setTempBreakpoint(type2, pyPosition.getFile(), pyPosition.getLine());
            this.passToCurrentThread(context, ResumeOrStepCommand.Mode.RESUME);
        }
    }

    public PyDebugValue evaluate(String expression, boolean execute2, boolean doTrunc) throws PyDebuggerException {
        this.dropFrameCaches();
        PyStackFrame frame = this.currentFrame();
        return this.evaluate(expression, execute2, frame, doTrunc);
    }

    private PyDebugValue evaluate(String expression, boolean execute2, PyStackFrame frame, boolean trimResult) throws PyDebuggerException {
        PyDebuggerOptionsProvider settings = PyDebuggerOptionsProvider.getInstance(this.getProject());
        return this.myDebugger.evaluate(frame.getThreadId(), frame.getFrameId(), expression, execute2, settings.getEvaluationResponseTimeout(), trimResult);
    }

    public void consoleExec(String command, PyDebugCallback<String> callback) {
        this.dropFrameCaches();
        try {
            PyStackFrame frame = this.currentFrame();
            this.myDebugger.consoleExec(frame.getThreadId(), frame.getFrameId(), command, callback);
        }
        catch (PyDebuggerException e) {
            callback.error(e);
        }
    }

    public String execTableCommand(String command, TableCommandType commandType, TableCommandParameters tableCommandParameters) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        return this.myDebugger.execTableCommand(frame.getThreadId(), frame.getFrameId(), command, commandType, tableCommandParameters);
    }

    public String execTableImageCommand(String command, TableCommandType commandType, TableCommandParameters tableCommandParameters) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        return this.myDebugger.execTableImageCommand(frame.getThreadId(), frame.getFrameId(), command, commandType, tableCommandParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFrameCached(@NotNull XStackFrame contextFrame) {
        if (contextFrame == null) {
            PyDebugProcess.$$$reportNull$$$0(24);
        }
        Object object = this.myFrameCacheObject;
        synchronized (object) {
            PyStackFrame frame = (PyStackFrame)contextFrame;
            return this.myStackFrameCache.containsKey(frame.getThreadFrameId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XValueChildrenList loadFrame(@Nullable XStackFrame contextFrame) throws PyDebuggerException {
        PyStackFrame frame = contextFrame == null ? this.currentFrame() : (PyStackFrame)contextFrame;
        Object object = this.myFrameCacheObject;
        synchronized (object) {
            if (!this.myStackFrameCache.containsKey(frame.getThreadFrameId())) {
                XValueChildrenList values = this.myDebugger.loadFrame(frame.getThreadId(), frame.getFrameId(), ProcessDebugger.GROUP_TYPE.DEFAULT);
                if (values == null) {
                    return null;
                }
                this.myStackFrameCache.put(frame.getThreadFrameId(), values);
            }
            this.showFailedTestInfoIfNecessary(frame);
        }
        return this.applyNewValue(this.getFrameFromCache(frame), frame.getThreadFrameId());
    }

    @NotNull
    public XValueChildrenList loadSpecialVariables(ProcessDebugger.GROUP_TYPE groupType) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        XValueChildrenList values = this.myDebugger.loadFrame(frame.getThreadId(), frame.getFrameId(), groupType);
        if (values != null) {
            PyDebugValue.getAsyncValues((XStackFrame)frame, (PyFrameAccessor)this, (XValueChildrenList)values);
        } else {
            values = XValueChildrenList.EMPTY;
        }
        XValueChildrenList xValueChildrenList = values;
        if (xValueChildrenList == null) {
            PyDebugProcess.$$$reportNull$$$0(25);
        }
        return xValueChildrenList;
    }

    private void showFailedTestInfoIfNecessary(@NotNull PyStackFrame frame) throws PyDebuggerException {
        if (frame == null) {
            PyDebugProcess.$$$reportNull$$$0(26);
        }
        PyExecutionStack pyExecutionStack = null;
        XSuspendContext suspendContext = this.getSession().getSuspendContext();
        if (suspendContext != null) {
            XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
            PyExecutionStack pyExecutionStack2 = pyExecutionStack = executionStack != null ? (PyExecutionStack)executionStack : null;
        }
        if (pyExecutionStack == null || !this.isFailedTestStop(pyExecutionStack.getThreadInfo())) {
            return;
        }
        XValueChildrenList values = this.getFrameFromCache(frame);
        if (values == null) {
            return;
        }
        if (!this.myInlayForFailedTestIsAlreadyShownSentinel.getAndSet(true)) {
            PyDebugValue exceptionDataContainer = PyDebugProcess.getExceptionDataFromFrame(values);
            if (exceptionDataContainer == null) {
                return;
            }
            XValueChildrenList exceptionDataValues = this.loadVariable(exceptionDataContainer);
            if (exceptionDataValues == null || exceptionDataValues.size() < 2) {
                return;
            }
            PyDebugValue exceptionData = (PyDebugValue)exceptionDataValues.getValue(1);
            String exceptionType = exceptionData.getType();
            String errorMessage = exceptionData.getValue();
            if (exceptionType == null || errorMessage == null) {
                return;
            }
            if (exceptionType.equals("EqualsAssertionError") && errorMessage.startsWith(" :: ")) {
                errorMessage = errorMessage.replaceFirst(" :: ", "");
            }
            PyThreadInfo threadInfo = pyExecutionStack.getThreadInfo();
            List threadFrames = threadInfo.getFrames();
            boolean isTestSetUpFail = false;
            if (threadFrames != null && (threadFrames.size() == 1 || threadFrames.size() > 1 && PyUnitTestsDebuggingService.isErrorInTestSetUpOrTearDown(threadFrames))) {
                isTestSetUpFail = true;
            }
            ((PyUnitTestsDebuggingService)this.getProject().getService(PyUnitTestsDebuggingService.class)).showFailedTestInlay(this.getSession(), frame, exceptionType, errorMessage, isTestSetUpFail);
        }
    }

    public void loadAsyncVariablesValues(@Nullable XStackFrame contextFrame, @NotNull List<PyFrameAccessor.PyAsyncValue<String>> pyAsyncValues) {
        if (pyAsyncValues == null) {
            PyDebugProcess.$$$reportNull$$$0(27);
        }
        PyDebugValueExecutionService.getInstance((Project)this.getProject()).submitTask((PyFrameAccessor)this, () -> {
            block7: {
                try {
                    if (!this.isConnected()) break block7;
                    PyStackFrame frame = contextFrame == null ? this.currentFrame() : (PyStackFrame)contextFrame;
                    XSuspendContext context = this.getSession().getSuspendContext();
                    String threadId = PyDebugProcess.threadIdBeforeResumeOrStep(context);
                    for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                        if (threadId != null && !threadId.equals(suspendedThread.getId())) continue;
                        this.myDebugger.loadFullVariableValues(frame.getThreadId(), frame.getFrameId(), pyAsyncValues);
                        break;
                    }
                }
                catch (PyDebuggerException e) {
                    if (!this.isConnected()) {
                        return;
                    }
                    for (PyFrameAccessor.PyAsyncValue asyncValue : pyAsyncValues) {
                        PyDebugValue value = asyncValue.getDebugValue();
                        for (XValueNode node : value.getValueNodes()) {
                            if (node == null || node.isObsolete()) continue;
                            if (e.getMessage().startsWith("Timeout")) {
                                value.updateNodeValueAfterLoading(node, " ", "", PyBundle.message("debugger.variables.view.loading.timed.out", new Object[0]));
                                ConfigureTypeRenderersHyperLink configureLink = new ConfigureTypeRenderersHyperLink(null, this.getProject(), value);
                                if (!(node instanceof XValueNodeImpl)) continue;
                                XValueNodeImpl valueNode = (XValueNodeImpl)node;
                                valueNode.clearAdditionalHyperlinks();
                                valueNode.addAdditionalHyperlink((XDebuggerTreeNodeHyperlink)configureLink);
                                continue;
                            }
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        });
    }

    private XValueChildrenList applyNewValue(XValueChildrenList pyDebugValues, String threadFrameId) {
        if (this.myNewVariableValue.containsKey(threadFrameId)) {
            PyDebugValue newValue = this.myNewVariableValue.get(threadFrameId);
            XValueChildrenList res = new XValueChildrenList();
            for (int i = 0; i < pyDebugValues.size(); ++i) {
                String name2 = pyDebugValues.getName(i);
                if (name2.equals(newValue.getName())) {
                    res.add(name2, (XValue)newValue);
                    continue;
                }
                res.add(name2, pyDebugValues.getValue(i));
            }
            return res;
        }
        return pyDebugValues;
    }

    @NotNull
    public XValueChildrenList loadVariableDefaultView(PyDebugValue variable) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        PyDebugValue debugValue = new PyDebugValue(variable, variable.getFullName());
        XValueChildrenList result2 = this.myDebugger.loadVariable(frame.getThreadId(), frame.getFrameId(), debugValue);
        if (result2 == null) {
            throw new PyDebuggerException("Failed to load a variable");
        }
        XValueChildrenList xValueChildrenList = result2;
        if (xValueChildrenList == null) {
            PyDebugProcess.$$$reportNull$$$0(28);
        }
        return xValueChildrenList;
    }

    @Nullable
    public XValueChildrenList loadVariable(PyDebugValue var) throws PyDebuggerException {
        PyDebugValue debugValue = new PyDebugValue(var, var.getFullName());
        PyUserNodeRenderer typeRenderer = ConfigureTypeRenderersActionKt.getTypeRenderer(var);
        if (typeRenderer != null) {
            return ConfigureTypeRenderersActionKt.loadTypeRendererChildren((PyFrameAccessor)this, debugValue, typeRenderer);
        }
        return this.loadVariableDefaultView(debugValue);
    }

    public void loadReferrers(PyReferringObjectsValue var, PyDebugCallback<? super XValueChildrenList> callback) {
        try {
            PyStackFrame frame = this.currentFrame();
            this.myDebugger.loadReferrers(frame.getThreadId(), frame.getFrameId(), var, callback);
        }
        catch (PyDebuggerException e) {
            callback.error(e);
        }
    }

    public void changeVariable(PyDebugValue var, String value) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        PyDebugValue newValue = this.myDebugger.changeVariable(frame.getThreadId(), frame.getFrameId(), var, value);
        this.myNewVariableValue.put(frame.getThreadFrameId(), newValue);
    }

    @Nullable
    public PyReferrersLoader getReferrersLoader() {
        if (this.myReferrersProvider == null) {
            this.myReferrersProvider = new PyReferrersLoader((IPyDebugProcess)this);
        }
        return this.myReferrersProvider;
    }

    public ArrayChunk getArrayItems(PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        return this.myDebugger.loadArrayItems(frame.getThreadId(), frame.getFrameId(), var, rowOffset, colOffset, rows, cols, format);
    }

    public DataViewerCommandResult executeDataViewerCommand(DataViewerCommandBuilder builder) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        builder.setThreadId(frame.getThreadId());
        builder.setFrameId(frame.getFrameId());
        return this.myDebugger.executeDataViewerCommand(builder);
    }

    @Nullable
    public String loadSource(String path2) {
        return this.myDebugger.loadSource(path2);
    }

    public boolean canSaveToTemp(String name2) {
        Project project = this.getSession().getProject();
        return PyDebugSupportUtils.canSaveToTemp(project, name2);
    }

    public void setCurrentRootNode(@Nullable XCompositeNode currentRootNode) {
        this.myCurrentRootNode = currentRootNode;
    }

    @Nullable
    public XCompositeNode getCurrentRootNode() {
        return this.myCurrentRootNode;
    }

    @NotNull
    private PyStackFrame currentFrame() throws PyDebuggerException {
        if (!this.isConnected()) {
            throw new PyDebuggerException("Disconnected");
        }
        PyStackFrame frame = (PyStackFrame)this.getSession().getCurrentStackFrame();
        if (frame == null && this.myConsoleContextFrame != null) {
            PyStackFrame pyStackFrame = this.myConsoleContextFrame;
            if (pyStackFrame == null) {
                PyDebugProcess.$$$reportNull$$$0(29);
            }
            return pyStackFrame;
        }
        if (frame == null) {
            throw new PyDebuggerException(PyBundle.message("debugger.debug.process.running", new Object[0]));
        }
        PyStackFrame pyStackFrame = frame;
        if (pyStackFrame == null) {
            PyDebugProcess.$$$reportNull$$$0(30);
        }
        return pyStackFrame;
    }

    private String getFunctionNameForBreakpoint(XLineBreakpoint<?> breakpoint) {
        XSourcePosition sourcePosition = breakpoint.getSourcePosition();
        return sourcePosition == null ? null : this.getFunctionName(sourcePosition);
    }

    @Nullable
    private String getFunctionName(@NotNull XSourcePosition position) {
        if (position == null) {
            PyDebugProcess.$$$reportNull$$$0(31);
        }
        VirtualFile file = position.getFile();
        return (String)ReadAction.compute(() -> {
            PsiElement psiElement;
            PyFunction function;
            int breakpointLine;
            Document document = FileDocumentManager.getInstance().getDocument(file);
            Project project = this.getSession().getProject();
            if (document != null && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PythonFileType.INSTANCE) && (breakpointLine = position.getLine()) < document.getLineCount() && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(psiElement = XDebuggerUtil.getInstance().findContextElement(file, document.getLineStartOffset(breakpointLine), project, false)), PyFunction.class)) != null) {
                return function.getName();
            }
            return null;
        });
    }

    public void addBreakpoint(PySourcePosition position, XLineBreakpoint<?> breakpoint) {
        this.myRegisteredBreakpoints.put(position, breakpoint);
        if (this.isConnected()) {
            String conditionExpression = breakpoint.getConditionExpression() == null ? null : breakpoint.getConditionExpression().getExpression();
            String logExpression = breakpoint.getLogExpressionObject() == null ? null : breakpoint.getLogExpressionObject().getExpression();
            SuspendPolicy policy = breakpoint.getType().isSuspendThreadSupported() ? breakpoint.getSuspendPolicy() : SuspendPolicy.NONE;
            this.myDebugger.setBreakpoint(breakpoint.getType().getId(), position.getFile(), position.getLine(), conditionExpression, logExpression, this.getFunctionNameForBreakpoint(breakpoint), policy);
        }
    }

    public void removeBreakpoint(PySourcePosition position) {
        XLineBreakpoint<?> breakpoint = this.myRegisteredBreakpoints.get(position);
        if (breakpoint != null) {
            this.myRegisteredBreakpoints.remove(position);
            if (this.isConnected()) {
                this.myDebugger.removeBreakpoint(breakpoint.getType().getId(), position.getFile(), position.getLine());
            }
        }
    }

    public void addExceptionBreakpoint(XBreakpoint<? extends ExceptionBreakpointProperties<?>> breakpoint) {
        this.myRegisteredExceptionBreakpoints.put(((ExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionBreakpointId(), breakpoint);
        if (this.isConnected()) {
            String conditionExpression = breakpoint.getConditionExpression() == null ? null : breakpoint.getConditionExpression().getExpression();
            ((ExceptionBreakpointProperties)breakpoint.getProperties()).setCondition(conditionExpression);
            String logExpression = breakpoint.getLogExpressionObject() == null ? null : breakpoint.getLogExpressionObject().getExpression();
            ((ExceptionBreakpointProperties)breakpoint.getProperties()).setLogExpression(logExpression);
            this.myDebugger.addExceptionBreakpoint((ExceptionBreakpointCommandFactory)breakpoint.getProperties());
        }
    }

    public void removeExceptionBreakpoint(XBreakpoint<? extends ExceptionBreakpointProperties<?>> breakpoint) {
        this.myRegisteredExceptionBreakpoints.remove(((ExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionBreakpointId());
        if (this.isConnected()) {
            this.myDebugger.removeExceptionBreakpoint((ExceptionBreakpointCommandFactory)breakpoint.getProperties());
        }
    }

    public Collection<PyThreadInfo> getThreads() {
        return this.myDebugger.getThreads();
    }

    public void threadSuspended(PyThreadInfo threadInfo, boolean updateSourcePosition) {
        if (!this.mySuspendedThreads.contains(threadInfo)) {
            this.mySuspendedThreads.add(threadInfo);
            List frames = threadInfo.getFrames();
            if (frames != null) {
                String exceptionName;
                PySuspendContext suspendContext = this.createSuspendContext(threadInfo);
                XBreakpoint breakpoint = null;
                if (threadInfo.isStopOnBreakpoint()) {
                    PySourcePosition framePosition = ((PyStackFrameInfo)frames.get(0)).getPosition();
                    PySourcePosition position = this.myPositionConverter.convertFrameToPython(framePosition);
                    breakpoint = (XBreakpoint)this.myRegisteredBreakpoints.get(position);
                    if (breakpoint == null) {
                        this.myDebugger.removeTempBreakpoint(position.getFile(), position.getLine());
                    }
                } else if (threadInfo.isExceptionBreak() && (exceptionName = threadInfo.getMessage()) != null) {
                    breakpoint = this.myRegisteredExceptionBreakpoints.get(exceptionName);
                }
                if (breakpoint != null && breakpoint.getType().isSuspendThreadSupported() && breakpoint.getSuspendPolicy() == SuspendPolicy.ALL) {
                    this.suspendAllOtherThreads(threadInfo);
                }
                if (updateSourcePosition) {
                    if (breakpoint != null) {
                        if (!this.getSession().breakpointReached(breakpoint, threadInfo.getMessage(), (XSuspendContext)suspendContext)) {
                            this.resume(suspendContext);
                        }
                    } else {
                        this.getSession().positionReached((XSuspendContext)suspendContext, this.isFailedTestStop(threadInfo));
                    }
                } else if (breakpoint != null) {
                    this.myBreakpointHits.add(new BreakpointHitContext(breakpoint, threadInfo.getMessage(), suspendContext));
                }
            }
        }
    }

    @NotNull
    protected PySuspendContext createSuspendContext(PyThreadInfo threadInfo) {
        return new PySuspendContext(this, threadInfo);
    }

    public void threadResumed(PyThreadInfo threadInfo) {
        this.mySuspendedThreads.remove(threadInfo);
    }

    public void dropFrameCaches() {
        this.myStackFrameCache.clear();
        this.myNewVariableValue.clear();
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String prefix) throws Exception {
        if (this.isConnected()) {
            PyStackFrame frame = this.currentFrame();
            List list = this.myDebugger.getCompletions(frame.getThreadId(), frame.getFrameId(), prefix);
            if (list == null) {
                PyDebugProcess.$$$reportNull$$$0(32);
            }
            return list;
        }
        return new ArrayList<PydevCompletionVariant>();
    }

    @NotNull
    public String getDescription(String prefix) throws Exception {
        if (this.isConnected()) {
            PyStackFrame frame = this.currentFrame();
            String string = this.myDebugger.getDescription(frame.getThreadId(), frame.getFrameId(), prefix);
            if (string == null) {
                PyDebugProcess.$$$reportNull$$$0(33);
            }
            return string;
        }
        return "";
    }

    public void interruptDebugConsole() {
        if (this.isConnected()) {
            this.myDebugger.interruptDebugConsole();
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            PyDebugProcess.$$$reportNull$$$0(34);
        }
        this.myDebugger.close();
    }

    public PyStackFrame createStackFrame(PyStackFrameInfo frameInfo) {
        PyStackFrame frame = new PyStackFrame(this.getSession().getProject(), (PyFrameAccessor)this, frameInfo, this.getPositionConverter().convertFromPython(frameInfo.getPosition(), frameInfo.getName()));
        frame.restoreChildrenDescriptors(this.myDescriptorsCache);
        return frame;
    }

    @NlsContexts.ProgressText
    public String getCurrentStateMessage() {
        if (this.getSession().isStopped()) {
            return XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
        }
        if (this.isConnected()) {
            return XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
        }
        return this.getConnectionMessage();
    }

    public void addProcessListener(ProcessListener listener2) {
        ProcessHandler handler = this.doGetProcessHandler();
        if (handler != null) {
            handler.addProcessListener(listener2);
        }
    }

    public boolean isWaitingForConnection() {
        return this.myWaitingForConnection;
    }

    public void setWaitingForConnection(boolean waitingForConnection) {
        this.myWaitingForConnection = waitingForConnection;
    }

    public int getConnectTimeout() {
        return 60000;
    }

    @Nullable
    protected XSourcePosition getCurrentFrameSourcePosition() {
        try {
            PyStackFrame frame = this.currentFrame();
            return frame.getSourcePosition();
        }
        catch (PyDebuggerException e) {
            return null;
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.getSession().getProject();
        if (project == null) {
            PyDebugProcess.$$$reportNull$$$0(35);
        }
        return project;
    }

    @Nullable
    public XSourcePosition getSourcePositionForName(String name2, String parentType) {
        if (name2 == null) {
            return null;
        }
        XSourcePosition currentPosition = this.getCurrentFrameSourcePosition();
        PsiFile file = this.getPsiFile(currentPosition);
        if (file == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)parentType)) {
            Ref<PsiElement> elementRef = PyDebugProcess.resolveInCurrentFrame(name2, currentPosition, file);
            return elementRef.isNull() ? null : XDebuggerUtil.getInstance().createPositionByElement((PsiElement)elementRef.get());
        }
        PyType parentDef = this.resolveTypeFromString(parentType, file);
        if (parentDef == null) {
            return null;
        }
        TypeEvalContext context = TypeEvalContext.codeInsightFallback((Project)file.getProject());
        List results = parentDef.resolveMember(name2, null, AccessDirection.READ, PyResolveContext.defaultContext((TypeEvalContext)context));
        if (results != null && !results.isEmpty()) {
            return XDebuggerUtil.getInstance().createPositionByElement(((RatedResolveResult)results.get(0)).getElement());
        }
        return PyDebugProcess.typeToPosition(parentDef);
    }

    @NotNull
    private static Ref<PsiElement> resolveInCurrentFrame(final String name2, XSourcePosition currentPosition, PsiFile file) {
        final Ref elementRef = Ref.create();
        PsiElement currentElement = file.findElementAt(currentPosition.getOffset());
        if (currentElement == null) {
            Ref ref = elementRef;
            if (ref == null) {
                PyDebugProcess.$$$reportNull$$$0(36);
            }
            return ref;
        }
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (element instanceof PyImportElement) {
                    PyImportElement importElement = (PyImportElement)element;
                    if (name2.equals(importElement.getVisibleName())) {
                        if (elementRef.isNull()) {
                            elementRef.set((Object)element);
                        }
                        return false;
                    }
                    return true;
                }
                if (elementRef.isNull()) {
                    elementRef.set((Object)element);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/debugger/PyDebugProcess$7";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (PsiElement)currentElement, (String)name2, null);
        Ref ref = elementRef;
        if (ref == null) {
            PyDebugProcess.$$$reportNull$$$0(37);
        }
        return ref;
    }

    @Nullable
    private PsiFile getPsiFile(XSourcePosition currentPosition) {
        if (currentPosition == null) {
            return null;
        }
        return PsiManager.getInstance((Project)this.getProject()).findFile(currentPosition.getFile());
    }

    @Nullable
    public XSourcePosition getSourcePositionForType(String typeName) {
        XSourcePosition currentPosition = this.getCurrentFrameSourcePosition();
        PsiFile file = this.getPsiFile(currentPosition);
        if (typeName == null || !(file instanceof PyFile)) {
            return null;
        }
        PyType pyType = this.resolveTypeFromString(typeName, file);
        return pyType == null ? null : PyDebugProcess.typeToPosition(pyType);
    }

    public void showNumericContainer(@NotNull PyDebugValue value) {
        if (value == null) {
            PyDebugProcess.$$$reportNull$$$0(38);
        }
        PyViewNumericContainerAction.showNumericViewer(this.getProject(), value);
    }

    public void addFrameListener(@NotNull PyFrameListener listener2) {
        if (listener2 == null) {
            PyDebugProcess.$$$reportNull$$$0(39);
        }
        this.myFrameListeners.add(listener2);
    }

    public boolean isSimplifiedView() {
        return PyDebuggerSettings.getInstance().isSimplifiedView();
    }

    @Nullable
    private static XSourcePosition typeToPosition(PyType pyType) {
        PyClassType classType = (PyClassType)PyUtil.as((Object)pyType, PyClassType.class);
        if (classType != null) {
            return XDebuggerUtil.getInstance().createPositionByElement((PsiElement)classType.getPyClass());
        }
        PyModuleType moduleType = (PyModuleType)PyUtil.as((Object)pyType, PyModuleType.class);
        if (moduleType != null) {
            return XDebuggerUtil.getInstance().createPositionByElement((PsiElement)moduleType.getModule());
        }
        return null;
    }

    private PyType resolveTypeFromString(String typeName, PsiFile file) {
        typeName = typeName.replace("__builtin__.", "");
        PyType pyType = null;
        if (!typeName.contains(".")) {
            pyType = PyTypeParser.getTypeByName((PsiElement)file, (String)typeName);
        }
        if (pyType == null) {
            PyElementGenerator generator = PyElementGenerator.getInstance((Project)this.getProject());
            PyPsiFacade psiFacade = PyPsiFacade.getInstance((Project)this.getProject());
            PsiFile dummyFile = generator.createDummyFile(LanguageLevel.forElement((PsiElement)file), "");
            Module moduleForFile = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            dummyFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)moduleForFile);
            pyType = psiFacade.parseTypeAnnotation(typeName, (PsiElement)dummyFile);
        }
        return pyType;
    }

    boolean isFailedTestStop(@NotNull PyThreadInfo threadInfo) {
        if (threadInfo == null) {
            PyDebugProcess.$$$reportNull$$$0(40);
        }
        return threadInfo.isExceptionBreak() && !this.myRegisteredExceptionBreakpoints.containsKey(threadInfo.getMessage());
    }

    @Nullable
    private XValueChildrenList getFrameFromCache(@NotNull PyStackFrame frame) {
        if (frame == null) {
            PyDebugProcess.$$$reportNull$$$0(41);
        }
        return this.myStackFrameCache.getOrDefault(frame.getThreadFrameId(), null);
    }

    @Nullable
    private static PyDebugValue getExceptionDataFromFrame(@NotNull XValueChildrenList values) {
        if (values == null) {
            PyDebugProcess.$$$reportNull$$$0(42);
        }
        for (int i = 0; i < values.size(); ++i) {
            if (!values.getName(i).equals("__exception__")) continue;
            return (PyDebugValue)values.getValue(i);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 21, 22, 25, 28, 29, 30, 32, 33, 35, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSocket";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverHost";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerFactory";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebugProcess";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRendererId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFrame";
                break;
            }
            case 26: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyAsyncValues";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfo";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebugProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmartStepIntoHandler";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmartStepIntoVariants";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSpecialVariables";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "loadVariableDefaultView";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "currentFrame";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInCurrentFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteHostPortForDebuggerConnection";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getUserTypeRenderersLink";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "startSetNextStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "startSmartStepInto";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isFrameCached";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showFailedTestInfoIfNecessary";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadAsyncVariablesValues";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processTerminated";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "showNumericContainer";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addFrameListener";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isFailedTestStop";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFrameFromCache";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionDataFromFrame";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 21, 22, 25, 28, 29, 30, 32, 33, 35, 36, 37 -> new IllegalStateException(string);
        };
    }

    private static interface DebuggerFactory {
        @NotNull
        public ProcessDebugger createDebugger(@NotNull PyDebugProcess var1);
    }

    private static final class WatchReturnValuesAction
    extends ToggleAction {
        private volatile boolean myWatchesReturnValues;
        private final PyDebugProcess myProcess;
        private final @NlsActions.ActionText String myText;

        WatchReturnValuesAction(@NotNull PyDebugProcess debugProcess) {
            if (debugProcess == null) {
                WatchReturnValuesAction.$$$reportNull$$$0(0);
            }
            super("", PyBundle.message("debugger.watch.return.values.description", new Object[0]), null);
            this.myWatchesReturnValues = PyDebuggerSettings.getInstance().isWatchReturnValues();
            this.myProcess = debugProcess;
            this.myText = PyBundle.message("debugger.watch.show.return.values", new Object[0]);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                WatchReturnValuesAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
            presentation.setText(this.myText);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                WatchReturnValuesAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                WatchReturnValuesAction.$$$reportNull$$$0(3);
            }
            return this.myWatchesReturnValues;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean watch) {
            if (e == null) {
                WatchReturnValuesAction.$$$reportNull$$$0(4);
            }
            this.myWatchesReturnValues = watch;
            PyDebuggerSettings.getInstance().setWatchReturnValues(watch);
            Project project = e.getProject();
            if (project != null) {
                this.myProcess.setShowReturnValues(this.myWatchesReturnValues);
                this.myProcess.getSession().rebuildViews();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcess";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyDebugProcess$WatchReturnValuesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyDebugProcess$WatchReturnValuesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private record BreakpointHitContext(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        @NotNull
        private final XBreakpoint<?> breakpoint;
        @NotNull
        private final XSuspendContext suspendContext;

        private BreakpointHitContext(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
            if (breakpoint == null) {
                BreakpointHitContext.$$$reportNull$$$0(0);
            }
            if (suspendContext == null) {
                BreakpointHitContext.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public XBreakpoint<?> breakpoint() {
            XBreakpoint<?> xBreakpoint = this.breakpoint;
            if (xBreakpoint == null) {
                BreakpointHitContext.$$$reportNull$$$0(2);
            }
            return xBreakpoint;
        }

        @NotNull
        public XSuspendContext suspendContext() {
            XSuspendContext xSuspendContext = this.suspendContext;
            if (xSuspendContext == null) {
                BreakpointHitContext.$$$reportNull$$$0(3);
            }
            return xSuspendContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakpoint";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyDebugProcess$BreakpointHitContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyDebugProcess$BreakpointHitContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "breakpoint";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suspendContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

