/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.actions.PyExecuteInConsole;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugAsyncioCustomizer;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugSessionFactory;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PydevDebugConsoleExecuteActionHandler;
import com.jetbrains.python.debugger.ValuesPolicy;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.DebugAwareConfiguration;
import com.jetbrains.python.run.EnvironmentController;
import com.jetbrains.python.run.PlainEnvironmentController;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonModuleExecution;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.PythonToolExecution;
import com.jetbrains.python.run.PythonToolModuleExecution;
import com.jetbrains.python.run.PythonToolScriptExecution;
import com.jetbrains.python.run.TargetEnvironmentController;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class PyDebugRunner
implements ProgramRunner<RunnerSettings> {
    @NonNls
    public static final String PY_DEBUG_RUNNER = "PyDebugRunner";
    @NonNls
    public static final String DEBUGGER_MAIN = "pydev/pydevd.py";
    @NonNls
    public static final String CLIENT_PARAM = "--client";
    @NonNls
    public static final String PORT_PARAM = "--port";
    @NonNls
    public static final String FILE_PARAM = "--file";
    @NonNls
    public static final String MODULE_PARAM = "--module";
    @NonNls
    public static final String MULTIPROCESS_PARAM = "--multiprocess";
    @NonNls
    public static final String IDE_PROJECT_ROOTS = "IDE_PROJECT_ROOTS";
    @NonNls
    public static final String LIBRARY_ROOTS = "LIBRARY_ROOTS";
    @NonNls
    public static final String PYTHON_ASYNCIO_DEBUG = "PYTHONASYNCIODEBUG";
    @NonNls
    public static final String GEVENT_SUPPORT = "GEVENT_SUPPORT";
    @NonNls
    public static final String PYDEVD_FILTERS = "PYDEVD_FILTERS";
    @NonNls
    public static final String PYDEVD_FILTER_LIBRARIES = "PYDEVD_FILTER_LIBRARIES";
    @NonNls
    public static final String CYTHON_EXTENSIONS_DIR = new File(PathManager.getSystemPath(), "cythonExtensions").toString();
    @NonNls
    protected static final String PYDEVD_USE_CYTHON = "PYDEVD_USE_CYTHON";
    @NonNls
    protected static final String PYCHARM_DEBUG = "PYCHARM_DEBUG";
    @NonNls
    protected static final String USE_LOW_IMPACT_MONITORING = "USE_LOW_IMPACT_MONITORING";
    @NonNls
    protected static final String HALT_VARIABLE_RESOLVE_THREADS_ON_STEP_RESUME = "HALT_VARIABLE_RESOLVE_THREADS_ON_STEP_RESUME";
    @NonNls
    private static final String PYTHONPATH_ENV_NAME = "PYTHONPATH";
    @NonNls
    private static final String PYTHON_DONT_WRITE_PYC_FLAG = "-B";
    @NonNls
    private static final String PYTHON3_PYCACHE_PREFIX_OPTION = "pycache_prefix=";
    private static final Logger LOG = Logger.getInstance(PyDebugRunner.class);
    private PyDebugProcess pyDebugProcess = null;
    public static final Key<Boolean> FORCE_DISABLE_DEBUGGER_TRACING = Key.create((String)"FORCE_DISABLE_DEBUGGER_TRACING");

    @NotNull
    public String getRunnerId() {
        return PY_DEBUG_RUNNER;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PyDebugRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            PyDebugRunner.$$$reportNull$$$0(1);
        }
        if (!"Debug".equals(executorId)) {
            return false;
        }
        if (profile instanceof WrappingRunConfiguration) {
            return PyDebugRunner.isDebuggable((RunProfile)((WrappingRunConfiguration)profile).getPeer());
        }
        return PyDebugRunner.isDebuggable(profile);
    }

    private static boolean isDebuggable(@NotNull RunProfile profile) {
        if (profile == null) {
            PyDebugRunner.$$$reportNull$$$0(2);
        }
        if (profile instanceof DebugAwareConfiguration) {
            return ((DebugAwareConfiguration)profile).canRunUnderDebug();
        }
        return profile instanceof AbstractPythonRunConfiguration;
    }

    @RequiresEdt
    protected Promise<@NotNull XDebugSession> createSession(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
        if (state == null) {
            PyDebugRunner.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.createSessionUsingTargetsApi(state, environment);
    }

    @NotNull
    private Promise<XDebugSession> createSessionUsingTargetsApi(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
        if (state == null) {
            PyDebugRunner.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(6);
        }
        PythonCommandLineState pyState = (PythonCommandLineState)state;
        RunProfile profile = environment.getRunProfile();
        if (PyDebuggerOptionsProvider.getInstance(environment.getProject()).isRunDebuggerInServerMode() && Registry.is((String)"python.debug.use.single.port")) {
            int port = PyDebuggerOptionsProvider.getInstance(environment.getProject()).getDebuggerPort();
            TargetEnvironment.TargetPortBinding targetPortBinding = new TargetEnvironment.TargetPortBinding(Integer.valueOf(port), port);
            Promise promise = Promises.runAsync(() -> {
                try {
                    PythonDebuggerServerModeTargetedCommandLineBuilder debuggerScriptCommandLineBuilder = new PythonDebuggerServerModeTargetedCommandLineBuilder(this, environment.getProject(), pyState, profile, targetPortBinding);
                    return pyState.execute(environment.getExecutor(), debuggerScriptCommandLineBuilder);
                }
                catch (ExecutionException err) {
                    throw new RuntimeException(err);
                }
            }).thenAsync(result2 -> AppUIExecutor.onUiThread().submit(() -> this.createXDebugSession(environment, port, (ExecutionResult)result2)));
            if (promise == null) {
                PyDebugRunner.$$$reportNull$$$0(7);
            }
            return promise;
        }
        ClientId clientId = ClientId.getCurrentOrNull();
        Promise promise = Promises.runAsync(() -> {
            int serverLocalPort = PyDebugRunner.findAvailableSocketPort();
            try {
                TargetEnvironment.LocalPortBinding localPortBinding = new TargetEnvironment.LocalPortBinding(serverLocalPort, null);
                PythonDebuggerClientModeTargetedCommandLineBuilder debuggerScriptCommandLineBuilder = new PythonDebuggerClientModeTargetedCommandLineBuilder(this, environment.getProject(), pyState, profile, localPortBinding);
                ExecutionResult result2 = pyState.execute(environment.getExecutor(), debuggerScriptCommandLineBuilder);
                ServerSocket serverSocket = debuggerScriptCommandLineBuilder.getServerSocketForDebugging();
                if (serverSocket == null) {
                    LOG.error("The server socket has not been created after the target environment preparation, trying to fallback and create the server socket on the loopback address");
                    serverSocket = PyDebugRunner.createServerSocketOnLoopbackAddress(serverLocalPort);
                }
                return Pair.create((Object)serverSocket, (Object)result2);
            }
            catch (Exception err) {
                throw new RuntimeException(err.getMessage(), err);
            }
        }).thenAsync(pair -> AppUIExecutor.onUiThread().submit(() -> {
            try (AccessToken ignored = ClientId.withClientId((ClientId)clientId);){
                ServerSocket serverSocket = (ServerSocket)pair.getFirst();
                ExecutionResult result2 = (ExecutionResult)pair.getSecond();
                XDebugSession xDebugSession = this.createXDebugSession(environment, pyState, serverSocket, result2);
                return xDebugSession;
            }
        }));
        if (promise == null) {
            PyDebugRunner.$$$reportNull$$$0(8);
        }
        return promise;
    }

    @NotNull
    private static ServerSocket createServerSocketOnLoopbackAddress(int serverLocalPort) {
        try {
            return new ServerSocket(serverLocalPort, 0, InetAddress.getLoopbackAddress());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static int findAvailableSocketPort() {
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            throw new RuntimeException(PyBundle.message("runcfg.error.message.failed.to.find.free.socket.port", new Object[0]), e);
        }
    }

    @NotNull
    private XDebugSession createXDebugSession(final @NotNull ExecutionEnvironment environment, final PythonCommandLineState pyState, final ServerSocket serverSocket, final ExecutionResult result2) throws ExecutionException {
        RunnerLayoutUi sessionUi;
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(9);
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyDebugRunner.this.pyDebugProcess = PyDebugRunner.this.createDebugProcess(session, serverSocket, result2, pyState);
                PyDebugRunner.createConsoleCommunicationAndSetupActions(environment.getProject(), result2, PyDebugRunner.this.pyDebugProcess, session);
                PyDebugProcess pyDebugProcess = PyDebugRunner.this.pyDebugProcess;
                if (pyDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pyDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        if (ExperimentalUI.isNewUI() && (sessionUi = session.getUI()) != null) {
            sessionUi.getDefaults().initContentAttraction("ConsoleContent", "finish", (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce());
        }
        XDebugSession xDebugSession = session;
        if (xDebugSession == null) {
            PyDebugRunner.$$$reportNull$$$0(10);
        }
        return xDebugSession;
    }

    @NotNull
    private XDebugSession createXDebugSession(final @NotNull ExecutionEnvironment environment, final int serverPort, final ExecutionResult result2) throws ExecutionException {
        RunnerLayoutUi sessionUi;
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(11);
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    2.$$$reportNull$$$0(0);
                }
                PyDebugProcess pyDebugProcess = PyDebugRunner.this.createDebugProcess(session, serverPort, result2);
                PyDebugRunner.createConsoleCommunicationAndSetupActions(environment.getProject(), result2, pyDebugProcess, session);
                PyDebugProcess pyDebugProcess2 = pyDebugProcess;
                if (pyDebugProcess2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return pyDebugProcess2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        if (ExperimentalUI.isNewUI() && (sessionUi = session.getUI()) != null) {
            sessionUi.getDefaults().initContentAttraction("ConsoleContent", "finish", (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce());
        }
        XDebugSession xDebugSession = session;
        if (xDebugSession == null) {
            PyDebugRunner.$$$reportNull$$$0(12);
        }
        return xDebugSession;
    }

    @NotNull
    private Promise<XDebugSession> createSessionLegacy(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
        if (state == null) {
            PyDebugRunner.$$$reportNull$$$0(13);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(14);
        }
        PythonCommandLineState pyState = (PythonCommandLineState)state;
        RunProfile profile = environment.getRunProfile();
        Sdk sdk2 = pyState.getSdk();
        PyDebugSessionFactory sessionCreator = PyDebugSessionFactory.findExtension(sdk2);
        if (sessionCreator != null) {
            CancellablePromise cancellablePromise = AppUIExecutor.onWriteThread().submit(() -> sessionCreator.createSession(pyState, environment));
            if (cancellablePromise == null) {
                PyDebugRunner.$$$reportNull$$$0(15);
            }
            return cancellablePromise;
        }
        Promise promise = Promises.runAsync(() -> {
            try {
                ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
                int serverLocalPort = serverSocket.getLocalPort();
                ExecutionResult result2 = pyState.execute(environment.getExecutor(), this.createCommandLinePatchers(environment.getProject(), pyState, profile, serverLocalPort));
                return Pair.create((Object)serverSocket, (Object)result2);
            }
            catch (ExecutionException err) {
                throw new RuntimeException(err.getMessage(), err);
            }
        }).thenAsync(pair -> AppUIExecutor.onUiThread().submit(() -> {
            ServerSocket serverSocket = (ServerSocket)pair.getFirst();
            ExecutionResult result2 = (ExecutionResult)pair.getSecond();
            return this.createXDebugSession(environment, pyState, serverSocket, result2);
        }));
        if (promise == null) {
            PyDebugRunner.$$$reportNull$$$0(16);
        }
        return promise;
    }

    @NotNull
    protected PyDebugProcess createDebugProcess(@NotNull XDebugSession session, ServerSocket serverSocket, ExecutionResult result2, PythonCommandLineState pyState) {
        if (session == null) {
            PyDebugRunner.$$$reportNull$$$0(17);
        }
        return new PyDebugProcess(session, serverSocket, result2.getExecutionConsole(), result2.getProcessHandler(), pyState.isMultiprocessDebug());
    }

    @NotNull
    protected PyDebugProcess createDebugProcess(@NotNull XDebugSession session, int serverPort, ExecutionResult result2) {
        if (session == null) {
            PyDebugRunner.$$$reportNull$$$0(18);
        }
        return new PyDebugProcess(session, result2.getExecutionConsole(), result2.getProcessHandler(), "localhost", serverPort);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        XDebugSession session;
        if (state == null) {
            PyDebugRunner.$$$reportNull$$$0(19);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(20);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        PythonCommandLineState pyState = (PythonCommandLineState)state;
        Sdk sdk2 = pyState.getSdk();
        PyDebugSessionFactory sessionCreator = PyDebugSessionFactory.findExtension(sdk2);
        if (sessionCreator != null) {
            session = sessionCreator.createSession(pyState, environment);
        } else {
            ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
            int serverLocalPort = serverSocket.getLocalPort();
            RunProfile profile = environment.getRunProfile();
            ExecutionResult result2 = pyState.execute(environment.getExecutor(), this.createCommandLinePatchers(environment.getProject(), pyState, profile, serverLocalPort));
            session = this.createXDebugSession(environment, pyState, serverSocket, result2);
        }
        this.initSession(session, state, environment.getExecutor());
        RunContentDescriptor runContentDescriptor = session.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            PyDebugRunner.$$$reportNull$$$0(21);
        }
        return runContentDescriptor;
    }

    protected @NotNull Promise<@Nullable RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(22);
        }
        if (state == null) {
            PyDebugRunner.$$$reportNull$$$0(23);
        }
        return this.execute(environment, state, null);
    }

    private @NotNull Promise<@Nullable RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, @Nullable XDebugSessionListener sessionListener) {
        PythonCommandLineState pythonState;
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(24);
        }
        if (state == null) {
            PyDebugRunner.$$$reportNull$$$0(25);
        }
        if (state instanceof PythonCommandLineState && !(pythonState = (PythonCommandLineState)state).canRun()) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                PyDebugRunner.$$$reportNull$$$0(26);
            }
            return promise;
        }
        Promise promise = this.createSession(state, environment).thenAsync(session -> AppUIExecutor.onUiThread().submit(() -> {
            if (sessionListener != null) {
                session.addSessionListener(sessionListener);
            }
            this.initSession((XDebugSession)session, state, environment.getExecutor());
            return session.getRunContentDescriptor();
        }));
        if (promise == null) {
            PyDebugRunner.$$$reportNull$$$0(27);
        }
        return promise;
    }

    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(28);
        }
        this.exec(environment, null);
    }

    private @NotNull Promise<@Nullable RunContentDescriptor> executeWithLegacyWorkaround(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, @Nullable XDebugSessionListener sessionListener) throws ExecutionException {
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(29);
        }
        if (state == null) {
            PyDebugRunner.$$$reportNull$$$0(30);
        }
        boolean callExecute = true;
        try {
            callExecute = this.getClass().getDeclaredMethod("doExecute", RunProfileState.class, ExecutionEnvironment.class).getDeclaringClass().equals(PyDebugRunner.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (callExecute) {
            return this.execute(environment, state, sessionListener);
        }
        CancellablePromise cancellablePromise = AppUIExecutor.onUiThread().submit(() -> this.doExecute(state, environment));
        if (cancellablePromise == null) {
            PyDebugRunner.$$$reportNull$$$0(31);
        }
        return cancellablePromise;
    }

    protected void initSession(XDebugSession session, RunProfileState state, Executor executor) {
    }

    public static int findIndex(List<String> paramList, String paramName) {
        for (int i = 0; i < paramList.size(); ++i) {
            if (!paramName.equals(paramList.get(i))) continue;
            return i + 1;
        }
        return -1;
    }

    public static void createConsoleCommunicationAndSetupActions(@NotNull Project project, @NotNull ExecutionResult result2, @NotNull PyDebugProcess debugProcess, @NotNull XDebugSession session) {
        ExecutionConsole console;
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(32);
        }
        if (result2 == null) {
            PyDebugRunner.$$$reportNull$$$0(33);
        }
        if (debugProcess == null) {
            PyDebugRunner.$$$reportNull$$$0(34);
        }
        if (session == null) {
            PyDebugRunner.$$$reportNull$$$0(35);
        }
        if ((console = result2.getExecutionConsole()) instanceof PythonDebugLanguageConsoleView) {
            ProcessHandler processHandler = result2.getProcessHandler();
            PyDebugRunner.initDebugConsoleView(project, debugProcess, (PythonDebugLanguageConsoleView)console, processHandler, session);
        }
    }

    public static PythonDebugConsoleCommunication initDebugConsoleView(Project project, PyDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, XDebugSession session) {
        PythonConsoleView pythonConsoleView = console.getPydevConsoleView();
        PythonDebugConsoleCommunication debugConsoleCommunication = new PythonDebugConsoleCommunication(project, debugProcess, pythonConsoleView);
        pythonConsoleView.setConsoleCommunication((ConsoleCommunication)debugConsoleCommunication);
        PydevDebugConsoleExecuteActionHandler consoleExecuteActionHandler = new PydevDebugConsoleExecuteActionHandler(console, processHandler, (ConsoleCommunication)debugConsoleCommunication);
        PythonDebugConsoleCommunication pythonDebugConsoleCommunication = PyDebugRunner.initDebugConsoleView(pythonConsoleView, consoleExecuteActionHandler, debugProcess, processHandler, debugConsoleCommunication, session);
        if (console.isEnabled()) {
            console.enableConsole(false);
        }
        return pythonDebugConsoleCommunication;
    }

    protected static PythonDebugConsoleCommunication initDebugConsoleView(final @NotNull PythonConsoleView pythonConsoleView, @NotNull PydevDebugConsoleExecuteActionHandler consoleExecuteActionHandler, @NotNull PyDebugProcess debugProcess, @NotNull ProcessHandler processHandler, @NotNull PythonDebugConsoleCommunication debugConsoleCommunication, final XDebugSession session) {
        if (pythonConsoleView == null) {
            PyDebugRunner.$$$reportNull$$$0(36);
        }
        if (consoleExecuteActionHandler == null) {
            PyDebugRunner.$$$reportNull$$$0(37);
        }
        if (debugProcess == null) {
            PyDebugRunner.$$$reportNull$$$0(38);
        }
        if (processHandler == null) {
            PyDebugRunner.$$$reportNull$$$0(39);
        }
        if (debugConsoleCommunication == null) {
            PyDebugRunner.$$$reportNull$$$0(40);
        }
        pythonConsoleView.setExecutionHandler(consoleExecuteActionHandler);
        debugProcess.getSession().addSessionListener((XDebugSessionListener)consoleExecuteActionHandler);
        new LanguageConsoleBuilder((LanguageConsoleView)pythonConsoleView).processHandler(processHandler).initActions((BaseConsoleExecuteActionHandler)consoleExecuteActionHandler, "py", true);
        debugConsoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

            public void commandExecuted(boolean more) {
                session.rebuildViews();
            }

            public void inputRequested() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    ConsoleView patt0$temp = session.getConsoleView();
                    if (patt0$temp instanceof PythonDebugLanguageConsoleView) {
                        PythonDebugLanguageConsoleView debugConsoleView = (PythonDebugLanguageConsoleView)patt0$temp;
                        RunnerLayoutUi sessionUi = session.getUI();
                        if (sessionUi != null) {
                            PyExecuteInConsole.selectConsoleTab(session.getRunContentDescriptor(), sessionUi.getContentManager(), true);
                        }
                        if (pythonConsoleView.isVisible()) {
                            PyExecuteInConsole.requestFocus(true, null, pythonConsoleView, true);
                        } else {
                            ConsoleView patt1$temp = debugConsoleView.getPrimaryConsoleView();
                            if (patt1$temp instanceof ConsoleViewImpl) {
                                ConsoleViewImpl consoleView = (ConsoleViewImpl)patt1$temp;
                                PyExecuteInConsole.requestFocus(false, consoleView.getEditor(), null, true);
                            }
                        }
                    }
                });
            }
        });
        return debugConsoleCommunication;
    }

    @Nullable
    public static CommandLinePatcher createRunConfigPatcher(RunProfileState state, RunProfile profile) {
        AbstractPythonRunConfiguration runConfigPatcher = null;
        if (state instanceof PythonCommandLineState && profile instanceof AbstractPythonRunConfiguration) {
            runConfigPatcher = (AbstractPythonRunConfiguration)profile;
        }
        return runConfigPatcher;
    }

    public CommandLinePatcher[] createCommandLinePatchers(Project project, PythonCommandLineState state, RunProfile profile, int serverLocalPort) {
        return new CommandLinePatcher[]{this.createDebugServerPatcher(project, state, serverLocalPort, profile), PyDebugRunner.createRunConfigPatcher((RunProfileState)state, profile)};
    }

    public static boolean patchExeParams(ParametersList parametersList) {
        int moduleParamsIndex = parametersList.getParamsGroups().indexOf(parametersList.getParamsGroup("Module"));
        ParamsGroup oldModuleParams = parametersList.removeParamsGroup(moduleParamsIndex);
        if (oldModuleParams == null) {
            return false;
        }
        boolean isModule = false;
        ParamsGroup newModuleParams = new ParamsGroup("Module");
        for (String param : oldModuleParams.getParameters()) {
            if (!param.equals("-m")) {
                newModuleParams.addParameter(param);
                continue;
            }
            isModule = true;
        }
        parametersList.addParamsGroupAt(moduleParamsIndex, newModuleParams);
        return isModule;
    }

    private CommandLinePatcher createDebugServerPatcher(final Project project, final PythonCommandLineState pyState, final int serverLocalPort, final RunProfile profile) {
        return new CommandLinePatcher(){

            public void patchCommandLine(GeneralCommandLine commandLine) {
                ParametersList parametersList = commandLine.getParametersList();
                @NotNull ParamsGroup debugParams = parametersList.getParamsGroup("Debugger");
                assert (debugParams != null);
                boolean isModule = PyDebugRunner.patchExeParams(parametersList);
                PyDebugRunner.this.fillDebugParameters(project, debugParams, serverLocalPort, pyState, commandLine, profile, isModule);
                @NotNull ParamsGroup exeParams = parametersList.getParamsGroup("Exe Options");
                PythonSdkFlavor flavor = pyState.getSdkFlavor();
                if (flavor != null) {
                    assert (exeParams != null);
                    for (String option : flavor.getExtraDebugOptions()) {
                        exeParams.addParameter(option);
                    }
                }
            }
        };
    }

    private void fillDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, int serverLocalPort, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd, @Nullable RunProfile runProfile, boolean isModule) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(41);
        }
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(42);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(43);
        }
        if (cmd == null) {
            PyDebugRunner.$$$reportNull$$$0(44);
        }
        PythonHelper.DEBUGGER.addToGroup(debugParams, cmd);
        if (isModule) {
            debugParams.addParameter(MODULE_PARAM);
        }
        this.configureDebugParameters(project, debugParams, pyState, cmd);
        PyDebugRunner.configureDebugEnvironment(project, cmd.getEnvironment(), runProfile);
        PyDebugRunner.configureDebugConnectionParameters(debugParams, serverLocalPort);
    }

    @NotNull
    private PythonExecution prepareDebuggerScriptExecution(@NotNull Project project, @NotNull Function<TargetEnvironment, HostPort> serverPortOnTarget, @NotNull PythonCommandLineState pyState, @NotNull PythonExecution originalExecution, @Nullable RunProfile runProfile, @NotNull HelpersAwareTargetEnvironmentRequest request) {
        PythonExecution debuggerScript;
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(45);
        }
        if (serverPortOnTarget == null) {
            PyDebugRunner.$$$reportNull$$$0(46);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(47);
        }
        if (originalExecution == null) {
            PyDebugRunner.$$$reportNull$$$0(48);
        }
        if (request == null) {
            PyDebugRunner.$$$reportNull$$$0(49);
        }
        if (originalExecution instanceof PythonToolExecution) {
            PythonToolExecution pythonToolExecution = (PythonToolExecution)originalExecution;
            debuggerScript = PythonScripts.prepareHelperScriptViaToolExecution(PythonHelper.DEBUGGER, request, pythonToolExecution.getToolPath(), pythonToolExecution.getToolParams());
        } else {
            debuggerScript = PythonScripts.prepareHelperScriptExecution(PythonHelper.DEBUGGER, request);
        }
        TargetEnvironmentRequest targetEnvironmentRequest = request.getTargetEnvironmentRequest();
        PythonScripts.extendEnvs(debuggerScript, originalExecution.getEnvs(), targetEnvironmentRequest.getTargetPlatform());
        debuggerScript.setWorkingDir(originalExecution.getWorkingDir());
        originalExecution.accept(new PythonExecution.Visitor(){

            @Override
            public void visit(@NotNull PythonScriptExecution pythonScriptExecution) {
                if (pythonScriptExecution == null) {
                    5.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void visit(@NotNull PythonModuleExecution pythonModuleExecution) {
                if (pythonModuleExecution == null) {
                    5.$$$reportNull$$$0(1);
                }
                debuggerScript.addParameter(PyDebugRunner.MODULE_PARAM);
            }

            @Override
            public void visit(@NotNull PythonToolScriptExecution pythonToolScriptExecution) {
                if (pythonToolScriptExecution == null) {
                    5.$$$reportNull$$$0(2);
                }
            }

            @Override
            public void visit(@NotNull PythonToolModuleExecution pythonToolModuleExecution) {
                if (pythonToolModuleExecution == null) {
                    5.$$$reportNull$$$0(3);
                }
                String moduleFlag = pythonToolModuleExecution.getModuleFlag();
                debuggerScript.addParameter(moduleFlag);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonScriptExecution";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonModuleExecution";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonToolScriptExecution";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonToolModuleExecution";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/debugger/PyDebugRunner$5";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.configureDebugParameters(project, pyState, debuggerScript, false);
        boolean isLocalTarget = targetEnvironmentRequest instanceof LocalTargetEnvironmentRequest;
        PyDebugRunner.configureDebugEnvironment(project, new TargetEnvironmentController(debuggerScript.getEnvs(), request), runProfile, isLocalTarget);
        if (PyDebuggerOptionsProvider.getInstance(project).isRunDebuggerInServerMode() && Registry.is((String)"python.debug.use.single.port")) {
            PyDebugRunner.configureServerModeDebugConnectionParameters(debuggerScript, serverPortOnTarget);
        } else {
            PyDebugRunner.configureClientModeDebugConnectionParameters(debuggerScript, serverPortOnTarget);
        }
        originalExecution.accept(new PythonExecution.Visitor(){

            @Override
            public void visit(@NotNull PythonScriptExecution pythonScriptExecution) {
                Function<TargetEnvironment, String> scriptPath;
                if (pythonScriptExecution == null) {
                    6.$$$reportNull$$$0(0);
                }
                if ((scriptPath = pythonScriptExecution.getPythonScriptPath()) == null) {
                    throw new IllegalArgumentException("Python script path must be set");
                }
                debuggerScript.addParameter(scriptPath);
            }

            @Override
            public void visit(@NotNull PythonModuleExecution pythonModuleExecution) {
                String moduleName;
                if (pythonModuleExecution == null) {
                    6.$$$reportNull$$$0(1);
                }
                if ((moduleName = pythonModuleExecution.getModuleName()) == null) {
                    throw new IllegalArgumentException("Python module name must be set");
                }
                debuggerScript.addParameter(moduleName);
            }

            @Override
            public void visit(@NotNull PythonToolScriptExecution pythonToolScriptExecution) {
                if (pythonToolScriptExecution == null) {
                    6.$$$reportNull$$$0(2);
                }
                Function<TargetEnvironment, Path> scriptPath = pythonToolScriptExecution.getPythonScriptPath();
                debuggerScript.addParameter(scriptPath.andThen(it -> it.toString()));
            }

            @Override
            public void visit(@NotNull PythonToolModuleExecution pythonToolModuleExecution) {
                if (pythonToolModuleExecution == null) {
                    6.$$$reportNull$$$0(3);
                }
                String moduleName = pythonToolModuleExecution.getModuleName();
                debuggerScript.addParameter(moduleName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonScriptExecution";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonModuleExecution";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonToolScriptExecution";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonToolModuleExecution";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/debugger/PyDebugRunner$6";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        debuggerScript.getParameters().addAll(originalExecution.getParameters());
        PythonExecution pythonExecution = debuggerScript;
        if (pythonExecution == null) {
            PyDebugRunner.$$$reportNull$$$0(50);
        }
        return pythonExecution;
    }

    public static void configureDebugEnvironment(@NotNull Project project, Map<String, String> environment, @Nullable RunProfile runProfile) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(51);
        }
        PyDebugRunner.configureDebugEnvironment(project, new PlainEnvironmentController(environment), runProfile, true);
    }

    private static void configureDebugEnvironment(@NotNull Project project, @NotNull EnvironmentController environmentController, @Nullable RunProfile runProfile, boolean addCythonExtensionsToPythonPath) {
        Module module2;
        PyDebuggerSettings debuggerSettings;
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(52);
        }
        if (environmentController == null) {
            PyDebugRunner.$$$reportNull$$$0(53);
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportGeventDebugging()) {
            environmentController.putFixedValue(GEVENT_SUPPORT, "True");
        }
        if ((debuggerSettings = PyDebuggerSettings.getInstance()).isSteppingFiltersEnabled()) {
            environmentController.putFixedValue(PYDEVD_FILTERS, debuggerSettings.getSteppingFiltersForProject(project));
        }
        if (debuggerSettings.isLibrariesFilterEnabled()) {
            environmentController.putFixedValue(PYDEVD_FILTER_LIBRARIES, "True");
        }
        if (debuggerSettings.getValuesPolicy() != ValuesPolicy.SYNC) {
            environmentController.putFixedValue((String)PyDebugValue.POLICY_ENV_VARS.get(debuggerSettings.getValuesPolicy()), "True");
        }
        PydevConsoleRunnerFactory.putIPythonEnvFlag(project, environmentController);
        if (addCythonExtensionsToPythonPath) {
            environmentController.appendTargetPathToPathsValue(PYTHONPATH_ENV_NAME, CYTHON_EXTENSIONS_DIR);
        }
        PyDebugAsyncioCustomizer.Companion.getInstance().enableAsyncioMode(environmentController);
        AbstractPythonRunConfiguration runConfiguration = runProfile instanceof AbstractPythonRunConfiguration ? (AbstractPythonRunConfiguration)runProfile : null;
        Module module3 = module2 = runConfiguration != null ? runConfiguration.getModule() : null;
        if (module2 != null) {
            PyDebugRunner.addProjectRootsToEnv(module2, environmentController);
        }
        if (runConfiguration != null) {
            LanguageLevel langLevel;
            PythonSdkFlavor flavor;
            Sdk sdk2 = runConfiguration.getSdk();
            if (sdk2 != null && (flavor = PythonSdkFlavor.getFlavor((Sdk)sdk2)) != null && ((langLevel = flavor.getLanguageLevel(sdk2)) == LanguageLevel.PYTHON34 || langLevel == LanguageLevel.PYTHON35)) {
                environmentController.putFixedValue(PYDEVD_USE_CYTHON, "NO");
            }
            PyDebugRunner.addSdkRootsToEnv(environmentController, runConfiguration);
            environmentController.appendTargetPathToPathsValue(PYTHONPATH_ENV_NAME, runConfiguration.getWorkingDirectorySafe());
        }
        PyDebugRunner.applyRegistryFlags(environmentController);
    }

    private static void applyRegistryFlags(@NotNull EnvironmentController environmentController) {
        if (environmentController == null) {
            PyDebugRunner.$$$reportNull$$$0(54);
        }
        if (Registry.is((String)"python.debug.low.impact.monitoring.api")) {
            environmentController.putFixedValue(USE_LOW_IMPACT_MONITORING, "True");
        }
        if (!Registry.is((String)"python.debug.enable.cython.speedups")) {
            environmentController.putFixedValue(PYDEVD_USE_CYTHON, "NO");
        }
        if (Registry.is((String)"python.debug.enable.diagnostic.prints")) {
            environmentController.putFixedValue(PYCHARM_DEBUG, "True");
        }
        if (Registry.is((String)"python.debug.halt.variable.resolve.threads.on.step.resume")) {
            environmentController.putFixedValue(HALT_VARIABLE_RESOLVE_THREADS_ON_STEP_RESUME, "True");
        }
    }

    protected void configureDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(55);
        }
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(56);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(57);
        }
        if (cmd == null) {
            PyDebugRunner.$$$reportNull$$$0(58);
        }
        if (pyState.isMultiprocessDebug()) {
            debugParams.addParameter(PyDebugRunner.getMultiprocessDebugParameter());
        }
        PyDebugRunner.configureCommonDebugParameters(project, debugParams);
    }

    protected void configureDebugParameters(@NotNull Project project, @NotNull PythonCommandLineState pyState, @NotNull PythonExecution debuggerScript, boolean debuggerScriptInServerMode) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(59);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(60);
        }
        if (debuggerScript == null) {
            PyDebugRunner.$$$reportNull$$$0(61);
        }
        if (pyState instanceof PythonScriptCommandLineState && ((PythonScriptCommandLineState)pyState).showCommandLineAfterwards()) {
            debuggerScript.addParameter("--cmd-line");
        }
        if (pyState.isMultiprocessDebug() && !debuggerScriptInServerMode) {
            debuggerScript.addParameter(PyDebugRunner.getMultiprocessDebugParameter());
        }
        PyDebugRunner.configureCommonDebugParameters(project, debuggerScript);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    private static String getMultiprocessDebugParameter() {
        if (Registry.get((String)"python.debugger.use.dispatcher").asBoolean()) {
            return "--multiproc";
        }
        return MULTIPROCESS_PARAM;
    }

    public static void configureCommonDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(62);
        }
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(63);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !PyDebugRunner.isForceDisableDebuggerTracing()) {
            debugParams.addParameter("--DEBUG");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSaveCallSignatures()) {
            debugParams.addParameter("--save-signatures");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportQtDebugging()) {
            String pyQtBackend = StringUtil.toLowerCase((String)PyDebuggerOptionsProvider.getInstance(project).getPyQtBackend());
            debugParams.addParameter(String.format("--qt-support=%s", pyQtBackend));
        }
    }

    public static void configureCommonDebugParameters(@NotNull Project project, @NotNull PythonExecution debuggerScript) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(64);
        }
        if (debuggerScript == null) {
            PyDebugRunner.$$$reportNull$$$0(65);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !PyDebugRunner.isForceDisableDebuggerTracing()) {
            debuggerScript.addParameter("--DEBUG");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSaveCallSignatures()) {
            debuggerScript.addParameter("--save-signatures");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportQtDebugging()) {
            String pyQtBackend = StringUtil.toLowerCase((String)PyDebuggerOptionsProvider.getInstance(project).getPyQtBackend());
            debuggerScript.addParameter(String.format("--qt-support=%s", pyQtBackend));
        }
    }

    private static boolean isForceDisableDebuggerTracing() {
        return Boolean.TRUE.equals(ApplicationManager.getApplication().getUserData(FORCE_DISABLE_DEBUGGER_TRACING));
    }

    public static void disableBuiltinBreakpoint(@Nullable Sdk sdk2, Map<String, String> env) {
        PythonSdkFlavor flavor;
        if (sdk2 != null && (flavor = PythonSdkFlavor.getFlavor((Sdk)sdk2)) != null && flavor.getLanguageLevel(sdk2) == LanguageLevel.PYTHON37) {
            env.put("PYTHONBREAKPOINT", "0");
        }
    }

    private static void configureDebugConnectionParameters(@NotNull ParamsGroup debugParams, int serverLocalPort) {
        String[] debuggerArgs;
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(66);
        }
        for (String s : debuggerArgs = new String[]{CLIENT_PARAM, "127.0.0.1", PORT_PARAM, String.valueOf(serverLocalPort), FILE_PARAM}) {
            debugParams.addParameter(s);
        }
    }

    private static void configureClientModeDebugConnectionParameters(@NotNull PythonExecution debuggerScript, @NotNull Function<TargetEnvironment, HostPort> serverPortOnTarget) {
        if (debuggerScript == null) {
            PyDebugRunner.$$$reportNull$$$0(67);
        }
        if (serverPortOnTarget == null) {
            PyDebugRunner.$$$reportNull$$$0(68);
        }
        debuggerScript.addParameter(CLIENT_PARAM);
        debuggerScript.addParameter(serverPortOnTarget.andThen(HostPort::getHost));
        debuggerScript.addParameter(PORT_PARAM);
        debuggerScript.addParameter(serverPortOnTarget.andThen(HostPort::getPort).andThen(Object::toString));
        debuggerScript.addParameter(FILE_PARAM);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static void configureServerModeDebugConnectionParameters(@NotNull PythonExecution debuggerScript, @NotNull Function<TargetEnvironment, HostPort> serverPortOnTarget) {
        if (debuggerScript == null) {
            PyDebugRunner.$$$reportNull$$$0(69);
        }
        if (serverPortOnTarget == null) {
            PyDebugRunner.$$$reportNull$$$0(70);
        }
        debuggerScript.addParameter(PORT_PARAM);
        debuggerScript.addParameter(serverPortOnTarget.andThen(HostPort::getPort).andThen(Object::toString));
        debuggerScript.addParameter(FILE_PARAM);
    }

    private static void addProjectRootsToEnv(@NotNull Module module2, @NotNull EnvironmentController environment) {
        if (module2 == null) {
            PyDebugRunner.$$$reportNull$$$0(71);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(72);
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        Stream<VirtualFile> contentRoots = Stream.concat(Arrays.stream(moduleRootManager.getContentRoots()), PyDebugRunner.getDependenciesContentRoots(module2));
        environment.putTargetPathsValue(IDE_PROJECT_ROOTS, contentRoots.map(contentRoot -> contentRoot.getPath()).collect(Collectors.toList()));
    }

    private static Stream<VirtualFile> getDependenciesContentRoots(Module module2) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        Stream<Module> dependencies = Arrays.stream(moduleRootManager.getDependencies());
        return dependencies.flatMap(d -> Arrays.stream(ModuleRootManager.getInstance((Module)d).getContentRoots()));
    }

    private static void addSdkRootsToEnv(@NotNull EnvironmentController environmentController, @NotNull AbstractPythonRunConfiguration runConfiguration) {
        Sdk sdk2;
        if (environmentController == null) {
            PyDebugRunner.$$$reportNull$$$0(73);
        }
        if (runConfiguration == null) {
            PyDebugRunner.$$$reportNull$$$0(74);
        }
        if ((sdk2 = runConfiguration.getSdk()) != null) {
            ArrayList<String> roots = new ArrayList<String>();
            for (VirtualFile contentRoot : sdk2.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                roots.add(contentRoot.getPath());
            }
            environmentController.putFixedValue(LIBRARY_ROOTS, StringUtil.join(roots, (String)File.pathSeparator));
        }
    }

    private void exec(@NotNull ExecutionEnvironment environment, @Nullable XDebugSessionListener sessionListener) throws ExecutionException {
        RunProfileState state;
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(75);
        }
        if ((state = environment.getState()) != null) {
            ExecutionManager.getInstance((Project)environment.getProject()).startRunProfile(environment, () -> {
                try {
                    return this.executeWithLegacyWorkaround(environment, state, sessionListener);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
        }
    }

    @TestOnly
    public void executeWithListener(@NotNull ExecutionEnvironment environment, @Nullable XDebugSessionListener sessionListener) throws ExecutionException {
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(76);
        }
        this.exec(environment, sessionListener);
    }

    @TestOnly
    @Nullable
    public PyDebugProcess getProcess() {
        return this.pyDebugProcess;
    }

    @TestOnly
    public void resetProcess() {
        this.pyDebugProcess = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10, 12, 15, 16, 21, 26, 27, 31, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: 
            case 5: 
            case 13: 
            case 19: 
            case 23: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 72: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 26: 
            case 27: 
            case 31: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner";
                break;
            }
            case 17: 
            case 18: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 32: 
            case 41: 
            case 45: 
            case 51: 
            case 52: 
            case 55: 
            case 59: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonConsoleView";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleExecuteActionHandler";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugConsoleCommunication";
                break;
            }
            case 42: 
            case 56: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugParams";
                break;
            }
            case 43: 
            case 47: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyState";
                break;
            }
            case 44: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 46: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverPortOnTarget";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalExecution";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 53: 
            case 54: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentController";
                break;
            }
            case 61: 
            case 65: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerScript";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionUsingTargetsApi";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createXDebugSession";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionLegacy";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "executeWithLegacyWorkaround";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDebuggerScriptExecution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDebuggable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSession";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSessionUsingTargetsApi";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 26: 
            case 27: 
            case 31: 
            case 50: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createXDebugSession";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSessionLegacy";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "executeWithLegacyWorkaround";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleCommunicationAndSetupActions";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "initDebugConsoleView";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fillDebugParameters";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "prepareDebuggerScriptExecution";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugEnvironment";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "applyRegistryFlags";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugParameters";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "configureCommonDebugParameters";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugConnectionParameters";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "configureClientModeDebugConnectionParameters";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "configureServerModeDebugConnectionParameters";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addProjectRootsToEnv";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addSdkRootsToEnv";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "executeWithListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10, 12, 15, 16, 21, 26, 27, 31, 50 -> new IllegalStateException(string);
        };
    }

    private final class PythonDebuggerClientModeTargetedCommandLineBuilder
    extends PythonDebuggerTargetedCommandLineBuilder {
        @NotNull
        private final TargetEnvironment.LocalPortBinding myLocalPortBinding;
        @Nullable
        private volatile ServerSocket myServerSocketForDebugging;

        private PythonDebuggerClientModeTargetedCommandLineBuilder(@NotNull PyDebugRunner pyDebugRunner, @NotNull Project project, @NotNull PythonCommandLineState pyState, @NotNull RunProfile profile, TargetEnvironment.LocalPortBinding localPortBinding) {
            if (project == null) {
                PythonDebuggerClientModeTargetedCommandLineBuilder.$$$reportNull$$$0(0);
            }
            if (pyState == null) {
                PythonDebuggerClientModeTargetedCommandLineBuilder.$$$reportNull$$$0(1);
            }
            if (profile == null) {
                PythonDebuggerClientModeTargetedCommandLineBuilder.$$$reportNull$$$0(2);
            }
            if (localPortBinding == null) {
                PythonDebuggerClientModeTargetedCommandLineBuilder.$$$reportNull$$$0(3);
            }
            super(project, pyState, profile);
            this.myLocalPortBinding = localPortBinding;
        }

        @Override
        protected @NotNull Function<@Nullable TargetEnvironment, HostPort> createPortBinding(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest) {
            if (helpersAwareTargetRequest == null) {
                PythonDebuggerClientModeTargetedCommandLineBuilder.$$$reportNull$$$0(4);
            }
            helpersAwareTargetRequest.getTargetEnvironmentRequest().getLocalPortBindings().add(this.myLocalPortBinding);
            helpersAwareTargetRequest.getTargetEnvironmentRequest().onEnvironmentPrepared((environment, indicator) -> {
                try {
                    this.myServerSocketForDebugging = PythonDebuggerClientModeTargetedCommandLineBuilder.createServerSocketForDebugging(environment, this.myLocalPortBinding);
                }
                catch (IOException e) {
                    LOG.error("Unable to create server socket for debugging", (Throwable)e);
                }
                return Unit.INSTANCE;
            });
            helpersAwareTargetRequest.getTargetEnvironmentRequest().getLocalPortBindings().add(this.myLocalPortBinding);
            Function function = TargetEnvironmentFunctions.getTargetEnvironmentValue((TargetEnvironment.LocalPortBinding)this.myLocalPortBinding);
            if (function == null) {
                PythonDebuggerClientModeTargetedCommandLineBuilder.$$$reportNull$$$0(5);
            }
            return function;
        }

        @NotNull
        private static ServerSocket createServerSocketForDebugging(@NotNull TargetEnvironment environment, @NotNull TargetEnvironment.LocalPortBinding ideServerPortBinding) throws IOException {
            InetAddress hostInetAddress;
            if (environment == null) {
                PythonDebuggerClientModeTargetedCommandLineBuilder.$$$reportNull$$$0(6);
            }
            if (ideServerPortBinding == null) {
                PythonDebuggerClientModeTargetedCommandLineBuilder.$$$reportNull$$$0(7);
            }
            ResolvedPortBinding localPortBinding = (ResolvedPortBinding)environment.getLocalPortBindings().get(ideServerPortBinding);
            int port = ideServerPortBinding.getLocal();
            if (localPortBinding != null) {
                hostInetAddress = InetAddress.getByName(localPortBinding.getLocalEndpoint().getHost());
            } else {
                LOG.error("The resolution of the local port binding for \"" + port + "\" port cannot be found in the prepared environment, falling back to \"localhost\" for the server socket binding on the local machine");
                hostInetAddress = InetAddress.getLoopbackAddress();
            }
            LOG.debug("Creating server socket for debugging at " + String.valueOf(hostInetAddress) + ":" + port);
            return new ServerSocket(port, 0, hostInetAddress);
        }

        @Nullable
        public ServerSocket getServerSocketForDebugging() {
            return this.myServerSocketForDebugging;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPortBinding";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helpersAwareTargetRequest";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner$PythonDebuggerClientModeTargetedCommandLineBuilder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideServerPortBinding";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner$PythonDebuggerClientModeTargetedCommandLineBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPortBinding";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createPortBinding";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createServerSocketForDebugging";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public final class PythonDebuggerServerModeTargetedCommandLineBuilder
    extends PythonDebuggerTargetedCommandLineBuilder {
        @NotNull
        private final TargetEnvironment.TargetPortBinding myTargetPortBinding;

        public PythonDebuggerServerModeTargetedCommandLineBuilder(@NotNull PyDebugRunner this$0, @NotNull Project project, @NotNull PythonCommandLineState pyState, @NotNull RunProfile profile, TargetEnvironment.TargetPortBinding targetPortBinding) {
            if (project == null) {
                PythonDebuggerServerModeTargetedCommandLineBuilder.$$$reportNull$$$0(0);
            }
            if (pyState == null) {
                PythonDebuggerServerModeTargetedCommandLineBuilder.$$$reportNull$$$0(1);
            }
            if (profile == null) {
                PythonDebuggerServerModeTargetedCommandLineBuilder.$$$reportNull$$$0(2);
            }
            if (targetPortBinding == null) {
                PythonDebuggerServerModeTargetedCommandLineBuilder.$$$reportNull$$$0(3);
            }
            super(project, pyState, profile);
            this.myTargetPortBinding = targetPortBinding;
        }

        @Override
        @NotNull
        public Function<TargetEnvironment, HostPort> createPortBinding(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest) {
            if (helpersAwareTargetRequest == null) {
                PythonDebuggerServerModeTargetedCommandLineBuilder.$$$reportNull$$$0(4);
            }
            helpersAwareTargetRequest.getTargetEnvironmentRequest().getTargetPortBindings().add(this.myTargetPortBinding);
            Function function = TargetEnvironmentFunctions.getTargetEnvironmentValue((TargetEnvironment.TargetPortBinding)this.myTargetPortBinding);
            if (function == null) {
                PythonDebuggerServerModeTargetedCommandLineBuilder.$$$reportNull$$$0(5);
            }
            return function;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPortBinding";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helpersAwareTargetRequest";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner$PythonDebuggerServerModeTargetedCommandLineBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner$PythonDebuggerServerModeTargetedCommandLineBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPortBinding";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createPortBinding";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public abstract class PythonDebuggerTargetedCommandLineBuilder
    implements PythonScriptTargetedCommandLineBuilder {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PythonCommandLineState myPyState;
        @NotNull
        private final RunProfile myProfile;

        private PythonDebuggerTargetedCommandLineBuilder(@NotNull Project project, @NotNull PythonCommandLineState pyState, RunProfile profile) {
            if (project == null) {
                PythonDebuggerTargetedCommandLineBuilder.$$$reportNull$$$0(0);
            }
            if (pyState == null) {
                PythonDebuggerTargetedCommandLineBuilder.$$$reportNull$$$0(1);
            }
            if (profile == null) {
                PythonDebuggerTargetedCommandLineBuilder.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myPyState = pyState;
            this.myProfile = profile;
        }

        @Override
        @NotNull
        public final PythonExecution build(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @NotNull PythonExecution pythonScript) {
            if (helpersAwareTargetRequest == null) {
                PythonDebuggerTargetedCommandLineBuilder.$$$reportNull$$$0(3);
            }
            if (pythonScript == null) {
                PythonDebuggerTargetedCommandLineBuilder.$$$reportNull$$$0(4);
            }
            Function<TargetEnvironment, HostPort> portBinding = this.createPortBinding(helpersAwareTargetRequest);
            PythonExecution debuggerScript = PyDebugRunner.this.prepareDebuggerScriptExecution(this.myProject, portBinding, this.myPyState, pythonScript, this.myProfile, helpersAwareTargetRequest);
            List<String> configuredInterpreterParameters = this.myPyState.getConfiguredInterpreterParameters();
            PythonSdkFlavor flavor = this.myPyState.getSdkFlavor();
            if (flavor != null) {
                debuggerScript.getAdditionalInterpreterParameters().addAll(flavor.getExtraDebugOptions());
            }
            debuggerScript.getAdditionalInterpreterParameters().addAll(this.createInterpreterParametersToPreventPycGenerationInHelpersDir(configuredInterpreterParameters));
            debuggerScript.setCharset(PydevConsoleRunnerImpl.CONSOLE_CHARSET);
            PythonExecution pythonExecution = debuggerScript;
            if (pythonExecution == null) {
                PythonDebuggerTargetedCommandLineBuilder.$$$reportNull$$$0(5);
            }
            return pythonExecution;
        }

        @NotNull
        protected abstract Function<TargetEnvironment, HostPort> createPortBinding(@NotNull HelpersAwareTargetEnvironmentRequest var1);

        private List<String> createInterpreterParametersToPreventPycGenerationInHelpersDir(@NotNull List<String> existingInterpreterParameters) {
            Sdk sdk2;
            if (existingInterpreterParameters == null) {
                PythonDebuggerTargetedCommandLineBuilder.$$$reportNull$$$0(6);
            }
            if ((sdk2 = this.myPyState.getSdk()) == null || PythonSdkUtil.isRemote((Sdk)sdk2)) {
                return Collections.emptyList();
            }
            String pythonVersion2 = sdk2.getVersionString();
            if (pythonVersion2 == null) {
                return Collections.emptyList();
            }
            PythonSdkFlavor pythonSdkFlavor = PySdkExtKt.getOrCreateAdditionalData(sdk2).getFlavor();
            if (!(pythonSdkFlavor instanceof CPythonSdkFlavor)) {
                return Collections.emptyList();
            }
            if (existingInterpreterParameters.contains(PyDebugRunner.PYTHON_DONT_WRITE_PYC_FLAG)) {
                return Collections.emptyList();
            }
            if (pythonSdkFlavor.getLanguageLevel(sdk2).isOlderThan(LanguageLevel.PYTHON38)) {
                return List.of(PyDebugRunner.PYTHON_DONT_WRITE_PYC_FLAG);
            }
            for (int i = 0; i < existingInterpreterParameters.size(); ++i) {
                if (!existingInterpreterParameters.get(i).startsWith(PyDebugRunner.PYTHON3_PYCACHE_PREFIX_OPTION) || i <= 0 || !existingInterpreterParameters.get(i - 1).equals("-X")) continue;
                return Collections.emptyList();
            }
            try {
                return List.of("-X", PyDebugRunner.PYTHON3_PYCACHE_PREFIX_OPTION + String.valueOf(PythonDebuggerTargetedCommandLineBuilder.prepareAndGetPycacheDirectory()));
            }
            catch (IOException e) {
                return List.of(PyDebugRunner.PYTHON_DONT_WRITE_PYC_FLAG);
            }
        }

        private static Path prepareAndGetPycacheDirectory() throws IOException {
            Path pycacheDir = PathManager.getSystemDir().resolve("cpython-cache");
            Files.createDirectories(pycacheDir, new FileAttribute[0]);
            return pycacheDir.toAbsolutePath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helpersAwareTargetRequest";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pythonScript";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner$PythonDebuggerTargetedCommandLineBuilder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingInterpreterParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner$PythonDebuggerTargetedCommandLineBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createInterpreterParametersToPreventPycGenerationInHelpersDir";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

