/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.requirement;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstImportElement;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.IgnoreRequirementFix;
import com.jetbrains.python.inspections.quickfix.PyAddToDeclaredPackagesQuickFix;
import com.jetbrains.python.inspections.quickfix.SyncProjectQuickFix;
import com.jetbrains.python.inspections.requirement.DeclaredButNotInstalledPackagesChecker;
import com.jetbrains.python.inspections.requirement.InstalledButNotDeclaredChecker;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.dependencies.PythonDependenciesManager;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.utils.PyPackageManagerModuleHelpers;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/inspections/requirement/PyRequirementVisitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "ignoredPackages", "", "", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Ljava/util/Collection;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "getIgnoredPackages", "()Ljava/util/Collection;", "visitPyFromImportStatement", "", "node", "Lcom/jetbrains/python/psi/PyFromImportStatement;", "visitPyImportStatement", "Lcom/jetbrains/python/psi/PyImportStatement;", "checkPackageNameInRequirements", "importedExpression", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "visitPyFile", "Lcom/jetbrains/python/psi/PyFile;", "checkPackagesHaveBeenInstalled", "file", "Lcom/intellij/psi/PsiElement;", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyRequirementVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRequirementVisitor.kt\ncom/jetbrains/python/inspections/requirement/PyRequirementVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,117:1\n11879#2,9:118\n13805#2:127\n13806#2:129\n11888#2:130\n1#3:128\n1869#4,2:131\n1761#4,3:133\n1634#4,3:136\n37#5,2:139\n*S KotlinDebug\n*F\n+ 1 PyRequirementVisitor.kt\ncom/jetbrains/python/inspections/requirement/PyRequirementVisitor\n*L\n40#1:118,9\n40#1:127\n40#1:129\n40#1:130\n40#1:128\n40#1:131,2\n44#1:133,3\n100#1:136,3\n108#1:139,2\n*E\n"})
public final class PyRequirementVisitor
extends PyInspectionVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<String> ignoredPackages;
    @NotNull
    private static final String REQUIREMENT_NOT_SATISFIED = "INSP.requirements.package.requirements.not.satisfied";
    @NotNull
    private static final String PACKAGE_NOT_LISTED = "INSP.requirements.package.containing.module.not.listed.in.project.requirements";

    public PyRequirementVisitor(@Nullable ProblemsHolder holder, @NotNull Collection<String> ignoredPackages, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter(ignoredPackages, (String)"ignoredPackages");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(holder, context);
        this.ignoredPackages = ignoredPackages;
    }

    @NotNull
    public final Collection<String> getIgnoredPackages() {
        return this.ignoredPackages;
    }

    public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PyReferenceExpression pyReferenceExpression = node.getImportSource();
        if (pyReferenceExpression == null) {
            return;
        }
        PyReferenceExpression importSource = pyReferenceExpression;
        this.checkPackageNameInRequirements((PyQualifiedExpression)importSource);
    }

    /*
     * WARNING - void declaration
     */
    public void visitPyImportStatement(@NotNull PyImportStatement node) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PyAstImportElement[] pyAstImportElementArray = node.getImportElements();
        Intrinsics.checkNotNullExpressionValue((Object)pyAstImportElementArray, (String)"getImportElements(...)");
        Object[] $this$mapNotNull$iv = pyAstImportElementArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PyReferenceExpression it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PyImportElement it = (PyImportElement)element$iv$iv;
            boolean bl2 = false;
            if (it.getImportReferenceExpression() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PyReferenceExpression it = (PyReferenceExpression)element$iv;
            boolean bl = false;
            this.checkPackageNameInRequirements((PyQualifiedExpression)it);
        }
    }

    private final void checkPackageNameInRequirements(PyQualifiedExpression importedExpression) {
        Object[] objectArray;
        Object[] objectArray2;
        boolean bl;
        block13: {
            Iterable $this$any$iv = PyInspectionExtension.EP_NAME.getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PyInspectionExtension it = (PyInspectionExtension)element$iv;
                    boolean bl2 = false;
                    if (!it.ignorePackageNameInRequirements(importedExpression)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        PyExpression pyExpression = PyPsiUtils.getFirstQualifier((PyQualifiedExpression)importedExpression);
        Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getFirstQualifier(...)");
        PyExpression packageReferenceExpression = pyExpression;
        String string = packageReferenceExpression.getName();
        if (string == null) {
            return;
        }
        String importedPyModule = string;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)packageReferenceExpression));
        if (module2 == null) {
            return;
        }
        Module module3 = module2;
        if (PyPackageManagerModuleHelpers.INSTANCE.isLocalModule(packageReferenceExpression, module3)) {
            return;
        }
        Sdk sdk2 = PySdkExtKt.getPythonSdk(module3);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        Project project = module3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PythonPackageManager manager = PythonPackageManager.Companion.forSdk(project, sdk3);
        PythonDependenciesManager pythonDependenciesManager = manager.getDependencyManager();
        if (pythonDependenciesManager == null) {
            return;
        }
        PythonDependenciesManager requirementsManager = pythonDependenciesManager;
        if (requirementsManager.getDependenciesFile() == null) {
            return;
        }
        InstalledButNotDeclaredChecker installedNotDeclaredChecker = new InstalledButNotDeclaredChecker(this.ignoredPackages, manager);
        String string2 = installedNotDeclaredChecker.getUndeclaredPackageName(importedPyModule);
        if (string2 == null) {
            return;
        }
        String packageName = string2;
        if (requirementsManager.isAddDependencyPossible()) {
            objectArray2 = new LocalQuickFix[]{new PyAddToDeclaredPackagesQuickFix(requirementsManager, packageName), new IgnoreRequirementFix(SetsKt.setOf((Object)packageName))};
            objectArray = objectArray2;
        } else {
            objectArray = new LocalQuickFix[]{};
        }
        LocalQuickFix[] fixes = objectArray;
        objectArray2 = new Object[]{importedPyModule};
        this.registerProblem((PsiElement)packageReferenceExpression, PyPsiBundle.message((String)PACKAGE_NOT_LISTED, (Object[])objectArray2), ProblemHighlightType.WEAK_WARNING, null, Arrays.copyOf(fixes, fixes.length));
    }

    public void visitPyFile(@NotNull PyFile node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)node));
        if (module2 == null) {
            return;
        }
        Module module3 = module2;
        this.checkPackagesHaveBeenInstalled((PsiElement)node, module3);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPackagesHaveBeenInstalled(PsiElement file, Module module2) {
        void destination$iv;
        void $this$mapTo$iv;
        if (PyPackageManagerModuleHelpers.INSTANCE.isRunningPackagingTasks(module2)) {
            return;
        }
        Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)module2);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PythonPackageManager manager = PythonPackageManager.Companion.forSdk(project, sdk3);
        DeclaredButNotInstalledPackagesChecker declaredNotInstalledChecker = new DeclaredButNotInstalledPackagesChecker(this.ignoredPackages);
        List<PyRequirement> unsatisfied = declaredNotInstalledChecker.findUnsatisfiedRequirements(module2, manager);
        if (unsatisfied.isEmpty()) {
            return;
        }
        String string = PyPackageUtil.requirementsToString(unsatisfied);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requirementsToString(...)");
        String requirementsList = string;
        Object object = new Object[]{requirementsList, unsatisfied.size()};
        String string2 = PyPsiBundle.message((String)REQUIREMENT_NOT_SATISFIED, (Object[])object);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        object = unsatisfied;
        Object[] objectArray = (Object[])new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PyRequirement pyRequirement = (PyRequirement)item$iv;
            void var17_18 = destination$iv;
            boolean bl = false;
            String string3 = it.getPresentableTextWithoutVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPresentableTextWithoutVersion(...)");
            var17_18.add(string3);
        }
        Set set = (Set)destination$iv;
        IgnoreRequirementFix ignoreFix = new IgnoreRequirementFix(set);
        objectArray = new LocalQuickFix[]{new SyncProjectQuickFix(), ignoreFix};
        List quickFixes = CollectionsKt.listOf((Object[])objectArray);
        Collection $this$toTypedArray$iv = quickFixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        this.registerProblem(file, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/inspections/requirement/PyRequirementVisitor$Companion;", "", "<init>", "()V", "REQUIREMENT_NOT_SATISFIED", "", "PACKAGE_NOT_LISTED", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

