/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.InstalledPackagesPanel;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.SdkUiUtilKt;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyPackagesNotificationPanel;
import com.jetbrains.python.packaging.PyPackagingSettings;
import com.jetbrains.python.packaging.bridge.PythonPackageManagementServiceBridge;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInstalledPackagesPanel
extends InstalledPackagesPanel {
    static String PYTHON = "python";

    public PyInstalledPackagesPanel(@NotNull Project project, @NotNull PackagesNotificationPanel area) {
        if (project == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(0);
        }
        if (area == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(1);
        }
        super(project, area);
    }

    public void setShowGrid(boolean v) {
        this.myPackagesTable.setShowGrid(v);
    }

    private Sdk getSelectedSdk() {
        PyPackageManagementService service = (PyPackageManagementService)this.myPackageManagementService;
        return service != null ? service.getSdk() : null;
    }

    public void updateNotifications(@Nullable Sdk selectedSdk) {
        if (selectedSdk == null) {
            this.myNotificationArea.hide();
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            application.invokeLater(() -> this.updateUninstallUpgrade(), ModalityState.any());
            application.invokeLater(() -> {
                if (selectedSdk == this.getSelectedSdk()) {
                    this.myNotificationArea.hide();
                    this.myInstallEnabled = this.installEnabled();
                }
            }, ModalityState.any());
        });
    }

    protected Set<String> getPackagesToPostpone() {
        return Sets.newHashSet((Object[])new String[]{"pip", "distutils", "setuptools"});
    }

    protected boolean canUninstallPackage(InstalledPackage pkg) {
        String location;
        Sdk sdk2 = this.getSelectedSdk();
        if (sdk2 == null) {
            return false;
        }
        if (!PyPackageUtil.packageManagementEnabled(sdk2, false, false)) {
            return false;
        }
        if (SdkUiUtilKt.isVirtualEnv(sdk2) && pkg instanceof PyPackage && (location = ((PyPackage)pkg).getLocation()) != null && location.startsWith(PythonSdkUtil.getUserSite())) {
            return false;
        }
        String name2 = pkg.getName();
        return !"pip".equals(name2) && !"setuptools".equals(name2) && !"distribute".equals(name2) && !PYTHON.equals(name2);
    }

    protected boolean canInstallPackage(@NotNull InstalledPackage pyPackage) {
        if (pyPackage == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(2);
        }
        return this.installEnabled();
    }

    protected boolean installEnabled() {
        return PyPackageUtil.packageManagementEnabled(this.getSelectedSdk(), false, false);
    }

    protected boolean canUpgradePackage(InstalledPackage pyPackage) {
        if (!PyPackageUtil.packageManagementEnabled(this.getSelectedSdk(), false, false)) {
            return false;
        }
        return !PYTHON.equals(pyPackage.getName());
    }

    protected AnAction @NotNull [] getExtraActions() {
        DumbAwareToggleAction useCondaButton = new DumbAwareToggleAction(PyBundle.messagePointer("action.AnActionButton.text.use.conda.package.manager", new Object[0]), Presentation.NULL_STRING, PythonIcons.Python.Anaconda){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Sdk sdk2 = PyInstalledPackagesPanel.this.getSelectedSdk();
                PackageManagementService packageManagementService = PyInstalledPackagesPanel.this.myPackageManagementService;
                if (packageManagementService instanceof PythonPackageManagementServiceBridge) {
                    PythonPackageManagementServiceBridge bridge = (PythonPackageManagementServiceBridge)packageManagementService;
                    return sdk2 != null && bridge.isConda() && bridge.getUseConda();
                }
                return false;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                PackageManagementService packageManagementService;
                Sdk sdk2 = PyInstalledPackagesPanel.this.getSelectedSdk();
                if (sdk2 == null || !((packageManagementService = PyInstalledPackagesPanel.this.myPackageManagementService) instanceof PythonPackageManagementServiceBridge)) {
                    return;
                }
                PythonPackageManagementServiceBridge bridge = (PythonPackageManagementServiceBridge)packageManagementService;
                if (bridge.isConda()) {
                    bridge.setUseConda(state);
                }
                PyInstalledPackagesPanel.this.updatePackages(PyInstalledPackagesPanel.this.myPackageManagementService);
            }

            public void update(@NotNull AnActionEvent e) {
                PythonPackageManagementServiceBridge bridge;
                PackageManagementService packageManagementService;
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.update(e);
                Sdk sdk2 = PyInstalledPackagesPanel.this.getSelectedSdk();
                e.getPresentation().setVisible(sdk2 != null && (packageManagementService = PyInstalledPackagesPanel.this.myPackageManagementService) instanceof PythonPackageManagementServiceBridge && (bridge = (PythonPackageManagementServiceBridge)packageManagementService).isConda());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        DumbAwareToggleAction showEarlyReleasesButton = new DumbAwareToggleAction(PyBundle.messagePointer("action.AnActionButton.text.show.early.releases", new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.Show){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return PyPackagingSettings.getInstance((Project)((PyInstalledPackagesPanel)PyInstalledPackagesPanel.this).myProject).earlyReleasesAsUpgrades;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                PyPackagingSettings.getInstance((Project)((PyInstalledPackagesPanel)PyInstalledPackagesPanel.this).myProject).earlyReleasesAsUpgrades = state;
                PyInstalledPackagesPanel.this.updatePackages(PyInstalledPackagesPanel.this.myPackageManagementService);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        AnAction[] anActionArray = new AnAction[]{useCondaButton, showEarlyReleasesButton};
        if (anActionArray == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    @NotNull
    protected PackagesNotificationPanel createNotificationPanel() {
        return new PyPackagesNotificationPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canInstallPackage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

